/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.calculator.length;

import java.util.ArrayList;
import java.util.List;
import net.loomchild.maligna.calculator.Calculator;
import net.loomchild.maligna.calculator.length.counter.Counter;

public abstract class LengthCalculator
implements Calculator {
    private Counter counter;

    public LengthCalculator(Counter counter) {
        this.counter = counter;
    }

    @Override
    public float calculateScore(List<String> sourceSegmentList, List<String> targetSegmentList) {
        List<Integer> sourceLengthList = this.calculateLengthList(sourceSegmentList);
        List<Integer> targetLengthList = this.calculateLengthList(targetSegmentList);
        return this.calculateLengthScore(sourceLengthList, targetLengthList);
    }

    protected List<Integer> calculateLengthList(List<String> segmentList) {
        ArrayList<Integer> lengthList = new ArrayList<Integer>();
        for (String segment : segmentList) {
            int length = this.counter.calculateLength(segment);
            if (length <= 0) continue;
            lengthList.add(length);
        }
        return lengthList;
    }

    protected int calculateTotalLength(List<Integer> lengthList) {
        int totalLength = 0;
        for (int length : lengthList) {
            totalLength += length;
        }
        return totalLength;
    }

    protected abstract float calculateLengthScore(List<Integer> var1, List<Integer> var2);
}

