/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect;

import be.frma.langguess.IOUtils;
import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.TagExtractor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenProfile {
    private static final Logger logger = LoggerFactory.getLogger(GenProfile.class);

    public static LangProfile load(String lang, File file) {
        LangProfile profile = new LangProfile(lang);
        FilterInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            if (file.getName().endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            TagExtractor tagextractor = new TagExtractor("abstract", 100);
            XMLStreamReader reader = null;
            try {
                XMLInputFactory factory = XMLInputFactory.newInstance();
                reader = factory.createXMLStreamReader(is);
                while (reader.hasNext()) {
                    switch (reader.next()) {
                        case 1: {
                            tagextractor.setTag(reader.getName().toString());
                            break;
                        }
                        case 4: {
                            tagextractor.add(reader.getText());
                            break;
                        }
                        case 2: {
                            tagextractor.closeTag(profile);
                        }
                    }
                }
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Training database file '" + file.getName() + "' is an invalid XML.", e);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (XMLStreamException e) {}
            }
            logger.info(lang + ":" + tagextractor.count());
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Can't open training database file '" + file.getName() + "'", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(is);
        return profile;
    }
}

