(game-module "u-e50-1998"
  (title "Earth 50km/cell + 1998 Places")
  (blurb "Places in 1998 on the 50km/cell map")
  (variants
   (world-seen)
   (see-all)
   ;; The following is useful for hacking on the file
   (bare true
    (true
     (set synthesis-methods nil)
     (add u* start-with 0)
     (add city start-with 1)
     (add u* independent-near-start 0)
     (table independent-density (u* t* 0))
     (set sides-min 1)
     (set sides-max 1)
     ))
   )
  )

(include "earth-50km")

(include "t-e50-river")

(set synthesis-methods '(make-countries))

;; Rules: every country of at least 1,000,000 people gets at least
;; one town.  Beyond that, to qualify as a town, a place must have
;; both population and manufacturing capability.

;; Cities must be known megalopoli.  They must also contain sufficient
;; resources (scientific & technical) to develop nuclear weapons.

(base 263 283 0 (n "Aberdeen") (sides "British"))
(base 92 191 0 (n "Acapulco") (sides "Mexican"))
(base 680 76 0 (n "Adelaide") (sides "Australian"))
(base 600 245 0 (n "Akita") (sides "Japanese"))
(base 122 249 0 (n "Albany") (sides "American"))
(base 376 235 0 (n "Aleppo") (sides "Syrian"))
(base 485 211 0 (n "Allahabad") (sides "Indian"))
(base 120 244 0 (n "Allentown") (sides "American"))
(base 283 265 0 (n "Amiens") (sides "French"))
(base 464 225 0 (n "Amritsar") (sides "Indian"))
(base 732 290 0 (n "Anchorage") (sides "American"))
(base 360 236 0 (n "Antalya") (sides "Turk"))
(base 203 101 0 (n "Antofagasta") (sides "Chilean"))
(base 191 118 0 (n "Arequipa") (sides "Peruvian"))
(base 350 298 0 (n "Archangel'sk") (sides "Russian"))
(base 600 253 0 (n "Asahikawa") (sides "Japanese"))
(base 379 207 0 (n "Aswan") (sides "Egyptian"))
(base 372 214 0 (n "Asyut") (sides "Egyptian"))
(base 238 67 0 (n "Bahia Blanca") (sides "Argentinian"))
(base 594 151 0 (n "Balikpapan") (sides "Indonesian"))
(base 591 146 0 (n "Banjarmasin") (sides "Indonesian"))
(base 547 240 0 (n "Baoding") (sides "Chinese"))
(base 322 245 0 (n "Bari") (sides "Italian"))
(base 297 260 0 (n "Basel") (sides "Swiss"))
(base 407 221 0 (n "Basra") (sides "Iraqi"))
(base 97 222 0 (n "Baton Rouge") (sides "American"))
(base 377 247 0 (n "Batumi") (sides "Georgian"))
(base 90 221 0 (n "Beaumont") (sides "American"))
(base 487 211 0 (n "Benares") (sides "Indian"))
(base 342 225 0 (n "Benghazi") (sides "Libyan"))
(base 283 289 0 (n "Bergen") (sides "Norwegian"))
(base 477 208 0 (n "Bhopal") (sides "Indian"))
(base 325 272 0 (n "Bialystok") (sides "Polish"))
(base 278 250 0 (n "Bilbao") (sides "Spanish"))
(base 560 267 0 (n "Blagoveshchenk") (sides "Russian"))
(base 339 256 0 (n "Brasov") (sides "Romanian"))
(base 298 270 0 (n "Braunschweig") (sides "German"))
(base 273 262 0 (n "Brest") (sides "French"))
(base 584 164 0 (n "Brunei"))
(base 156 163 0 (n "Buenaventura") (sides "Colombian"))
(base 314 272 0 (n "Bydgoszcz") (sides "Polish"))
(base 279 235 0 (n "Cadiz") (sides "Spanish"))
(base 676 117 0 (n "Cairns") (sides "Australian"))
(base 326 236 0 (n "Catania") (sides "Italian"))
(base 580 261 0 (n "Chabarovsk") (sides "Russian"))
(base 119 226 0 (n "Charleston") (sides "American"))
(base 113 232 0 (n "Charlotte") (sides "American"))
(base 104 231 0 (n "Chattanooga") (sides "American"))
(base 66 217 0 (n "Chihuahua") (sides "Mexican"))
(base 439 248 0 (n "Chimkent") (sides "Kazakh"))
(base 527 270 0 (n "Chita") (sides "Russian"))
(base 513 203 0 (n "Chittagong") (sides "Bangladeshi"))
(base 185 172 0 (n "Ciudad Guayana") (sides "Venezuelan"))
(base 334 258 0 (n "Cluj-Napoca") (sides "Romanian"))
(base 205 116 0 (n "Cochabamba") (sides "Bolivian"))
(base 492 179 0 (n "Coimbatore") (sides "Indian"))
(base 147 173 0 (n "Colon") (sides "Panamanian"))
(base 212 71 0 (n "Concepcion") (sides "Chilean"))
(base 347 253 0 (n "Constanta") (sides "Romanian"))
(base 280 238 0 (n "Cordoba") (sides "Argentinian"))
(base 257 271 0 (n "Cork") (sides "Irish"))
(base 86 215 0 (n "Corpus Christi") (sides "American"))
(base 337 252 0 (n "Craiova") (sides "Romanian"))
(base 163 171 0 (n "Cucuta") (sides "Colombian"))
(base 557 189 0 (n "Da Nang") (sides "Vietnamese"))
(base 565 243 0 (n "Dandong") (sides "Chinese"))
(base 637 126 0 (n "Darwin") (sides "Australian"))
(base 604 170 0 (n "Davao") (sides "Filipino"))
(base 102 243 0 (n "Dayton") (sides "American"))
(base 328 260 0 (n "Debrecen") (sides "Hungarian"))
(base 80 246 0 (n "Des Moines") (sides "American"))
(base 381 237 0 (n "Diyarbakir") (sides "Turk"))
(base 417 179 0 (n "Djibouti"))
(base 278 268 0 (n "Dover") (sides "British"))
(base 428 210 0 (n "Dubai"))
(base 75 206 0 (n "Durango") (sides "Mexican"))
(base 444 249 0 (n "Dzambul") (sides "Kazakh"))
(base 381 242 0 (n "Erzurum") (sides "Turk"))
(base 11 252 0 (n "Eugene") (sides "American"))
(base 284 229 0 (n "Fez") (sides "Moroccan"))
(base 569 212 0 (n "Fuzhou") (sides "Chinese"))
(base 345 255 0 (n "Galati") (sides "Romanian"))
(base 376 236 0 (n "Gaziantep") (sides "Turk"))
(base 197 169 0 (n "Georgetown"))
(base 281 234 0 (n "Gibraltar") (sides "British"))
(base 242 116 0 (n "Goiania") (sides "Brazilian"))
(base 96 249 0 (n "Grand Rapids") (sides "American"))
(base 386 251 0 (n "Grozny") (sides "Russian"))
(base 541 213 0 (n "Guiyang") (sides "Chinese"))
(base 556 198 0 (n "Haikou") (sides "Chinese"))
(base 600 250 0 (n "Hakodate") (sides "Japanese"))
(base 141 253 0 (n "Halifax") (sides "Canadian"))
(base 108 251 0 (n "Hamilton") (sides "Canadian"))
(base 567 220 0 (n "Hangzhou") (sides "Chinese"))
(base 709 59 0 (n "Hobart") (sides "Australian"))
(base 557 226 0 (n "Huainan") (sides "Chinese"))
(base 102 231 0 (n "Huntsville") (sides "American"))
(base 457 210 0 (n "Hyderabad PAK") (sides "Pakistani"))
(base 333 170 0 (n "Ibadan") (sides "Nigerian"))
(base 573 237 0 (n "Inchon") (sides "Korean"))
(base 476 205 0 (n "Indore") (sides "Indian"))
(base 307 258 0 (n "Innsbruck") (sides "Austrian"))
(base 175 145 0 (n "Iquitos") (sides "Peruvian"))
(base 296 263 0 (n "Karlsruhe") (sides "German"))
(base 297 268 0 (n "Kassel") (sides "German"))
(base 295 275 0 (n "Kiel") (sides "German"))
(base 389 155 0 (n "Kisangani") (sides "Zairean"))
(base 410 125 0 (n "Kitwe") (sides "Zambian"))
(base 318 278 0 (n "Klaipeda") (sides "Lithuanian"))
(base 580 267 0 (n "Komsomol'sk") (sides "Russian"))
(base 326 262 0 (n "Kosice") (sides "Slovakian"))
(base 370 254 0 (n "Krasnodarsk") (sides "Russian"))
(base 307 252 0 (n "La Spezia") (sides "Italian"))
(base 265 220 0 (n "Las Palmas") (sides "Spanish"))
(base 103 239 0 (n "Lexington") (sides "American"))
(base 285 266 0 (n "Lille") (sides "French"))
(base 284 257 0 (n "Limoges") (sides "French"))
(base 99 238 0 (n "Louisville") (sides "American"))
(base 326 268 0 (n "Lublin") (sides "Polish"))
(base 407 128 0 (n "Lubumbashi") (sides "Zairean"))
(base 482 214 0 (n "Lucknow") (sides "Indian"))
(base 495 175 0 (n "Madurai") (sides "Indian"))
(base 454 119 0 (n "Mahajanga") (sides "Madagascaran"))
(base 282 236 0 (n "Malaga") (sides "Spanish"))
(base 420 211 0 (n "Manama"))
(base 203 147 0 (n "Manaus") (sides "Brazilian"))
(base 523 203 0 (n "Mandalay") (sides "Burmese"))
(base 159 165 0 (n "Manizales") (sides "Colombian"))
(base 247 69 0 (n "Mar del Plata") (sides "Argentinian"))
(base 369 141 0 (n "Matadi") (sides "Zairean"))
(base 71 205 0 (n "Mazatlan") (sides "Mexican"))
(base 374 154 0 (n "Mboudaka") (sides "Zairean"))
(base 392 208 0 (n "Medina") (sides "Saudi"))
(base 217 80 0 (n "Mendoza") (sides "Argentinian"))
(base 110 200 0 (n "Merida") (sides "Mexican"))
(base 325 238 0 (n "Messina") (sides "Italian"))
(base 291 263 0 (n "Metz") (sides "French"))
(base 103 222 0 (n "Mobile") (sides "American"))
(base 426 145 0 (n "Mombasa") (sides "Kenyan"))
(base 389 234 0 (n "Mosul") (sides "Iraqi"))
(base 457 223 0 (n "Multan") (sides "Pakistani"))
(base 331 308 0 (n "Murmansk") (sides "Russian"))
(base 352 258 0 (n "Mykolayiv") (sides "Ukrainian"))
(base 559 217 0 (n "Nanchang") (sides "Chinese"))
(base 276 261 0 (n "Nantes") (sides "French"))
(base 261 141 0 (n "Natal") (sides "Brazilian"))
(base 570 220 0 (n "Ningbo") (sides "Chinese"))
(base 275 271 0 (n "Norwich") (sides "British"))
(base 333 172 0 (n "Ogbomosho") (sides "Nigerian"))
(base 122 216 0 (n "Orlando") (sides "American"))
(base 391 237 0 (n "Orumiyah") (sides "Iranian"))
(base 290 230 0 (n "Oujda") (sides "Moroccan"))
(base 570 147 0 (n "Palembang") (sides "Indonesian"))
(base 626 273 0 (n "P. Kamchatkij") (sides "Russian"))
(base 204 167 0 (n "Paramaribo"))
(base 160 157 0 (n "Pasto") (sides "Colombian"))
(base 341 237 0 (n "Patra") (sides "Greek"))
(base 342 248 0 (n "Plovdiv") (sides "Bulgarian"))
(base 267 266 0 (n "Plymouth") (sides "British"))
(base 308 264 0 (n "Plzen") (sides "Czech"))
(base 355 264 0 (n "Poltava") (sides "Ukrainian"))
(base 576 153 0 (n "Pontaniak") (sides "Indonesian"))
(base 344 164 0 (n "Port Harcourt") (sides "Nigerian"))
(base 370 222 0 (n "Port Said") (sides "Egyptian"))
(base 274 267 0 (n "Portsmouth") (sides "British"))
(base 332 249 0 (n "Pristina") (sides "Yugoslavian"))
(base 442 225 0 (n "Qandahar") (sides "Afghan"))
(base 553 260 0 (n "Qiqihar") (sides "Chinese"))
(base 121 259 0 (n "Quebec") (sides "Canadian"))
(base 159 153 0 (n "Quito") (sides "Ecuadorean"))
(base 119 233 0 (n "Raleigh") (sides "American"))
(base 458 229 0 (n "Rawalpindi") (sides "Pakistani"))
(base 287 263 0 (n "Reims") (sides "French"))
(base 119 237 0 (n "Richmond") (sides "American"))
(base 114 236 0 (n "Roanoke") (sides "American"))
(base 89 247 0 (n "Rockford") (sides "American"))
(base 234 80 0 (n "Rosario") (sides "Argentinian"))
(base 301 274 0 (n "Rostock") (sides "German"))
(base 293 263 0 (n "Saarbruecken") (sides "German"))
(base 33 231 0 (n "San Bernardino") (sides "American"))
(base 84 203 0 (n "San Luis Potosi") (sides "Mexican"))
(base 210 115 0 (n "Santa Cruz de la Sierra") (sides "Bolivian"))
(base 142 198 0 (n "Santiago de Cuba") (sides "Cuban"))
(base 117 224 0 (n "Savannah") (sides "American"))
(base 299 272 0 (n "Schwerin") (sides "German"))
(base 359 253 0 (n "Sevastopol") (sides "Ukrainian"))
(base 420 219 0 (n "Shiraz") (sides "Iranian"))
(base 344 275 0 (n "Smolensk") (sides "Russian"))
(base 276 269 0 (n "Southend") (sides "British"))
(base 321 250 0 (n "Split") (sides "Croatian"))
(base 163 260 0 (n "St. John's") (sides "Canadian"))
(base 296 262 0 (n "Strasbourg") (sides "French"))
(base 371 221 0 (n "Suez") (sides "Egyptian"))
(base 473 201 0 (n "Surat") (sides "Indian"))
(base 326 257 0 (n "Szeged") (sides "Hungarian"))
(base 394 238 0 (n "Tabriz") (sides "Iranian"))
(base 91 203 0 (n "Tampico") (sides "Mexican"))
(base 280 232 0 (n "Tangier") (sides "Moroccan"))
(base 330 256 0 (n "Timisoara") (sides "Romanian"))
(base 298 250 0 (n "Toulon") (sides "French"))
(base 280 260 0 (n "Tours") (sides "French"))
(base 376 245 0 (n "Trabzon") (sides "Turk"))
(base 286 297 0 (n "Trondheim") (sides "Norwegian"))
(base 316 289 0 (n "Turku") (sides "Finnish"))
(base 605 143 0 (n "Ujung Pendang") (sides "Indonesian"))
(base 276 246 0 (n "Valladolid") (sides "Spanish"))
(base 327 232 0 (n "Valletta"))
(base 347 251 0 (n "Varna") (sides "Bulgarian"))
(base 311 255 0 (n "Venice") (sides "Italian"))
(base 266 248 0 (n "Vigo") (sides "Spanish"))
(base 496 194 0 (n "Vijayawada") (sides "Indian"))
(base 340 276 0 (n "Vitebsk") (sides "Belarussian"))
(base 62 264 0 (n "Winnipeg") (sides "Canadian"))
(base 358 163 0 (n "Yaounde") (sides "Cameroonian"))
(base 588 136 0 (n "Yogyakarta") (sides "Indonesian"))
(base 556 230 0 (n "Xuzhou") (sides "Chinese"))
(base 428 141 0 (n "Zanzibar") (sides "Tanzanian"))

(town 319 165 0 (n "Abidjan") (sides "Ivorian"))
(town 340 174 0 (n "Abuja") (sides "Nigerian"))
(town 326 166 0 (n "Accra") (sides "Ghanaian"))
(town 370 236 0 (n "Adana") (sides "Turk"))
(town 419 182 0 (n "Aden") (sides "Yemeni"))
(town 408 175 0 (n "Adis Abeba") (sides "Ethiopian"))
(town 470 205 0 (n "Ahmadabad") (sides "Indian"))
(town 57 232 0 (n "Albuquerque") (sides "American"))
(town 365 223 0 (n "Alexandria") (sides "Egyptian"))
(town 300 235 0 (n "Algiers") (sides "Algerian"))
(town 455 250 0 (n "Alma-Ata") (sides "Kazakh"))
(town 378 225 0 (n "Amman") (sides "Jordanian"))
(town 285 270 0 (n "Amsterdam") (sides "Dutch"))
(town 362 242 0 (n "Ankara") (sides "Turk"))
(town 460 112 0 (n "Antananarivo") (sides "Madagascaran"))
(town 286 268 0 (n "Antwerp") (sides "Belgian"))
(town 601 248 0 (n "Aomori") (sides "Japanese"))
(town 421 241 0 (n "Ashgabat") (sides "Turkmen"))
(town 401 189 0 (n "Asmera") (sides "Eritrean"))
(town 389 257 0 (n "Astrachan'") (sides "Russian"))
(town 233 98 0 (n "Asuncion") (sides "Paraguayan"))
(town 344 238 0 (n "Athens") (sides "Greek"))
(town 108 229 0 (n "Atlanta") (sides "American"))
(town 762 72 0 (n "Auckland") (sides "New Zealander"))
(town 83 221 0 (n "Austin") (sides "American"))
(town 396 227 0 (n "Baghdad") (sides "Iraqi"))
(town 399 243 0 (n "Baku") (sides "Azerbaijani"))
(town 120 241 0 (n "Baltimore") (sides "American"))
(town 300 184 0 (n "Bamako") (sides "Malian"))
(town 580 138 0 (n "Bandung") (sides "Indonesian"))
(town 488 186 0 (n "Bangalore") (sides "Indian"))
(town 541 184 0 (n "Bangkok") (sides "Siamese"))
(town 369 163 0 (n "Bangui") (sides "Central African"))
(town 154 179 0 (n "Baranquilla") (sides "Colombian"))
(town 292 246 0 (n "Barcelona") (sides "Spanish"))
(town 460 273 0 (n "Barnaul") (sides "Russian"))
(town 375 229 0 (n "Beirut") (sides "Lebanese"))
(town 227 150 0 (n "Belem") (sides "Brazilian"))
(town 257 278 0 (n "Belfast") (sides "British"))
(town 329 253 0 (n "Belgrade") (sides "Yugoslavian"))
(town 258 109 0 (n "Belo Horizonte") (sides "Brazilian"))
(town 297 258 0 (n "Bern") (sides "Swiss"))
(town 293 270 0 (n "Bielefeld") (sides "German"))
(town 103 228 0 (n "Birmingham AL") (sides "American"))
(town 451 249 0 (n "Bishkek") (sides "Kyrgyz"))
(town 428 119 0 (n "Blantyre") (sides "Malawian"))
(town 163 164 0 (n "Bogota") (sides "Colombian"))
(town 309 253 0 (n "Bologna") (sides "Italian"))
(town 281 255 0 (n "Bordeaux") (sides "French"))
(town 350 272 0 (n "Br'ansk") (sides "Russian"))
(town 244 118 0 (n "Brasilia") (sides "Brazilian"))
(town 318 261 0 (n "Bratislava") (sides "Slovakian"))
(town 370 146 0 (n "Brazzaville") (sides "Congolese"))
(town 293 272 0 (n "Bremen") (sides "German"))
(town 705 93 0 (n "Brisbane") (sides "Australian"))
(town 269 269 0 (n "Bristol") (sides "British"))
(town 316 263 0 (n "Brno") (sides "Czech"))
(town 286 267 0 (n "Brussels") (sides "Belgian"))
(town 342 253 0 (n "Bucharest") (sides "Romanian"))
(town 322 260 0 (n "Budapest") (sides "Hungarian"))
(town 241 77 0 (n "Buenos Aires") (sides "Argentinian"))
(town 111 249 0 (n "Buffalo") (sides "American"))
(town 404 147 0 (n "Bujumbura") (sides "Burundi"))
(town 23 267 0 (n "Calgary") (sides "Canadian"))
(town 159 162 0 (n "Cali") (sides "Colombian"))
(town 705 75 0 (n "Canberra") (sides "Australian"))
(town 411 79 0 (n "Cape Town") (sides "South African"))
(town 173 177 0 (n "Caracas") (sides "Venezuelan"))
(town 278 229 0 (n "Casablanca") (sides "Moroccan"))
(town 597 177 0 (n "Cebu") (sides "Filipino"))
(town 562 251 0 (n "Changchun") (sides "Chinese"))
(town 575 246 0 (n "Changjin") (sides "Chinese"))
(town 551 219 0 (n "Changsha") (sides "Chinese"))
(town 409 276 0 (n "Chelabinsk") (sides "Russian"))
(town 305 267 0 (n "Chemnitz") (sides "German"))
(town 531 223 0 (n "Chengdu") (sides "Chinese"))
(town 765 57 0 (n "Christchurch") (sides "New Zealander"))
(town 102 241 0 (n "Cincinnati") (sides "American"))
(town 105 246 0 (n "Cleveland") (sides "American"))
(town 291 267 0 (n "Cologne") (sides "German"))
(town 504 169 0 (n "Colombo") (sides "Sri Lankan"))
(town 104 243 0 (n "Columbus") (sides "American"))
(town 293 175 0 (n "Conakry") (sides "Guinean"))
(town 225 84 0 (n "Cordoba") (sides "Spanish"))
(town 331 168 0 (n "Cotonou") (sides "Beninese"))
(town 252 97 0 (n "Curitiba") (sides "Brazilian"))
(town 508 206 0 (n "Dacca") (sides "Bangladeshi"))
(town 559 240 0 (n "Dairen") (sides "Chinese"))
(town 278 186 0 (n "Dakar") (sides "Senegalese"))
(town 80 226 0 (n "Dallas") (sides "American"))
(town 377 228 0 (n "Damascus") (sides "Syrian"))
(town 429 139 0 (n "Dar es Salaam") (sides "Tanzanian"))
(town 357 261 0 (n "Dnipropetrovsk") (sides "Ukrainian"))
(town 292 269 0 (n "Dortmund") (sides "German"))
(town 350 163 0 (n "Douala") (sides "Cameroonian"))
(town 306 268 0 (n "Dresden") (sides "German"))
(town 259 274 0 (n "Dublin") (sides "Irish"))
(town 435 85 0 (n "Durban") (sides "South African"))
(town 442 240 0 (n "Dusanbe") (sides "Tajik"))
(town 291 268 0 (n "Dusseldorf") (sides "German"))
(town 264 278 0 (n "Edinburgh") (sides "British"))
(town 21 273 0 (n "Edmonton") (sides "Canadian"))
(town 61 224 0 (n "El Paso") (sides "American"))
(town 412 228 0 (n "Esfahan") (sides "Iranian"))
(town 292 268 0 (n "Essen") (sides "German"))
(town 460 224 0 (n "Faisalabad") (sides "Pakistani"))
(town 310 251 0 (n "Florence") (sides "Italian"))
(town 252 145 0 (n "Fortaleza") (sides "Brazilian"))
(town 296 266 0 (n "Frankfurt") (sides "German"))
(town 295 172 0 (n "Freetown") (sides "Sierra Leonan"))
(town 79 226 0 (n "Ft Worth") (sides "American"))
(town 585 230 0 (n "Fukuoka") (sides "Japanese"))
(town 418 99 0 (n "Gaborone") (sides "Motswana"))
(town 314 274 0 (n "Gdansk") (sides "Polish"))
(town 304 252 0 (n "Genoa") (sides "Italian"))
(town 298 282 0 (n "Goteborg") (sides "Swedish"))
(town 80 200 0 (n "Guadalajara") (sides "Mexican"))
(town 559 205 0 (n "Guangzhou") (sides "Chinese"))
(town 116 186 0 (n "Guatemala") (sides "Guatemalan"))
(town 157 150 0 (n "Guayaquil") (sides "Ecuadorean"))
(town 545 201 0 (n "Ha-noi") (sides "Vietnamese"))
(town 562 256 0 (n "Haerbin") (sides "Chinese"))
(town 375 227 0 (n "Haifa") (sides "Israeli"))
(town 296 270 0 (n "Hannover") (sides "German"))
(town 422 114 0 (n "Harare") (sides "Zimbabwean"))
(town 125 247 0 (n "Hartford") (sides "American"))
(town 321 288 0 (n "Helsinki") (sides "Finnish"))
(town 590 233 0 (n "Hiroshima") (sides "Japanese"))
(town 559 177 0 (n "Ho Chi Minh City") (sides "Vietnamese"))
(town 758 204 0 (n "Honolulu") (sides "American"))
(town 273 273 0 (n "Hull") (sides "British"))
(town 486 195 0 (n "Hyderabad") (sides "Indian"))
(town 97 242 0 (n "Indianapolis") (sides "American"))
(town 507 271 0 (n "Irkutsk") (sides "Russian"))
(town 351 239 0 (n "Izmir") (sides "Turk"))
(town 118 221 0 (n "Jacksonville") (sides "American"))
(town 471 214 0 (n "Jaipur") (sides "Indian"))
(town 578 139 0 (n "Jakarta") (sides "Indonesian"))
(town 357 282 0 (n "Jaroslavi") (sides "Russian"))
(town 387 243 0 (n "Jerevan") (sides "Armenian"))
(town 376 225 0 (n "Jerusalem") (sides "Israeli"))
(town 397 202 0 (n "Jiddah") (sides "Saudi"))
(town 553 235 0 (n "Jinan") (sides "Chinese"))
(town 448 232 0 (n "Kabul") (sides "Afghan"))
(town 589 224 0 (n "Kagoshima") (sides "Japanese"))
(town 405 154 0 (n "Kampala") (sides "Ugandan"))
(town 597 238 0 (n "Kanazawa") (sides "Japanese"))
(town 339 181 0 (n "Kano") (sides "Nigerian"))
(town 481 213 0 (n "Kanpur") (sides "Indian"))
(town 79 241 0 (n "Kansas City") (sides "American"))
(town 576 204 0 (n "Kaohsiun") (sides "Chinese"))
(town 440 264 0 (n "Karaganda") (sides "Kazakh"))
(town 492 215 0 (n "Kathmandu") (sides "Nepalese"))
(town 319 266 0 (n "Katowice") (sides "Polish"))
(town 325 275 0 (n "Kaunas") (sides "Lithuanian"))
(town 381 277 0 (n "Kazan'") (sides "Russian"))
(town 463 277 0 (n "Kemerovo") (sides "Russian"))
(town 358 265 0 (n "Kharkiv") (sides "Ukrainian"))
(town 389 188 0 (n "Khartoum") (sides "Sudanese"))
(town 403 150 0 (n "Kigali") (sides "Rwandan"))
(town 142 194 0 (n "Kingston") (sides "Jamaican"))
(town 372 144 0 (n "Kinshasa") (sides "Zairean"))
(town 344 259 0 (n "Kishinev") (sides "Moldovan"))
(town 586 231 0 (n "Kitakyushu") (sides "Japanese"))
(town 318 275 0 (n "Konigsberg") (sides "Russian"))
(town 322 265 0 (n "Krakow") (sides "Polish"))
(town 476 279 0 (n "Krasnojarsk") (sides "Russian"))
(town 556 161 0 (n "Kuala Lumpur") (sides "Malaysian"))
(town 386 272 0 (n "Kujbyshev") (sides "Russian"))
(town 588 226 0 (n "Kumamoto") (sides "Japanese"))
(town 317 173 0 (n "Kumasi") (sides "Ghanaian"))
(town 533 210 0 (n "Kunming") (sides "Chinese"))
(town 408 219 0 (n "Kuwait City") (sides "Kuwaiti"))
(town 417 275 0 (n "Kurgan") (sides "Russian"))
(town 576 232 0 (n "Kwangju") (sides "Korean"))
(town 125 205 0 (n "La Habana") (sides "Cuban"))
(town 200 117 0 (n "La Paz") (sides "Bolivian"))
(town 333 168 0 (n "Lagos") (sides "Nigerian"))
(town 462 225 0 (n "Lahore") (sides "Pakistani"))
(town 278 264 0 (n "Le Havre") (sides "French"))
(town 268 275 0 (n "Leeds") (sides "British"))
(town 272 271 0 (n "Leicester") (sides "British"))
(town 302 269 0 (n "Leipzig") (sides "German"))
(town 354 154 0 (n "Libreville") (sides "Gabonese"))
(town 175 126 0 (n "Lima") (sides "Peruvian"))
(town 310 261 0 (n "Linz") (sides "Austrian"))
(town 270 240 0 (n "Lisbon") (sides "Portuguese"))
(town 267 273 0 (n "Liverpool") (sides "British"))
(town 314 256 0 (n "Ljubljana") (sides "Slovenian"))
(town 320 269 0 (n "Lodz") (sides "Polish"))
(town 330 167 0 (n "Lome") (sides "Togolese"))
(town 372 134 0 (n "Luanda") (sides "Angolan"))
(town 413 120 0 (n "Lusaka") (sides "Zambian"))
(town 331 264 0 (n "L'viv") (sides "Ukrainian"))
(town 293 255 0 (n "Lyon") (sides "French"))
(town 497 183 0 (n "Madras") (sides "Indian"))
(town 300 270 0 (n "Magdeburg") (sides "German"))
(town 405 272 0 (n "Magnitogorsk") (sides "Russian"))
(town 128 181 0 (n "Managua") (sides "Nicaragua"))
(town 586 186 0 (n "Manila") (sides "Philippine"))
(town 296 264 0 (n "Mannheim") (sides "German"))
(town 434 96 0 (n "Maputo") (sides "Mozambican"))
(town 161 178 0 (n "Maracaibo") (sides "Venezuelan"))
(town 280 224 0 (n "Marrakech") (sides "Moroccan"))
(town 296 250 0 (n "Marseilles") (sides "French"))
(town 424 236 0 (n "Mashhad") (sides "Iranian"))
(town 591 230 0 (n "Matsuyama") (sides "Japanese"))
(town 398 202 0 (n "Mecca") (sides "Saudi"))
(town 548 162 0 (n "Medan") (sides "Indonesian"))
(town 157 168 0 (n "Medellin") (sides "Colombian"))
(town 94 232 0 (n "Memphis") (sides "American"))
(town 91 197 0 (n "Mexico City") (sides "Mexican"))
(town 126 211 0 (n "Miami") (sides "American"))
(town 90 250 0 (n "Milwaukee") (sides "American"))
(town 77 253 0 (n "Minneapolis-St. Paul") (sides "American"))
(town 335 273 0 (n "Minsk") (sides "Belarussian"))
(town 432 158 0 (n "Mogadishu") (sides "Somalian"))
(town 302 167 0 (n "Monrovia") (sides "Liberian"))
(town 81 211 0 (n "Monterrey") (sides "Mexican"))
(town 247 77 0 (n "Montevideo") (sides "Uruguayan"))
(town 292 270 0 (n "Muenster") (sides "German"))
(town 440 206 0 (n "Muscat") (sides "Omani"))
(town 354 180 0 (n "N'djamena") (sides "Chadian"))
(town 586 226 0 (n "Nagasaki") (sides "Japanese"))
(town 484 203 0 (n "Nagpur") (sides "Indian"))
(town 588 212 0 (n "Naha") (sides "Japanese"))
(town 417 151 0 (n "Nairobi") (sides "Kenyan"))
(town 561 225 0 (n "Nanjing") (sides "Chinese"))
(town 319 244 0 (n "Naples") (sides "Italian"))
(town 100 234 0 (n "Nashville") (sides "American"))
(town 99 220 0 (n "New Orleans") (sides "American"))
(town 123 244 0 (n "Newark") (sides "American"))
(town 268 277 0 (n "Newcastle") (sides "British"))
(town 323 183 0 (n "Niamey") (sides "Nigerien"))
(town 301 251 0 (n "Nice") (sides "French"))
(town 600 241 0 (n "Niigata") (sides "Japanese"))
(town 402 283 0 (n "Niznij Tagil") (sides "Russian"))
(town 123 235 0 (n "Norfolk") (sides "American"))
(town 278 193 0 (n "Nouakchott") (sides "Mauritanian"))
(town 466 273 0 (n "Novokuzneck") (sides "Russian"))
(town 302 264 0 (n "Nuremberg") (sides "German"))
(town 349 257 0 (n "Odessa") (sides "Ukrainian"))
(town 592 233 0 (n "Okayama") (sides "Japanese"))
(town 76 233 0 (n "Oklahoma City") (sides "American"))
(town 74 245 0 (n "Omaha") (sides "American"))
(town 435 275 0 (n "Omsk") (sides "Russian"))
(town 294 233 0 (n "Oran") (sides "Algerian"))
(town 398 269 0 (n "Orenburg") (sides "Russian"))
(town 292 287 0 (n "Oslo") (sides "Norwegian"))
(town 319 264 0 (n "Ostrava") (sides "Czech"))
(town 114 255 0 (n "Ottawa") (sides "Canadian"))
(town 316 181 0 (n "Ouagadougou") (sides "Burkinabe"))
(town 321 238 0 (n "Palermo") (sides "Italian"))
(town 146 174 0 (n "Panama City") (sides "Panamanian"))
(town 494 211 0 (n "Patna") (sides "Indian"))
(town 393 283 0 (n "Perm'") (sides "Russian"))
(town 626 83 0 (n "Perth") (sides "Australian"))
(town 426 275 0 (n "Petropavlovsk") (sides "Russian"))
(town 554 180 0 (n "Phnom-Penh") (sides "Kampuchean"))
(town 46 228 0 (n "Phoenix") (sides "American"))
(town 110 244 0 (n "Pittsburgh") (sides "American"))
(town 480 195 0 (n "Poona") (sides "Indian"))
(town 428 79 0 (n "Port Elizabeth") (sides "South African"))
(town 672 133 0 (n "Port Moresby") (sides "Papuan"))
(town 152 195 0 (n "Port-au-Prince") (sides "Haitian"))
(town 10 255 0 (n "Portland") (sides "American"))
(town 267 245 0 (n "Porto") (sides "Portuguese"))
(town 253 87 0 (n "Porto Alegre") (sides "Brazilian"))
(town 313 271 0 (n "Poznan") (sides "Polish"))
(town 310 265 0 (n "Prague") (sides "Czech"))
(town 424 97 0 (n "Pretoria") (sides "South African"))
(town 128 246 0 (n "Providence") (sides "American"))
(town 581 232 0 (n "Pusan") (sides "Korean"))
(town 569 241 0 (n "Pyongyang") (sides "Korean"))
(town 561 234 0 (n "Qingdao") (sides "Chinese"))
(town 279 230 0 (n "Rabat") (sides "Moroccan"))
(town 528 191 0 (n "Rangoon") (sides "Burmese"))
(town 264 136 0 (n "Recife") (sides "Brazilian"))
(town 209 287 0 (n "Reykjavik") (sides "Icelander"))
(town 324 280 0 (n "Riga") (sides "Latvian"))
(town 262 103 0 (n "Rio de Janeiro") (sides "Brazilian"))
(town 410 208 0 (n "Riyadh") (sides "Saudi"))
(town 113 250 0 (n "Rochester") (sides "American"))
(town 369 259 0 (n "Rostov") (sides "Russian"))
(town 280 264 0 (n "Rouen") (sides "French"))
(town 19 240 0 (n "Sacramento") (sides "American"))
(town 39 244 0 (n "Salt Lake City") (sides "American"))
(town 263 125 0 (n "Salvador") (sides "Brazilian"))
(town 439 242 0 (n "Samarkand") (sides "Uzbek"))
(town 81 219 0 (n "San Antonio") (sides "American"))
(town 36 226 0 (n "San Diego") (sides "American"))
(town 135 176 0 (n "San Jose") (sides "Costa Rican"))
(town 20 237 0 (n "San Jose CA") (sides "American"))
(town 166 195 0 (n "San Juan") (sides "American"))
(town 120 184 0 (n "San Salvador") (sides "Salvadoran"))
(town 213 79 0 (n "Santiago") (sides "Chilean"))
(town 157 195 0 (n "Santo Domingo") (sides "Dominican"))
(town 599 252 0 (n "Sapporo") (sides "Japanese"))
(town 324 251 0 (n "Sarajevo") (sides "Bosnian"))
(town 378 268 0 (n "Saratov") (sides "Russian"))
(town 604 242 0 (n "Sendai") (sides "Japanese"))
(town 278 237 0 (n "Seville") (sides "Spanish"))
(town 602 234 0 (n "Shizuoka") (sides "Japanese"))
(town 334 247 0 (n "Skopje") (sides "Macedonian"))
(town 338 249 0 (n "Sofia") (sides "Bulgarian"))
(town 90 239 0 (n "St. Louis") (sides "American"))
(town 334 287 0 (n "St. Petersburg") (sides "Russian"))
(town 306 273 0 (n "Stettin") (sides "Polish"))
(town 307 286 0 (n "Stockholm") (sides "Swedish"))
(town 299 262 0 (n "Stuttgart") (sides "German"))
(town 590 138 0 (n "Surabaya") (sides "Indonesian"))
(town 404 280 0 (n "Sverdlovsk") (sides "Russian"))
(town 575 210 0 (n "T'aipei") (sides "Chinese"))
(town 415 280 0 (n "T'umen'") (sides "Russian"))
(town 579 234 0 (n "Taegu") (sides "Korean"))
(town 322 286 0 (n "Tallinn") (sides "Estonian"))
(town 120 215 0 (n "Tampa") (sides "American"))
(town 440 246 0 (n "Tashkent") (sides "Uzbek"))
(town 386 246 0 (n "Tbilisi") (sides "Georgian"))
(town 124 185 0 (n "Tegucigalpa") (sides "Honduran"))
(town 410 234 0 (n "Tehran") (sides "Iranian"))
(town 375 225 0 (n "Tel Aviv") (sides "Israeli"))
(town 339 244 0 (n "Thessaloniki") (sides "Greek"))
(town 550 241 0 (n "Tianjin") (sides "Chinese"))
(town 333 245 0 (n "Tirane") (sides "Albanian"))
(town 101 247 0 (n "Toledo") (sides "American"))
(town 459 280 0 (n "Tomsk") (sides "Russian"))
(town 300 254 0 (n "Torino") (sides "Italian"))
(town 289 250 0 (n "Toulouse") (sides "French"))
(town 313 255 0 (n "Trieste") (sides "Italian"))
(town 326 226 0 (n "Tripoli") (sides "Libyan"))
(town 51 225 0 (n "Tucson") (sides "American"))
(town 218 94 0 (n "Tucuman") (sides "Argentinian"))
(town 357 274 0 (n "Tula") (sides "Russian"))
(town 80 236 0 (n "Tulsa") (sides "American"))
(town 315 235 0 (n "Tunis") (sides "Tunisian"))
(town 518 260 0 (n "Ulaan Bataar") (sides "Mongolian"))
(town 515 269 0 (n "Ulan Ude") (sides "Russian"))
(town 460 264 0 (n "Ust' Kamenogorsk") (sides "Kazakh"))
(town 288 242 0 (n "Valencia") (sides "Spanish"))
(town 210 80 0 (n "Valparaiso") (sides "Chilean"))
(town 5 263 0 (n "Vancouver") (sides "Canadian"))
(town 98 197 0 (n "Veracruz") (sides "Mexican"))
(town 307 255 0 (n "Verona") (sides "Italian"))
(town 543 194 0 (n "Vientiane") (sides "Laotian"))
(town 329 275 0 (n "Vilnius") (sides "Lithuanian"))
(town 341 263 0 (n "Vinnytysa") (sides "Ukrainian"))
(town 579 250 0 (n "Vladivostok") (sides "Russian"))
(town 377 262 0 (n "Volgograd") (sides "Russian"))
(town 596 231 0 (n "Wakayama") (sides "Japanese"))
(town 73 238 0 (n "Wichita") (sides "American"))
(town 396 103 0 (n "Windhoek") (sides "Namibian"))
(town 315 267 0 (n "Wroclaw") (sides "Polish"))
(town 553 222 0 (n "Wuhan") (sides "Chinese"))
(town 535 232 0 (n "Xi'an") (sides "Chinese"))
(town 517 236 0 (n "Xining") (sides "Chinese"))
(town 604 235 0 (n "Yokohama") (sides "Japanese"))
(town 317 256 0 (n "Zagreb") (sides "Croatian"))
(town 284 246 0 (n "Zaragoza") (sides "Spanish"))
(town 544 234 0 (n "Zhengzhou") (sides "Chinese"))
(town 300 259 0 (n "Zurich") (sides "Swiss"))

(city 547 242 0 (n "Beijing") (sides "Chinese"))
(city 304 271 0 (n "Berlin") (sides "German"))
(city 270 271 0 (n "Birmingham") (sides "British"))
(city 475 196 0 (n "Bombay") (sides "Indian"))
(city 128 248 0 (n "Boston") (sides "American"))
(city 369 220 0 (n "Cairo") (sides "Egyptian"))
(city 504 204 0 (n "Calcutta") (sides "Indian"))
(city 92 246 0 (n "Chicago") (sides "American"))
(city 538 219 0 (n "Chongqing") (sides "Chinese"))
(city 299 278 0 (n "Copenhagen") (sides "Danish"))
(city 473 218 0 (n "Delhi") (sides "Indian"))
(city 56 241 0 (n "Denver") (sides "American"))
(city 101 248 0 (n "Detroit") (sides "American"))
(city 363 260 0 (n "Donets'k") (sides "Ukrainian"))
(city 262 278 0 (n "Glasgow") (sides "British"))
(city 368 279 0 (n "Gorky") (sides "Russian"))
(city 295 273 0 (n "Hamburg") (sides "German"))
(city 562 204 0 (n "Hong Kong") (sides "Chinese"))
(city 87 220 0 (n "Houston") (sides "American"))
(city 352 245 0 (n "Istanbul") (sides "Turk"))
(city 424 96 0 (n "Johannesburg") (sides "South African"))
(city 455 209 0 (n "Karachi") (sides "Pakistani"))
(city 345 266 0 (n "Kiev") (sides "Ukrainian"))
(city 594 233 0 (n "Kobe") (sides "Japanese"))
(city 595 234 0 (n "Kyoto") (sides "Japanese"))
(city 275 269 0 (n "London") (sides "British"))
(city 31 230 0 (n "Los Angeles") (sides "American"))
(city 280 243 0 (n "Madrid") (sides "Spanish"))
(city 268 273 0 (n "Manchester") (sides "British"))
(city 697 70 0 (n "Melbourne") (sides "Australian"))
(city 303 255 0 (n "Milan") (sides "Italian"))
(city 118 255 0 (n "Montreal") (sides "Canadian"))
(city 355 277 0 (n "Moscow") (sides "Russian"))
(city 306 261 0 (n "Munich") (sides "German"))
(city 599 235 0 (n "Nagoya") (sides "Japanese"))
(city 124 244 0 (n "New York") (sides "American"))
(city 456 277 0 (n "Novosibirsk") (sides "Russian"))
(city 595 233 0 (n "Osaka") (sides "Japanese"))
(city 284 262 0 (n "Paris") (sides "French"))
(city 122 242 0 (n "Philadelphia") (sides "American"))
(city 315 246 0 (n "Rome") (sides "Italian"))
(city 285 269 0 (n "Rotterdam") (sides "Dutch"))
(city 18 238 0 (n "San Francisco") (sides "American"))
(city 255 102 0 (n "Sao Paulo") (sides "Brazilian"))
(city 9 259 0 (n "Seattle") (sides "American"))
(city 574 237 0 (n "Seoul") (sides "Korean"))
(city 569 223 0 (n "Shanghai") (sides "Chinese"))
(city 560 248 0 (n "Shengyang") (sides "Chinese"))
(city 562 157 0 (n "Singapore") (sides "Singaporean"))
(city 707 78 0 (n "Sydney") (sides "Australian"))
(city 540 238 0 (n "Taiyuan") (sides "Chinese"))
(city 604 236 0 (n "Tokyo") (sides "Japanese"))
(city 109 252 0 (n "Toronto") (sides "Canadian"))
(city 316 261 0 (n "Vienna") (sides "Austrian"))
(city 322 270 0 (n "Warsaw") (sides "Polish"))
(city 118 240 0 (n "Washington DC") (sides "American"))

