# tcl/tk browser for Xconq image families.
# Copyright (C) 1998-2000 Stanley T. Shebs.

# Xconq is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.  See the file COPYING.

set mag 32
set showcolor 1
set shownames 1
set showmasks 1
set bgcolor gray
set fgcolor magenta
set showbbox 0
set showsolid 0
set showgrid 0
set with_emblem 0

set as unit

set tk_strictMotif 1

wm title . imfapp

menu .menubar
. configure -menu .menubar

.menubar add cascade -label File -menu .menubar.file
menu .menubar.file
.menubar.file add command -label New \
	-command { new_cmd }
.menubar.file add command -label "Open Imf Dir..." -state disabled \
	-command { open_imf_dir_cmd }
.menubar.file add command -label "Add Imf File..." \
	-command { add_imf_file_cmd }
.menubar.file add command -label "Add Other File..." \
	-command { add_other_file_cmd }
.menubar.file add separator
.menubar.file add command -label "Save Imf Dir..." -state disabled \
	-command { save_imf_dir_cmd }
.menubar.file add command -label "Save Imf File..." \
	-command { save_imf_file_cmd }
.menubar.file add check -label "Save Selected Only" \
	-variable save_selected_only
.menubar.file add separator
.menubar.file add command -label Quit \
	-command { exit }

.menubar add cascade -label View -menu .menubar.view
menu .menubar.view
.menubar.view add radio -label 8x8 -variable mag -value 8 \
	-command { .images.content config -iwidth 8 -iheight 8 }
.menubar.view add radio -label 16x16 -variable mag -value 16 \
	-command { .images.content config -iwidth 16 -iheight 16 }
.menubar.view add radio -label 24x26 -variable mag -value 24 \
	-command { .images.content config -iwidth 24 -iheight 26 }
.menubar.view add radio -label 32x32 -variable mag -value 32 \
	-command { .images.content config -iwidth 32 -iheight 32 }
.menubar.view add radio -label 44x48 -variable mag -value 44 \
	-command { .images.content config -iwidth 44 -iheight 48 }
.menubar.view add radio -label 64x64 -variable mag -value 64 \
	-command { .images.content config -iwidth 64 -iheight 64 }
.menubar.view add radio -label 88x96 -variable mag -value 88 \
	-command { .images.content config -iwidth 88 -iheight 96 }
.menubar.view add separator
.menubar.view add check -label Color -variable showcolor \
	-command { toggle_show_color }
.menubar.view add check -label Names -variable shownames \
	-command { toggle_show_names }
.menubar.view add check -label Masks -variable showmasks \
	-command { toggle_show_masks }
.menubar.view add cascade -label Background -menu .menubar.view.bg
menu .menubar.view.bg
.menubar.view.bg add radio -label black -variable bgcolor \
	-command { set_bg_color }
.menubar.view.bg add radio -label gray -variable bgcolor \
	-command { set_bg_color }
.menubar.view.bg add radio -label white -variable bgcolor \
	-command { set_bg_color }
.menubar.view.bg add radio -label red -variable bgcolor \
	-command { set_bg_color }
.menubar.view.bg add radio -label green -variable bgcolor \
	-command { set_bg_color }
.menubar.view.bg add radio -label blue -variable bgcolor \
	-command { set_bg_color }
.menubar.view.bg add radio -label magenta -variable bgcolor \
	-command { set_bg_color }
.menubar.view.bg add radio -label maroon -variable bgcolor \
	-command { set_bg_color }
.menubar.view add cascade -label Foreground -menu .menubar.view.fg
menu .menubar.view.fg
.menubar.view.fg add radio -label black -variable fgcolor \
	-command { set_fg_color }
.menubar.view.fg add radio -label gray -variable fgcolor \
	-command { set_fg_color }
.menubar.view.fg add radio -label white -variable fgcolor \
	-command { set_fg_color }
.menubar.view.fg add radio -label red -variable fgcolor \
	-command { set_fg_color }
.menubar.view.fg add radio -label green -variable fgcolor \
	-command { set_fg_color }
.menubar.view.fg add radio -label blue -variable fgcolor \
	-command { set_fg_color }
.menubar.view.fg add radio -label magenta -variable fgcolor \
	-command { set_fg_color }
.menubar.view.fg add radio -label maroon -variable fgcolor \
	-command { set_fg_color }
.menubar.view add check -label BBox -variable showbbox \
	-command { toggle_show_bbox }
.menubar.view add check -label "Solid Color" -variable showsolid \
	-command { toggle_show_solid }
.menubar.view add check -label Grid -variable showgrid \
	-command { toggle_show_grid }
.menubar.view add separator
.menubar.view add radio -label "As Unit" -variable as -value unit \
	-command { toggle_as_unit }
.menubar.view add radio -label "As Terrain" -variable as -value terrain \
	-command { toggle_as_terrain }
.menubar.view add radio -label "As Emblem" -variable as -value emblem \
	-command { toggle_as_emblem }
.menubar.view add check -label "With Unit" -variable with_unit \
	-command { toggle_with_unit }
.menubar.view add check -label "With Selected as Terrain" -variable with_terrain \
	-command { toggle_with_terrain }
.menubar.view add check -label "With Selected As Emblem" \
	-variable with_emblem \
	-command { toggle_with_emblem }

frame .closeup -borderwidth 2 -relief sunken
pack .closeup -side top -fill x

canvas .closeup.content -height 130
pack .closeup.content -side top -fill both

.closeup.content create text 10 20 -tag selname -text "(nothing selected)" -anchor sw
.closeup.content create text 480 20 -tag status -text "" -anchor se

set winbgcolor [ .closeup.content cget -background ]

proc add_closeup { wid hgt sx sy } {
    global winbgcolor

    imfsample .closeup.content.s$wid -bg $winbgcolor -width $wid -height $hgt \
	    -iwidth $wid -iheight $hgt
    .closeup.content create window $sx $sy -window .closeup.content.s$wid \
	    -anchor nw
    .closeup.content create rect \
	    [ expr $sx - 1 ] [ expr $sy - 1 ] [ expr $sx + $wid ] [ expr $sy + $hgt ] \
	    -outline gray
}

set sx 2
set sy 30
add_closeup 8 8 $sx $sy
incr sx [ expr 8 + 4 ]
add_closeup 16 16 $sx $sy
incr sx [ expr 16 + 4 ]
add_closeup 24 26 $sx $sy
incr sx [ expr 24 + 4 ]
add_closeup 32 32 $sx $sy
incr sx [ expr 32 + 4 ]
add_closeup 44 48 $sx $sy
incr sx [ expr 44 + 4 ]
add_closeup 64 64 $sx $sy
incr sx [ expr 64 + 4 ]
add_closeup 88 96 $sx $sy

frame .images -width 500 -height 300
pack .images -side top -fill both -expand true
pack propagate .images false

imfsample .images.content -pad 2 \
	-showcolor $showcolor -showmasks $showmasks -shownames $shownames \
	-bg $bgcolor
#	-yscrollcommand { .images.scroll set }

scrollbar .images.scroll -orient vert -command { .images.content yview }
pack .images.scroll -side right -fill y
pack .images.content -side left -fill both -expand true

bind .images.content <ButtonRelease-1> { select_imf %x %y }

proc set_initial_view {} {
    .closeup.content itemconfig status -text [ get_imf_status ]
}

# Clear all existing images, start afresh.

proc new_cmd {} {
    .images.content remove all
}

proc open_imf_dir_cmd {} {
}

proc add_imf_file_cmd {} {
    set filename [ tk_getOpenFile ]
    if { $filename != {} } {
	load_imf_file $filename
	.images.content add all
	.closeup.content itemconfig status -text [ get_imf_status ]
    }
}

proc save_imf_dir_cmd {} {
}

proc save_imf_file_cmd {} {
    set filename [ tk_getSaveFile -initialfile "images.imf" ]
    if { $filename != {} } {
	save_imf_file $filename
    }
}

proc toggle_show_color {} {
    global showcolor

    .images.content config -showcolor $showcolor
}

proc toggle_show_names {} {
    global shownames

    .images.content config -shownames $shownames
}

proc toggle_show_masks {} {
    global showmasks

    .images.content config -showmasks $showmasks
}

proc toggle_show_bbox {} {
    global showbbox

    .images.content config -showbbox $showbbox
}

proc toggle_show_solid {} {
    global showsolid

    .images.content config -showsolid $showsolid
}

proc toggle_show_grid {} {
    global showgrid

    .images.content config -showgrid $showgrid
}

# Change the background color for all image samples.

proc set_bg_color {} {
    global bgcolor

    .images.content config -bg $bgcolor
    .closeup.content.s8 config -bg $bgcolor
    .closeup.content.s16 config -bg $bgcolor
    .closeup.content.s24 config -bg $bgcolor
    .closeup.content.s32 config -bg $bgcolor
    .closeup.content.s44 config -bg $bgcolor
    .closeup.content.s64 config -bg $bgcolor
    .closeup.content.s88 config -bg $bgcolor
}

proc set_fg_color {} {
    global fgcolor

    .images.content config -fg $fgcolor
    .closeup.content.s8 config -fg $fgcolor
    .closeup.content.s16 config -fg $fgcolor
    .closeup.content.s24 config -fg $fgcolor
    .closeup.content.s32 config -fg $fgcolor
    .closeup.content.s44 config -fg $fgcolor
    .closeup.content.s64 config -fg $fgcolor
    .closeup.content.s88 config -fg $fgcolor
}

proc toggle_as_unit {} {
}

proc toggle_as_terrain {} {
}

proc toggle_as_emblem {} {
}

proc toggle_with_unit {} {
#    .images.content unit [ .images.content curselection ]
}

proc toggle_with_terrain {} {
    .images.content terrain [ .images.content curselection ]
}

proc toggle_with_emblem {} {
    global with_emblem

    if { $with_emblem } {
	.images.content emblem [ .images.content curselection ]
    } else {
	.images.content emblem -1
    }
}

proc select_imf { x y } {
    .images.content select $x $y
    set n [ .images.content curselection ]
    if { $n >= 0 } {
	set header "[ get_imf_name $n ] ([ get_imf_numsizes $n ] images)" 
	.closeup.content.s8 replace imf [ get_imf_name $n ]
	.closeup.content.s16 replace imf [ get_imf_name $n ]
	.closeup.content.s24 replace imf [ get_imf_name $n ]
	.closeup.content.s32 replace imf [ get_imf_name $n ]
	.closeup.content.s44 replace imf [ get_imf_name $n ]
	.closeup.content.s64 replace imf [ get_imf_name $n ]
	.closeup.content.s88 replace imf [ get_imf_name $n ]
    } else {
	set header "(nothing selected)"
    }
    .closeup.content itemconfigure selname -text $header
}
