/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy.actions;

import com.jidesoft.swing.MultilineLabel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class EditPasteTableNameDlg
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(EditPasteTableNameDlg.class);
    private JTextField _txtTableName = new JTextField();
    private JButton _btnOK = new JButton(s_stringMgr.getString("EditPasteTableNameDlg.OK"));
    private JButton _btnCancel = new JButton(s_stringMgr.getString("EditPasteTableNameDlg.Cancel"));
    private String _tableName;
    private String _destTableName;

    public EditPasteTableNameDlg(Frame owner, String destTableName) {
        super(owner, s_stringMgr.getString("EditPasteTableNameDlg.title"), true);
        this._destTableName = destTableName;
        this.createUI();
        this._btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPasteTableNameDlg.this.onOK();
            }
        });
        this.getRootPane().setDefaultButton(this._btnOK);
        this._btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPasteTableNameDlg.this.onCancel();
            }
        });
        GUIUtils.enableCloseByEscape((JDialog)this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditPasteTableNameDlg.this._txtTableName.requestFocus();
            }
        });
        this.setSize(400, 200);
    }

    private void onCancel() {
        this.close();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void onOK() {
        if (null == this._txtTableName.getText() || 0 == this._txtTableName.getText().trim().length()) {
            JOptionPane.showMessageDialog(this, s_stringMgr.getString("EditPasteTableNameDlg.TableNameEmpty"));
            return;
        }
        this._tableName = this._txtTableName.getText();
        this.close();
    }

    private void createUI() {
        this.getContentPane().setLayout(new GridBagLayout());
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)new MultilineLabel(s_stringMgr.getString("EditPasteTableNameDlg.text")), gbc);
        gbc = new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this._txtTableName, gbc);
        if (null != this._destTableName) {
            gbc = new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
            JLabel lblDestNameLink = new JLabel(s_stringMgr.getString("EditPasteTableNameDlg.htmlSetNameTo", new Object[]{this._destTableName}));
            lblDestNameLink.setCursor(Cursor.getPredefinedCursor(12));
            lblDestNameLink.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    EditPasteTableNameDlg.this._txtTableName.setText(EditPasteTableNameDlg.this._destTableName);
                }
            });
            this.getContentPane().add((Component)lblDestNameLink, gbc);
        }
        gbc = new GridBagConstraints(0, ++gridy, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)new JPanel(), gbc);
        gbc = new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.createButtonPanel(), gbc);
    }

    private JPanel createButtonPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0);
        ret.add((Component)this._btnOK, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)this._btnCancel, gbc);
        return ret;
    }

    public String getTableName() {
        return this._tableName;
    }
}

