/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.vcs;

import com.intellij.openapi.vcs.FileStatus;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public enum UmlDiffStatus {
    ADDED,
    CHANGED,
    DELETED;

    private static final Map<FileStatus, UmlDiffStatus> CONVERTER;

    @Nullable
    public static UmlDiffStatus fromFileStatus(FileStatus status) {
        return CONVERTER.get(status);
    }

    static {
        CONVERTER = new HashMap<FileStatus, UmlDiffStatus>();
        CONVERTER.put(FileStatus.ADDED, ADDED);
        CONVERTER.put(FileStatus.DELETED, DELETED);
        CONVERTER.put(FileStatus.DELETED_FROM_FS, DELETED);
        CONVERTER.put(FileStatus.MODIFIED, CHANGED);
    }
}

