/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.actionCable;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.special.GenerateChannelAction;
import org.jetbrains.plugins.ruby.rails.codeInsight.actionCable.ActionCableReference;

public class ActionCableChannelNotFoundInspection
extends JSInspection {
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSFile(JSFile file) {
                if (RailsUtil.isUnderChannelClientDirectory((PsiFile)file)) {
                    super.visitJSFile(file);
                }
            }

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                for (PsiReference ref : node.getReferences()) {
                    if (!(ref instanceof ActionCableReference) || ref.resolve() != null) continue;
                    String channelName = ref.getRangeInElement().substring(node.getText());
                    if (channelName.endsWith("Channel")) {
                        channelName = channelName.substring(0, channelName.length() - "Channel".length());
                    }
                    CreateChannelQuickFix fix = new CreateChannelQuickFix(channelName);
                    holder.registerProblem((PsiElement)node, ref.getRangeInElement(), RBundle.message((String)"rails.action.cable.undefined.channel.inspection.text"), new LocalQuickFix[]{fix});
                }
            }
        };
        if (jSElementVisitor == null) {
            ActionCableChannelNotFoundInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            ActionCableChannelNotFoundInspection.$$$reportNull$$$0(1);
        }
        return !RailsUtil.isUnderChannelClientDirectory((PsiFile)element.getContainingFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/actionCable/ActionCableChannelNotFoundInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/actionCable/ActionCableChannelNotFoundInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CreateChannelQuickFix
    implements LocalQuickFix {
        private final String myChannnelName;

        CreateChannelQuickFix(String channelName) {
            this.myChannnelName = channelName;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = RBundle.message((String)"rails.action.cable.undefined.channel.inspection.qfix.name");
            if (string == null) {
                CreateChannelQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"rails.action.cable");
            if (string == null) {
                CreateChannelQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Module module;
            if (project == null) {
                CreateChannelQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                CreateChannelQuickFix.$$$reportNull$$$0(3);
            }
            if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)descriptor.getPsiElement())) == null) {
                return;
            }
            GenerateChannelAction action = new GenerateChannelAction("channel", this.myChannnelName);
            action.invokeDialog(module, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/actionCable/ActionCableChannelNotFoundInspection$CreateChannelQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/actionCable/ActionCableChannelNotFoundInspection$CreateChannelQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

