/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.editor.SqlCodeBlockProvider;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDeclareStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlDmlStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedQueryDefinitionImpl;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    private static final int EXPRESSION_LIST_FOLD_MIN = 3;
    private static final int RANGE_LENGTH_TO_FOLD = 12;

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root2, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (root2 == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(2);
        }
        if (!(root2 instanceof SqlFile)) {
            return;
        }
        CharSequence charSequence = document.getCharsSequence();
        for (PsiElement e : SqlImplUtil.sqlTraverser(root2)) {
            if (!(e instanceof SqlStatement && !(e instanceof SqlSelectStatement) || e instanceof SqlProcedureDefinitionImpl || e instanceof SqlNamedQueryDefinitionImpl || e instanceof LazyParseablePsiElement || e instanceof SqlResultSetExpression && !(e instanceof SqlParenthesizedExpression) || e instanceof PsiComment && ((PsiComment)e).getTokenType() == SqlTokens.SQL_BLOCK_COMMENT) && !(e instanceof SqlExpressionList)) continue;
            SqlFoldingBuilder.addFoldingDescriptor(e, charSequence, descriptors);
        }
    }

    private static void addFoldingDescriptor(@NotNull PsiElement o, @NotNull CharSequence charSequence, @NotNull List<FoldingDescriptor> result2) {
        TextRange realRange;
        TextRange range;
        if (o == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (charSequence == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(5);
        }
        if (!SqlFoldingBuilder.shouldFold(o, range = o.getTextRange(), charSequence)) {
            return;
        }
        int lastCharIndex = Math.min(range.getEndOffset(), charSequence.length()) - 1;
        SqlFoldingBuilder.checkLastIndexInRange(o, charSequence, range, lastCharIndex);
        boolean leaveLastNewLine = '\n' == charSequence.charAt(lastCharIndex);
        TextRange textRange = realRange = leaveLastNewLine ? new TextRange(range.getStartOffset(), lastCharIndex) : range;
        if (PsiUtilCore.getElementType((PsiElement)o) == SqlCompositeElementTypes.SQL_BLOCK_STATEMENT) {
            PsiElement content = SqlImplUtil.getBlockContentElement(o);
            if (content != null) {
                result2.add(new FoldingDescriptor(content, content.getTextRange()));
            } else {
                PsiElement[] children2 = o.getChildren();
                if (children2.length > 0) {
                    PsiElement firstItem = children2[0];
                    PsiElement lastItem = children2[children2.length - 1];
                    if (firstItem != null && lastItem != null) {
                        result2.add(new FoldingDescriptor(o, new TextRange(firstItem.getTextOffset(), lastItem.getTextRange().getEndOffset())));
                    }
                }
            }
        } else {
            result2.add(new FoldingDescriptor(o, realRange));
        }
    }

    private static boolean shouldFold(@NotNull PsiElement element2, @NotNull TextRange range, @NotNull CharSequence charSequence) {
        if (element2 == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(6);
        }
        if (range == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(7);
        }
        if (charSequence == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(8);
        }
        if (range.getLength() <= 12) {
            return false;
        }
        if (element2 instanceof SqlExpressionList) {
            return ((SqlExpressionList)element2).getExpressionList().size() >= 3;
        }
        if (StringUtil.indexOfAny((CharSequence)charSequence, (String)"\r\n", (int)range.getStartOffset(), (int)range.getEndOffset()) != -1) {
            return true;
        }
        return InjectedLanguageManager.getInstance((Project)element2.getProject()).getInjectionHost(element2) != null;
    }

    private static void checkLastIndexInRange(@NotNull PsiElement o, @NotNull CharSequence charSequence, TextRange range, int lastCharIndex) {
        boolean inRange;
        if (o == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(9);
        }
        if (charSequence == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(10);
        }
        boolean bl = inRange = lastCharIndex >= 0 && lastCharIndex < charSequence.length() && lastCharIndex > range.getStartOffset();
        if (!inRange) {
            PsiFile containingFile = o.getContainingFile();
            FileViewProvider viewProvider = containingFile.getViewProvider();
            String docInfo = "";
            if (containingFile.isValid()) {
                PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)containingFile.getProject());
                Document document = docManager.getDocument(containingFile);
                boolean committed = document != null && docManager.isCommitted(document);
                docInfo = (document != null ? "Committed: " + committed + ", doc.length: " + document.getTextLength() + ", " : "") + "document: " + document + ",\n";
            }
            SqlDialectImplUtil.LOG.error("Length: " + charSequence.length() + ", Range: " + range + ",\n" + docInfo + "element: " + o.getClass() + ",\ncontainingFile: " + containingFile + ", file.length: " + containingFile.getText().length() + ", valid: " + containingFile.isValid() + ",\nviewProvider: " + viewProvider);
        }
    }

    @NotNull
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(11);
        }
        if (range == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(12);
        }
        StringBuilder sb = new StringBuilder();
        SqlFoldingBuilder.appendPlaceholder(node, range.getStartOffset(), range.getStartOffset() + 12, sb);
        String string = sb.toString().trim();
        if (string == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static void appendPlaceholder(@NotNull ASTNode node, int startOffset, int limitOffset, @NotNull StringBuilder builder) {
        PsiElement singleSign;
        SqlNameElement nameElement;
        if (node == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(14);
        }
        if (builder == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(15);
        }
        PsiElement psi = node.getPsi();
        JBIterable leaves = SqlImplUtil.sqlTraverser(psi).traverse(TreeTraversal.LEAVES_DFS);
        boolean hadNonWs = false;
        boolean keywordsDone = false;
        boolean hadFrom = false;
        PsiElement last = null;
        PsiElement first = null;
        for (PsiElement leaf : leaves) {
            if (leaf instanceof PsiComment) continue;
            if (!(leaf instanceof LeafPsiElement)) break;
            if (leaf instanceof PsiWhiteSpace) {
                if (!hadNonWs) continue;
                builder.append(' ');
                continue;
            }
            hadNonWs = true;
            IElementType elementType = ((LeafPsiElement)leaf).getElementType();
            if (elementType == SqlCommonKeywords.SQL_FROM) {
                hadFrom = true;
            }
            if (keywordsDone || elementType != SqlTokens.SQL_KEYWORD_TOKEN && elementType != SqlCommonTokens.SQL_ASTERISK) {
                keywordsDone = true;
                TextRange textRange = leaf.getTextRange();
                if (textRange.getEndOffset() < startOffset || textRange.getStartOffset() > limitOffset) {
                    if (elementType != SqlCommonKeywords.SQL_FROM || !(psi instanceof SqlQueryExpression)) break;
                    SqlFoldingBuilder.appendQueryName(builder, SqlFoldingBuilder.findNameElement(psi));
                    break;
                }
            }
            builder.append(leaf.getText());
            last = leaf;
            if (first != null) continue;
            first = leaf;
        }
        PsiElement lastLeave = (PsiElement)leaves.last();
        String ellipsis = SqlFoldingBuilder.getEllipsis(psi, last);
        boolean hadEllipsis = false;
        boolean endsWithClosingElement = SqlFoldingBuilder.isClosingElement(first, lastLeave);
        if (!endsWithClosingElement && builder.length() > 0 && builder.charAt(0) == '(') {
            builder.replace(0, 1, "");
        }
        if (endsWithClosingElement) {
            builder.append(ellipsis);
            builder.append(lastLeave.getText());
        }
        if ((nameElement = SqlFoldingBuilder.findNameElement(psi)) != null) {
            if (psi instanceof SqlQueryExpression && !hadFrom) {
                if (!endsWithClosingElement) {
                    builder.append(ellipsis);
                    hadEllipsis = true;
                }
                SqlFoldingBuilder.appendQueryName(builder, nameElement);
            } else if (nameElement.getTextOffset() >= limitOffset) {
                builder.append(nameElement.getName());
            }
        }
        if (!endsWithClosingElement && !hadEllipsis) {
            builder.append(ellipsis);
        }
        if (psi instanceof SqlNAryExpression && (singleSign = ((SqlNAryExpression)psi).getOpSignElement()) != null && singleSign.getTextOffset() >= limitOffset) {
            builder.append(singleSign.getText());
            builder.append("... ");
        }
    }

    private static void appendQueryName(@NotNull StringBuilder builder, SqlNameElement nameElement) {
        if (builder == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(16);
        }
        if (nameElement != null) {
            builder.append("from ");
            builder.append(nameElement.getName());
        }
    }

    private static boolean isClosingElement(PsiElement first, PsiElement lastLeave) {
        if (!(lastLeave instanceof LeafPsiElement) || !(first instanceof LeafPsiElement)) {
            return false;
        }
        IElementType lastElementType = ((LeafPsiElement)lastLeave).getElementType();
        IElementType firstElementType = ((LeafPsiElement)first).getElementType();
        if (lastElementType == SqlCommonTokens.SQL_RIGHT_PAREN) {
            return firstElementType == SqlCommonTokens.SQL_LEFT_PAREN;
        }
        if (lastElementType == SqlCommonKeywords.SQL_END) {
            return SqlCodeBlockProvider.STARTERS.contains(firstElementType);
        }
        return false;
    }

    @NotNull
    private static String getEllipsis(@Nullable PsiElement psi, @Nullable PsiElement last) {
        if (last != null && psi instanceof SqlExpressionList) {
            String string = SqlFoldingBuilder.getMoreText((JBIterable<? extends PsiElement>)SqlImplUtil.sqlChildren(psi).filter(SqlExpression.class), last);
            if (string == null) {
                SqlFoldingBuilder.$$$reportNull$$$0(17);
            }
            return string;
        }
        if (last != null && psi instanceof SqlDeclareStatement) {
            String string = SqlFoldingBuilder.getMoreText((JBIterable<? extends PsiElement>)SqlImplUtil.sqlChildren(psi).filter(SqlDefinition.class), last);
            if (string == null) {
                SqlFoldingBuilder.$$$reportNull$$$0(18);
            }
            return string;
        }
        if ("... " == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(19);
        }
        return "... ";
    }

    @NotNull
    private static String getMoreText(@NotNull JBIterable<? extends PsiElement> items, @NotNull PsiElement last) {
        TextRange lastTextRange;
        long count2;
        if (items == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(20);
        }
        if (last == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(21);
        }
        String string = (count2 = (long)items.filter(arg_0 -> SqlFoldingBuilder.lambda$getMoreText$0(lastTextRange = last.getTextRange(), arg_0)).size()) == 0L ? "" : "...[" + count2 + " more]";
        if (string == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Nullable
    private static SqlNameElement findNameElement(@Nullable PsiElement psi) {
        if (psi instanceof SqlNAryExpression) {
            return SqlFoldingBuilder.findNameElement((PsiElement)((SqlNAryExpression)psi).getLOperand());
        }
        if (psi instanceof SqlDefinition) {
            return ((SqlDefinition)psi).getNameElement();
        }
        if (psi instanceof SqlAlterStatement) {
            return ((SqlAlterStatement)psi).getAlterTargetReference();
        }
        if (psi instanceof SqlDmlStatement) {
            SqlAsExpression first;
            SqlFromClause fromClause;
            SqlExpression expression;
            SqlDmlInstruction instruction2 = (SqlDmlInstruction)PsiTreeUtil.getChildOfType((PsiElement)psi, SqlDmlInstruction.class);
            SqlExpression sqlExpression = expression = instruction2 == null ? null : instruction2.getTargetExpression();
            if (psi instanceof SqlUpdateStatement && (fromClause = (SqlFromClause)PsiTreeUtil.getChildOfType((PsiElement)instruction2, SqlFromClause.class)) != null && (first = (SqlAsExpression)SqlImplUtil.sqlTraverser((PsiElement)fromClause).filter(SqlAsExpression.class).first()) != null) {
                return SqlFoldingBuilder.findNameNode((PsiElement)first.getExpression());
            }
            return SqlFoldingBuilder.findNameNode((PsiElement)expression);
        }
        if (psi instanceof SqlQueryExpression) {
            SqlQueryExpression queryExpression = (SqlQueryExpression)psi;
            SqlTableExpression tableExpression = queryExpression.getTableExpression();
            return SqlFoldingBuilder.findNameNode((PsiElement)tableExpression);
        }
        return null;
    }

    @Nullable
    private static SqlNameElement findNameNode(@Nullable PsiElement element2) {
        return (SqlNameElement)SyntaxTraverser.psiTraverser((PsiElement)element2).filter(SqlNameElement.class).first();
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(23);
        }
        return false;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        if (node == null) {
            SqlFoldingBuilder.$$$reportNull$$$0(24);
        }
        return node.getElementType() instanceof SqlFileElementType;
    }

    private static /* synthetic */ boolean lambda$getMoreText$0(TextRange lastTextRange, PsiElement n) {
        return n.getTextRange().getStartOffset() > lastTextRange.getEndOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSequence";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 11: 
            case 14: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/editor/SqlFoldingBuilder";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/editor/SqlFoldingBuilder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguagePlaceholderText";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getEllipsis";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoreText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFoldingDescriptor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldFold";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkLastIndexInRange";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagePlaceholderText";
                break;
            }
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendPlaceholder";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendQueryName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMoreText";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

