/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.extractors.DisplayHtmlValuesExtractor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbDocumentationLinks;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbTableChild;
import com.intellij.database.psi.DocumentationLink;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseTargetElementEvaluator;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbElementImpl<D, P extends DbElement>
extends FakePsiElement
implements DbElement,
PsiMetaOwner,
PsiPresentableMetaData {
    private static final Logger LOG = Logger.getInstance(DbElementImpl.class);
    public static final int WEIGHT_BASE = 10000;
    public static final int WEIGHT_INC = 1000;
    protected final P myParent;
    @NotNull
    protected final D myDelegate;
    protected volatile long myTransactionalVersion;
    protected static final String ASYNC_DOC_CUT = "<!-- async-doc-cut -->";

    public DbElementImpl(P parent2, @NotNull D delegate) {
        if (delegate == null) {
            DbElementImpl.$$$reportNull$$$0(0);
        }
        this.myParent = parent2;
        this.myDelegate = delegate;
    }

    @NotNull
    public D getDelegate() {
        D d2 = this.myDelegate;
        if (d2 == null) {
            DbElementImpl.$$$reportNull$$$0(1);
        }
        return d2;
    }

    @Nullable
    public P getDasParent() {
        return this.myParent;
    }

    @NotNull
    public String getName() {
        String string = this.myDelegate instanceof DasObject ? ((DasObject)this.myDelegate).getName() : DasUtil.NO_NAME;
        if (string == null) {
            DbElementImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public Language getLanguage() {
        SqlLanguage sqlLanguage = SqlLanguage.INSTANCE;
        if (sqlLanguage == null) {
            DbElementImpl.$$$reportNull$$$0(3);
        }
        return sqlLanguage;
    }

    public PsiElement getDeclaration() {
        return this;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    public short getPosition() {
        return this.myDelegate instanceof DasPositioned ? ((DasPositioned)this.myDelegate).getPosition() : (short)0;
    }

    public void init(PsiElement element2) {
    }

    @NotNull
    public Project getProject() {
        Project project = ((DbElement)ObjectUtils.assertNotNull(this.getDasParent())).getProject();
        if (project == null) {
            DbElementImpl.$$$reportNull$$$0(4);
        }
        return project;
    }

    @Nullable
    public PsiMetaData getMetaData() {
        return this;
    }

    public boolean isWritable() {
        D delegate = this.getDelegate();
        if (delegate instanceof PsiElement) {
            return ((PsiElement)delegate).isWritable();
        }
        DatabaseSystem dataSource = this.getDataSource().getDelegate();
        return !(dataSource instanceof DatabaseConnectionPoint) || !((DatabaseConnectionPoint)dataSource).isReadOnly();
    }

    public String getLocationString() {
        DbElement parent2;
        ObjectKind type = this.getKind();
        DbElement dbElement = parent2 = type != ObjectKind.NONE ? this.getParent() : null;
        if (parent2 != null) {
            return StringUtil.notNullize((String)StringUtil.nullize((String)QNameUtil.getQualifiedName(parent2)), (String)DbPresentation.getPresentableName((DasObject)parent2, true)) + " [" + this.getDataSource().getName() + "]";
        }
        return super.getLocationString();
    }

    public PsiManager getManager() {
        return PsiManager.getInstance((Project)this.getProject());
    }

    public boolean isDirectory() {
        return false;
    }

    public VirtualFile getVirtualFile() {
        return DatabaseElementVirtualFileImpl.findFile(this, false);
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        return true;
    }

    public void checkSetName(String name) throws IncorrectOperationException {
    }

    @NotNull
    public JBIterable<DbElement> getDasChildren(@Nullable ObjectKind kind) {
        JBIterable jBIterable = this.getDataSource().findChildren(this).filter(DasUtil.byKind((ObjectKind)kind));
        if (jBIterable == null) {
            DbElementImpl.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    public String getText() {
        return DatabaseEditorHelper.generateDefinition(this, new StringBuilder()).toString();
    }

    @NotNull
    public ObjectKind getKind() {
        D delegate = this.getDelegate();
        if (delegate instanceof DasObject) {
            ObjectKind objectKind = ((DasObject)delegate).getKind();
            if (objectKind == null) {
                DbElementImpl.$$$reportNull$$$0(6);
            }
            return objectKind;
        }
        throw new AssertionError((Object)(((Object)((Object)this)).getClass() + ":" + delegate));
    }

    @Nullable
    public Icon getIcon() {
        return this.getIcon(0);
    }

    @Nullable
    public Icon getBaseIcon() {
        return DbPresentation.getIcon(this.getKind());
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return DbPresentation.getIcon((DasObject)this);
    }

    public boolean isCaseSensitive() {
        return DbElementImpl.isCaseSensitive(this);
    }

    @Nullable
    public String getComment() {
        return this.myDelegate instanceof DasObject ? ((DasObject)this.myDelegate).getComment() : null;
    }

    public DbElement getParent() {
        return this.getDasParent();
    }

    @NotNull
    public String getTypeName() {
        String string = DbPresentation.getPresentableName(this.getKind(), DbImplUtil.getDatabaseDialect(this));
        if (string == null) {
            DbElementImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            DbElementImpl.$$$reportNull$$$0(8);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        SqlElement sqlElement;
        if (name == null) {
            DbElementImpl.$$$reportNull$$$0(9);
        }
        if ((sqlElement = DbSqlUtil.getSqlElement(this)) instanceof PsiNamedElement) {
            ((PsiNamedElement)sqlElement).setName(name);
        } else {
            D delegate = this.getDelegate();
            if (delegate instanceof PsiNamedElement) {
                ((PsiNamedElement)delegate).setName(name);
            }
        }
        return this;
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            DbElementImpl.$$$reportNull$$$0(10);
        }
        for (DbElement element2 : this.getDasChildren(null)) {
            element2.accept(visitor2);
        }
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        D delegate = this.getDelegate();
        return !(delegate instanceof Navigatable) || ((Navigatable)delegate).canNavigateToSource();
    }

    public void navigate(boolean requestFocus) {
        boolean navigateToData = DatabaseSettings.getSettings().navigateToData;
        DbElement adjusted = DatabaseTargetElementEvaluator.adjustForNavigation(this);
        if (navigateToData && DatabaseEditorHelper.isTableDataAvailable(adjusted)) {
            VirtualFile virtualFile = adjusted.getVirtualFile();
            if (virtualFile != null) {
                String[] stringArray;
                Project project = this.getProject();
                if (this.getKind() == ObjectKind.COLUMN) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = this.getName();
                } else {
                    stringArray = null;
                }
                new OpenDataFileDescriptor(project, virtualFile, stringArray, null, false, null).navigate(requestFocus);
            }
        } else {
            DatabaseTargetElementEvaluator.navigateToSource(this, requestFocus);
        }
    }

    @NotNull
    public StringBuilder getDocumentation() {
        StringBuilder stringBuilder = this.createDocHeaderColored().cast(StringBuilder.class);
        if (stringBuilder == null) {
            DbElementImpl.$$$reportNull$$$0(11);
        }
        return stringBuilder;
    }

    @NotNull
    protected DdlBuilder.Colored createDocHeaderColored() {
        DdlBuilder.Colored colored = this.createDocBuilder(this.createDocHeaderDefault());
        String comment = this.getComment();
        if (StringUtil.isNotEmpty((String)comment)) {
            colored.plain("<br>").plain("-- " + comment, DefaultLanguageHighlighterColors.LINE_COMMENT);
        }
        DdlBuilder.Colored colored2 = colored;
        if (colored2 == null) {
            DbElementImpl.$$$reportNull$$$0(12);
        }
        return colored2;
    }

    @NotNull
    protected StringBuilder createDocHeaderDefault() {
        DocumentationLink link;
        StringBuilder sb = new StringBuilder();
        for (DbElementImpl cur = this; cur != null; cur = cur.getParent()) {
            String name = cur.getName();
            if (StringUtil.isEmpty((String)name)) continue;
            sb.insert(0, "<b>" + StringUtil.capitalizeWords((String)cur.getTypeName(), (boolean)true) + ":</b> " + name + "<br>");
        }
        D delegate = this.getDelegate();
        DocumentationLink documentationLink = link = delegate instanceof BasicElement ? DbDocumentationLinks.makeDocumentationLink((BasicElement)delegate) : null;
        if (link != null) {
            sb.append("<br><b>Documentation: <tt>").append(link.getHtmlText()).append("</tt></b><br>");
        }
        StringBuilder stringBuilder = sb.insert(0, DisplayHtmlValuesExtractor.getHeader());
        if (stringBuilder == null) {
            DbElementImpl.$$$reportNull$$$0(13);
        }
        return stringBuilder;
    }

    protected void scheduleAsyncDocumentationUpdate(@NotNull CharSequence prefix, @NotNull AsyncDocGetter docGetter) {
        if (prefix == null) {
            DbElementImpl.$$$reportNull$$$0(14);
        }
        if (docGetter == null) {
            DbElementImpl.$$$reportNull$$$0(15);
        }
        String progressMessage = "<br><small>Connecting to database...</small>";
        QuickDocUtil.updateQuickDocAsync((PsiElement)this, (CharSequence)prefix, out -> {
            block6: {
                if (docGetter == null) {
                    DbElementImpl.$$$reportNull$$$0(33);
                }
                try {
                    CharOut charOut = CharOut.Util.newSink((Consumer<? super CharSequence>)out);
                    docGetter.beforeGet(charOut);
                    if (!DatabaseSettings.getSettings().loadSlowDocumentation) {
                        return;
                    }
                    if (!DbImplUtil.canConnectTo(this)) {
                        return;
                    }
                    out.consume((Object)ASYNC_DOC_CUT);
                    out.consume((Object)progressMessage);
                    out.consume(QuickDocUtil.CUT_AT_CMD);
                    out.consume((Object)ASYNC_DOC_CUT);
                    TimeoutUtil.sleep((long)1000L);
                    ConnectionProvider.runWithProvider(this, DGDepartment.QUICK_DOCUMENTATION, (ThrowableConsumer<ConnectionProvider, Exception>)((ThrowableConsumer)provider -> {
                        if (docGetter == null) {
                            DbElementImpl.$$$reportNull$$$0(34);
                        }
                        docGetter.get(charOut, (ConnectionProvider)provider);
                    }));
                }
                catch (ProcessCanceledException e) {
                    out.consume(QuickDocUtil.CUT_AT_CMD);
                    out.consume((Object)progressMessage);
                    out.consume((Object)"<br><b>Connection canceled</b>");
                }
                catch (Exception e) {
                    out.consume(QuickDocUtil.CUT_AT_CMD);
                    out.consume((Object)progressMessage);
                    out.consume((Object)DbImplUtil.exceptionToHtml(e, "<br><b>Connection failed</b>", new StringBuilder()));
                    if (e instanceof SQLException || e instanceof IOException) break block6;
                    LOG.warn((Throwable)e);
                }
            }
        });
    }

    protected boolean appendDefinition(@NotNull StringBuilder sb) {
        String text2;
        if (sb == null) {
            DbElementImpl.$$$reportNull$$$0(16);
        }
        if ((text2 = DbImplUtil.loadDefinitionFromStorage(this)) == null && DatabaseEditorHelper.isDefinitionAvailable(this)) {
            StringBuilder tmp = new StringBuilder();
            DatabaseEditorHelper.generateDefinition(this, tmp);
            if (tmp.length() == 0) {
                return false;
            }
            tmp.insert(0, "-- auto-generated definition\n");
            text2 = tmp.toString();
        }
        if (text2 != null) {
            sb.append("<br><code><pre>");
            sb.append(this.sql2Html(text2));
            while (Character.isWhitespace(sb.charAt(sb.length() - 1))) {
                sb.setLength(sb.length() - 1);
            }
            sb.append("</pre></code>");
            return true;
        }
        return false;
    }

    protected DdlBuilder.Colored createDocBuilder(StringBuilder sb) {
        DdlBuilder.Colored colored = new DdlBuilder.Colored(sb);
        colored.configureFor(this);
        return colored;
    }

    protected void checkValid() {
        PsiUtilCore.ensureValid((PsiElement)this);
    }

    public boolean isValid() {
        return this.getDataSource().isValidImpl(this);
    }

    @NotNull
    public DbDataSourceImpl getDataSource() {
        DbDataSourceImpl o = (DbDataSourceImpl)((Object)SyntaxTraverser.psiApi().parents((Object)this).filter(DbDataSourceImpl.class).first());
        if (o != null) {
            DbDataSourceImpl dbDataSourceImpl = o;
            if (dbDataSourceImpl == null) {
                DbElementImpl.$$$reportNull$$$0(17);
            }
            return dbDataSourceImpl;
        }
        throw new AssertionError((Object)(this.getTypeName() + ": no datasource"));
    }

    public int getWeight() {
        ObjectKind kind = this.getKind();
        if (kind == ObjectKind.TABLE) {
            return 10000;
        }
        if (kind == ObjectKind.MAT_VIEW) {
            return 11000;
        }
        if (kind == ObjectKind.VIEW) {
            return 12000;
        }
        if (kind == ObjectKind.SEQUENCE) {
            return 13000;
        }
        if (kind == ObjectKind.TRIGGER) {
            return 14000;
        }
        if (kind == ObjectKind.ROUTINE) {
            return 16000;
        }
        if (kind == ObjectKind.PACKAGE) {
            return 17000;
        }
        return 10000;
    }

    @NotNull
    protected String sql2Html(CharSequence s) {
        String string = DbSqlUtil.sql2Html(this.getProject(), (Language)DbSqlUtil.getSqlDialect(this), s);
        if (string == null) {
            DbElementImpl.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static Processor<DbElement> newDeclarationProcessor(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent) {
        if (processor == null) {
            DbElementImpl.$$$reportNull$$$0(19);
        }
        if (state == null) {
            DbElementImpl.$$$reportNull$$$0(20);
        }
        Processor processor2 = element2 -> {
            if (processor == null) {
                DbElementImpl.$$$reportNull$$$0(31);
            }
            if (state == null) {
                DbElementImpl.$$$reportNull$$$0(32);
            }
            if (lastParent == element2) {
                return true;
            }
            return processor.execute((PsiElement)element2, state);
        };
        if (processor2 == null) {
            DbElementImpl.$$$reportNull$$$0(21);
        }
        return processor2;
    }

    public Processor<DbElement> createDeclarationProcessor(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            DbElementImpl.$$$reportNull$$$0(22);
        }
        if (state == null) {
            DbElementImpl.$$$reportNull$$$0(23);
        }
        if (place == null) {
            DbElementImpl.$$$reportNull$$$0(24);
        }
        return DbElementImpl.newDeclarationProcessor(processor, state, lastParent);
    }

    public final boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        JBIterable<DbDataSource> parents;
        if (processor == null) {
            DbElementImpl.$$$reportNull$$$0(25);
        }
        if (state == null) {
            DbElementImpl.$$$reportNull$$$0(26);
        }
        if (place == null) {
            DbElementImpl.$$$reportNull$$$0(27);
        }
        Processor<DbElement> p2 = this.createDeclarationProcessor(processor, state, lastParent, place);
        JBIterable elements = JBIterable.empty();
        elements = elements.append(this.getDasChildren(null));
        if (this instanceof DbNamespaceImpl && !(parents = DbElementImpl.getParentDataSources(this.getDataSource())).isEmpty()) {
            ObjectPath path = ObjectPaths.of((DasObject)this);
            JBIterable additional = parents.flatten(ds -> DbSqlUtil.findObjects(ds, path).flatten(ns -> ns.getDasChildren(null)).map(o -> DbImplUtil.findElement(ds, o)));
            elements = elements.append((Iterable)additional).filter((Condition)new JBIterable.SCond<DbElement>(){
                Set<DbElement> visited = ContainerUtil.newTroveSet((TObjectHashingStrategy)new TObjectHashingStrategy<DbElement>(){

                    public int computeHashCode(DbElement object) {
                        return object == null ? 0 : object.getName().hashCode() + 31 * object.getKind().hashCode();
                    }

                    public boolean equals(DbElement o1, DbElement o2) {
                        if (o1 == o2 || o1 == null || o2 == null) {
                            return o1 == o2;
                        }
                        return o1.getName().equals(o2.getName()) || o1.getKind() == o2.getKind();
                    }
                });

                public boolean value(DbElement e) {
                    return this.visited.add(e);
                }
            });
        }
        return ContainerUtil.process((Iterable)elements, p2);
    }

    @NotNull
    private static JBIterable<DbDataSource> getParentDataSources(@NotNull DbDataSource dataSource) {
        if (dataSource == null) {
            DbElementImpl.$$$reportNull$$$0(28);
        }
        if (!(dataSource.getDelegate() instanceof SqlDataSource)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbElementImpl.$$$reportNull$$$0(29);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.generate((Object)dataSource, o -> {
            DatabaseSystem delegate = o.getDelegate();
            return delegate instanceof SqlDataSource ? ((SqlDataSource)delegate).getParentDataSource() : null;
        });
        if (jBIterable == null) {
            DbElementImpl.$$$reportNull$$$0(30);
        }
        return jBIterable;
    }

    public String toString() {
        ObjectKind kind = this.getKind();
        String s = kind == ObjectKind.SCHEMA ? QNameUtil.getQualifiedName(this) : (this instanceof DbTableChild ? this.getText() : this.getName());
        return kind + ":" + s;
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    private static boolean isCaseSensitive(DbElement element2) {
        if (!(element2 instanceof DasSchemaChild) && !(element2 instanceof DasColumn)) {
            return false;
        }
        return DbUtil.isCaseSensitive((String)element2.getName(), (DbElement)element2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbElementImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 15: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docGetter";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 20: 
            case 23: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbElementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentation";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocHeaderColored";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocHeaderDefault";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "sql2Html";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "newDeclarationProcessor";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentDataSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 29: 
            case 30: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "scheduleAsyncDocumentationUpdate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendDefinition";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "newDeclarationProcessor";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createDeclarationProcessor";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getParentDataSources";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$newDeclarationProcessor$2";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$scheduleAsyncDocumentationUpdate$1";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    protected static interface AsyncDocGetter {
        public void get(@NotNull CharOut var1, @NotNull ConnectionProvider var2) throws Exception;

        default public void beforeGet(@NotNull CharOut charOut) {
            if (charOut == null) {
                AsyncDocGetter.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charOut", "com/intellij/database/psi/DbElementImpl$AsyncDocGetter", "beforeGet"));
        }
    }
}

