/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatter;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvFormatParser {
    private final CsvFormat myDataFormat;
    private final Map<Object, Pattern> myCompiledPatterns;
    private LookAhead myLookAhead;

    public CsvFormatParser(@NotNull CsvFormat format) {
        if (format == null) {
            CsvFormatParser.$$$reportNull$$$0(0);
        }
        this.myCompiledPatterns = ContainerUtil.newIdentityHashMap();
        this.myDataFormat = format;
    }

    public CsvFormat getDataFormat() {
        return this.myDataFormat;
    }

    @NotNull
    static List<String> values(@Nullable CsvRecordFormat format, @NotNull CharSequence sequence, @NotNull List<CsvDocumentDataHookUp.ValueRange> ranges) {
        if (sequence == null) {
            CsvFormatParser.$$$reportNull$$$0(1);
        }
        if (ranges == null) {
            CsvFormatParser.$$$reportNull$$$0(2);
        }
        List list = ContainerUtil.map(ranges, range -> {
            if (sequence == null) {
                CsvFormatParser.$$$reportNull$$$0(8);
            }
            String value = range.value(sequence).toString();
            return !(range instanceof QuotedValueRange) && format != null && format.nullText != null && StringUtil.equals((CharSequence)value, (CharSequence)format.nullText) ? null : value;
        });
        if (list == null) {
            CsvFormatParser.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public CsvDocumentDataHookUp.CsvMarkup parse(CharSequence sequence) {
        CsvDocumentDataHookUp.CsvRecord record;
        this.myLookAhead = new LookAhead();
        List<String> columnNames = null;
        CsvDocumentDataHookUp.CsvRecord headerRow = null;
        ArrayList rows = ContainerUtil.newArrayList();
        int currentOffset = 0;
        if (this.myDataFormat.headerRecord != null) {
            CsvDocumentDataHookUp.CsvRecord headerRecord = this.parseRecordSkippingLines(sequence, currentOffset, this.myDataFormat.headerRecord, this.myDataFormat.rowNumbers);
            if (headerRecord == null) {
                return null;
            }
            headerRow = headerRecord;
            columnNames = CsvFormatParser.values(null, sequence, headerRecord.values);
            currentOffset = headerRecord.range.getEndOffset();
        }
        while ((record = this.parseRecordSkippingLines(sequence, currentOffset, this.myDataFormat.dataRecord, this.myDataFormat.rowNumbers)) != null) {
            if (columnNames == null) {
                columnNames = CsvFormatParser.values(null, sequence, record.values);
            }
            if (columnNames.size() != record.values.size()) {
                currentOffset = CsvFormatParser.skipLine(sequence, currentOffset);
                continue;
            }
            currentOffset = record.range.getEndOffset();
            rows.add(record);
        }
        return columnNames == null ? null : new CsvDocumentDataHookUp.CsvMarkup(new CsvFormatter(this.myDataFormat), sequence, rows, headerRow, this.myDataFormat.rowNumbers);
    }

    private CsvDocumentDataHookUp.CsvRecord parseRecordSkippingLines(CharSequence sequence, int startOffset, CsvRecordFormat template, boolean firstColumnIsTitle) {
        CsvDocumentDataHookUp.CsvRecord record = null;
        while (startOffset < sequence.length() && (record = this.parseRecord(sequence, startOffset, template, firstColumnIsTitle)) == null) {
            startOffset = CsvFormatParser.skipLine(sequence, startOffset);
        }
        return record;
    }

    private CsvDocumentDataHookUp.CsvRecord parseRecord(CharSequence sequence, int startOffset, CsvRecordFormat template, boolean firstColumnIsTitle) {
        Ref titleAndValuesRef = Ref.create();
        int endOffset = startOffset;
        endOffset = StringUtil.isEmpty((String)template.prefix) ? endOffset : (StringUtil.startsWith((CharSequence)sequence, (int)endOffset, (CharSequence)template.prefix) ? endOffset + template.prefix.length() : -1);
        int n = endOffset = endOffset == -1 ? -1 : this.parseValues((Ref<List<CsvDocumentDataHookUp.ValueRange>>)titleAndValuesRef, sequence, endOffset, template);
        int n2 = endOffset == -1 ? -1 : (StringUtil.isEmpty((String)template.suffix) ? endOffset : (endOffset = StringUtil.startsWith((CharSequence)sequence, (int)endOffset, (CharSequence)template.suffix) ? endOffset + template.suffix.length() : -1));
        if (endOffset == -1) {
            return null;
        }
        boolean hasRecordSeparator = false;
        if (endOffset != sequence.length() && endOffset == this.myLookAhead.nextRecordSeparatorOffset(template, sequence, endOffset)) {
            endOffset += template.recordSeparator.length();
            hasRecordSeparator = true;
        }
        TextRange recordRange = new TextRange(startOffset, endOffset);
        List titleAndValues = (List)titleAndValuesRef.get();
        return firstColumnIsTitle && titleAndValues.size() < 2 ? null : new CsvDocumentDataHookUp.CsvRecord(recordRange, titleAndValues, hasRecordSeparator);
    }

    private int parseValues(Ref<List<CsvDocumentDataHookUp.ValueRange>> valuesRef, CharSequence sequence, int startOffset, CsvRecordFormat template) {
        assert (valuesRef.isNull());
        int valuesEndOffset = startOffset;
        ArrayList values2 = ContainerUtil.newArrayList();
        Ref valueRef = Ref.create();
        boolean first = true;
        while (valuesEndOffset != this.myLookAhead.valuesEndOffset(template, sequence, valuesEndOffset)) {
            int valueEndOffset;
            if (!first) {
                if (valuesEndOffset != this.myLookAhead.nextValueSeparatorOffset(template, sequence, valuesEndOffset)) {
                    return -1;
                }
                valuesEndOffset += template.valueSeparator.length();
            }
            if ((valueEndOffset = this.parseValue((Ref<CsvDocumentDataHookUp.ValueRange>)valueRef, sequence, valuesEndOffset, template)) == -1) {
                return -1;
            }
            values2.add(ObjectUtils.assertNotNull((Object)valueRef.get()));
            valuesEndOffset = valueEndOffset;
            first = false;
        }
        if (values2.isEmpty()) {
            return -1;
        }
        valuesRef.set((Object)values2);
        return valuesEndOffset;
    }

    private int parseValue(Ref<CsvDocumentDataHookUp.ValueRange> value, CharSequence sequence, int startOffset, CsvRecordFormat template) {
        int endOffset;
        int valueStartOffset = endOffset = template.trimWhitespace ? this.skipWhitespaceUpToNextDelimiterOrRecordSeparator(template, sequence, startOffset) : startOffset;
        CsvRecordFormat.Quotes detectedQuotes = null;
        for (CsvRecordFormat.Quotes quotes : template.quotes) {
            if (quotes.leftQuote.isEmpty() || quotes.rightQuote.isEmpty() || !StringUtil.startsWith((CharSequence)sequence, (int)endOffset, (CharSequence)quotes.leftQuote)) continue;
            detectedQuotes = quotes;
            break;
        }
        if (detectedQuotes == null) {
            int valueEndOffset;
            endOffset = valueEndOffset = this.myLookAhead.nextDelimiterOrRecordSeparatorOffset(template, sequence, valueStartOffset);
            while (template.trimWhitespace && valueEndOffset > valueStartOffset && Character.isWhitespace(sequence.charAt(valueEndOffset - 1))) {
                --valueEndOffset;
            }
            value.set((Object)new CsvDocumentDataHookUp.ValueRange(valueStartOffset, valueEndOffset));
        } else {
            int valueEndOffset;
            Matcher matcher = this.allInQuotesPattern(detectedQuotes).matcher(sequence);
            boolean matched = matcher.find(valueStartOffset + detectedQuotes.leftQuote.length());
            assert (matched);
            endOffset = valueEndOffset = matcher.end(0);
            if (StringUtil.startsWith((CharSequence)sequence, (int)valueEndOffset, (CharSequence)detectedQuotes.rightQuote)) {
                endOffset = valueEndOffset += detectedQuotes.rightQuote.length();
                value.set((Object)new QuotedValueRange(valueStartOffset, valueEndOffset, detectedQuotes));
            } else {
                if (sequence.length() != endOffset) {
                    return -1;
                }
                value.set((Object)new ImproperQuotedValueRange(valueStartOffset, valueEndOffset, detectedQuotes));
            }
            if (template.trimWhitespace) {
                endOffset = this.skipWhitespaceUpToNextDelimiterOrRecordSeparator(template, sequence, endOffset);
            }
        }
        assert (!value.isNull());
        return endOffset;
    }

    @NotNull
    private Pattern allInQuotesPattern(@NotNull CsvRecordFormat.Quotes quotes) {
        Pattern pattern;
        if (quotes == null) {
            CsvFormatParser.$$$reportNull$$$0(4);
        }
        if ((pattern = this.myCompiledPatterns.get(quotes)) == null) {
            pattern = Pattern.compile("(?:" + Pattern.quote(quotes.rightQuoteEscaped) + "|(?!" + Pattern.quote(quotes.rightQuote) + ").)*+", 32);
            this.myCompiledPatterns.put(quotes, pattern);
        }
        Pattern pattern2 = pattern;
        if (pattern2 == null) {
            CsvFormatParser.$$$reportNull$$$0(5);
        }
        return pattern2;
    }

    private int skipWhitespaceUpToNextDelimiterOrRecordSeparator(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int offset) {
        if (template == null) {
            CsvFormatParser.$$$reportNull$$$0(6);
        }
        if (sequence == null) {
            CsvFormatParser.$$$reportNull$$$0(7);
        }
        return CsvFormatParser.skipWhitespace(sequence, offset, this.myLookAhead.nextDelimiterOrRecordSeparatorOffset(template, sequence, offset));
    }

    private static String unescapeQuotes(CharSequence s, CsvRecordFormat.Quotes quotes) {
        List<String> escapedQuotes = Arrays.asList(quotes.leftQuoteEscaped, quotes.rightQuoteEscaped);
        List<String> unescapedQuotes = Arrays.asList(quotes.leftQuote, quotes.rightQuote);
        return StringUtil.replace((String)String.valueOf(s), escapedQuotes, unescapedQuotes);
    }

    private static int skipWhitespace(CharSequence sequence, int offset, int maxOffset) {
        maxOffset = Math.min(maxOffset, sequence.length());
        while (offset < maxOffset && Character.isWhitespace(sequence.charAt(offset))) {
            ++offset;
        }
        return offset;
    }

    private static int skipLine(CharSequence sequence, int offset) {
        while (offset < sequence.length() && sequence.charAt(offset) != '\n') {
            ++offset;
        }
        if (offset < sequence.length()) {
            ++offset;
        }
        return offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/CsvFormatParser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/CsvFormatParser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "allInQuotesPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "values";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "allInQuotesPattern";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceUpToNextDelimiterOrRecordSeparator";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$values$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LookAhead {
        private int myNextRecordSeparatorRequestOffset = -1;
        private int myNextRecordSeparatorOffset = -1;

        private LookAhead() {
        }

        public int nextDelimiterOffset(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int startOffset) {
            if (template == null) {
                LookAhead.$$$reportNull$$$0(0);
            }
            if (sequence == null) {
                LookAhead.$$$reportNull$$$0(1);
            }
            int nextPartOffset = this.valuesEndOffset(template, sequence, startOffset);
            int nextValueSeparatorOffset = this.nextValueSeparatorOffset(template, sequence, startOffset);
            return Math.min(nextPartOffset, nextValueSeparatorOffset);
        }

        public int valuesEndOffset(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int startOffset) {
            String suffix;
            String suffixAndSeparator;
            int suffixAndSeparatorIdx;
            if (template == null) {
                LookAhead.$$$reportNull$$$0(2);
            }
            if (sequence == null) {
                LookAhead.$$$reportNull$$$0(3);
            }
            return (suffixAndSeparatorIdx = LookAhead.indexOfOrEnd(sequence, startOffset, suffixAndSeparator = (suffix = StringUtil.notNullize((String)template.suffix)) + StringUtil.notNullize((String)template.recordSeparator))) != sequence.length() ? suffixAndSeparatorIdx : (startOffset <= sequence.length() - suffix.length() && StringUtil.endsWith((CharSequence)sequence, (CharSequence)suffix) ? sequence.length() - suffix.length() : sequence.length());
        }

        public int nextRecordSeparatorOffset(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int startOffset) {
            if (template == null) {
                LookAhead.$$$reportNull$$$0(4);
            }
            if (sequence == null) {
                LookAhead.$$$reportNull$$$0(5);
            }
            if (startOffset >= this.myNextRecordSeparatorRequestOffset && startOffset <= this.myNextRecordSeparatorOffset) {
                return this.myNextRecordSeparatorOffset;
            }
            this.myNextRecordSeparatorRequestOffset = startOffset;
            this.myNextRecordSeparatorOffset = LookAhead.indexOfOrEnd(sequence, startOffset, template.recordSeparator);
            return this.myNextRecordSeparatorOffset;
        }

        public int nextValueSeparatorOffset(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int startOffset) {
            if (template == null) {
                LookAhead.$$$reportNull$$$0(6);
            }
            if (sequence == null) {
                LookAhead.$$$reportNull$$$0(7);
            }
            return LookAhead.indexOfOrEnd(sequence, startOffset, template.valueSeparator);
        }

        public int nextDelimiterOrRecordSeparatorOffset(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int offset) {
            int nextDelimiterOffset;
            if (template == null) {
                LookAhead.$$$reportNull$$$0(8);
            }
            if (sequence == null) {
                LookAhead.$$$reportNull$$$0(9);
            }
            if ((nextDelimiterOffset = this.nextDelimiterOffset(template, sequence, offset)) == offset) {
                return nextDelimiterOffset;
            }
            int recordSeparatorOffset = this.nextRecordSeparatorOffset(template, sequence, offset);
            return Math.min(nextDelimiterOffset, recordSeparatorOffset);
        }

        private static int indexOfOrEnd(@NotNull CharSequence sequence, int start, @Nullable CharSequence infix) {
            if (sequence == null) {
                LookAhead.$$$reportNull$$$0(10);
            }
            int idx = StringUtil.isEmpty((CharSequence)infix) ? -1 : StringUtil.indexOf((CharSequence)sequence, (CharSequence)infix, (int)start);
            return idx == -1 ? sequence.length() : idx;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sequence";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/CsvFormatParser$LookAhead";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nextDelimiterOffset";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valuesEndOffset";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nextRecordSeparatorOffset";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nextValueSeparatorOffset";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nextDelimiterOrRecordSeparatorOffset";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexOfOrEnd";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ImproperQuotedValueRange
    extends QuotedValueRange {
        ImproperQuotedValueRange(int startOffset, int endOffset, @NotNull CsvRecordFormat.Quotes quotes) {
            if (quotes == null) {
                ImproperQuotedValueRange.$$$reportNull$$$0(0);
            }
            super(startOffset, endOffset, quotes);
        }

        @Override
        protected TextRange unquotedRange() {
            return new TextRange(this.getStartOffset() + this.myQuotes.leftQuote.length(), this.getEndOffset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/datagrid/CsvFormatParser$ImproperQuotedValueRange", "<init>"));
        }
    }

    private static class QuotedValueRange
    extends CsvDocumentDataHookUp.ValueRange {
        protected final CsvRecordFormat.Quotes myQuotes;

        QuotedValueRange(int startOffset, int endOffset, @NotNull CsvRecordFormat.Quotes quotes) {
            if (quotes == null) {
                QuotedValueRange.$$$reportNull$$$0(0);
            }
            super(startOffset, endOffset);
            this.myQuotes = quotes;
        }

        @Override
        public CharSequence value(CharSequence s) {
            return CsvFormatParser.unescapeQuotes(this.unquotedRange().subSequence(s), this.myQuotes);
        }

        protected TextRange unquotedRange() {
            return new TextRange(this.getStartOffset() + this.myQuotes.leftQuote.length(), this.getEndOffset() - this.myQuotes.rightQuote.length());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/datagrid/CsvFormatParser$QuotedValueRange", "<init>"));
        }
    }
}

