/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.rails.associations;

import com.intellij.diagram.rails.associations.MigrationFiledType;
import com.intellij.openapi.module.Module;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.mongoid.MongoField;
import org.jetbrains.plugins.ruby.rails.migrations.MigrationField;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class AssociationProperty {
    private final Module myModule;
    private final String myName;
    private boolean myAssociatedType;
    private String myDataType;

    public AssociationProperty(Module module, MigrationField migrationField) {
        this.myModule = module;
        this.myName = migrationField.getName();
        this.myAssociatedType = false;
    }

    public AssociationProperty(Module module, String name) {
        this.myModule = module;
        this.myName = name;
        this.myAssociatedType = true;
    }

    public AssociationProperty(Module module, MongoField field) {
        this.myModule = module;
        this.myName = field.getName();
        this.myDataType = field.getDataType();
    }

    @NotNull
    public MigrationFiledType getMigrationFiledType() {
        if (this.isSystemDBFiled()) {
            MigrationFiledType migrationFiledType = MigrationFiledType.SYSTEM_DB;
            if (migrationFiledType == null) {
                AssociationProperty.$$$reportNull$$$0(0);
            }
            return migrationFiledType;
        }
        MigrationFiledType migrationFiledType = this.myAssociatedType ? MigrationFiledType.ASSOCIATION : MigrationFiledType.MIGRATION;
        if (migrationFiledType == null) {
            AssociationProperty.$$$reportNull$$$0(1);
        }
        return migrationFiledType;
    }

    private boolean isSystemDBFiled() {
        return "created_at".equals(this.myName) || "updated_at".equals(this.myName) || "id".equals(this.myName) || this.isDBKey();
    }

    private boolean isDBKey() {
        Matcher matcher;
        Pattern pattern = Pattern.compile("(\\S+)_id");
        if (this.myName != null && (matcher = pattern.matcher(this.myName)).matches()) {
            String modelName = matcher.group(1);
            RailsModel model = RailsModel.fromModelName((Module)this.myModule, (String)NamingConventions.toCamelCase((String)modelName));
            return model != null;
        }
        return false;
    }

    public String getName() {
        return this.myName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssociationProperty that = (AssociationProperty)o;
        if (this.myAssociatedType != that.myAssociatedType) {
            return false;
        }
        return !(this.myName != null ? !this.myName.equals(that.myName) : that.myName != null);
    }

    public int hashCode() {
        int result = this.myName != null ? this.myName.hashCode() : 0;
        result = 31 * result + (this.myAssociatedType ? 1 : 0);
        return result;
    }

    public String getDataType() {
        return this.myDataType;
    }

    public void setDataType(@NotNull String dataType) {
        if (dataType == null) {
            AssociationProperty.$$$reportNull$$$0(2);
        }
        this.myDataType = dataType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/rails/associations/AssociationProperty";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMigrationFiledType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/rails/associations/AssociationProperty";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDataType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

