/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.refactoring;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.move.FileReferenceContextUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6MoveFileHandler
extends MoveFileHandler {
    private static final Key<Boolean> MARKER = Key.create((String)"marker.not.invalidated");
    private static final Logger LOG = Logger.getInstance(ES6MoveFileHandler.class);

    public boolean canProcessElement(PsiFile file2) {
        return file2 instanceof JSFile && DialectDetector.hasFeature((PsiElement)file2, JSLanguageFeature.IMPORT_DECLARATIONS);
    }

    public void prepareMovedFile(PsiFile file2, PsiDirectory moveDestination, Map<PsiElement, PsiElement> oldToNewMap) {
    }

    @Nullable
    public List<UsageInfo> findUsages(PsiFile psiFile, PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles) {
        if (!(psiFile instanceof JSFile)) {
            return null;
        }
        Map encodedInfo = FileReferenceContextUtil.encodeFileReferences((PsiElement)psiFile);
        if (encodedInfo.size() == 0) {
            return null;
        }
        psiFile.putCopyableUserData(MARKER, (Object)true);
        Map<String, VirtualFile> resultMap = ES6MoveFileHandler.convertMap(encodedInfo, el -> el.getVirtualFile());
        return Collections.singletonList(new RestoreReferencesUsage((PsiElement)psiFile, resultMap));
    }

    public void retargetUsages(List<UsageInfo> usageInfos, Map<PsiElement, PsiElement> oldToNewMap) {
        for (UsageInfo info : usageInfos) {
            PsiElement element;
            if (!(info instanceof RestoreReferencesUsage) || (element = info.getElement()) == null || !element.isValid()) continue;
            Boolean data = (Boolean)element.getCopyableUserData(MARKER);
            if (data != null) {
                element.putCopyableUserData(MARKER, null);
            }
            if (Boolean.TRUE.equals(data)) continue;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(ES6MoveFileHandler.getErrorMessage(element));
            } else {
                LOG.warn(ES6MoveFileHandler.getErrorMessage(element));
            }
            PsiManager manager = element.getManager();
            Map refs = ((RestoreReferencesUsage)info).myRefs;
            Map map = ES6MoveFileHandler.convertMap(refs, el -> FileReferenceHelper.getPsiFileSystemItem((PsiManager)manager, (VirtualFile)el));
            FileReferenceContextUtil.decodeFileReferences((PsiElement)element, map, (TextRange)element.getTextRange());
        }
    }

    public void updateMovedFile(PsiFile file2) throws IncorrectOperationException {
        if (DialectDetector.isTypeScript((PsiElement)file2) && file2 instanceof JSFile && ((JSFile)file2).getReferencedPaths().size() > 0) {
            for (PsiComment comment : PsiTreeUtil.findChildrenOfType((PsiElement)file2, PsiComment.class)) {
                FileReferenceContextUtil.decodeFileReferences((PsiElement)comment);
            }
        }
    }

    @NotNull
    private static String getErrorMessage(@NotNull PsiElement element) {
        PsiFile file2;
        if (element == null) {
            ES6MoveFileHandler.$$$reportNull$$$0(0);
        }
        String path = (file2 = element.getContainingFile()) != null ? file2.getVirtualFile().getPath() : "unknown";
        String string = "Psi file was invalidated after move file: '" + path + "'. All file references will be lost";
        if (string == null) {
            ES6MoveFileHandler.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static <Old, New> Map<String, New> convertMap(@NotNull Map<String, Old> map, @NotNull NullableFunction<Old, New> func) {
        if (map == null) {
            ES6MoveFileHandler.$$$reportNull$$$0(2);
        }
        if (func == null) {
            ES6MoveFileHandler.$$$reportNull$$$0(3);
        }
        THashMap resultMap = ContainerUtil.newTroveMap();
        for (Map.Entry<String, Old> entry : map.entrySet()) {
            Old value = entry.getValue();
            String key = entry.getKey();
            Object newValue = func.fun(value);
            if (newValue == null) continue;
            resultMap.put(key, newValue);
        }
        THashMap tHashMap = resultMap;
        if (tHashMap == null) {
            ES6MoveFileHandler.$$$reportNull$$$0(4);
        }
        return tHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/refactoring/ES6MoveFileHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/refactoring/ES6MoveFileHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class RestoreReferencesUsage
    extends UsageInfo {
        private final Map<String, VirtualFile> myRefs;

        RestoreReferencesUsage(@NotNull PsiElement element, Map<String, VirtualFile> refs) {
            if (element == null) {
                RestoreReferencesUsage.$$$reportNull$$$0(0);
            }
            super(element);
            this.myRefs = refs;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/refactoring/ES6MoveFileHandler$RestoreReferencesUsage", "<init>"));
        }
    }
}

