/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.names.JSNamedEntityKind;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.extractMethod.DefaultJSExtractFunctionSettings;
import com.intellij.lang.javascript.refactoring.extractMethod.ExtractedFunctionSignatureGenerator;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionDialog;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionSettings;
import com.intellij.lang.javascript.refactoring.extractMethod.JSFunctionInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.extractMethod.JSScopeSelectionUI;
import com.intellij.lang.javascript.refactoring.extractMethod.JSSignatureContext;
import com.intellij.lang.javascript.refactoring.introduce.JSIntroducedExpressionUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExtractFunctionHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"refactoring.extract.method.dialog.title");
    public static final String DEFAULT_EXTRACTED_NAME = "extracted";
    private static final String DECLARE_AS_FUNCTION_EXPRESSION_PROPERTY_KEY = "js.extract.function.declare.as.expression";
    private static final String DECLARE_STATIC_PROPERTY_KEY = "js.extract.function.declare.static";
    private static final String CLASS_MEMBER_VISIBILITY_PROPERTY_KEY = "js.extract.function.last.visibility";
    private static final String GLOBAL_SCOPE_WAS_SELECTED_KEY = "js.extract.function.global.scope.was.selected";
    private static final Class[] classTypes = new Class[]{JSObjectLiteralExpression.class, JSClass.class, JSFile.class, JSBlockStatement.class, JSEmbeddedContent.class, TypeScriptModule.class};
    public static final String RET_PREFIX = "__ret";
    private static final String VOID_TYPE_NAME = "void";
    private final Function<Editor, JSScopeSelectionUI> myScopeSelectionUICreator;

    public JSExtractFunctionHandler(@NotNull JSScopeSelectionUI scopeSelectionUI) {
        if (scopeSelectionUI == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(0);
        }
        this.myScopeSelectionUICreator = __ -> {
            if (scopeSelectionUI == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(75);
            }
            return scopeSelectionUI;
        };
    }

    public JSExtractFunctionHandler() {
        this.myScopeSelectionUICreator = ApplicationManager.getApplication().isUnitTestMode() ? e -> JSScopeSelectionUI.syncTestScopeSelector((Function<? super List<IntroductionScope>, ? extends IntroductionScope>)((Function)ContainerUtil::getFirstItem)) : ScopeSelectionPopup::new;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(1);
        }
        if (editor == null || file2 == null) {
            return;
        }
        this.invokeWithSettings(editor, file2, null);
    }

    public void invokeWithSettings(@NotNull Editor editor, @NotNull PsiFile file2, @Nullable DefaultJSExtractFunctionSettings explicitSettings) {
        ContextInfo contextInfo;
        AbstractInplaceIntroducer activeIntroducer;
        if (editor == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(3);
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)file2, editor, JSBundle.message((String)"javascript.refactoring.extract.function.title", (Object[])new Object[0]))) {
            return;
        }
        if (!editor.getSelectionModel().hasSelection()) {
            editor.getSelectionModel().selectLineAtCaret();
        }
        if ((activeIntroducer = AbstractInplaceIntroducer.getActiveIntroducer((Editor)editor)) != null) {
            IntroductionScope scopeFromInplace;
            activeIntroducer.stopIntroduce(editor);
            contextInfo = this.createContextInfo(editor, file2);
            if (!this.possibleToExtract(contextInfo)) {
                return;
            }
            IntroductionScope introductionScope = scopeFromInplace = activeIntroducer instanceof JSFunctionInplaceIntroducer ? ((JSFunctionInplaceIntroducer)activeIntroducer).restoreUsedScope(contextInfo.introductionScopes) : null;
            if (scopeFromInplace != null) {
                this.performDialogRefactoringWithScope(contextInfo, scopeFromInplace, explicitSettings);
                return;
            }
        }
        if (!this.possibleToExtract(contextInfo = this.createContextInfo(editor, file2))) {
            return;
        }
        Consumer callback = scope -> this.performDialogOrInplaceRefactoringWithScope(contextInfo, (IntroductionScope)scope, explicitSettings);
        this.chooseIntroductionScope((JSSignatureContext)contextInfo, (Consumer<? super IntroductionScope>)callback, editor, DEFAULT_EXTRACTED_NAME);
    }

    private void performDialogOrInplaceRefactoringWithScope(@NotNull ContextInfo contextInfo, @NotNull IntroductionScope scope, @Nullable DefaultJSExtractFunctionSettings explicitSettings) {
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(5);
        }
        PropertiesComponent.getInstance().setValue(GLOBAL_SCOPE_WAS_SELECTED_KEY, scope.isGlobal());
        if (JSExtractFunctionHandler.shouldPerformInplaceRefactoring(contextInfo)) {
            DefaultJSExtractFunctionSettings inplaceSettings = (DefaultJSExtractFunctionSettings)ObjectUtils.coalesce((Object)explicitSettings, (Object)JSExtractFunctionHandler.getInplaceSettings(scope));
            inplaceSettings.setIntroductionScope(scope);
            JSFunctionInplaceIntroducer inplaceHandler = new JSFunctionInplaceIntroducer(this, inplaceSettings, contextInfo, scope);
            if (inplaceHandler.startInplaceIntroduceTemplate()) {
                return;
            }
        }
        this.performDialogRefactoringWithScope(contextInfo, scope, explicitSettings);
    }

    @NotNull
    private static DefaultJSExtractFunctionSettings getInplaceSettings(@NotNull IntroductionScope scope) {
        if (scope == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(6);
        }
        boolean declareAsFunctionExpression = JSExtractFunctionHandler.getDeclareAsFunctionExpression();
        boolean declareStatic = JSExtractFunctionHandler.getDeclareStatic();
        JSAttributeList.AccessType visibility = (JSAttributeList.AccessType)ObjectUtils.coalesce((Object)JSExtractFunctionHandler.getClassMemberVisibility(), (Object)JSAttributeList.AccessType.PRIVATE);
        DefaultJSExtractFunctionSettings defaultJSExtractFunctionSettings = new DefaultJSExtractFunctionSettings(null, declareStatic, declareAsFunctionExpression, visibility, null, scope);
        if (defaultJSExtractFunctionSettings == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(7);
        }
        return defaultJSExtractFunctionSettings;
    }

    private void performDialogRefactoringWithScope(@NotNull ContextInfo contextInfo, @NotNull IntroductionScope scope, @Nullable DefaultJSExtractFunctionSettings explicitSettings) {
        JSExtractFunctionSettings settings;
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(9);
        }
        if (explicitSettings != null) {
            explicitSettings.setIntroductionScope(scope);
        }
        if ((settings = explicitSettings) == null) {
            settings = this.showDialog(contextInfo, this.getSignatureGenerator(), scope);
        }
        if (settings == null) {
            return;
        }
        DefaultJSExtractFunctionSettings finalSettings = settings;
        WriteCommandAction.runWriteCommandAction((Project)scope.parent.getProject(), (String)JSBundle.message((String)"javascript.extract.method.title", (Object[])new Object[0]), null, () -> {
            if (contextInfo == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(74);
            }
            this.doRefactoring(contextInfo, finalSettings);
        }, (PsiFile[])new PsiFile[0]);
    }

    private static boolean shouldPerformInplaceRefactoring(@NotNull ContextInfo contextInfo) {
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(10);
        }
        if (contextInfo.holder != null && (contextInfo.holder.isECMA4 || contextInfo.holder.isCoffeeScript)) {
            return false;
        }
        return contextInfo.editor.getSettings().isVariableInplaceRenameEnabled() && contextInfo.file.isPhysical();
    }

    @NotNull
    public final ContextInfo createContextInfo(Editor editor, PsiFile file2) {
        ContextInfo contextInfo = new ContextInfo(editor, file2);
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(11);
        }
        return contextInfo;
    }

    @Nullable
    protected JSExtractFunctionSettings showDialog(@NotNull ContextInfo ci, @NotNull ExtractedFunctionSignatureGenerator signatureGenerator, @NotNull IntroductionScope scope) {
        if (ci == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(12);
        }
        if (signatureGenerator == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(14);
        }
        JSExtractFunctionDialog dialog = new JSExtractFunctionDialog(signatureGenerator, ci, scope);
        dialog.show();
        if (dialog.getExitCode() != 0) {
            return null;
        }
        return dialog;
    }

    public final void chooseIntroductionScope(JSSignatureContext ci, Consumer<? super IntroductionScope> callback, Editor editor, String name) {
        this.chooseIntroductionScope(ci, callback, (JSScopeSelectionUI)this.myScopeSelectionUICreator.fun((Object)editor), name);
    }

    public final void chooseIntroductionScope(@NotNull JSSignatureContext signatureContext, final @NotNull Consumer<? super IntroductionScope> callback, @NotNull JSScopeSelectionUI scopeSelectionUi, @NotNull String functionName) {
        if (signatureContext == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(15);
        }
        if (callback == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(16);
        }
        if (scopeSelectionUi == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(17);
        }
        if (functionName == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(18);
        }
        List<IntroductionScope> introductionScopes = signatureContext.getIntroductionScopes();
        PsiElement anchorElement = signatureContext.getAnchor();
        if (signatureContext.isActionScript()) {
            callback.consume((Object)JSExtractFunctionHandler.getDefaultSuggestedScope(introductionScopes, false));
            return;
        }
        if (introductionScopes.size() == 1) {
            callback.consume((Object)introductionScopes.get(0));
            return;
        }
        if (introductionScopes.size() > 1) {
            ArrayList<IntroductionScope> scopesInList = new ArrayList<IntroductionScope>(introductionScopes);
            Collections.reverse(scopesInList);
            IntroductionScope defaultSuggestedScope = JSExtractFunctionHandler.getDefaultSuggestedScope(introductionScopes, true);
            List presentations = ContainerUtil.mapNotNull(scopesInList, scope -> {
                if (functionName == null) {
                    JSExtractFunctionHandler.$$$reportNull$$$0(72);
                }
                if (signatureContext == null) {
                    JSExtractFunctionHandler.$$$reportNull$$$0(73);
                }
                DefaultJSExtractFunctionSettings defaultSettings = new DefaultJSExtractFunctionSettings(functionName, (IntroductionScope)scope);
                PsiElement anchor = this.findFunctionAnchor(scope.parent, anchorElement);
                if (anchor == null) {
                    return null;
                }
                int hintPosition = anchor.getTextRange().getStartOffset();
                return new JSScopeSelectionUI.ScopePresentation((IntroductionScope)scope, this.getSignatureGenerator().fun(defaultSettings, signatureContext), hintPosition);
            });
            Pass<IntroductionScope> pass = new Pass<IntroductionScope>(){

                public void pass(IntroductionScope o) {
                    callback.consume((Object)o);
                }
            };
            scopeSelectionUi.show(defaultSuggestedScope, presentations, (Pass<? super IntroductionScope>)pass);
        }
    }

    private static IntroductionScope getDefaultSuggestedScope(List<? extends IntroductionScope> introductionScopes, boolean checkLastSelectedScope) {
        IntroductionScope nearestScope = introductionScopes.get(0);
        boolean insidePackageStatement = PsiTreeUtil.getParentOfType((PsiElement)nearestScope.getParent(), (Class[])new Class[]{JSPackageStatement.class, JSClass.class}) instanceof JSPackageStatement;
        for (IntroductionScope introductionScope : introductionScopes) {
            if (introductionScope.isClassContext()) {
                return introductionScope;
            }
            if (!introductionScope.isGlobal() || insidePackageStatement || checkLastSelectedScope && !PropertiesComponent.getInstance().getBoolean(GLOBAL_SCOPE_WAS_SELECTED_KEY)) continue;
            return introductionScope;
        }
        return nearestScope;
    }

    protected boolean possibleToExtract(ContextInfo ci) {
        if (ci.getProblem() != null) {
            CommonRefactoringUtil.showErrorHint((Project)ci.project, (Editor)ci.editor, (String)ci.getProblem(), (String)JSBundle.message((String)"javascript.refactoring.extract.function.title", (Object[])new Object[0]), (String)"refactoring.extractFunction");
            return false;
        }
        return true;
    }

    private boolean notAllowedStatement(PsiElement n) {
        return n instanceof JSPackageStatement || n instanceof JSImportStatement || n instanceof JSBlockStatement && n.getParent() instanceof JSFunction || n instanceof JSFunction;
    }

    protected PsiElement findStatement(PsiElement elementAt, int start, int end) {
        if ((elementAt instanceof PsiComment || elementAt instanceof PsiWhiteSpace) && (elementAt.getParent() instanceof JSBlockStatement || elementAt.getParent() instanceof JSFile)) {
            return elementAt;
        }
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)elementAt, JSStatement.class);
        if (this.notAllowedStatement((PsiElement)statement)) {
            return null;
        }
        return statement;
    }

    @NotNull
    static JSExtractFunctionSettings.ParametersInfo createDefaultParametersInfo(@NotNull IntroductionScope scope) {
        if (scope == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(19);
        }
        JSExtractFunctionSettings.ParametersInfo parametersInfo = new JSExtractFunctionSettings.ParametersInfo();
        parametersInfo.variables.addAll(scope.usedVars);
        JSExtractFunctionSettings.ParametersInfo parametersInfo2 = parametersInfo;
        if (parametersInfo2 == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(20);
        }
        return parametersInfo2;
    }

    protected int getExtractFragmentStartOffset(Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        return selectionModel.getSelectionStart();
    }

    protected int getExtractFragmentEndOffset(Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        return selectionModel.getSelectionEnd();
    }

    public static boolean isPropertyContext(PsiElement parent) {
        return parent instanceof JSObjectLiteralExpression;
    }

    @Nullable
    public Result doRefactoring(ContextInfo contextInfo, @NotNull JSExtractFunctionSettings settings) {
        boolean needReformat;
        JSElement callElement;
        PsiElement fromText;
        if (settings == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(21);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        IntroductionScope introductionScope = settings.getIntroductionScope();
        contextInfo.editor.getSelectionModel().removeSelection();
        int startOffset = contextInfo.possibleRange.getStartOffset();
        String origText = contextInfo.editor.getDocument().getText(contextInfo.possibleRange);
        String text = origText.trim();
        int leftTrim = origText.indexOf(text);
        startOffset += leftTrim;
        StringBuilder b = new StringBuilder(text);
        JSExtractFunctionSettings.ParametersInfo parametersInfo = JSExtractFunctionHandler.getNotNullParametersInfo(settings);
        String semicolon = this.getStatementTerminator(contextInfo);
        for (Map.Entry e : contextInfo.parameterReferences.entrySet()) {
            JSExtractFunctionSettings.ParameterInfo parameterInfo = parametersInfo.variableOptions.get(e.getValue());
            if (parameterInfo == null) continue;
            RangeMarker range = (RangeMarker)e.getKey();
            b.replace(range.getStartOffset() - startOffset, range.getEndOffset() - startOffset, parameterInfo.name);
            startOffset += ((JSVariable)e.getValue()).getName().length() - parameterInfo.name.length();
        }
        for (RangeMarker range : contextInfo.continueStatementsToReplaceWithReturn) {
            int rangeStart = range.getStartOffset();
            int rangeEnd = range.getEndOffset();
            String toInsert = "return" + semicolon;
            b.replace(rangeStart - startOffset, rangeEnd - startOffset, toInsert);
            startOffset += rangeEnd - rangeStart - toInsert.length();
        }
        text = b.toString();
        String callPrefix = "";
        String callSuffix = "";
        if (contextInfo.isExpression) {
            boolean exprIsVoid = VOID_TYPE_NAME.equals(introductionScope.returnType);
            text = (exprIsVoid ? "" : this.getReturnStatementPrefix()) + text;
            if (!text.endsWith(semicolon)) {
                text = text + semicolon;
            }
        } else {
            ArrayList<JSVariable> outputVars = new ArrayList<JSVariable>(introductionScope.outputVars);
            Iterator i = outputVars.iterator();
            while (i.hasNext()) {
                JSVariable var = (JSVariable)i.next();
                JSExtractFunctionSettings.ParameterInfo parameterInfo = parametersInfo.variableOptions.get(var);
                if (parameterInfo == null || parameterInfo.used) continue;
                i.remove();
            }
            if (outputVars.size() == 1) {
                JSVariable var = (JSVariable)outputVars.get(0);
                JSType type = var.getType();
                text = text + JSExtractFunctionHandler.getReturnText(semicolon, var);
                boolean createVar = this.hasVariableDeclarationInExtractedText(contextInfo, var);
                callPrefix = (createVar ? this.getVariableDeclarationPrefix(var, contextInfo.holder) : "") + var.getName();
                if (contextInfo.isActionScript() && createVar && type != null) {
                    callPrefix = callPrefix + ":" + type.getTypeText();
                }
                callPrefix = callPrefix + " = ";
            } else if (outputVars.size() > 1) {
                text = text + JSExtractFunctionHandler.getReturnLiteralObjectText(contextInfo, outputVars, semicolon);
                if (this.canUseDestructuring(contextInfo, outputVars)) {
                    callPrefix = this.getOutputDestructuringDeclarationPrefix(contextInfo, outputVars);
                } else {
                    callPrefix = this.getVariableDeclarationPrefix(null, contextInfo.holder) + RET_PREFIX + (contextInfo.isActionScript() ? ":Object" : "") + " = ";
                    callSuffix = this.getOutputVariablesInitialization(contextInfo, outputVars, semicolon);
                }
            }
        }
        if (contextInfo.hasReturnInside) {
            callPrefix = callPrefix + this.getReturnStatementPrefix();
        }
        if (contextInfo.isAsync()) {
            callPrefix = callPrefix + "await ";
        }
        if (settings.makeFunctionExpression() && (JSExtractFunctionHandler.isPropertyContext(introductionScope.parent) || ExtractedFunctionSignatureGenerator.findClassRefForScope(contextInfo.anchor, introductionScope.parent) != null)) {
            callPrefix = callPrefix + "this.";
        }
        String introducedFunctionText = this.getSignatureGenerator().fun(settings, contextInfo);
        introducedFunctionText = this.addBodyToSignature(introducedFunctionText, text);
        if (settings.makeFunctionExpression() && !JSExtractFunctionHandler.isPropertyContext(introductionScope.parent) && !introductionScope.isClassContext()) {
            introducedFunctionText = introducedFunctionText + semicolon;
        }
        if ((fromText = this.createFunctionFromText(introductionScope, introducedFunctionText)) == null || JSExtractFunctionHandler.findExtractedNamedElement(fromText) == null) {
            return null;
        }
        JSIntroducedExpressionUtil.Replacer replacer = contextInfo.isExpression ? JSExtractFunctionHandler.buildExpressionReplacer(contextInfo.extractedElements, contextInfo.possibleRange) : null;
        PsiElement functionAnchor = this.findFunctionAnchor(introductionScope.parent, contextInfo.anchor);
        PsiElement created = introductionScope.parent.addBefore(fromText, functionAnchor);
        if (contextInfo.ecmaL4 && created instanceof JSFunction) {
            PsiElement typeElement = ((JSFunction)created).getReturnTypeElement();
            String typeName = JSResolveUtil.getShortTypeName(introductionScope.returnType, true);
            if (typeElement != null && introductionScope.returnType.indexOf(46) != -1 && !introductionScope.returnType.equals(typeName)) {
                ImportUtils.doImport(typeElement, introductionScope.returnType, false);
            }
        }
        ArrayList<FormatFixer> formatFixers = new ArrayList<FormatFixer>();
        if (!(introductionScope.parent instanceof XmlBackedJSClass)) {
            formatFixers.add(FormatFixer.create(created, FormatFixer.Mode.Reformat));
        }
        String callArgs = JSExtractFunctionHandler.buildCallArguments(parametersInfo);
        String callString = this.createMethodCallStringAfterExtractMethod(contextInfo, settings, callArgs, callPrefix, introductionScope);
        JSStatement callStatement = JSChangeUtil.createStatementPsiFromTextWithContext(callString + semicolon, contextInfo.anchor, JSStatement.class);
        if (contextInfo.isExpression) {
            JSExpression callExpression = (JSExpression)ObjectUtils.assertNotNull((Object)PsiTreeUtil.findChildOfType((PsiElement)callStatement, JSExpression.class));
            assert (replacer != null);
            callElement = replacer.replaceExpression(callExpression);
        } else {
            callElement = (JSElement)JSExtractFunctionHandler.replaceStatements((JSStatement)ObjectUtils.assertNotNull((Object)callStatement), contextInfo.extractedElements, contextInfo.anchor);
        }
        if (callSuffix.length() > 0) {
            PsiElement callEpilogue = JSChangeUtil.createJSTreeFromTextWithContext(callSuffix, contextInfo.extractedElements.get(0)).getPsi();
            PsiElement last = callEpilogue.getNextSibling();
            while (last.getNextSibling() != null) {
                last = last.getNextSibling();
            }
            callElement.getParent().addRangeAfter(callEpilogue, last, (PsiElement)callElement);
        }
        boolean bl = needReformat = !contextInfo.isExpression && contextInfo.extractedElements.size() > 1 || callSuffix.length() > 0;
        if (needReformat) {
            formatFixers.add(FormatFixer.create((PsiElement)callElement, FormatFixer.Mode.Reformat));
        }
        JSNamedElement extractedNamedElement = JSExtractFunctionHandler.findExtractedNamedElement(created);
        JSReferenceExpression reference = JSExtractFunctionHandler.findReferenceByName(settings.getMethodName(), callElement);
        if (extractedNamedElement == null || reference == null) {
            return null;
        }
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)extractedNamedElement.getProject());
        SmartPsiElementPointer declarationPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)extractedNamedElement);
        SmartPsiElementPointer referencePointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)reference);
        FormatFixer.fixAll(formatFixers);
        return new Result((SmartPsiElementPointer<? extends JSNamedElement>)declarationPointer, (SmartPsiElementPointer<? extends JSReferenceExpression>)referencePointer);
    }

    @NotNull
    private static String buildCallArguments(@NotNull JSExtractFunctionSettings.ParametersInfo parametersInfo) {
        if (parametersInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(22);
        }
        String callArgs = "";
        boolean referencesArguments = false;
        for (JSVariable var : JSExtractFunctionHandler.getOrderedParameters(parametersInfo)) {
            if (JSExtractFunctionHandler.isArgumentsReference(var)) {
                referencesArguments = true;
                continue;
            }
            JSExtractFunctionSettings.ParameterInfo parameterInfo = parametersInfo.variableOptions.get(var);
            if (parameterInfo != null && !parameterInfo.used) continue;
            if (callArgs.length() > 0) {
                callArgs = callArgs + ",";
            }
            callArgs = callArgs + var.getName();
        }
        if (referencesArguments) {
            if (callArgs.length() > 0) {
                callArgs = callArgs + ",";
            }
            callArgs = callArgs + "arguments";
        }
        String string = callArgs;
        if (string == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    private static JSIntroducedExpressionUtil.Replacer buildExpressionReplacer(@NotNull List<? extends PsiElement> expressions, @NotNull TextRange possibleRange) {
        PsiElement expressionParent;
        TextRange expressionRange;
        if (expressions == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(24);
        }
        if (possibleRange == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(25);
        }
        TextRange range = !possibleRange.equals((Object)(expressionRange = (expressionParent = (PsiElement)ObjectUtils.assertNotNull((Object)PsiTreeUtil.findCommonParent((PsiElement)expressions.get(0), (PsiElement)expressions.get(expressions.size() - 1)))).getTextRange())) ? expressionRange.intersection(possibleRange) : null;
        Pair expressionDescriptor = Pair.create((Object)((JSExpression)expressionParent), (Object)range);
        JSIntroducedExpressionUtil.Replacer replacer = JSIntroducedExpressionUtil.createReplacer((Pair<? extends JSExpression, TextRange>)expressionDescriptor);
        if (replacer == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(26);
        }
        return replacer;
    }

    private static PsiElement replaceStatements(@NotNull JSStatement callStatement, @NotNull List<? extends PsiElement> extractedElements, PsiElement anchor) {
        if (callStatement == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(27);
        }
        if (extractedElements == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(28);
        }
        if (extractedElements.size() == 1) {
            return extractedElements.iterator().next().replace((PsiElement)callStatement);
        }
        anchor = anchor.getParent().addBefore((PsiElement)callStatement, anchor);
        for (PsiElement psiElement : extractedElements) {
            if (!psiElement.isValid()) continue;
            PsiElement prev = psiElement.getPrevSibling();
            if (prev instanceof PsiWhiteSpace) {
                prev.delete();
            }
            psiElement.delete();
        }
        return anchor;
    }

    private boolean canUseDestructuring(ContextInfo contextInfo, List<? extends JSVariable> outputVars) {
        DialectOptionHolder holder = contextInfo.holder;
        if (holder == null || !holder.hasFeature(JSLanguageFeature.DESTRUCTURING_ASSIGNMENT)) {
            return false;
        }
        String prefix = this.getVariableDeclarationPrefix(outputVars.get(0), contextInfo.holder);
        for (JSVariable jSVariable : outputVars) {
            String currentPrefix = this.getVariableDeclarationPrefix(jSVariable, contextInfo.holder);
            if (this.hasVariableDeclarationInExtractedText(contextInfo, jSVariable) && StringUtil.equals((CharSequence)prefix, (CharSequence)currentPrefix)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static JSVarStatement.VarKeyword getKeywordForVariable(@Nullable JSVariable variable, @Nullable DialectOptionHolder dialect) {
        if (variable == null) {
            JSVarStatement.VarKeyword varKeyword = dialect != null && dialect.hasFeature(JSLanguageFeature.LET_DEFINITIONS) ? JSVarStatement.VarKeyword.CONST : JSVarStatement.VarKeyword.VAR;
            if (varKeyword == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(29);
            }
            return varKeyword;
        }
        JSVarStatement currentStatementParent = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSVarStatement.class);
        JSVarStatement.VarKeyword keyword = currentStatementParent != null ? currentStatementParent.getVarKeyword() : null;
        JSVarStatement.VarKeyword varKeyword = (JSVarStatement.VarKeyword)ObjectUtils.coalesce((Object)keyword, (Object)JSVarStatement.VarKeyword.VAR);
        if (varKeyword == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(30);
        }
        return varKeyword;
    }

    private boolean hasVariableDeclarationInExtractedText(@NotNull ContextInfo contextInfo, @NotNull JSVariable var) {
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(31);
        }
        if (var == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(32);
        }
        return contextInfo.possibleRange.contains(var.getTextRange());
    }

    private static String getReturnText(String semicolon, JSVariable var) {
        return "\nreturn " + var.getName() + semicolon;
    }

    private String getOutputDestructuringDeclarationPrefix(@NotNull ContextInfo contextInfo, @NotNull List<? extends JSVariable> outputVars) {
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(33);
        }
        if (outputVars == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(34);
        }
        String variables = StringUtil.join(outputVars, el -> el.getName(), (String)", ");
        return this.getVariableDeclarationPrefix(outputVars.get(0), contextInfo.holder) + "{ " + variables + " } = ";
    }

    @NotNull
    private String getOutputVariablesInitialization(@NotNull ContextInfo contextInfo, @NotNull List<? extends JSVariable> outputVars, @NotNull String semicolon) {
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(35);
        }
        if (outputVars == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(36);
        }
        if (semicolon == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(37);
        }
        String join = StringUtil.join(outputVars, el -> {
            if (contextInfo == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(70);
            }
            if (semicolon == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(71);
            }
            String varName = el.getName();
            boolean hasVariableDeclarationInExtractedText = this.hasVariableDeclarationInExtractedText(contextInfo, (JSVariable)el);
            String varPrefix = hasVariableDeclarationInExtractedText ? this.getVariableDeclarationPrefix((JSVariable)el, contextInfo.holder) : "";
            return varPrefix + varName + " = " + RET_PREFIX + "." + varName + semicolon;
        }, (String)"\n");
        String string = "\n" + join;
        if (string == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    private static String getReturnLiteralObjectText(@NotNull ContextInfo contextInfo, @NotNull List<? extends JSVariable> outputVars, @NotNull String semicolon) {
        DialectOptionHolder holder;
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(39);
        }
        if (outputVars == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(40);
        }
        if (semicolon == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(41);
        }
        boolean isShorthandPropertyAllow = (holder = contextInfo.holder) != null && holder.hasFeature(JSLanguageFeature.SHORTHAND_PROPERTY_NAMES);
        String string = "\nreturn {" + StringUtil.join(outputVars, el -> {
            String varName = el.getName();
            return isShorthandPropertyAllow ? varName : varName + ":" + varName;
        }, (String)", ") + "}" + semicolon;
        if (string == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(42);
        }
        return string;
    }

    protected String createMethodCallStringAfterExtractMethod(ContextInfo contextInfo, JSExtractFunctionSettings settings, String callArgs, String callPrefix, IntroductionScope scope) {
        boolean shouldProvideDirectThis;
        String methodName = settings.getMethodName();
        if (scope.isClassContext() && !contextInfo.ecmaL4) {
            boolean isStaticCallFromInstanceContext = JSExtractFunctionHandler.possibleToExtractStaticFromInstance(contextInfo, scope) && settings.makeStatic();
            String className = ((JSClass)scope.getParent()).getName();
            String scopePrefix = isStaticCallFromInstanceContext ? className : "this";
            return callPrefix + scopePrefix + "." + methodName + "(" + callArgs + ")";
        }
        PsiElement parent = scope.parent;
        boolean bl = shouldProvideDirectThis = !settings.makeFunctionExpression() || settings.makeFunctionExpression() && ExtractedFunctionSignatureGenerator.findClassRefForScope(contextInfo.anchor, parent) == null && !JSExtractFunctionHandler.isPropertyContext(parent);
        if (shouldProvideDirectThis && !contextInfo.isActionScript() && contextInfo.hasThisUsage) {
            return callPrefix + methodName + ".call(this" + (callArgs.isEmpty() ? "" : ", ") + callArgs + ")";
        }
        return callPrefix + methodName + "(" + callArgs + ")";
    }

    @Nullable
    protected PsiElement createFunctionFromText(IntroductionScope introductionScope, String introducedFunctionText) {
        PsiElement parent = introductionScope.getParent();
        if (introductionScope.isClassContext() && !DialectDetector.isActionScript(parent)) {
            return (PsiElement)JSChangeUtil.createClassMemberPsiFromTextWithContext(introducedFunctionText, parent, JSElement.class);
        }
        if (JSExtractFunctionHandler.isPropertyContext(parent)) {
            JSObjectLiteralExpression objectLiteralExpression = JSChangeUtil.createExpressionPsiWithContext("{" + introducedFunctionText + "}", parent, JSObjectLiteralExpression.class);
            return objectLiteralExpression != null ? objectLiteralExpression.getFirstProperty() : null;
        }
        ASTNode node = JSChangeUtil.createJSTreeFromTextWithContext(introducedFunctionText, parent);
        return node != null ? node.getPsi() : null;
    }

    protected String getStatementTerminator(ContextInfo contextInfo) {
        return JSCodeStyleSettings.getSemicolon((PsiElement)contextInfo.file);
    }

    protected String getReturnStatementPrefix() {
        return "return ";
    }

    @NotNull
    protected ExtractedFunctionSignatureGenerator getSignatureGenerator() {
        ExtractedFunctionSignatureGenerator extractedFunctionSignatureGenerator = new ExtractedFunctionSignatureGenerator();
        if (extractedFunctionSignatureGenerator == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(43);
        }
        return extractedFunctionSignatureGenerator;
    }

    protected String getVariableDeclarationPrefix(@Nullable JSVariable variable, @Nullable DialectOptionHolder dialect) {
        JSVarStatement.VarKeyword keyword = JSExtractFunctionHandler.getKeywordForVariable(variable, dialect);
        return keyword.getText() + " ";
    }

    protected String addBodyToSignature(String signature, String body) {
        return signature + "{\n" + body + "\n}";
    }

    @Nullable
    private PsiElement findFunctionAnchor(PsiElement scope, PsiElement startElement) {
        boolean placeAtScopeStart = startElement != null && JSCodeStyleSettings.isLocalDeclarationsAtScopeStart(startElement);
        PsiElement anchor = JSUtils.findFunctionAnchor(scope, startElement, placeAtScopeStart);
        return this.needInsertAfter(scope, anchor) ? JSPsiImplUtils.getNextSiblingIgnoreWhitespace(anchor) : JSPsiImplUtils.findLeadingCommentOrSelf(anchor);
    }

    protected boolean needInsertAfter(@NotNull PsiElement parent, @Nullable PsiElement functionAnchor) {
        if (parent == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(44);
        }
        return parent instanceof JSClass || functionAnchor instanceof JSPackageStatement;
    }

    static boolean isArgumentsReference(JSVariable var) {
        return "arguments".equals(var.getName()) && !(var instanceof JSParameter);
    }

    private static String getExpressionElementPresentation(PsiElement element) {
        if (element instanceof JSFunctionExpression) {
            element = ((JSFunctionExpression)element).getBody()[0];
        }
        String compactedText = element.getText().replaceAll("[\\n|\\r| ]+", " ");
        return "starting with " + compactedText.substring(0, Math.min(compactedText.length(), 30));
    }

    @Nullable
    protected IntroductionScope createPairWithPresentation(PsiElement parent) {
        if (parent == null) {
            return null;
        }
        String presentation = null;
        boolean forceMakeFunExpr = false;
        PsiElement element = parent;
        Class[] classes = (Class[])ArrayUtil.append((Object[])this.getScopeTypes(), JSFunction.class);
        while (element instanceof JSBlockStatement) {
            element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])classes);
        }
        if (element instanceof JSObjectLiteralExpression) {
            PsiElement objectParent = element.getParent();
            JSExpression assignedTo = null;
            if (objectParent instanceof JSAssignmentExpression) {
                assignedTo = ((JSAssignmentExpression)objectParent).getLOperand();
            } else if (objectParent instanceof JSVariable) {
                assignedTo = ((JSVariable)objectParent).getNameIdentifier();
            }
            presentation = "object " + (assignedTo == null ? JSExtractFunctionHandler.getExpressionElementPresentation(element) : "assigned to " + assignedTo.getText());
            forceMakeFunExpr = true;
        } else if (element instanceof JSFile) {
            presentation = JSBundle.message((String)"javascript.language.term.global", (Object[])new Object[0]);
        } else if (element instanceof XmlTagChild) {
            presentation = JSBundle.message((String)(element instanceof JSEmbeddedContent ? "javascript.language.term.global" : "javascript.language.term.xml.tag"), (Object[])new Object[0]);
            if (element instanceof XmlTag) {
                presentation = presentation + " " + ((XmlTag)element).getName();
            }
        } else {
            presentation = new JSNamedElementPresenter(element).describeWithQualifiedName();
        }
        return new IntroductionScope(parent, presentation, forceMakeFunExpr);
    }

    protected Class[] getScopeTypes() {
        return classTypes;
    }

    protected boolean acceptBlockStatementAsScope(JSBlockStatement blockStatement) {
        return false;
    }

    @Nullable
    public IntroductionScope findBase(PsiElement at, boolean findAll) {
        PsiElement classFromContext;
        JSEmbeddedContent scriptTagAnchor;
        PsiElement decorator = PsiTreeUtil.getParentOfType((PsiElement)at, ES6Decorator.class);
        if (decorator != null) {
            IntroductionScope base = this.findBase(decorator, findAll);
            while (base != null && base.getParent() instanceof JSClass) {
                base = this.findBase(base.getParent(), findAll);
            }
            return base;
        }
        if (at.getContainingFile() instanceof XmlFile && PsiTreeUtil.getParentOfType((PsiElement)at, XmlAttributeValue.class) != null && (scriptTagAnchor = JSUtils.findScriptTagContent((XmlFile)at.getContainingFile())) != null) {
            return this.createPairWithPresentation((PsiElement)scriptTagAnchor);
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)at, (Class[])this.getScopeTypes());
        if (JSPsiImplUtils.isEmbeddedExpressionContent(parent)) {
            return this.findBase(parent.getParent(), findAll);
        }
        boolean stopOnNextParent = false;
        while (parent instanceof JSBlockStatement) {
            if (this.acceptBlockStatementAsScope((JSBlockStatement)parent) || stopOnNextParent) {
                return this.createPairWithPresentation(parent);
            }
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof JSFunction) {
                if (findAll) {
                    return this.createPairWithPresentation(parent);
                }
                PsiElement ref = ExtractedFunctionSignatureGenerator.findClassRef(parent);
                if (ref != null) {
                    stopOnNextParent = true;
                    parent = grandParent;
                } else if (grandParent instanceof JSFunctionExpression && !ActionScriptResolveUtil.isAnonymousEventHandler((JSFunctionExpression)grandParent)) {
                    PsiElement grandParent2 = grandParent.getParent();
                    if (grandParent2 instanceof JSParenthesizedExpression) {
                        grandParent2 = grandParent2.getParent();
                    }
                    if (grandParent2 instanceof JSCallExpression) {
                        return this.createPairWithPresentation(parent);
                    }
                }
            }
            parent = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])this.getScopeTypes());
        }
        if (parent instanceof JSFile && parent.getContext() != null && (classFromContext = JSResolveUtil.getClassReferenceForXmlFromContext(parent)) != null) {
            parent = classFromContext;
        }
        if (at instanceof XmlBackedJSClass) {
            return null;
        }
        return this.createPairWithPresentation(parent);
    }

    public List<IntroductionScope> findBases(PsiElement at) {
        ArrayList<IntroductionScope> scopes = new ArrayList<IntroductionScope>();
        IntroductionScope currentScope = this.findBase(at, true);
        while (currentScope != null && !(currentScope.parent instanceof JSFile) && !(currentScope.parent instanceof XmlTagChild)) {
            scopes.add(currentScope);
            currentScope = this.findBase(currentScope.parent, true);
        }
        if (currentScope != null) {
            scopes.add(currentScope);
        }
        return scopes;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(45);
        }
        if (elements == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(46);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static JSExtractFunctionSettings.ParametersInfo getNotNullParametersInfo(JSExtractFunctionSettings settings) {
        JSExtractFunctionSettings.ParametersInfo parametersInfo = settings.getParametersInfo();
        if (parametersInfo != null) {
            JSExtractFunctionSettings.ParametersInfo parametersInfo2 = parametersInfo;
            if (parametersInfo2 == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(47);
            }
            return parametersInfo2;
        }
        JSExtractFunctionSettings.ParametersInfo parametersInfo3 = JSExtractFunctionHandler.createDefaultParametersInfo(settings.getIntroductionScope());
        if (parametersInfo3 == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(48);
        }
        return parametersInfo3;
    }

    @NotNull
    public static List<JSVariable> getOrderedParameters(@NotNull JSExtractFunctionSettings.ParametersInfo parametersInfo) {
        if (parametersInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(49);
        }
        ArrayList<JSVariable> parameters = new ArrayList<JSVariable>(parametersInfo.variables);
        if (parametersInfo.variables.size() != parametersInfo.variableOptions.size()) {
            ArrayList<JSVariable> arrayList = parameters;
            if (arrayList == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(50);
            }
            return arrayList;
        }
        Collections.sort(parameters, Comparator.comparingInt(o -> {
            if (parametersInfo == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(69);
            }
            return parametersInfo.variableOptions.get((Object)o).index;
        }));
        ArrayList<JSVariable> arrayList = parameters;
        if (arrayList == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(51);
        }
        return arrayList;
    }

    private static String getExpressionTypeText(@Nullable JSExpression expression) {
        if (expression == null) {
            return null;
        }
        JSType type = JSResolveUtil.getExpressionJSType(expression);
        return type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
    }

    @NotNull
    private static List<JSExpression> getExtractedExpressions(@Nullable PsiElement nonEmptyAt, @NotNull TextRange extractionRange) {
        if (extractionRange == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(52);
        }
        JSExpression parent = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)nonEmptyAt, JSExpression.class, (boolean)false);
        JSExpression expression = null;
        while (parent != null && extractionRange.contains(parent.getTextRange())) {
            expression = parent;
            parent = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, JSExpression.class);
        }
        if (expression == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(53);
            }
            return list;
        }
        ArrayList extractedElements = ContainerUtil.newArrayList();
        extractedElements.add(expression);
        if (parent instanceof JSBinaryExpression) {
            PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)expression, (boolean)true);
            while (nextLeaf != null && extractionRange.contains(nextLeaf.getTextRange())) {
                JSExpression parentExpr = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)nextLeaf, JSExpression.class);
                PsiElement nextExpr = null;
                while (parentExpr != null && extractionRange.contains(parentExpr.getTextRange())) {
                    nextExpr = parentExpr;
                    parentExpr = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)parentExpr, JSExpression.class);
                }
                if (nextExpr != null) {
                    extractedElements.add(nextExpr);
                }
                nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)(nextExpr != null ? nextExpr : nextLeaf), (boolean)true);
            }
        }
        ArrayList arrayList = extractedElements;
        if (arrayList == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(54);
        }
        return arrayList;
    }

    @NotNull
    private static TextRange getExpressionRange(@NotNull List<? extends PsiElement> expressions) {
        if (expressions == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(55);
        }
        TextRange textRange = JSExtractFunctionHandler.expandRangeByNonMeaningfulElements((JSExpression)expressions.get(0), (JSExpression)expressions.get(expressions.size() - 1));
        if (textRange == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(56);
        }
        return textRange;
    }

    @NotNull
    private static TextRange expandRangeByNonMeaningfulElements(@NotNull JSExpression left, @NotNull JSExpression right) {
        if (left == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(57);
        }
        if (right == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(58);
        }
        PsiElement newLeft = JSExtractFunctionHandler.takeLeavesOrSelf((PsiElement)left, (Condition<? super PsiElement>)((Condition)psiElement -> psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment), false);
        PsiElement newRight = JSExtractFunctionHandler.takeLeavesOrSelf((PsiElement)right, (Condition<? super PsiElement>)((Condition)psiElement -> psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment || psiElement.getNode() != null && psiElement.getNode().getElementType() == JSTokenTypes.SEMICOLON), true);
        TextRange textRange = new TextRange(newLeft.getTextRange().getStartOffset(), newRight.getTextRange().getEndOffset());
        if (textRange == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(59);
        }
        return textRange;
    }

    @NotNull
    public static String[] suggestNames(@NotNull ContextInfo contextInfo) {
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(60);
        }
        JSExpression expression = (JSExpression)ObjectUtils.tryCast((Object)ContainerUtil.getFirstItem(contextInfo.extractedElements), JSExpression.class);
        PsiElement useScope = PsiTreeUtil.getParentOfType((PsiElement)contextInfo.anchor, JSExecutionScope.class);
        if (!contextInfo.isExpression || expression == null || useScope == null) {
            String[] stringArray = new String[]{DEFAULT_EXTRACTED_NAME};
            if (stringArray == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(61);
            }
            return stringArray;
        }
        List<String> candidates = JSNameSuggestionsUtil.generateVariableNamesFromExpression(expression, useScope, "get", Collections.emptyList(), JSNamedEntityKind.Accessor);
        if (candidates.isEmpty()) {
            String[] stringArray = new String[]{DEFAULT_EXTRACTED_NAME};
            if (stringArray == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(62);
            }
            return stringArray;
        }
        String[] stringArray = candidates.toArray(ArrayUtil.EMPTY_STRING_ARRAY);
        if (stringArray == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(63);
        }
        return stringArray;
    }

    @Nullable
    public static PsiElement findConflictingElementInScope(@NotNull String name, PsiElement scope, boolean isStatic, @Nullable PsiElement toIgnore) {
        if (name == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(64);
        }
        List<PsiElement> conflicts = JSRefactoringUtil.findExistingInScope(name, scope, isStatic);
        return (PsiElement)ContainerUtil.find(conflicts, t -> t != toIgnore);
    }

    @NotNull
    private static PsiElement takeLeavesOrSelf(@NotNull PsiElement element, Condition<? super PsiElement> condition, boolean forward) {
        PsiElement result2;
        if (element == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(65);
        }
        PsiElement previous = element;
        PsiElement psiElement = result2 = forward ? PsiTreeUtil.nextLeaf((PsiElement)element) : PsiTreeUtil.prevLeaf((PsiElement)element);
        while (result2 != null && condition.value((Object)result2)) {
            previous = result2;
            result2 = forward ? PsiTreeUtil.nextLeaf((PsiElement)result2) : PsiTreeUtil.prevLeaf((PsiElement)result2);
        }
        PsiElement psiElement2 = previous;
        if (psiElement2 == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(66);
        }
        return psiElement2;
    }

    @Nullable
    private static JSReferenceExpression findReferenceByName(String name, JSElement element) {
        Ref result2 = new Ref();
        PsiTreeUtil.processElements((PsiElement)element, t -> {
            if (t instanceof JSReferenceExpression && StringUtil.equals((CharSequence)((JSReferenceExpression)t).getReferenceName(), (CharSequence)name)) {
                result2.set((Object)((JSReferenceExpression)t));
                return false;
            }
            return true;
        });
        return (JSReferenceExpression)result2.get();
    }

    @Nullable
    private static JSNamedElement findExtractedNamedElement(@Nullable PsiElement created) {
        if (created instanceof JSNamedElement) {
            return (JSNamedElement)created;
        }
        if (created instanceof JSVarStatement) {
            return ((JSVarStatement)created).getVariables()[0];
        }
        if (created instanceof JSExpressionStatement) {
            JSExpression expression = ((JSExpressionStatement)created).getExpression();
            if (expression instanceof JSAssignmentExpression) {
                return ((JSAssignmentExpression)expression).getDefinitionExpression();
            }
            return (JSNamedElement)ObjectUtils.tryCast((Object)expression, JSNamedElement.class);
        }
        return null;
    }

    public static boolean possibleToExtractStaticFromInstance(@NotNull JSSignatureContext context, @NotNull IntroductionScope introductionScope) {
        if (context == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(67);
        }
        if (introductionScope == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(68);
        }
        return context.getJSContext().isCompatibleWith(JSContext.STATIC) && !StringUtil.isEmpty((String)((JSClass)introductionScope.getParent()).getName());
    }

    public static boolean getDeclareAsFunctionExpression() {
        return PropertiesComponent.getInstance().getBoolean(DECLARE_AS_FUNCTION_EXPRESSION_PROPERTY_KEY);
    }

    public static void saveDeclareAsFunctionExpression(boolean value) {
        PropertiesComponent.getInstance().setValue(DECLARE_AS_FUNCTION_EXPRESSION_PROPERTY_KEY, value);
    }

    public static boolean getDeclareStatic() {
        return PropertiesComponent.getInstance().getBoolean(DECLARE_STATIC_PROPERTY_KEY);
    }

    public static void saveDeclareStatic(boolean value) {
        PropertiesComponent.getInstance().setValue(DECLARE_STATIC_PROPERTY_KEY, value);
    }

    @Nullable
    public static JSAttributeList.AccessType getClassMemberVisibility() {
        String value = PropertiesComponent.getInstance().getValue(CLASS_MEMBER_VISIBILITY_PROPERTY_KEY);
        return StringUtil.isEmpty((String)value) ? null : (JSAttributeList.AccessType)StringUtil.parseEnum((String)value, null, JSAttributeList.AccessType.class);
    }

    public static void saveClassMemberVisibility(@Nullable JSAttributeList.AccessType accessType) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        if (accessType == null) {
            propertiesComponent.unsetValue(CLASS_MEMBER_VISIBILITY_PROPERTY_KEY);
        } else {
            propertiesComponent.setValue(CLASS_MEMBER_VISIBILITY_PROPERTY_KEY, accessType.toString());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 38: 
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 66: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 38: 
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 66: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeSelectionUI";
                break;
            }
            case 1: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 31: 
            case 33: 
            case 35: 
            case 39: 
            case 60: 
            case 70: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextInfo";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 11: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 38: 
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ci";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureGenerator";
                break;
            }
            case 15: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureContext";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeSelectionUi";
                break;
            }
            case 18: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 22: 
            case 49: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersInfo";
                break;
            }
            case 24: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleRange";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callStatement";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractedElements";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 34: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputVars";
                break;
            }
            case 37: 
            case 41: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semicolon";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractionRange";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introductionScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInplaceSettings";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createContextInfo";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultParametersInfo";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCallArguments";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExpressionReplacer";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordForVariable";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariablesInitialization";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnLiteralObjectText";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureGenerator";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullParametersInfo";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderedParameters";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractedExpressions";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionRange";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "expandRangeByNonMeaningfulElements";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNames";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "takeLeavesOrSelf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeWithSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performDialogOrInplaceRefactoringWithScope";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInplaceSettings";
                break;
            }
            case 7: 
            case 11: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 38: 
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 66: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performDialogRefactoringWithScope";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldPerformInplaceRefactoring";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "chooseIntroductionScope";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultParametersInfo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoring";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildCallArguments";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "buildExpressionReplacer";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatements";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "hasVariableDeclarationInExtractedText";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getOutputDestructuringDeclarationPrefix";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getOutputVariablesInitialization";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getReturnLiteralObjectText";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "needInsertAfter";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getOrderedParameters";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getExtractedExpressions";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionRange";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "expandRangeByNonMeaningfulElements";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "suggestNames";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "findConflictingElementInScope";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "takeLeavesOrSelf";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "possibleToExtractStaticFromInstance";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOrderedParameters$8";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOutputVariablesInitialization$6";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "lambda$chooseIntroductionScope$4";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "lambda$performDialogRefactoringWithScope$3";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 38: 
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 66: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Result {
        @NotNull
        private final SmartPsiElementPointer<? extends JSNamedElement> declaration;
        @NotNull
        private final SmartPsiElementPointer<? extends JSReferenceExpression> reference;

        public Result(@NotNull SmartPsiElementPointer<? extends JSNamedElement> declaration, @NotNull SmartPsiElementPointer<? extends JSReferenceExpression> reference) {
            if (declaration == null) {
                Result.$$$reportNull$$$0(0);
            }
            if (reference == null) {
                Result.$$$reportNull$$$0(1);
            }
            this.declaration = declaration;
            this.reference = reference;
        }

        @Nullable
        public JSNamedElement getDeclaration() {
            return (JSNamedElement)this.declaration.getElement();
        }

        @Nullable
        public JSReferenceExpression getReference() {
            return (JSReferenceExpression)this.reference.getElement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "declaration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "reference";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$Result";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class IntroductionScope {
        @NotNull
        public final PsiElement parent;
        public final String presentation;
        public final boolean forceMakeFunExpr;
        public final Set<JSVariable> usedVars;
        public final Set<JSVariable> outputVars;
        String returnType;

        public IntroductionScope(@NotNull PsiElement parent, String presentation) {
            if (parent == null) {
                IntroductionScope.$$$reportNull$$$0(0);
            }
            this(parent, presentation, false);
        }

        public IntroductionScope(@NotNull PsiElement parent, String presentation, boolean forceMakeFunExpr) {
            if (parent == null) {
                IntroductionScope.$$$reportNull$$$0(1);
            }
            this.usedVars = new LinkedHashSet<JSVariable>();
            this.outputVars = new LinkedHashSet<JSVariable>();
            this.parent = parent;
            this.presentation = presentation;
            this.forceMakeFunExpr = forceMakeFunExpr;
        }

        public String toString() {
            return this.presentation;
        }

        public boolean isClassContext() {
            return this.parent instanceof JSClass;
        }

        public boolean isGlobal() {
            return this.parent instanceof JSFile || this.parent instanceof JSEmbeddedContent;
        }

        @NotNull
        public PsiElement getParent() {
            PsiElement psiElement = this.parent;
            if (psiElement == null) {
                IntroductionScope.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$IntroductionScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$IntroductionScope";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class ContextInfo
    implements JSSignatureContext {
        final List<PsiElement> extractedElements;
        @NotNull
        public final TextRange possibleRange;
        private final List<RangeMarker> continueStatementsToReplaceWithReturn;
        private final Map<RangeMarker, JSVariable> parameterReferences;
        public final List<IntroductionScope> introductionScopes;
        @NotNull
        public final Project project;
        @NotNull
        final PsiFile file;
        public final boolean ecmaL4;
        @NotNull
        public final Editor editor;
        boolean isExpression;
        public PsiElement anchor;
        boolean hasReturnInside;
        boolean hasThisUsage;
        boolean hasSuperUsage;
        public boolean hasAwaitExpressions;
        private String myProblem;
        @Nullable
        public final DialectOptionHolder holder;

        public ContextInfo(@NotNull Editor editor, PsiFile file2) {
            TextRange expandedRange;
            List expressions;
            PsiElement statement;
            PsiElement nonEmptyAt;
            if (editor == null) {
                ContextInfo.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                ContextInfo.$$$reportNull$$$0(1);
            }
            this.extractedElements = new ArrayList<PsiElement>();
            this.continueStatementsToReplaceWithReturn = new ArrayList<RangeMarker>();
            this.parameterReferences = new LinkedHashMap<RangeMarker, JSVariable>();
            this.editor = editor;
            final Document document = editor.getDocument();
            int start = JSExtractFunctionHandler.this.getExtractFragmentStartOffset(editor);
            int end = JSExtractFunctionHandler.this.getExtractFragmentEndOffset(editor);
            this.possibleRange = new TextRange(start, end);
            this.file = file2;
            this.project = file2.getProject();
            PsiElement at = this.file.findElementAt(start);
            PsiElement elementToSearchScope = nonEmptyAt = at instanceof PsiWhiteSpace || at instanceof PsiComment ? JSPsiImplUtils.findNextCodeLeaf(at) : at;
            this.anchor = statement = JSExtractFunctionHandler.this.findStatement(at, start, end);
            if (statement instanceof PsiWhiteSpace) {
                this.anchor = statement.getNextSibling();
            }
            PsiElement statement2 = JSExtractFunctionHandler.this.findStatement(this.file.findElementAt(end - 1), start, end);
            this.holder = DialectDetector.dialectOfElement((PsiElement)ObjectUtils.coalesce((Object)statement, (Object)statement2));
            this.ecmaL4 = this.holder != null && this.holder.isECMA4;
            this.isExpression = false;
            if (statement == statement2 && statement != null && !this.possibleRange.contains(statement.getTextRange()) && !(expressions = JSExtractFunctionHandler.getExtractedExpressions(nonEmptyAt, this.possibleRange)).isEmpty() && (expandedRange = JSExtractFunctionHandler.getExpressionRange(expressions)).contains(this.possibleRange)) {
                this.isExpression = true;
                this.extractedElements.addAll(expressions);
                elementToSearchScope = (PsiElement)expressions.get(0);
            }
            this.introductionScopes = JSExtractFunctionHandler.this.findBases(elementToSearchScope);
            final Ref returnType = new Ref();
            JSRecursiveElementVisitor elementVisitor = new JSRecursiveElementVisitor(){
                final Set<JSVariable> processed = new THashSet();
                JSFunction currentFunction;

                public void visitJSReferenceExpression(JSReferenceExpression node) {
                    PsiElement element;
                    if (node.getQualifier() == null && !JSResolveUtil.isSelfReference((PsiElement)node) && (element = node.resolve()) instanceof JSVariable && element.getContainingFile().getOriginalFile().equals(node.getContainingFile().getOriginalFile())) {
                        JSVariable var = (JSVariable)element;
                        this.handleVariable(var, true);
                        ContextInfo.this.parameterReferences.put(document.createRangeMarker(node.getTextRange()), var);
                    }
                    super.visitJSReferenceExpression(node);
                }

                public void visitJSBreakStatement(JSBreakStatement node) {
                    JSStatement statementToBreak = node.getStatementToBreak();
                    if (statementToBreak == null || !ContextInfo.this.possibleRange.contains(statementToBreak.getTextRange())) {
                        ContextInfo.this.myProblem = JSBundle.message((String)"javascript.refactoring.extract.function.code.contain.break.statement", (Object[])new Object[0]);
                    }
                    super.visitJSBreakStatement(node);
                }

                public void visitJSContinueStatement(JSContinueStatement node) {
                    JSStatement statementToContinue = node.getStatementToContinue();
                    boolean continueFromCompletelyExtractedLoopBody = false;
                    if (statementToContinue instanceof JSLoopStatement && !ContextInfo.this.possibleRange.contains(statementToContinue.getTextRange())) {
                        JSStatement body;
                        JSStatement firstChild = body = ((JSLoopStatement)statementToContinue).getBody();
                        JSStatement lastChild = body;
                        if (body instanceof JSBlockStatement) {
                            firstChild = body.getFirstChild();
                            lastChild = body.getLastChild();
                            if (firstChild.getNode().getElementType() == JSTokenTypes.LBRACE && (firstChild = firstChild.getNextSibling()) instanceof PsiWhiteSpace) {
                                firstChild = firstChild.getNextSibling();
                            }
                            if (lastChild.getNode().getElementType() == JSTokenTypes.RBRACE && (lastChild = lastChild.getPrevSibling()) instanceof PsiWhiteSpace) {
                                lastChild = lastChild.getPrevSibling();
                            }
                        }
                        if (firstChild != null && lastChild != null && ContextInfo.this.possibleRange.contains(new TextRange(firstChild.getTextOffset(), lastChild.getTextRange().getEndOffset()))) {
                            continueFromCompletelyExtractedLoopBody = true;
                            ContextInfo.this.continueStatementsToReplaceWithReturn.add(document.createRangeMarker(node.getTextRange()));
                        }
                    }
                    if (statementToContinue == null || !continueFromCompletelyExtractedLoopBody && !ContextInfo.this.possibleRange.contains(statementToContinue.getTextRange())) {
                        ContextInfo.this.myProblem = JSBundle.message((String)"javascript.refactoring.extract.function.code.contain.continue.statement", (Object[])new Object[0]);
                    }
                    super.visitJSContinueStatement(node);
                }

                public void visitJSVariable(JSVariable node) {
                    super.visitJSVariable(node);
                    this.handleVariable(node, false);
                }

                public void visitJSReturnStatement(@NotNull JSReturnStatement node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitJSReturnStatement(node);
                    if (this.currentFunction == null) {
                        if (!ContextInfo.this.isExpression && ContextInfo.this.extractedElements.get(ContextInfo.this.extractedElements.size() - 1) != node) {
                            ContextInfo.this.myProblem = JSBundle.message((String)"javascript.refactoring.extract.function.code.contain.conditional.return", (Object[])new Object[0]);
                        }
                        returnType.set((Object)JSExtractFunctionHandler.getExpressionTypeText(node.getExpression()));
                        ContextInfo.this.hasReturnInside = true;
                    }
                }

                public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    JSFunction prevCurrentFunction = this.currentFunction;
                    this.currentFunction = node;
                    super.visitJSFunctionExpression(node);
                    this.currentFunction = prevCurrentFunction;
                }

                public void visitJSPrefixExpression(JSPrefixExpression node) {
                    if (node.getOperationSign() == JSTokenTypes.AWAIT_KEYWORD) {
                        ContextInfo.this.hasAwaitExpressions = true;
                    }
                    super.visitJSPrefixExpression(node);
                }

                public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    JSFunction prevCurrentFunction = this.currentFunction;
                    this.currentFunction = node;
                    super.visitJSFunctionDeclaration(node);
                    this.currentFunction = prevCurrentFunction;
                }

                public void visitJSThisExpression(JSThisExpression node) {
                    if (this.currentFunction == null) {
                        ContextInfo.this.hasThisUsage = true;
                    }
                    super.visitJSThisExpression(node);
                }

                public void visitJSSuperExpression(JSSuperExpression superExpression) {
                    if (this.currentFunction == null) {
                        ContextInfo.this.hasSuperUsage = true;
                    }
                    super.visitJSSuperExpression(superExpression);
                }

                private void handleVariable(JSVariable var, boolean referencedInFragment) {
                    if (!this.processed.contains(var)) {
                        if (JSResolveUtil.findParent((PsiElement)var) instanceof JSClass) {
                            this.processed.add(var);
                            return;
                        }
                        boolean hasReadsOutOfBlock = false;
                        THashSet hasWritesInBlock = new THashSet();
                        if (!referencedInFragment && var.getInitializer() != null) {
                            hasWritesInBlock.addAll(ContextInfo.this.introductionScopes);
                        }
                        PsiElement varBase = var.getDeclarationScope();
                        THashSet varIsReachableFrom = new THashSet();
                        for (IntroductionScope scope : ContextInfo.this.introductionScopes) {
                            if (!ContextInfo.this.reachableFromExtractScope(varBase, scope)) continue;
                            varIsReachableFrom.add(scope);
                        }
                        for (PsiReference ref : ReferencesSearch.search((PsiElement)var, (SearchScope)new LocalSearchScope((PsiElement)var.getContainingFile()))) {
                            TextRange textRange = ref.getElement().getTextRange();
                            ReadWriteAccessDetector.Access access = JSReadWriteAccessDetector.ourInstance.getExpressionAccess(ref.getElement());
                            if (!(access == ReadWriteAccessDetector.Access.Write && !JSResolveUtil.isSelfReference(ref.getElement()) || ContextInfo.this.possibleRange.contains(textRange) && !this.isInsideLoop(ref.getElement(), varBase))) {
                                hasReadsOutOfBlock = true;
                            }
                            if (access == ReadWriteAccessDetector.Access.Read || !ContextInfo.this.possibleRange.contains(textRange)) continue;
                            for (IntroductionScope scope : ContextInfo.this.introductionScopes) {
                                if (varIsReachableFrom.contains(scope)) continue;
                                hasWritesInBlock.add(scope);
                            }
                        }
                        if (hasReadsOutOfBlock) {
                            for (IntroductionScope scope : hasWritesInBlock) {
                                scope.outputVars.add(var);
                            }
                        }
                        if (referencedInFragment) {
                            for (IntroductionScope scope : ContextInfo.this.introductionScopes) {
                                if (varIsReachableFrom.contains(scope)) continue;
                                scope.usedVars.add(var);
                            }
                        }
                        this.processed.add(var);
                    }
                }

                private boolean isInsideLoop(PsiElement element, PsiElement varBase) {
                    PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSLoopStatement.class, varBase.getClass()});
                    while (parent instanceof JSLoopStatement) {
                        if (!ContextInfo.this.possibleRange.contains(parent.getTextRange())) {
                            return true;
                        }
                        parent = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{JSLoopStatement.class, varBase.getClass()});
                    }
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "node";
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$ContextInfo$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSReturnStatement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSFunctionExpression";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSFunctionDeclaration";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            if (this.isExpression) {
                for (PsiElement element2 : this.extractedElements) {
                    element2.accept((PsiElementVisitor)elementVisitor);
                }
            }
            while (statement != null) {
                TextRange textRange = statement.getTextRange();
                if (!this.possibleRange.contains(textRange)) {
                    boolean nonws;
                    boolean intersects = textRange.intersectsStrict(this.possibleRange);
                    boolean bl = nonws = !(statement instanceof PsiWhiteSpace);
                    if (nonws || !intersects) {
                        if (!nonws || !intersects || textRange.contains(this.possibleRange)) break;
                        this.extractedElements.clear();
                        break;
                    }
                }
                this.extractedElements.add(statement);
                statement.accept((PsiElementVisitor)elementVisitor);
                if (statement == statement2) break;
                PsiElement n = statement.getNextSibling();
                statement = null;
                while (n != null) {
                    if (!(n instanceof PsiWhiteSpace)) {
                        statement = n;
                        break;
                    }
                    if (n == statement2) break;
                    n = n.getNextSibling();
                }
                if (n == null) break;
                if (!JSExtractFunctionHandler.this.notAllowedStatement(n)) continue;
                this.extractedElements.clear();
                break;
            }
            if (this.isExpression) {
                JSExpression expression = (JSExpression)this.extractedElements.get(0);
                returnType.set((Object)(expression.getParent() instanceof JSExpressionStatement ? JSExtractFunctionHandler.VOID_TYPE_NAME : JSExtractFunctionHandler.getExpressionTypeText(expression)));
            } else {
                for (IntroductionScope scope : this.introductionScopes) {
                    int outputVarsSize = scope.outputVars.size();
                    String scopeReturnType = (String)returnType.get();
                    if (outputVarsSize == 1) {
                        JSVariable next = scope.outputVars.iterator().next();
                        JSType type = next.getType();
                        String string = scopeReturnType = type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
                        if (scopeReturnType == null) {
                            scopeReturnType = "*";
                        }
                    } else if (outputVarsSize > 1) {
                        scopeReturnType = "Object";
                    }
                    scope.returnType = scopeReturnType;
                }
            }
            for (IntroductionScope scope : this.introductionScopes) {
                if (scope.returnType != null) continue;
                scope.returnType = returnType.get() == null ? JSExtractFunctionHandler.VOID_TYPE_NAME : (String)returnType.get();
            }
            if (this.extractedElements.size() == 0 || this.anchor == null || ContainerUtil.and(this.extractedElements, element -> element instanceof PsiWhiteSpace)) {
                this.myProblem = JSBundle.message((String)"javascript.refactoring.extract.function.bad.selection", (Object[])new Object[0]);
            }
            if (this.continueStatementsToReplaceWithReturn.size() != 0) {
                boolean allScopesReturnVoid = true;
                for (IntroductionScope scope : this.introductionScopes) {
                    if (JSExtractFunctionHandler.VOID_TYPE_NAME.equals(scope.returnType)) continue;
                    allScopesReturnVoid = false;
                }
                if (!allScopesReturnVoid) {
                    this.myProblem = JSBundle.message((String)"javascript.refactoring.extract.function.code.contain.continue.statement", (Object[])new Object[0]);
                }
            }
        }

        private boolean reachableFromExtractScope(PsiElement varScope, IntroductionScope scope) {
            PsiElement parent = scope.getParent();
            if (parent == varScope || parent.getParent() == varScope) {
                return true;
            }
            return PsiTreeUtil.findCommonParent((PsiElement)parent, (PsiElement)varScope) == varScope;
        }

        public String getProblem() {
            return this.myProblem;
        }

        @Override
        public boolean isActionScript() {
            return this.ecmaL4;
        }

        @Override
        public boolean isAsync() {
            return this.hasAwaitExpressions;
        }

        @Override
        @NotNull
        public JSContext getJSContext() {
            if (JSResolveUtil.calculateStaticFromContext(this.anchor)) {
                JSContext jSContext = JSContext.STATIC;
                if (jSContext == null) {
                    ContextInfo.$$$reportNull$$$0(2);
                }
                return jSContext;
            }
            if (this.hasSuperUsage || this.hasThisUsage) {
                JSContext jSContext = JSContext.INSTANCE;
                if (jSContext == null) {
                    ContextInfo.$$$reportNull$$$0(3);
                }
                return jSContext;
            }
            JSContext jSContext = JSContext.UNKNOWN;
            if (jSContext == null) {
                ContextInfo.$$$reportNull$$$0(4);
            }
            return jSContext;
        }

        @Override
        public PsiElement getAnchor() {
            return this.anchor;
        }

        @Override
        @NotNull
        public List<IntroductionScope> getIntroductionScopes() {
            List<IntroductionScope> list = this.introductionScopes;
            if (list == null) {
                ContextInfo.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$ContextInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$ContextInfo";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJSContext";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIntroductionScopes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ScopeSelectionPopup
    implements JSScopeSelectionUI {
        private final Editor editor;
        private LightweightHint myLastHint;

        public ScopeSelectionPopup(Editor editor) {
            this.editor = editor;
        }

        @Override
        public void show(@NotNull IntroductionScope defaultSuggestedScope, final @NotNull List<? extends JSScopeSelectionUI.ScopePresentation> scopeList, @NotNull Pass<? super IntroductionScope> callback) {
            if (defaultSuggestedScope == null) {
                ScopeSelectionPopup.$$$reportNull$$$0(0);
            }
            if (scopeList == null) {
                ScopeSelectionPopup.$$$reportNull$$$0(1);
            }
            if (callback == null) {
                ScopeSelectionPopup.$$$reportNull$$$0(2);
            }
            final LogicalPosition initialPos = this.editor.offsetToLogicalPosition(this.editor.getCaretModel().getOffset());
            final JBList list = new JBList((Collection)ContainerUtil.map(scopeList, presentation -> presentation.getScope()));
            list.setSelectedValue((Object)defaultSuggestedScope, true);
            list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int index = list.getSelectedIndex();
                    if (index < 0) {
                        return;
                    }
                    JSScopeSelectionUI.ScopePresentation presentation = (JSScopeSelectionUI.ScopePresentation)scopeList.get(index);
                    int hintPosition = presentation.getHintPosition();
                    LogicalPosition position = editor.offsetToLogicalPosition(hintPosition);
                    editor.getScrollingModel().scrollTo(position, ScrollType.MAKE_VISIBLE);
                    editor.getScrollingModel().runActionOnScrollingFinished(() -> {
                        JComponent label = HintUtil.createInformationLabel((String)presentation.getSignature());
                        LightweightHint hint = new LightweightHint(label);
                        myLastHint = hint;
                        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
                        Point p = HintManagerImpl.getHintPosition((LightweightHint)hint, (Editor)editor, (LogicalPosition)position, (short)3);
                        hintManager.showEditorHint(hint, editor, p, 48, 0, false, HintManagerImpl.createHintHint((Editor)editor, (Point)p, (LightweightHint)hint, (short)3).setContentActive(false).setAwtTooltip(true).setShowImmediately(true));
                    });
                }
            });
            list.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    IntroductionScope scope = (IntroductionScope)value;
                    PsiElement expr = scope.parent;
                    if (expr.isValid()) {
                        this.setText(scope.presentation);
                    }
                    return rendererComponent;
                }
            });
            JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Destination Scope").setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> {
                if (callback == null) {
                    ScopeSelectionPopup.$$$reportNull$$$0(3);
                }
                callback.pass(list.getSelectedValue());
            }).addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    editor.getScrollingModel().scrollTo(initialPos, ScrollType.CENTER);
                    if (myLastHint != null) {
                        myLastHint.hide();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$ScopeSelectionPopup$3", "onClosed"));
                }
            }).createPopup().showInBestPositionFor(this.editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultSuggestedScope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scopeList";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$ScopeSelectionPopup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "show";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$show$1";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

