/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import java.util.HashMap;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTClazzLineageInfo;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.nustaq.serialization.FSTObjectSerializer;
import org.nustaq.serialization.FSTSerializerRegistryDelegate;

public class FSTSerializerRegistry {
    private FSTSerializerRegistryDelegate delegate;
    public static FSTObjectSerializer NULL = new NULLSerializer();
    HashMap<Class, SerEntry> map = new HashMap(97);

    public void setDelegate(FSTSerializerRegistryDelegate delegate) {
        this.delegate = delegate;
    }

    public FSTSerializerRegistryDelegate getDelegate() {
        return this.delegate;
    }

    public final FSTObjectSerializer getSerializer(Class cl) {
        Class<?>[] lineage;
        FSTObjectSerializer ser;
        if (cl.isPrimitive()) {
            return null;
        }
        if (this.delegate != null && (ser = this.delegate.getSerializer(cl)) != null) {
            return ser;
        }
        for (Class<?> ascendant : lineage = FSTClazzLineageInfo.getLineage(cl)) {
            FSTObjectSerializer serializer = this.getSerializer(ascendant, cl);
            if (serializer == null) continue;
            return serializer;
        }
        return null;
    }

    final FSTObjectSerializer getSerializer(Class cl, Class lookupStart) {
        if (cl == null) {
            return null;
        }
        SerEntry serEntry = this.map.get(cl);
        if (serEntry != null) {
            if (cl == lookupStart && serEntry.ser.willHandleClass(cl)) {
                return serEntry.ser;
            }
            if (serEntry.forSubClasses && serEntry.ser.willHandleClass(cl)) {
                this.putSerializer(lookupStart, serEntry.ser, false);
                return serEntry.ser;
            }
        }
        return null;
    }

    public void putSerializer(Class cl, FSTObjectSerializer ser, boolean includeSubclasses) {
        this.map.put(cl, new SerEntry(includeSubclasses, ser));
    }

    static final class SerEntry {
        boolean forSubClasses = false;
        FSTObjectSerializer ser;

        SerEntry(boolean forSubClasses, FSTObjectSerializer ser) {
            this.forSubClasses = forSubClasses;
            this.ser = ser;
        }
    }

    static class NULLSerializer
    implements FSTObjectSerializer {
        NULLSerializer() {
        }

        @Override
        public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) {
        }

        @Override
        public void readObject(FSTObjectInput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy) throws Exception {
        }

        @Override
        public boolean willHandleClass(Class cl) {
            return true;
        }

        @Override
        public boolean alwaysCopy() {
            return false;
        }

        @Override
        public Object instantiate(Class objectClass, FSTObjectInput fstObjectInput, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition) throws Exception {
            return null;
        }
    }
}

