/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import git4idea.GitCommit;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.history.GitLogUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.data.GithubPullRequest;
import org.jetbrains.plugins.github.api.data.GithubPullRequestDetailedWithHtml;
import org.jetbrains.plugins.github.api.data.GithubSearchedIssue;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestDataProvider;
import org.jetbrains.plugins.github.util.GithubAsyncUtil;
import org.jetbrains.plugins.github.util.NonReusableEmptyProgressIndicator;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0002%&B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0001J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\u001aJ\u000e\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u0011R^\u0010\u000f\u001aR\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0012\u0014\u0012\u0012 \u0012*\b\u0018\u00010\u0013R\u00020\u00000\u0013R\u00020\u0000 \u0012*(\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0012\u0014\u0012\u0012 \u0012*\b\u0018\u00010\u0013R\u00020\u00000\u0013R\u00020\u0000\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00160\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsDataLoader;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "git", "Lgit4idea/commands/Git;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/progress/ProgressManager;Lgit4idea/commands/Git;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;)V", "cache", "Lcom/google/common/cache/Cache;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsDataLoader$DataTask;", "invalidationEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsDataLoader$ProviderChangedListener;", "isDisposed", "", "addProviderChangesListener", "", "listener", "disposable", "dispose", "getDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestDataProvider;", "githubSearchedIssue", "Lorg/jetbrains/plugins/github/api/data/GithubSearchedIssue;", "invalidateAllData", "invalidateData", "number", "DataTask", "ProviderChangedListener", "intellij.vcs.github"})
public final class GithubPullRequestsDataLoader
implements Disposable {
    private boolean isDisposed;
    private final Cache<Long, DataTask> cache;
    private final EventDispatcher<ProviderChangedListener> invalidationEventDispatcher;
    private final Project project;
    private final ProgressManager progressManager;
    private final Git git;
    private final GithubApiRequestExecutor requestExecutor;
    private final GitRepository repository;
    private final GitRemote remote;

    public final void invalidateData(long number) {
        this.cache.invalidate((Object)number);
    }

    public final void invalidateAllData() {
        this.cache.invalidateAll();
    }

    @NotNull
    public final GithubPullRequestDataProvider getDataProvider(@NotNull GithubSearchedIssue githubSearchedIssue) {
        Intrinsics.checkParameterIsNotNull((Object)githubSearchedIssue, (String)"githubSearchedIssue");
        if (this.isDisposed) {
            throw (Throwable)new IllegalStateException("Already disposed");
        }
        Object object = this.cache.get((Object)githubSearchedIssue.getNumber(), (Callable)new Callable<DataTask>(this, githubSearchedIssue){
            final /* synthetic */ GithubPullRequestsDataLoader this$0;
            final /* synthetic */ GithubSearchedIssue $githubSearchedIssue;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DataTask call() {
                void var2_2;
                NonReusableEmptyProgressIndicator indicator = new NonReusableEmptyProgressIndicator();
                GithubSearchedIssue.PullRequestLinks pullRequestLinks = this.$githubSearchedIssue.getPullRequestLinks();
                if (pullRequestLinks == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)pullRequestLinks, (String)"githubSearchedIssue.pullRequestLinks!!");
                String string = pullRequestLinks.getUrl();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"githubSearchedIssue.pullRequestLinks!!.url");
                DataTask task = this.this$0.new DataTask(string, (ProgressIndicator)indicator);
                GithubPullRequestsDataLoader.access$getProgressManager$p(this.this$0).runProcessWithProgressAsynchronously((Task.Backgroundable)task, (ProgressIndicator)indicator);
                return var2_2;
            }
            {
                this.this$0 = githubPullRequestsDataLoader;
                this.$githubSearchedIssue = githubSearchedIssue;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"cache.get(githubSearched\u2026dicator)\n      task\n    }");
        return (GithubPullRequestDataProvider)object;
    }

    public final void addProviderChangesListener(@NotNull ProviderChangedListener listener, @NotNull Disposable disposable) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
        this.invalidationEventDispatcher.addListener((EventListener)listener, disposable);
    }

    public void dispose() {
        this.invalidateAllData();
        this.isDisposed = true;
    }

    public GithubPullRequestsDataLoader(@NotNull Project project, @NotNull ProgressManager progressManager, @NotNull Git git, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull GitRepository repository, @NotNull GitRemote remote) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)progressManager, (String)"progressManager");
        Intrinsics.checkParameterIsNotNull((Object)git, (String)"git");
        Intrinsics.checkParameterIsNotNull((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)remote, (String)"remote");
        this.project = project;
        this.progressManager = progressManager;
        this.git = git;
        this.requestExecutor = requestExecutor;
        this.repository = repository;
        this.remote = remote;
        this.cache = CacheBuilder.newBuilder().removalListener(new RemovalListener<K1, V1>(this){
            final /* synthetic */ GithubPullRequestsDataLoader this$0;

            public final void onRemoval(RemovalNotification<Long, DataTask> it) {
                ((DataTask)it.getValue()).cancel$intellij_vcs_github();
                ProviderChangedListener providerChangedListener = (ProviderChangedListener)GithubPullRequestsDataLoader.access$getInvalidationEventDispatcher$p(this.this$0).getMulticaster();
                Object object = it.getKey();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.key");
                providerChangedListener.providerChanged(((Number)object).longValue());
            }
            {
                this.this$0 = githubPullRequestsDataLoader;
            }
        }).maximumSize(5L).build();
        EventDispatcher eventDispatcher = EventDispatcher.create(ProviderChangedListener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"EventDispatcher.create(P\u2026ngedListener::class.java)");
        this.invalidationEventDispatcher = eventDispatcher;
        LowMemoryWatcher.register((Runnable)new Runnable(){

            @Override
            public final void run() {
                this.invalidateAllData();
            }
        }, (Disposable)this);
    }

    @NotNull
    public static final /* synthetic */ ProgressManager access$getProgressManager$p(GithubPullRequestsDataLoader $this) {
        return $this.progressManager;
    }

    @NotNull
    public static final /* synthetic */ EventDispatcher access$getInvalidationEventDispatcher$p(GithubPullRequestsDataLoader $this) {
        return $this.invalidationEventDispatcher;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J!\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\tH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0004H\u0002J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0006H\u0016J5\u0010#\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u001b2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u001b0\t2\u0006\u0010\"\u001a\u00020\u00062\u000e\b\u0004\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u001b0&H\u0082\bR \u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR \u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u000e0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsDataLoader$DataTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestDataProvider;", "url", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsDataLoader;Ljava/lang/String;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "branchFetchRequest", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/openapi/util/Couple;", "getBranchFetchRequest", "()Ljava/util/concurrent/CompletableFuture;", "changesRequest", "", "Lcom/intellij/openapi/vcs/changes/Change;", "getChangesRequest", "detailsRequest", "Lorg/jetbrains/plugins/github/api/data/GithubPullRequestDetailedWithHtml;", "getDetailsRequest", "logCommitsRequest", "Lgit4idea/GitCommit;", "getLogCommitsRequest", "cancel", "", "cancel$intellij_vcs_github", "getOrHandle", "T", "future", "(Ljava/util/concurrent/CompletableFuture;)Ljava/lang/Object;", "isCommitFetched", "", "commitHash", "run", "indicator", "runPartialTask", "resultFuture", "task", "Lkotlin/Function0;", "intellij.vcs.github"})
    private final class DataTask
    extends Task.Backgroundable
    implements GithubPullRequestDataProvider {
        @NotNull
        private final CompletableFuture<GithubPullRequestDetailedWithHtml> detailsRequest;
        @NotNull
        private final CompletableFuture<Couple<String>> branchFetchRequest;
        @NotNull
        private final CompletableFuture<List<GitCommit>> logCommitsRequest;
        @NotNull
        private final CompletableFuture<List<Change>> changesRequest;
        private final String url;
        private final ProgressIndicator progressIndicator;

        @Override
        @NotNull
        public CompletableFuture<GithubPullRequestDetailedWithHtml> getDetailsRequest() {
            return this.detailsRequest;
        }

        @Override
        @NotNull
        public CompletableFuture<Couple<String>> getBranchFetchRequest() {
            return this.branchFetchRequest;
        }

        @Override
        @NotNull
        public CompletableFuture<List<GitCommit>> getLogCommitsRequest() {
            return this.logCommitsRequest;
        }

        @Override
        @NotNull
        public CompletableFuture<List<Change>> getChangesRequest() {
            return this.changesRequest;
        }

        /*
         * WARNING - void declaration
         */
        public void run(@NotNull ProgressIndicator indicator) {
            List result$iv;
            Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
            DataTask dataTask = this;
            CompletableFuture<Object> resultFuture$iv = this.getDetailsRequest();
            try {
                if (!resultFuture$iv.isCancelled()) {
                    indicator.checkCanceled();
                    GithubPullRequestDetailedWithHtml result$iv2 = GithubPullRequestsDataLoader.this.requestExecutor.execute(this.progressIndicator, GithubApiRequests.Repos.PullRequests.getHtml(this.url));
                    resultFuture$iv.complete(result$iv2);
                }
            }
            catch (ProcessCanceledException pce$iv) {
                resultFuture$iv.cancel(true);
            }
            catch (Exception e$iv) {
                resultFuture$iv.completeExceptionally(e$iv);
            }
            DataTask this_$iv = this;
            resultFuture$iv = this.getBranchFetchRequest();
            try {
                if (!resultFuture$iv.isCancelled()) {
                    indicator.checkCanceled();
                    GithubPullRequestDetailedWithHtml details = (GithubPullRequestDetailedWithHtml)this.getOrHandle(this.getDetailsRequest());
                    GithubPullRequestsDataLoader.this.git.fetch(GithubPullRequestsDataLoader.this.repository, GithubPullRequestsDataLoader.this.remote, CollectionsKt.emptyList(), new String[]{"refs/pull/" + details.getNumber() + "/head:"}).throwOnError(new int[0]);
                    GithubPullRequest.Tag tag = details.getBase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"details.base");
                    String string = tag.getSha();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"details.base.sha");
                    if (!this.isCommitFetched(string)) {
                        throw (Throwable)new IllegalStateException("Pull request base is not available after fetch");
                    }
                    GithubPullRequest.Tag tag2 = details.getHead();
                    Intrinsics.checkExpressionValueIsNotNull((Object)tag2, (String)"details.head");
                    String string2 = tag2.getSha();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"details.head.sha");
                    if (!this.isCommitFetched(string2)) {
                        throw (Throwable)new IllegalStateException("Pull request head is not available after fetch");
                    }
                    GithubPullRequest.Tag tag3 = details.getBase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)tag3, (String)"details.base");
                    String string3 = tag3.getSha();
                    GithubPullRequest.Tag tag4 = details.getHead();
                    Intrinsics.checkExpressionValueIsNotNull((Object)tag4, (String)"details.head");
                    Couple couple = Couple.of((Object)string3, (Object)tag4.getSha());
                    Intrinsics.checkExpressionValueIsNotNull((Object)couple, (String)"Couple.of(details.base.sha, details.head.sha)");
                    result$iv = couple;
                    resultFuture$iv.complete(result$iv);
                }
            }
            catch (ProcessCanceledException pce$iv) {
                resultFuture$iv.cancel(true);
            }
            catch (Exception e$iv) {
                resultFuture$iv.completeExceptionally(e$iv);
            }
            this_$iv = this;
            resultFuture$iv = this.getLogCommitsRequest();
            try {
                if (!resultFuture$iv.isCancelled()) {
                    indicator.checkCanceled();
                    Couple hashes = (Couple)this.getOrHandle(this.getBranchFetchRequest());
                    List list2 = GitLogUtil.collectFullDetails((Project)this.getProject(), (VirtualFile)GithubPullRequestsDataLoader.this.repository.getRoot(), (String[])new String[]{(String)hashes.first + ".." + (String)hashes.second});
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"GitLogUtil.collectFullDe\u2026irst}..${hashes.second}\")");
                    result$iv = list2;
                    resultFuture$iv.complete(result$iv);
                }
            }
            catch (ProcessCanceledException pce$iv) {
                resultFuture$iv.cancel(true);
            }
            catch (Exception e$iv) {
                resultFuture$iv.completeExceptionally(e$iv);
            }
            this_$iv = this;
            resultFuture$iv = this.getChangesRequest();
            try {
                if (!resultFuture$iv.isCancelled()) {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    indicator.checkCanceled();
                    List commits = (List)this.getOrHandle(this.getLogCommitsRequest());
                    Iterable e$iv = $receiver$iv = (Iterable)CollectionsKt.reversed((Iterable)commits);
                    Collection destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        GitCommit it = (GitCommit)element$iv$iv;
                        Iterable list$iv$iv = it.getChanges();
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    List list3 = CommittedChangesTreeBrowser.zipChanges((List)((List)destination$iv$iv));
                    Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"CommittedChangesTreeBrow\u2026).flatMap { it.changes })");
                    List result$iv3 = list3;
                    resultFuture$iv.complete(result$iv3);
                }
            }
            catch (ProcessCanceledException pce$iv) {
                resultFuture$iv.cancel(true);
            }
            catch (Exception e$iv) {
                resultFuture$iv.completeExceptionally(e$iv);
            }
        }

        private final <T> void runPartialTask(CompletableFuture<T> resultFuture, ProgressIndicator indicator, Function0<? extends T> task) {
            try {
                if (resultFuture.isCancelled()) {
                    return;
                }
                indicator.checkCanceled();
                Object result = task.invoke();
                resultFuture.complete(result);
            }
            catch (ProcessCanceledException pce) {
                resultFuture.cancel(true);
            }
            catch (Exception e) {
                resultFuture.completeExceptionally(e);
            }
        }

        private final <T> T getOrHandle(CompletableFuture<T> future) throws ProcessCanceledException {
            try {
                return future.join();
            }
            catch (CancellationException e) {
                throw (Throwable)new ProcessCanceledException((Throwable)e);
            }
            catch (CompletionException e) {
                if (GithubAsyncUtil.INSTANCE.isCancellation(e)) {
                    throw (Throwable)new ProcessCanceledException((Throwable)e);
                }
                Throwable throwable = e.getCause();
                if (throwable == null) {
                    throwable = e;
                }
                throw throwable;
            }
        }

        private final boolean isCommitFetched(String commitHash) {
            GitCommandResult gitCommandResult = GithubPullRequestsDataLoader.this.git.getObjectType(GithubPullRequestsDataLoader.this.repository, commitHash);
            Intrinsics.checkExpressionValueIsNotNull((Object)gitCommandResult, (String)"git.getObjectType(repository, commitHash)");
            GitCommandResult result = gitCommandResult;
            return result.success() && Intrinsics.areEqual((Object)result.getOutputAsJoinedString(), (Object)"commit");
        }

        public final void cancel$intellij_vcs_github() {
            this.progressIndicator.cancel();
        }

        public DataTask(@NotNull String url, ProgressIndicator progressIndicator) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)progressIndicator, (String)"progressIndicator");
            super(GithubPullRequestsDataLoader.this.project, "Load Pull Request Data", true);
            this.url = url;
            this.progressIndicator = progressIndicator;
            this.detailsRequest = new CompletableFuture();
            this.branchFetchRequest = new CompletableFuture();
            this.logCommitsRequest = new CompletableFuture();
            this.changesRequest = new CompletableFuture();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsDataLoader$ProviderChangedListener;", "Ljava/util/EventListener;", "providerChanged", "", "pullRequestNumber", "", "intellij.vcs.github"})
    public static interface ProviderChangedListener
    extends EventListener {
        public void providerChanged(long var1);
    }
}

