/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.openapi.vcs.annotate.VcsLineAnnotationData;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.util.HashMap;
import java.util.Map;

public class VcsRareLineAnnotationData
implements VcsLineAnnotationData {
    private final Map<Integer, VcsRevisionNumber> myMap;
    private final int mySize;

    public VcsRareLineAnnotationData(int size) {
        this.mySize = size;
        this.myMap = new HashMap<Integer, VcsRevisionNumber>();
    }

    @Override
    public void put(int lineNumber, VcsRevisionNumber revisionNumber) {
        assert (lineNumber >= 0 && this.mySize > lineNumber);
        this.myMap.put(lineNumber, revisionNumber);
    }

    @Override
    public int getNumLines() {
        return this.mySize;
    }

    @Override
    public VcsRevisionNumber getRevision(int lineNumber) {
        assert (lineNumber >= 0 && this.mySize > lineNumber);
        return this.myMap.get(lineNumber);
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }
}

