/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types;

public enum Access {
    INSTANCE(1),
    CLASS(2);

    private final byte myMask;

    private Access(int mask) {
        this.myMask = (byte)mask;
    }

    public Access and(Access access) {
        return Access.byMask(this.myMask & access.myMask);
    }

    public Access or(Access access) {
        return Access.byMask(this.myMask | access.myMask);
    }

    public boolean acceptInstance() {
        return (this.myMask & Access.INSTANCE.myMask) != 0;
    }

    public boolean acceptClass() {
        return (this.myMask & Access.CLASS.myMask) != 0;
    }

    public int getMask() {
        return this.myMask;
    }

    public static Access byMask(int mask) {
        switch (mask) {
            case 1: {
                return INSTANCE;
            }
            case 2: {
                return CLASS;
            }
        }
        throw new IllegalArgumentException("Illegal access mask");
    }
}

