/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.filechooser;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import org.wiztools.filechooser.FDFileFilter;
import org.wiztools.filechooser.FileChooser;
import org.wiztools.filechooser.FileChooserResponse;
import org.wiztools.filechooser.FileFilter;

public class FDFileChooser
implements FileChooser {
    private FileFilter ff;
    private FilenameFilter filenameFilter;
    private File selectedFile;
    private File setSelectedFile;
    private File[] selectedFiles;
    private String title;
    private boolean multipleMode = false;
    private File currentDir;

    @Override
    public void addChoosableFileFilter(FileFilter ff) {
        this.setFileFilter(ff);
    }

    @Override
    public void setFileFilter(FileFilter ff) {
        this.ff = ff;
        this.filenameFilter = new FDFileFilter(ff);
    }

    @Override
    public FileFilter getFileFilter() {
        return this.ff;
    }

    @Override
    public File getSelectedFile() {
        return this.selectedFile;
    }

    @Override
    public File[] getSelectedFiles() {
        return this.selectedFiles;
    }

    @Override
    public void setSelectedFile(File f) {
        this.setSelectedFile = f;
    }

    @Override
    public void setDialogTitle(String title) {
        this.title = title;
    }

    @Override
    public void setMultiSelectionEnabled(boolean enable) {
        this.multipleMode = enable;
    }

    @Override
    public void setCurrentDirectory(File dir) {
        this.currentDir = dir;
    }

    private void setFDOptions(FileDialog fd) {
        if (this.currentDir != null) {
            fd.setDirectory(this.currentDir.getAbsolutePath());
        }
        fd.setMultipleMode(this.multipleMode);
        if (this.title != null) {
            fd.setTitle(this.title);
        }
        if (this.filenameFilter != null) {
            fd.setFilenameFilter(this.filenameFilter);
        }
        if (this.setSelectedFile != null) {
            fd.setFile(this.setSelectedFile.getAbsolutePath());
            this.setSelectedFile = null;
        }
    }

    private FileDialog getFileDialog(Component parent) throws IllegalArgumentException {
        FileDialog fd;
        if (parent instanceof Dialog) {
            fd = new FileDialog((Dialog)parent);
        } else if (parent instanceof Frame) {
            fd = new FileDialog((Frame)parent);
        } else {
            throw new IllegalArgumentException("FileDialog accepts only Dialog / Frame component!");
        }
        return fd;
    }

    private FileChooserResponse returnResponse(FileDialog fd) {
        if (this.multipleMode) {
            this.selectedFiles = fd.getFiles();
            return this.selectedFiles.length == 0 ? FileChooserResponse.CANCEL_OPTION : FileChooserResponse.APPROVE_OPTION;
        }
        String fileStr = fd.getFile();
        this.selectedFile = fileStr != null ? new File(fileStr) : null;
        return this.selectedFile == null ? FileChooserResponse.CANCEL_OPTION : FileChooserResponse.APPROVE_OPTION;
    }

    @Override
    public FileChooserResponse showOpenDialog(Component parent) {
        FileDialog fd = this.getFileDialog(parent);
        this.setFDOptions(fd);
        fd.setMode(0);
        fd.setVisible(true);
        return this.returnResponse(fd);
    }

    @Override
    public FileChooserResponse showSaveDialog(Component parent) {
        FileDialog fd = this.getFileDialog(parent);
        this.setFDOptions(fd);
        fd.setMode(1);
        fd.setVisible(true);
        return this.returnResponse(fd);
    }
}

