/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.DayType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.asta.AstaDataType;
import net.sf.mpxj.asta.AstaReader;
import net.sf.mpxj.asta.MapRow;
import net.sf.mpxj.asta.Row;
import net.sf.mpxj.asta.SqliteResultSetRow;
import net.sf.mpxj.common.FileHelper;
import net.sf.mpxj.common.InputStreamHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.reader.ProjectReader;

public final class AstaDatabaseFileReader
implements ProjectReader {
    private AstaReader m_reader;
    private Integer m_projectID = 1;
    private String m_schema = "";
    private Connection m_connection;
    private PreparedStatement m_ps;
    private ResultSet m_rs;
    private Map<String, Integer> m_meta = new HashMap<String, Integer>();
    private List<ProjectListener> m_projectListeners;

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    @Override
    public ProjectFile read(String string) throws MPXJException {
        return this.read(new File(string));
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        throw new MPXJException("Not implemented");
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        File file = null;
        try {
            file = InputStreamHelper.writeStreamToTempFile(inputStream, "pp");
            ProjectFile projectFile = this.read(file);
            return projectFile;
        }
        catch (IOException iOException) {
            throw new MPXJException("Failed to read file", iOException);
        }
        finally {
            FileHelper.deleteQuietly(file);
        }
    }

    public ProjectFile read() throws MPXJException {
        try {
            this.m_reader = new AstaReader();
            ProjectFile projectFile = this.m_reader.getProject();
            projectFile.getEventManager().addProjectListeners(this.m_projectListeners);
            this.processProjectProperties();
            this.processCalendars();
            this.processResources();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            this.m_reader = null;
            return projectFile;
        }
        catch (SQLException sQLException) {
            throw new MPXJException("Error reading file", sQLException);
        }
        catch (ParseException parseException) {
            throw new MPXJException("Error reading file", parseException);
        }
    }

    private void processProjectProperties() throws SQLException {
        List<Row> list = this.getRows("select duration as durationhours, project_start as staru, project_end as ene, * from project_summary where projid=?", this.m_projectID);
        if (!list.isEmpty()) {
            this.m_reader.processProjectProperties(list.get(0));
        }
    }

    private void processCalendars() throws SQLException, ParseException {
        List<Row> list = this.getRows("select id as exceptionnid, * from exceptionn");
        Map<Integer, DayType> map = this.m_reader.createExceptionTypeMap(list);
        list = this.getRows("select id as work_patternid, name as namn, * from work_pattern");
        Map<Integer, Row> map2 = this.m_reader.createWorkPatternMap(list);
        list = this.getRows("select id, work_patterns from calendar");
        Map<Integer, List<Row>> map3 = this.createWorkPatternAssignmentMap(list);
        list = this.getRows("select id, exceptions from calendar");
        Map<Integer, List<Row>> map4 = this.createExceptionAssignmentMap(list);
        list = this.getRows("select id, shifts from work_pattern");
        Map<Integer, List<Row>> map5 = this.createTimeEntryMap(list);
        list = this.getRows("select id as calendarid, name as namk, * from calendar where projid=? order by id", this.m_projectID);
        for (Row row : list) {
            this.m_reader.processCalendar(row, map2, map3, map4, map5, map);
        }
        this.m_reader.getProject().getProjectConfig().updateUniqueCounters();
    }

    private void processResources() throws SQLException {
        List<Row> list = this.getRows("select id as permanent_resourceid, name as nase, calendar as calendav, * from permanent_resource where projid=? order by id", this.m_projectID);
        List<Row> list2 = this.getRows("select id as consumable_resourceid, name as nase, calendar as calendav, * from consumable_resource where projid=? order by id", this.m_projectID);
        this.m_reader.processResources(list, list2);
    }

    private void processTasks() throws SQLException {
        List<Row> list = this.getRows("select id as barid, bar_start as starv, bar_finish as enf, name as namh, * from bar where projid=?", this.m_projectID);
        List<Row> list2 = this.getRows("select id as expanded_taskid, * from expanded_task where projid=?", this.m_projectID);
        List<Row> list3 = this.getRows("select id as taskid, given_duration as given_durationhours, actual_duration as actual_durationhours, overall_percent_complete as overall_percenv_complete, name as nare, calendar as calendau, linkable_start as starz, linkable_finish as enj, notes as notet, wbs as wbt, natural_order as naturao_order, * from task where projid=?", this.m_projectID);
        List<Row> list4 = this.getRows("select id as milestoneid, name as nare, calendar as calendau, wbs as wbt, natural_order as naturao_order, * from milestone where projid=?", this.m_projectID);
        this.m_reader.processTasks(list, list2, list3, list4);
    }

    private void processPredecessors() throws SQLException {
        List<Row> list = this.getRows("select start_lag_time as start_lag_timehours, end_lag_time as end_lag_timehours, link_kind as typi, * from link where projid=? order by id", this.m_projectID);
        this.m_reader.processPredecessors(list);
    }

    private void processAssignments() throws SQLException {
        List<Row> list = this.getRows("select allocated_to as allocatee_to, player, percent_complete, effort as efforw, permanent_schedul_allocation.id as permanent_schedul_allocationid, linkable_start as starz, linkable_finish as enj, given_allocation, delay as delaahours from permanent_schedul_allocation inner join perm_resource_skill on permanent_schedul_allocation.allocation_of = perm_resource_skill.id where permanent_schedul_allocation.projid=? order by permanent_schedul_allocation.id", this.m_projectID);
        this.m_reader.processAssignments(list);
    }

    public void setProjectID(int n) {
        this.m_projectID = n;
    }

    private List<Row> getRows(String string) throws SQLException {
        LinkedList<Row> linkedList = new LinkedList<Row>();
        this.m_ps = this.m_connection.prepareStatement(string);
        this.m_rs = this.m_ps.executeQuery();
        this.populateMetaData();
        while (this.m_rs.next()) {
            linkedList.add(new SqliteResultSetRow(this.m_rs, this.m_meta));
        }
        return linkedList;
    }

    private List<Row> getRows(String string, Integer n) throws SQLException {
        LinkedList<Row> linkedList = new LinkedList<Row>();
        this.m_ps = this.m_connection.prepareStatement(string);
        this.m_ps.setInt(1, NumberHelper.getInt(n));
        this.m_rs = this.m_ps.executeQuery();
        this.populateMetaData();
        while (this.m_rs.next()) {
            linkedList.add(new SqliteResultSetRow(this.m_rs, this.m_meta));
        }
        return linkedList;
    }

    private void populateMetaData() throws SQLException {
        this.m_meta.clear();
        ResultSetMetaData resultSetMetaData = this.m_rs.getMetaData();
        int n = resultSetMetaData.getColumnCount() + 1;
        for (int i = 1; i < n; ++i) {
            String string = resultSetMetaData.getColumnName(i);
            Integer n2 = resultSetMetaData.getColumnType(i);
            this.m_meta.put(string, n2);
        }
    }

    public void setSchema(String string) {
        if (string.charAt(string.length() - 1) != '.') {
            string = string + '.';
        }
        this.m_schema = string;
    }

    public String getSchema() {
        return this.m_schema;
    }

    private Map<Integer, List<Row>> createWorkPatternAssignmentMap(List<Row> list) throws ParseException {
        HashMap<Integer, List<Row>> hashMap = new HashMap<Integer, List<Row>>();
        for (Row row : list) {
            Integer n = row.getInteger("ID");
            String string = row.getString("WORK_PATTERNS");
            hashMap.put(n, this.createWorkPatternAssignmentRowList(string));
        }
        return hashMap;
    }

    private List<Row> createWorkPatternAssignmentRowList(String string) throws ParseException {
        ArrayList<Row> arrayList = new ArrayList<Row>();
        String[] stringArray = string.split(",|:");
        for (int i = 1; i < stringArray.length; i += 5) {
            Integer n = Integer.valueOf(stringArray[i + 1]);
            Date date = AstaDataType.parseBasicTimestamp(stringArray[i + 3]);
            Date date2 = AstaDataType.parseBasicTimestamp(stringArray[i + 4]);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("WORK_PATTERN", n);
            hashMap.put("START_DATE", date);
            hashMap.put("END_DATE", date2);
            arrayList.add(new MapRow(hashMap));
        }
        return arrayList;
    }

    private Map<Integer, List<Row>> createExceptionAssignmentMap(List<Row> list) {
        HashMap<Integer, List<Row>> hashMap = new HashMap<Integer, List<Row>>();
        for (Row row : list) {
            Integer n = row.getInteger("ID");
            String string = row.getString("EXCEPTIONS");
            hashMap.put(n, this.createExceptionAssignmentRowList(string));
        }
        return hashMap;
    }

    private List<Row> createExceptionAssignmentRowList(String string) {
        ArrayList<Row> arrayList = new ArrayList<Row>();
        String[] stringArray = string.split(",|:");
        for (int i = 1; i < stringArray.length; i += 3) {
            Date date = AstaDataType.parseEpochTimestamp(stringArray[i + 0]);
            Date date2 = AstaDataType.parseEpochTimestamp(stringArray[i + 1]);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("STARU_DATE", date);
            hashMap.put("ENE_DATE", date2);
            arrayList.add(new MapRow(hashMap));
        }
        return arrayList;
    }

    private Map<Integer, List<Row>> createTimeEntryMap(List<Row> list) throws ParseException {
        HashMap<Integer, List<Row>> hashMap = new HashMap<Integer, List<Row>>();
        for (Row row : list) {
            Integer n = row.getInteger("ID");
            String string = row.getString("SHIFTS");
            hashMap.put(n, this.createTimeEntryRowList(string));
        }
        return hashMap;
    }

    private List<Row> createTimeEntryRowList(String string) throws ParseException {
        ArrayList<Row> arrayList = new ArrayList<Row>();
        String[] stringArray = string.split(",|:");
        int n = 1;
        while (n < stringArray.length) {
            int n2 = Integer.parseInt(stringArray[n += 2]);
            ++n;
            for (int i = 0; i < n2; ++i) {
                Integer n3 = Integer.valueOf(stringArray[n + 0]);
                Date date = AstaDataType.parseBasicTime(stringArray[n + 1]);
                Date date2 = AstaDataType.parseBasicTime(stringArray[n + 2]);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("START_TIME", date);
                hashMap.put("END_TIME", date2);
                hashMap.put("EXCEPTIOP", n3);
                arrayList.add(new MapRow(hashMap));
                n += 3;
            }
        }
        return arrayList;
    }
}

