/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.text.CharArrayCharSequence;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;

public class CharSequenceReader
extends Reader {
    private final CharSequence myText;
    private int myCurPos;

    public CharSequenceReader(@NotNull CharSequence text) {
        if (text == null) {
            CharSequenceReader.$$$reportNull$$$0(0);
        }
        this.myText = text;
        this.myCurPos = 0;
    }

    @Override
    public void close() {
    }

    @Override
    public int read(@NotNull char[] cbuf, int off, int len) {
        if (cbuf == null) {
            CharSequenceReader.$$$reportNull$$$0(1);
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException("cbuf.length=" + cbuf.length + "; off=" + off + "; len=" + len);
        }
        if (len == 0) {
            return 0;
        }
        if (this.myText instanceof CharArrayCharSequence) {
            int readChars = ((CharArrayCharSequence)this.myText).readCharsTo(this.myCurPos, cbuf, off, len);
            if (readChars < 0) {
                return -1;
            }
            this.myCurPos += readChars;
            return readChars;
        }
        int charsToCopy = Math.min(len, this.myText.length() - this.myCurPos);
        if (charsToCopy <= 0) {
            return -1;
        }
        for (int n = 0; n < charsToCopy; ++n) {
            cbuf[n + off] = this.myText.charAt(n + this.myCurPos);
        }
        this.myCurPos += charsToCopy;
        return charsToCopy;
    }

    @Override
    public int read() {
        if (this.myCurPos >= this.myText.length()) {
            return -1;
        }
        return this.myText.charAt(this.myCurPos++);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cbuf";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/text/CharSequenceReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

