/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.openapi.project.Project;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkBySdkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkBySdkDialog;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfigurationFactory;
import com.jetbrains.php.testFramework.PhpTestFrameworkFormDecorator;
import com.jetbrains.php.testFramework.PhpTestFrameworkSettingsManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkBySdkConfigurableForm;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkConfigurableForm;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTestFrameworkBySdkFactory
extends PhpTestFrameworkConfigurationFactory<PhpTestFrameworkBySdkConfiguration> {
    private static final String BY_INTERPRETER = " by Remote Interpreter";
    private final String myPresentableName;

    public PhpTestFrameworkBySdkFactory(@NotNull PhpTestFrameworkType frameworkType, @Nullable PhpTestFrameworkFormDecorator decorator) {
        if (frameworkType == null) {
            PhpTestFrameworkBySdkFactory.$$$reportNull$$$0(0);
        }
        super(frameworkType, decorator);
        this.myPresentableName = this.getTestFrameworkType().getDisplayName() + BY_INTERPRETER;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.myPresentableName;
        if (string == null) {
            PhpTestFrameworkBySdkFactory.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean accepts(@NotNull PhpTestFrameworkConfiguration config) {
        if (config == null) {
            PhpTestFrameworkBySdkFactory.$$$reportNull$$$0(2);
        }
        return super.accepts(config) && config instanceof PhpTestFrameworkBySdkConfiguration;
    }

    @Override
    @Nullable
    public PhpTestFrameworkConfigurableForm createBaseForm(@NotNull Project project, @NotNull PhpTestFrameworkConfiguration config) {
        if (project == null) {
            PhpTestFrameworkBySdkFactory.$$$reportNull$$$0(3);
        }
        if (config == null) {
            PhpTestFrameworkBySdkFactory.$$$reportNull$$$0(4);
        }
        if (config instanceof PhpTestFrameworkBySdkConfiguration) {
            return new PhpTestFrameworkBySdkConfigurableForm(project, this.myTestFrameworkType, (PhpTestFrameworkBySdkConfiguration)config);
        }
        return null;
    }

    @Override
    public PhpTestFrameworkBySdkConfiguration createNewInstance(@NotNull Project project, @NotNull List<PhpTestFrameworkConfiguration> existingConfigurations) {
        String displayName;
        PhpTestFrameworkBySdkDialog dialog;
        if (project == null) {
            PhpTestFrameworkBySdkFactory.$$$reportNull$$$0(5);
        }
        if (existingConfigurations == null) {
            PhpTestFrameworkBySdkFactory.$$$reportNull$$$0(6);
        }
        if ((dialog = new PhpTestFrameworkBySdkDialog(project, displayName = this.getTestFrameworkType().getDisplayName(), existingConfigurations)).showAndGet()) {
            PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreter(dialog.getSelectedInterpreterName());
            PhpTestFrameworkBySdkConfiguration configuration = this.createByInterpreter(interpreter);
            if (interpreter != null && configuration != null) {
                PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
                if (manager != null) {
                    PathMappingSettings mappings = manager.createPathMappings(project, interpreter.getPhpSdkAdditionalData());
                    PhpTestFrameworkConfiguration local = PhpTestFrameworkSettingsManager.getInstance(project).getLocalConfig(this.myTestFrameworkType);
                    if (local != null) {
                        this.fillSettingsByDefaultValue(local, configuration, (NullableFunction<String, String>)((NullableFunction)localPath -> localPath == null ? null : mappings.convertToRemote(localPath)));
                    }
                }
                return configuration;
            }
        }
        return null;
    }

    @Override
    public PhpTestFrameworkBySdkConfiguration createByInterpreter(@Nullable PhpInterpreter interpreter) {
        if (interpreter != null && interpreter.isRemote()) {
            PhpTestFrameworkBySdkConfiguration configuration = new PhpTestFrameworkBySdkConfiguration();
            configuration.setFrameworkType(this.myTestFrameworkType);
            configuration.setInterpreterId(interpreter.getId());
            return configuration;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkBySdkFactory";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkBySdkFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createBaseForm";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNewInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

