/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.zend.messages;

import com.jetbrains.php.debug.zend.ZendDebugUtil;
import com.jetbrains.php.debug.zend.messages.GetVarResponse;
import com.jetbrains.php.debug.zend.messages.ZendDebugRequest;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class GetVarRequest
extends ZendDebugRequest<GetVarResponse> {
    private final String myVariableExpression;
    private final int myDepth;
    private final String[] myPath;

    public GetVarRequest(String variableExpression, int depth, String[] path) {
        this.myVariableExpression = variableExpression;
        this.myDepth = depth;
        this.myPath = path;
    }

    public GetVarRequest(int depth, String[] path) {
        this(path[0], depth, new String[path.length - 1]);
        System.arraycopy(path, 1, this.myPath, 0, path.length - 1);
    }

    public GetVarRequest(String[] path) {
        this(1, path);
    }

    public GetVarRequest(String variableExpression) {
        this(variableExpression, 1, new String[0]);
    }

    @Override
    public short getMessageId() {
        return 32;
    }

    @Override
    public void serialize(DataOutputStream out) throws IOException {
        super.serialize(out);
        ZendDebugUtil.writeString(out, this.myVariableExpression);
        out.writeInt(this.myDepth);
        out.writeInt(this.myPath.length);
        for (String pathElement : this.myPath) {
            ZendDebugUtil.writeString(out, pathElement);
        }
    }

    @Override
    protected void appendParameters(Map<String, String> parameters) {
        super.appendParameters(parameters);
        GetVarRequest.appendParameters(parameters, "var_name", this.myVariableExpression);
        GetVarRequest.appendParameters(parameters, "depth", this.myDepth);
        GetVarRequest.appendParameters(parameters, "path", this.myPath);
    }
}

