/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.w3c.css.css.CssParser;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.media.AtRuleMedia;
import org.w3c.css.parser.AtRule;
import org.w3c.css.parser.AtRulePage;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssFouffa;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssValidatorListener;
import org.w3c.css.parser.Errors;
import org.w3c.css.parser.analyzer.ParseException;
import org.w3c.css.parser.analyzer.TokenMgrError;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.selectors.IdSelector;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.util.Warning;
import org.w3c.css.util.Warnings;

public final class StyleSheetParser
implements CssValidatorListener,
CssParser {
    private static Constructor co = null;
    CssFouffa cssFouffa;
    StyleSheet style = new StyleSheet();

    @Override
    public void reInit() {
        this.style = new StyleSheet();
    }

    @Override
    public StyleSheet getStyleSheet() {
        return this.style;
    }

    public void setWarningLevel(int warningLevel) {
        this.style.setWarningLevel(warningLevel);
    }

    @Override
    public void notifyErrors(Errors errors) {
        this.style.addErrors(errors);
    }

    @Override
    public void notifyWarnings(Warnings warnings) {
        this.style.addWarnings(warnings);
    }

    @Override
    public void handleRule(ApplContext ac, CssSelectors selector, ArrayList<CssProperty> properties) {
        if (selector.getAtRule() instanceof AtRulePage) {
            this.style.remove(selector);
        }
        for (CssProperty property : properties) {
            property.setSelectors(selector);
            this.style.addProperty(selector, property);
        }
    }

    @Override
    public void addCharSet(String charset) {
        this.style.addCharSet(charset);
    }

    @Override
    public void newAtRule(AtRule atRule) {
        this.style.newAtRule(atRule);
    }

    @Override
    public void endOfAtRule() {
        this.style.endOfAtRule();
    }

    @Override
    public void setImportant(boolean important) {
        this.style.setImportant(important);
    }

    @Override
    public void setSelectorList(ArrayList<CssSelectors> selectors) {
        this.style.setSelectorList(selectors);
    }

    @Override
    public void setProperty(ArrayList<CssProperty> properties) {
        this.style.setProperty(properties);
    }

    @Override
    public void endOfRule() {
        this.style.endOfRule();
    }

    @Override
    public void removeThisRule() {
        this.style.removeThisRule();
    }

    @Override
    public void removeThisAtRule() {
        this.style.removeThisAtRule();
    }

    @Override
    public void handleAtRule(ApplContext ac, String ident, String string) {
        this.style.getWarnings().addWarning(new Warning(this.cssFouffa.getSourceFile(), this.cssFouffa.getLine(), "at-rule", 2, new String[]{ident, string}, ac));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseURL(ApplContext ac, URL url, String title, String kind, String media, int origin) {
        boolean doneref = false;
        URL ref = ac.getReferrer();
        this.setWarningLevel(ac.getWarningLevel());
        if (Util.onDebug) {
            System.err.println("StyleSheet.parseURL(" + url + ", " + title + ", " + kind + ", " + media + ", " + origin + ")");
        }
        if (kind != null && !(kind = kind.trim().toLowerCase()).equals("stylesheet") && !kind.equals("alternate stylesheet")) {
            return;
        }
        try {
            ac.setOrigin(origin);
            this.cssFouffa = new CssFouffa(ac, url);
            this.cssFouffa.addListener(this);
            if (media == null && ac.getCssVersion() != CssVersion.CSS1) {
                media = ac.getMedium() == null ? "all" : ac.getMedium();
            }
            AtRuleMedia m = AtRuleMedia.getInstance(ac.getCssVersion());
            try {
                if (media != null) {
                    this.addMedias(m, media, ac);
                }
                this.cssFouffa.setAtRule(m);
            }
            catch (InvalidParamException e) {
                Errors er = new Errors();
                er.addError(new CssError(url.toString(), -1, e));
                this.notifyErrors(er);
                if (doneref) {
                    ac.setReferrer(ref);
                }
                return;
            }
            ac.setReferrer(url);
            doneref = true;
            this.cssFouffa.parseStyle();
        }
        catch (Exception e) {
            Errors er = new Errors();
            er.addError(new CssError(url.toString(), -1, e));
            this.notifyErrors(er);
        }
        finally {
            if (doneref) {
                ac.setReferrer(ref);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addMedias(AtRuleMedia m, String medias, ApplContext ac) throws InvalidParamException {
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            StringTokenizer tokens = new StringTokenizer(medias, ",");
            while (tokens.hasMoreTokens()) {
                m.addMedia(null, tokens.nextToken().trim(), ac);
            }
            return;
        } else {
            CssFouffa muP = new CssFouffa(ac, new StringReader(medias));
            try {
                AtRuleMedia arm = muP.parseMediaDeclaration();
                if (arm == null) return;
                m.allMedia = arm.allMedia;
                return;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseStyleElement(ApplContext ac, Reader reader, String title, String media, URL url, int lineno) {
        Errors er;
        boolean doneref = false;
        this.style.setWarningLevel(ac.getWarningLevel());
        if (Util.onDebug) {
            System.err.println("StyleSheet.parseStyleElement(" + title + ", " + media + ", " + url + "," + lineno + ")");
        }
        URL ref = ac.getReferrer();
        try {
            String charset = ac.getCharsetForURL(url);
            this.cssFouffa = new CssFouffa(ac, reader, url, lineno);
            this.cssFouffa.addListener(this);
            if (media == null && ac.getCssVersion() != CssVersion.CSS1) {
                media = "all";
            }
            AtRuleMedia m = AtRuleMedia.getInstance(ac.getCssVersion());
            try {
                if (media != null) {
                    this.addMedias(m, media, ac);
                }
                this.cssFouffa.setAtRule(m);
            }
            catch (InvalidParamException e) {
                Errors er2 = new Errors();
                er2.addError(new CssError(url.toString(), -1, e));
                this.notifyErrors(er2);
                if (doneref) {
                    ac.setReferrer(ref);
                }
                return;
            }
            ac.setReferrer(url);
            doneref = true;
            this.cssFouffa.parseStyle();
        }
        catch (IOException e) {
            er = new Errors();
            er.addError(new CssError(url.toString(), -1, e));
            this.notifyErrors(er);
        }
        catch (TokenMgrError e) {
            er = new Errors();
            CssParseException cpe = null;
            if (co != null) {
                try {
                    Object[] o = new Object[]{e};
                    Exception new_e = (Exception)co.newInstance(o);
                    cpe = new CssParseException(new_e);
                }
                catch (Exception ex) {
                    cpe = null;
                }
            }
            if (cpe == null) {
                cpe = new CssParseException(new Exception(e.getMessage()));
            }
            er.addError(new CssError(url.toString(), -1, cpe));
            this.notifyErrors(er);
        }
        catch (RuntimeException e) {
            er = new Errors();
            er.addError(new CssError(url.toString(), this.cssFouffa.getLine(), new CssParseException(e)));
            this.notifyErrors(er);
        }
        finally {
            if (doneref) {
                ac.setReferrer(ref);
            }
        }
    }

    @Override
    public void parseStyleElement(ApplContext ac, String input, URL url, int lineno) {
        this.parseStyleElement(ac, new StringReader(input), null, null, url, lineno);
    }

    @Override
    public void parseStyleElement(ApplContext ac, InputStream input, String title, String media, URL url, int lineno) {
        InputStreamReader reader = null;
        String charset = ac.getCharsetForURL(url);
        try {
            reader = new InputStreamReader(input, charset == null ? "iso-8859-1" : charset);
        }
        catch (UnsupportedEncodingException uex) {
            Errors er = new Errors();
            er.addError(new CssError(url.toString(), -1, uex));
            this.notifyErrors(er);
        }
        if (reader != null) {
            this.parseStyleElement(ac, reader, title, media, url, lineno);
        }
    }

    public void parseStyleSheet(ApplContext ac, Reader reader, URL docref) {
        this.parseStyleElement(ac, reader, null, null, docref == null ? ac.getFakeURL() : docref, 0);
    }

    @Override
    public void parseStyleAttribute(ApplContext ac, InputStream input, String id, URL url, int lineno) {
        this.style.setWarningLevel(ac.getWarningLevel());
        --lineno;
        if (Util.onDebug) {
            System.err.println("StyleSheet.parseStyleAttribute(" + id + "," + url + "," + lineno + ")");
        }
        try {
            String charset = ac.getCharsetForURL(url);
            this.cssFouffa = new CssFouffa(ac, input, charset, url, lineno);
            this.cssFouffa.addListener(this);
            CssSelectors selector = new CssSelectors(ac);
            try {
                AtRuleMedia media = AtRuleMedia.getInstance(ac.getCssVersion());
                if (ac.getCssVersion() != CssVersion.CSS1) {
                    media.addMedia(null, "all", ac);
                }
                this.cssFouffa.setAtRule(media);
            }
            catch (InvalidParamException media) {
                // empty catch block
            }
            try {
                if (id == null || id.length() == 0) {
                    id = "nullId-" + Long.toHexString(System.currentTimeMillis());
                }
                selector.addId(new IdSelector(id.substring(1)));
            }
            catch (InvalidParamException e) {
                this.style.removeThisRule();
                ac.getFrame().addError(new CssError(e));
            }
            this.cssFouffa.parseDeclarations(selector);
        }
        catch (IOException e) {
            Errors er = new Errors();
            er.addError(new CssError(url.toString(), -1, e));
            this.notifyErrors(er);
        }
    }

    @Override
    public void parseStyleAttribute(ApplContext ac, String input, String id, URL url, int lineno) {
        this.parseStyleAttribute(ac, new ByteArrayInputStream(input.getBytes()), id, url, lineno);
    }

    public void setStyle(Class style) {
        this.cssFouffa.setStyle(style);
    }

    static {
        try {
            Class<Exception> c = Exception.class;
            Class[] cp = new Class[]{Exception.class};
            co = c.getDeclaredConstructor(cp);
        }
        catch (NoSuchMethodException ex) {
            co = null;
        }
    }
}

