/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.docker.ui;

import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.DockerCredentialsType;
import com.intellij.docker.remote.DockerInterpreterContainerSettingsEditorDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.remote.docker.PhpDockerContainerSettingsManager;
import com.jetbrains.php.remote.docker.PhpDockerProcessUtil;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.remote.interpreter.ui.PhpProjectConfigComponentProvider;
import com.jetbrains.php.remote.interpreter.ui.PhpRemoteInterpreterConfigurationForm;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PhpDockerContainerComponentProvider
extends PhpProjectConfigComponentProvider {
    private static final Logger LOG = Logger.getInstance(PhpDockerContainerComponentProvider.class);

    @NotNull
    public PhpProjectConfigComponentProvider.PhpProjectConfigComponent create(@NotNull Project project, @NotNull Disposable parent) {
        if (project == null) {
            PhpDockerContainerComponentProvider.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            PhpDockerContainerComponentProvider.$$$reportNull$$$0(1);
        }
        PhpDockerContainerComponent phpDockerContainerComponent = new PhpDockerContainerComponent(project, parent);
        if (phpDockerContainerComponent == null) {
            PhpDockerContainerComponentProvider.$$$reportNull$$$0(2);
        }
        return phpDockerContainerComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/docker/ui/PhpDockerContainerComponentProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/docker/ui/PhpDockerContainerComponentProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class PhpDockerContainerComponent
    extends PhpProjectConfigComponentProvider.PhpProjectConfigComponent {
        private final Project myProject;
        private String myInterpreterId;
        private final TextFieldWithBrowseButton myContainerSettingsField;
        private RemoteServer<?> myCurrentServer;
        private DockerContainerSettings myContainerSettings;

        PhpDockerContainerComponent(@NotNull Project project, @NotNull Disposable parent) {
            if (project == null) {
                PhpDockerContainerComponent.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                PhpDockerContainerComponent.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myContainerSettingsField = new TextFieldWithBrowseButton();
            this.myContainerSettingsField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DockerInterpreterContainerSettingsEditorDialog dialog = new DockerInterpreterContainerSettingsEditorDialog(myProject, myCurrentServer, myContainerSettings);
                    if (dialog.showAndGet()) {
                        myContainerSettingsField.setText(DockerContainerSettings.settingsToCli((DockerContainerSettings)myContainerSettings));
                        if (StringUtil.isNotEmpty((String)myInterpreterId)) {
                            PhpDockerContainerSettingsManager.getInstance(myProject).setSettings(myInterpreterId, myContainerSettings);
                            PhpRemoteInterpreterConfigurationForm.fireChanges((Project)myProject);
                        }
                    }
                }
            });
            this.myContainerSettingsField.getTextField().setEditable(false);
            Disposer.register((Disposable)parent, (Disposable)this.myContainerSettingsField);
            if (project.isDefault()) {
                this.myContainerSettingsField.setEnabled(false);
                this.myContainerSettingsField.setText(PhpBundle.message((String)"PhpProjectConfigurable.docker.default.project.error.tooltip", (Object[])new Object[0]));
            }
            this.init((JComponent)this.myContainerSettingsField, "Docker container:");
        }

        public boolean isAvailable(@NotNull PhpRemoteSdkAdditionalData data) {
            if (data == null) {
                PhpDockerContainerComponent.$$$reportNull$$$0(2);
            }
            return data.getRemoteConnectionType() == DockerCredentialsType.getInstance();
        }

        public void onInterpreterChange(@NotNull String interpreterId, @NotNull PhpRemoteSdkAdditionalData data) {
            if (interpreterId == null) {
                PhpDockerContainerComponent.$$$reportNull$$$0(3);
            }
            if (data == null) {
                PhpDockerContainerComponent.$$$reportNull$$$0(4);
            }
            this.myInterpreterId = interpreterId;
            boolean available = this.isAvailable(data);
            if (available && !this.myProject.isDefault()) {
                DockerContainerSettings settings = PhpDockerContainerSettingsManager.getInstance(this.myProject).getSettings(interpreterId);
                this.myContainerSettings = settings == null ? DockerContainerSettings.defaultSettings((Project)this.myProject) : settings.clone();
                DockerCredentialsHolder docker = DockerCredentialsHolder.tryGetDockerCredentials((RemoteSdkAdditionalData)data);
                try {
                    this.myCurrentServer = docker == null ? null : PhpDockerProcessUtil.getAccount(docker);
                }
                catch (RemoteSdkException e) {
                    LOG.debug((Throwable)e);
                    this.myCurrentServer = null;
                }
                this.myContainerSettingsField.setText(DockerContainerSettings.settingsToCli((DockerContainerSettings)this.myContainerSettings));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreterId";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/remote/docker/ui/PhpDockerContainerComponentProvider$PhpDockerContainerComponent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailable";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onInterpreterChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

