/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.structureView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.structureView.JSInheritedFromObjectFilter;
import com.intellij.lang.javascript.structureView.JSInheritedMembersNodeProvider;
import com.intellij.lang.javascript.structureView.JSKindSorter;
import com.intellij.lang.javascript.structureView.JSStructureViewElement;
import com.intellij.lang.javascript.structureView.JSStructureViewElementBase;
import com.intellij.lang.javascript.structureView.JSSuperGrouper;
import com.intellij.lang.javascript.structureView.SimpleItemPresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PlatformIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSStructureViewModel
extends TextEditorBasedStructureViewModel
implements StructureViewModel.ElementInfoProvider {
    private final Class[] myClasses = new Class[]{JSFunction.class, JSFieldVariable.class, JSDefinitionExpression.class, JSAssignmentExpression.class, JSClass.class, JSProperty.class, TypeScriptModule.class};
    private final Set<NodeProvider> myNodeProviders = Collections.singleton(new JSInheritedMembersNodeProvider());
    private final Filter[] myFilters = new Filter[]{new JSFieldsFilter(), new JSInheritedFromObjectFilter()};
    private final Sorter[] mySorters = new Sorter[]{new JSKindSorter(), Sorter.ALPHA_SORTER};
    private final Grouper[] myGroupers = new Grouper[]{new JSSuperGrouper()};
    private final StructureViewTreeElement myRootElement;

    public JSStructureViewModel(PsiElement root, Editor editor) {
        super(editor);
        this.myRootElement = this.createRoot(root);
    }

    protected PsiFile getPsiFile() {
        PsiFile file2 = super.getPsiFile();
        if (file2 == null) {
            file2 = ((PsiElement)this.myRootElement.getValue()).getContainingFile();
        }
        return file2;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        StructureViewTreeElement structureViewTreeElement = this.myRootElement;
        if (structureViewTreeElement == null) {
            JSStructureViewModel.$$$reportNull$$$0(0);
        }
        return structureViewTreeElement;
    }

    @NotNull
    protected JSStructureViewElementBase createRoot(PsiElement root) {
        boolean isECMA = root.getContainingFile().getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4);
        JSStructureViewElement jSStructureViewElement = new JSStructureViewElement(root, isECMA);
        if (jSStructureViewElement == null) {
            JSStructureViewModel.$$$reportNull$$$0(1);
        }
        return jSStructureViewElement;
    }

    @NotNull
    public Grouper[] getGroupers() {
        if (this.myGroupers == null) {
            JSStructureViewModel.$$$reportNull$$$0(2);
        }
        return this.myGroupers;
    }

    @NotNull
    public Sorter[] getSorters() {
        if (this.mySorters == null) {
            JSStructureViewModel.$$$reportNull$$$0(3);
        }
        return this.mySorters;
    }

    @NotNull
    public Filter[] getFilters() {
        if (this.myFilters == null) {
            JSStructureViewModel.$$$reportNull$$$0(4);
        }
        return this.myFilters;
    }

    @NotNull
    public Collection<NodeProvider> getNodeProviders() {
        Set<NodeProvider> set = this.myNodeProviders;
        if (set == null) {
            JSStructureViewModel.$$$reportNull$$$0(5);
        }
        return set;
    }

    protected boolean isSuitable(PsiElement element) {
        return super.isSuitable(element) && (!(element instanceof JSVariable) || PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class) == null);
    }

    public Object getCurrentEditorElement() {
        PsiElement element;
        int offset;
        PsiElement at;
        PsiLanguageInjectionHost injectionHost;
        Object editorElement = super.getCurrentEditorElement();
        PsiFile file2 = this.getPsiFile();
        if (editorElement == null && !(file2 instanceof JSFile) && (injectionHost = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)(at = file2.findElementAt(offset = this.getEditor().getCaretModel().getOffset())), PsiLanguageInjectionHost.class)) != null && (element = InjectedLanguageManager.getInstance((Project)file2.getProject()).findInjectedElementAt(file2, offset)) != null) {
            return this.findAcceptableElement(element);
        }
        if (editorElement instanceof JSFunctionExpression) {
            editorElement = JSPsiImplUtils.getInitializedElement((JSExpression)editorElement);
        }
        if (editorElement instanceof JSAssignmentExpression) {
            editorElement = ((JSAssignmentExpression)editorElement).getDefinitionExpression();
        }
        if (editorElement instanceof JSPsiElementBase) {
            String name = ((JSPsiElementBase)editorElement).getName();
            JSFunction function = JSPsiImplUtils.getPossibleFunction((PsiElement)((JSPsiElementBase)editorElement));
            if (function != null && StringUtil.equals((CharSequence)name, (CharSequence)function.getName())) {
                return function;
            }
        }
        return editorElement;
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        return true;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        return false;
    }

    @NotNull
    protected Class[] getSuitableClasses() {
        if (this.myClasses == null) {
            JSStructureViewModel.$$$reportNull$$$0(6);
        }
        return this.myClasses;
    }

    public boolean shouldEnterElement(Object element) {
        return JSStructureViewModel.shouldEnterElementStatic(element);
    }

    public static boolean shouldEnterElementStatic(Object element) {
        return element instanceof JSClass || element instanceof JSImplicitElement && ((JSImplicitElement)element).getType() == JSImplicitElement.Type.Class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/structureView/JSStructureViewModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSorters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeProviders";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableClasses";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class JSFieldsFilter
    implements Filter {
        @NonNls
        public static final String ID = "SHOW_FIELDS";

        private JSFieldsFilter() {
        }

        public boolean isVisible(TreeElement treeNode) {
            if (!(treeNode instanceof JSStructureViewElementBase)) {
                return true;
            }
            if (treeNode.getPresentation() instanceof SimpleItemPresentation) {
                return true;
            }
            PsiElement element = ((JSStructureViewElementBase)treeNode).getValue();
            if (element instanceof JSClass || element instanceof TypeScriptModule) {
                return true;
            }
            return element instanceof JSFunction || element instanceof JSProperty && ((JSProperty)element).tryGetFunctionInitializer() != null || element instanceof JSObjectLiteralExpression;
        }

        public boolean isReverted() {
            return true;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            ActionPresentationData actionPresentationData = new ActionPresentationData(IdeBundle.message((String)"action.structureview.show.fields", (Object[])new Object[0]), null, PlatformIcons.FIELD_ICON);
            if (actionPresentationData == null) {
                JSFieldsFilter.$$$reportNull$$$0(0);
            }
            return actionPresentationData;
        }

        @NotNull
        public String getName() {
            if (ID == null) {
                JSFieldsFilter.$$$reportNull$$$0(1);
            }
            return ID;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/structureView/JSStructureViewModel$JSFieldsFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

