/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.ActionScriptTextReferenceResolver;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.impl.JSReferenceSetElement;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSIndexBasedResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTagContextBuilder;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSLiteralKeyType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.statistics.JSResolveStatisticsCollector;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlToken;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTextReference
extends JSReferenceSetElement
implements EmptyResolveMessageProvider {
    protected JSTextReference(@NotNull JSReferenceSet set, @NotNull String s, int offset) {
        if (set == null) {
            JSTextReference.$$$reportNull$$$0(0);
        }
        if (s == null) {
            JSTextReference.$$$reportNull$$$0(1);
        }
        this(set, s, new TextRange(offset, offset + s.length()));
    }

    protected JSTextReference(@NotNull JSReferenceSet set, @NotNull String s, @NotNull TextRange rangeInElement) {
        if (set == null) {
            JSTextReference.$$$reportNull$$$0(2);
        }
        if (s == null) {
            JSTextReference.$$$reportNull$$$0(3);
        }
        if (rangeInElement == null) {
            JSTextReference.$$$reportNull$$$0(4);
        }
        super(set, s, rangeInElement);
    }

    public void processToSink(PsiFile containingFile, ResultSink resultSink) {
        ActionScriptTextReferenceResolver.processToSink(this, containingFile, resultSink);
    }

    @Override
    @NotNull
    public JSQualifiedName getQualifiedName() {
        ArrayList<String> contextNames = null;
        PsiReference prevContextReference = null;
        for (PsiReference ref : this.mySet.myReferences) {
            if (ref == this) break;
            if (contextNames == null) {
                contextNames = new ArrayList<String>(3);
            }
            contextNames.add(ref.getCanonicalText());
            prevContextReference = ref;
        }
        if (contextNames != null) {
            String qName;
            PsiElement psiElement = prevContextReference.resolve();
            if (psiElement instanceof XmlToken) {
                JSTagContextBuilder builder = new JSTagContextBuilder(psiElement, "HTMLElement");
                psiElement = builder.element;
            }
            if (psiElement instanceof JSClass && (qName = ((JSClass)psiElement).getQualifiedName()) != null) {
                contextNames = new ArrayList(3);
                BaseJSSymbolProcessor.addIndexListFromQName(qName, contextNames);
            }
        }
        JSQualifiedName jSQualifiedName = this.qNameFromNames(contextNames);
        if (jSQualifiedName == null) {
            JSTextReference.$$$reportNull$$$0(5);
        }
        return jSQualifiedName;
    }

    @NotNull
    protected JSQualifiedName qNameFromNames(List<String> contextNames) {
        JSQualifiedNameImpl qualifier = contextNames != null ? JSQualifiedNameImpl.fromComponents(contextNames) : null;
        JSQualifiedNameImpl jSQualifiedNameImpl = JSQualifiedNameImpl.create(this.getCanonicalText(), qualifier);
        if (jSQualifiedNameImpl == null) {
            JSTextReference.$$$reportNull$$$0(6);
        }
        return jSQualifiedNameImpl;
    }

    @Override
    @NotNull
    protected ResolveResult[] doResolve() {
        ResolveResult[] resolveResultArray = this.doResolve(this.myCanonicalText);
        if (resolveResultArray == null) {
            JSTextReference.$$$reportNull$$$0(7);
        }
        return resolveResultArray;
    }

    protected final ResolveResult[] doResolve(String text) {
        if ("*".equals(this.myCanonicalText) || "?".equals(this.myCanonicalText)) {
            return new ResolveResult[]{new JSResolveResult(this.mySet.getElement())};
        }
        PsiFile psiFile = this.mySet.element.getContainingFile();
        if (this.useActionScriptIndex(psiFile)) {
            return ActionScriptTextReferenceResolver.resolve(this);
        }
        return JSTextReference.defaultResolve(this, text);
    }

    public boolean useActionScriptIndex(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            JSTextReference.$$$reportNull$$$0(8);
        }
        return DialectDetector.isActionScript((PsiElement)psiFile);
    }

    @NotNull
    public static ResolveResult[] defaultResolve(@NotNull JSReferenceSetElement element, String text) {
        ResolveResult[] localResults;
        if (element == null) {
            JSTextReference.$$$reportNull$$$0(9);
        }
        PsiFile psiFile = element.getElement().getContainingFile();
        PsiElement referenceElement = element.mySet.element;
        WalkUpResolveProcessor processor = new WalkUpResolveProcessor(text, psiFile, referenceElement);
        ResolveResult[] keyRefType = JSTextReference.getResolveResultsFromTypeScriptKeyTypes(referenceElement);
        if (keyRefType != null) {
            if (keyRefType == null) {
                JSTextReference.$$$reportNull$$$0(10);
            }
            return keyRefType;
        }
        ResolveResult[] refType = JSTextReference.getResolveResultsFromIndexerProperty(referenceElement);
        if (refType != null) {
            if (refType == null) {
                JSTextReference.$$$reportNull$$$0(11);
            }
            return refType;
        }
        JSQualifiedName qualifiedName = element.getQualifiedName();
        JSQualifiedName qualifier = qualifiedName.getParent();
        if (qualifier != null) {
            processor.addTypeHierarchy(JSNamedTypeFactory.createNamespace(qualifier, JSContext.UNKNOWN, element.getElement(), true));
        }
        processor.allowPartialResults();
        processor.setAddOnlyCompleteMatches(qualifier != null || !(referenceElement instanceof JSLiteralExpression));
        String str = qualifiedName.getQualifiedName();
        if (qualifier == null) {
            SinkResolveProcessor<ResolveResultSink> localProcessor = new SinkResolveProcessor<ResolveResultSink>(str, new ResolveResultSink(referenceElement, str));
            element.processLocalVariants(localProcessor);
            processor.addLocalResults(localProcessor);
        }
        if ((localResults = processor.getResults()).length > 0) {
            if (localResults == null) {
                JSTextReference.$$$reportNull$$$0(12);
            }
            return localResults;
        }
        JSIndexBasedResolveUtil.processAllSymbols(processor);
        ResolveResult[] results = processor.getResults();
        if (results.length == 0 && "undefined".equals(str)) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult(referenceElement)};
            if (resolveResultArray == null) {
                JSTextReference.$$$reportNull$$$0(13);
            }
            return resolveResultArray;
        }
        if (results == null) {
            JSTextReference.$$$reportNull$$$0(14);
        }
        return results;
    }

    private static ResolveResult[] getResolveResultsFromIndexerProperty(PsiElement referenceElement) {
        if (!(referenceElement instanceof JSLiteralExpression)) {
            return null;
        }
        String propertyName = ((JSLiteralExpression)referenceElement).getValueAsPropertyName();
        if (propertyName == null) {
            return null;
        }
        JSIndexedPropertyAccessExpression indexer = (JSIndexedPropertyAccessExpression)PsiTreeUtil.getContextOfType((PsiElement)referenceElement, (Class[])new Class[]{JSIndexedPropertyAccessExpression.class});
        if (indexer == null) {
            return null;
        }
        ResolveResultSink sink = new ResolveResultSink((PsiElement)indexer, propertyName);
        QualifiedItemProcessor<ResolveResultSink> processor = JSDialectSpecificHandlersFactory.forElement((PsiElement)indexer).createQualifiedItemProcessor(sink, (PsiElement)indexer);
        processor.setTypeContext(true);
        JSTypeEvaluator.evaluateTypes(indexer.getQualifier(), indexer.getContainingFile(), processor, JSEvaluateContext.JSEvaluationPlace.REFERENCE_EXPRESSION);
        ResolveResultSink resultSink = (ResolveResultSink)processor.getResultSink();
        if (processor.resolved.isSuitableForReferenceResolve() || resultSink.getCompleteResult() != null) {
            ResolveResult[] results = processor.getResultsAsResolveResults();
            JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.QUALIFIED, (Object)results.length);
            return results;
        }
        return null;
    }

    @Nullable
    private static ResolveResult[] getResolveResultsFromTypeScriptKeyTypes(PsiElement referenceElement) {
        if (!(referenceElement instanceof JSLiteralExpression) || !DialectDetector.isTypeScript(referenceElement)) {
            return null;
        }
        JSType expressionType = JSResolveUtil.getExpressionJSType((JSExpression)referenceElement);
        if (expressionType instanceof JSLiteralKeyType) {
            return ((JSLiteralKeyType)expressionType).resolveKey();
        }
        return null;
    }

    @Override
    public void processLocalVariants(SinkResolveProcessor<?> processor) {
        this.doProcessLocalVariants(processor, (Condition<? super PsiElement>)((Condition)element -> {
            JSNamedElement namedElement = element instanceof JSNamedElement ? (JSNamedElement)element : null;
            return namedElement != null && JSPsiImplUtils.getNameScope(namedElement) == null;
        }));
    }

    protected final void doProcessLocalVariants(final SinkResolveProcessor<?> processor, final Condition<? super PsiElement> filter) {
        PsiFile file2 = this.getElement().getContainingFile();
        PsiElement fileContext = file2.getContext();
        if (fileContext == null && !this.isPrimary()) {
            return;
        }
        String name = processor.getName();
        JSResolveUtil.treeWalkUp(new ResolveProcessor(name){
            {
                super(name);
                this.setProcessingOptions(new JSResolveUtil.StructureResolveProcessor.StructureProcessingOptions());
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (filter.value((Object)element)) {
                    return processor.execute(element, state);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/impl/JSTextReference$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this.mySet.element, this.mySet.element, this.mySet.element);
        if (fileContext != null) {
            JSResolveUtil.treeWalkUp(processor, (PsiElement)file2, (PsiElement)file2, this.mySet.element);
        }
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String text = this.getCanonicalText();
        text = "'" + text.replace("'", "''") + "'";
        String string = JSBundle.message((String)(this.mySet.element.getParent() instanceof TypeScriptImportStatement ? "javascript.unresolved.file" : "javascript.unresolved.variable.or.type.name.message2"), (Object[])new Object[]{text});
        if (string == null) {
            JSTextReference.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSTextReference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSTextReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "qNameFromNames";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolve";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultResolve";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "useActionScriptIndex";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "defaultResolve";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

