/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandler;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.editorActions.TypedHandlerUtil;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.editing.JavaScriptTypedHandler;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JSBackspaceHandler
extends BackspaceHandlerDelegate {
    private int myOffsetMatchingBrace;
    private boolean myToDeleteGt;

    public void beforeCharDeleted(char c, @NotNull PsiFile file2, @NotNull Editor editor) {
        DialectOptionHolder holder;
        if (file2 == null) {
            JSBackspaceHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JSBackspaceHandler.$$$reportNull$$$0(1);
        }
        this.myOffsetMatchingBrace = -1;
        if ((c == '(' || c == '[' || c == '{') && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            int offset = editor.getCaretModel().getOffset() - 1;
            this.myOffsetMatchingBrace = JSBackspaceHandler.findMatch(c, file2, editor, offset);
        }
        this.myToDeleteGt = c == '<' && file2 instanceof JSFile && (holder = DialectDetector.dialectOfElement((PsiElement)file2)) != null && holder.hasFeature(JSLanguageFeature.GENERICS) && TypedHandlerUtil.isAfterClassLikeIdentifierOrDot((int)(editor.getCaretModel().getOffset() - 1), (Editor)editor, (IElementType)JSTokenTypes.DOT, (IElementType)JSTokenTypes.IDENTIFIER, (boolean)false);
    }

    private static int findMatch(char c, @NotNull PsiFile file2, @NotNull Editor editor, int offset) {
        if (file2 == null) {
            JSBackspaceHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            JSBackspaceHandler.$$$reportNull$$$0(3);
        }
        if (offset == editor.getDocument().getTextLength() - 1) {
            return -1;
        }
        if (!file2.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE)) {
            return -1;
        }
        JSElement element = (JSElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)offset, JSElement.class, (boolean)false);
        if (element == null) {
            return -1;
        }
        PsiElement wrapper = JSBackspaceHandler.getTopLevelParent((PsiElement)element);
        if (wrapper instanceof JSEmbeddedContent) {
            return -1;
        }
        TextRange tr = file2.getTextRange();
        if (wrapper != null) {
            tr = wrapper.getTextRange();
        }
        String chars = editor.getDocument().getText();
        return JSBackspaceHandler.countBraces(c, BackspaceHandler.getRightChar((char)c), chars, tr, offset);
    }

    private static int countBraces(char left, char right, String text, TextRange tr, int offset) {
        int balance = 0;
        boolean stuffInTheMiddle = false;
        int rightBrace = -1;
        int start = tr.getStartOffset();
        int end = Math.min(text.length(), tr.getEndOffset());
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (left == c) {
                ++balance;
                continue;
            }
            if (right == c) {
                if (balance > 0) {
                    --balance;
                }
                if (i <= offset || stuffInTheMiddle || rightBrace != -1) continue;
                rightBrace = i;
                continue;
            }
            if (i <= offset || stuffInTheMiddle || rightBrace != -1 || c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f') continue;
            stuffInTheMiddle = true;
        }
        return balance == 0 ? rightBrace : -1;
    }

    private static PsiElement getTopLevelParent(@NotNull PsiElement element) {
        if (element == null) {
            JSBackspaceHandler.$$$reportNull$$$0(4);
        }
        for (PsiElement current = element; current != null && !(current instanceof PsiFile); current = current.getParent()) {
            if (JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS.contains(current.getNode().getElementType())) {
                return current;
            }
            if (!(current instanceof JSFunction)) continue;
            if (current.getParent() == null) {
                return current;
            }
            PsiElement next = JSBackspaceHandler.getTopLevelParent(current.getParent());
            if (next == null) {
                return current;
            }
            return next;
        }
        return null;
    }

    public boolean charDeleted(char c, @NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            JSBackspaceHandler.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            JSBackspaceHandler.$$$reportNull$$$0(6);
        }
        if (this.myOffsetMatchingBrace >= 0) {
            editor.getDocument().deleteString(this.myOffsetMatchingBrace - 1, this.myOffsetMatchingBrace);
            return true;
        }
        if (c == '<' && this.myToDeleteGt) {
            int offset = editor.getCaretModel().getOffset();
            CharSequence chars = editor.getDocument().getCharsSequence();
            if (editor.getDocument().getTextLength() <= offset) {
                return false;
            }
            char c1 = chars.charAt(offset);
            if (c1 != '>') {
                return true;
            }
            TypedHandlerUtil.handleGenericLTDeletion((Editor)editor, (int)offset, (IElementType)JSTokenTypes.LT, (IElementType)JSTokenTypes.GT, (TokenSet)JavaScriptTypedHandler.INVALID_INSIDE_REFERENCE);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSBackspaceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCharDeleted";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findMatch";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getTopLevelParent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "charDeleted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

