/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.protractor;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.protractor.ProtractorRunSettings;
import com.intellij.javascript.protractor.scope.ProtractorScopeKind;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtractorUtil {
    public static final String PACKAGE_NAME = "protractor";
    private static final String[] SUFFIXES_WITHOUT_FIRST_CHAR = new String[]{"onf.js", "onfig.js"};
    private static final String TAG__CONFIG_FILE = "config-file";
    private static final String TAG__NODE_INTERPRETER = "node-interpreter";
    private static final String TAG__PROTRACTOR_PACKAGE = "protractor-package";
    private static final String TAG__PROTRACTOR_OPTIONS = "protractor-options";
    private static final String TAG__SCOPE_KIND = "scope-kind";
    private static final String TAG__TEST_FILE = "test-file";
    private static final String TAG__TEST_NAMES = "test-names";
    private static final String TAG__TEST_NAME = "test-name";
    private static final String KEY__PROTRACTOR_PACKAGE_DIR = "nodejs.protractor.protractor_package";

    private ProtractorUtil() {
    }

    @NotNull
    public static List<VirtualFile> listPossibleConfigFilesInProject(@NotNull Project project) {
        if (project == null) {
            ProtractorUtil.$$$reportNull$$$0(0);
        }
        GlobalSearchScope contentScope = ProjectScope.getContentScope((Project)project);
        GlobalSearchScope scope = contentScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)ProjectScope.getLibrariesScope((Project)project)));
        ArrayList result2 = ContainerUtil.newArrayList();
        Collection files = FileTypeIndex.getFiles((FileType)JavaScriptFileType.INSTANCE, (GlobalSearchScope)scope);
        for (VirtualFile file2 : files) {
            if (file2 == null || !file2.isValid() || file2.isDirectory() || !ProtractorUtil.mightBeProtractorConfigFile(file2.getNameSequence()) || JSLibraryUtil.isProbableLibraryFile(file2)) continue;
            result2.add(file2);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ProtractorUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static List<VirtualFile> listExactConfigFilesInProject(@NotNull Project project) {
        if (project == null) {
            ProtractorUtil.$$$reportNull$$$0(2);
        }
        GlobalSearchScope contentScope = ProjectScope.getContentScope((Project)project);
        GlobalSearchScope scope = contentScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)ProjectScope.getLibrariesScope((Project)project)));
        ArrayList result2 = ContainerUtil.newArrayList();
        Collection files = FilenameIndex.getVirtualFilesByName((Project)project, (String)"protractor.conf.js", (GlobalSearchScope)scope);
        for (VirtualFile file2 : files) {
            if (file2 == null || !file2.isValid() || file2.isDirectory() || JSLibraryUtil.isProbableLibraryFile(file2)) continue;
            result2.add(file2);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ProtractorUtil.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static boolean mightBeProtractorConfigFile(@NotNull CharSequence fileName) {
        int delimInd;
        int suffixStartInd;
        if (fileName == null) {
            ProtractorUtil.$$$reportNull$$$0(4);
        }
        if ((suffixStartInd = ProtractorUtil.findSuffixStartInd(fileName)) == -1) {
            return false;
        }
        if (Character.isLowerCase(fileName.charAt(suffixStartInd)) && (delimInd = suffixStartInd - 1) >= 0 && !StringUtil.containsChar((String)".-_", (char)fileName.charAt(delimInd))) {
            return false;
        }
        return !StringUtil.contains((CharSequence)fileName, (CharSequence)"karma");
    }

    private static int findSuffixStartInd(@NotNull CharSequence fileName) {
        if (fileName == null) {
            ProtractorUtil.$$$reportNull$$$0(5);
        }
        for (String suffix : SUFFIXES_WITHOUT_FIRST_CHAR) {
            int ind = fileName.length() - suffix.length() - 1;
            if (ind < 0 || !StringUtil.charsEqualIgnoreCase((char)fileName.charAt(ind), (char)'c') || !StringUtil.endsWith((CharSequence)fileName, (CharSequence)suffix)) continue;
            return ind;
        }
        return -1;
    }

    public static boolean isProtractorConfigFile(@NotNull CharSequence fileName) {
        if (fileName == null) {
            ProtractorUtil.$$$reportNull$$$0(6);
        }
        return StringUtil.startsWith((CharSequence)fileName, (CharSequence)PACKAGE_NAME) && StringUtil.endsWith((CharSequence)fileName, (CharSequence)"conf.js");
    }

    @NotNull
    public static ProtractorRunSettings readXml(Element element) {
        ProtractorRunSettings.Builder builder = ProtractorRunSettings.builder();
        builder.setConfigFilePath(ProtractorUtil.readValueNotNull(element, TAG__CONFIG_FILE));
        String interpreterRefName = JDOMExternalizerUtil.readCustomField((Element)element, (String)TAG__NODE_INTERPRETER);
        builder.setInterpreterRef(NodeJsInterpreterRef.create(interpreterRefName));
        String pkg = JDOMExternalizerUtil.readCustomField((Element)element, (String)TAG__PROTRACTOR_PACKAGE);
        if (pkg != null) {
            builder.setPackage(new NodePackage(ProtractorUtil.readValueNotNull(element, TAG__PROTRACTOR_PACKAGE)));
        }
        builder.setProtractorOptions(ProtractorUtil.readValueNotNull(element, TAG__PROTRACTOR_OPTIONS));
        builder.setEnvData(EnvironmentVariablesData.readExternal((Element)element));
        ProtractorScopeKind scopeKind = ProtractorUtil.readScopeKind(element);
        builder.setScopeKind(scopeKind);
        if (scopeKind == ProtractorScopeKind.TEST_FILE || scopeKind == ProtractorScopeKind.SUITE || scopeKind == ProtractorScopeKind.TEST) {
            builder.setTestFilePath(ProtractorUtil.readValueNotNull(element, TAG__TEST_FILE));
        }
        if (scopeKind == ProtractorScopeKind.SUITE || scopeKind == ProtractorScopeKind.TEST) {
            builder.setTestNames(ProtractorUtil.readTestNames(element));
        }
        ProtractorRunSettings protractorRunSettings = builder.build();
        if (protractorRunSettings == null) {
            ProtractorUtil.$$$reportNull$$$0(7);
        }
        return protractorRunSettings;
    }

    @NotNull
    private static List<String> readTestNames(@NotNull Element parent) {
        Element testNamesElement;
        if (parent == null) {
            ProtractorUtil.$$$reportNull$$$0(8);
        }
        if ((testNamesElement = parent.getChild(TAG__TEST_NAMES)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                ProtractorUtil.$$$reportNull$$$0(9);
            }
            return list;
        }
        List list = JDOMExternalizerUtil.getChildrenValueAttributes((Element)testNamesElement, (String)TAG__TEST_NAME);
        if (list == null) {
            ProtractorUtil.$$$reportNull$$$0(10);
        }
        return list;
    }

    public static void writeXml(@NotNull Element element, @NotNull ProtractorRunSettings settings) {
        if (element == null) {
            ProtractorUtil.$$$reportNull$$$0(11);
        }
        if (settings == null) {
            ProtractorUtil.$$$reportNull$$$0(12);
        }
        JDOMExternalizerUtil.writeCustomField((Element)element, (String)TAG__CONFIG_FILE, (String)FileUtil.toSystemIndependentName((String)settings.getConfigFileSystemDependentPath()));
        JDOMExternalizerUtil.writeCustomField((Element)element, (String)TAG__NODE_INTERPRETER, (String)settings.getInterpreterRef().getReferenceName());
        if (settings.getPackage() != null) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)TAG__PROTRACTOR_PACKAGE, (String)settings.getPackage().getSystemIndependentPath());
        }
        ProtractorUtil.writeValue(element, TAG__PROTRACTOR_OPTIONS, settings.getProtractorOptions());
        settings.getEnvData().writeExternal(element);
        ProtractorScopeKind scopeKind = settings.getScopeKind();
        ProtractorUtil.writeValue(element, TAG__SCOPE_KIND, scopeKind.name());
        if (scopeKind == ProtractorScopeKind.TEST_FILE || scopeKind == ProtractorScopeKind.SUITE || scopeKind == ProtractorScopeKind.TEST) {
            ProtractorUtil.writeValue(element, TAG__TEST_FILE, FileUtil.toSystemIndependentName((String)settings.getTestFileSystemDependentPath()));
        }
        if (scopeKind == ProtractorScopeKind.SUITE || scopeKind == ProtractorScopeKind.TEST) {
            Element testNamesElement = new Element(TAG__TEST_NAMES);
            if (!settings.getTestNames().isEmpty()) {
                JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)testNamesElement, (String)TAG__TEST_NAME, settings.getTestNames());
            }
            element.addContent(testNamesElement);
        }
    }

    private static void writeValue(@NotNull Element element, @NotNull String tagName, @Nullable String value) {
        if (element == null) {
            ProtractorUtil.$$$reportNull$$$0(13);
        }
        if (tagName == null) {
            ProtractorUtil.$$$reportNull$$$0(14);
        }
        if (value != null) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)tagName, (String)value);
        }
    }

    @NotNull
    private static String readValueNotNull(@NotNull Element element, @NotNull String key) {
        if (element == null) {
            ProtractorUtil.$$$reportNull$$$0(15);
        }
        if (key == null) {
            ProtractorUtil.$$$reportNull$$$0(16);
        }
        String string = StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)element, (String)key));
        if (string == null) {
            ProtractorUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static ProtractorScopeKind readScopeKind(@NotNull Element element) {
        ProtractorScopeKind protractorScopeKind;
        if (element == null) {
            ProtractorUtil.$$$reportNull$$$0(18);
        }
        String scopeKindStr = ProtractorUtil.readValueNotNull(element, TAG__SCOPE_KIND);
        try {
            protractorScopeKind = ProtractorScopeKind.valueOf(scopeKindStr);
        }
        catch (Exception ignored) {
            ProtractorScopeKind protractorScopeKind2 = ProtractorScopeKind.ALL;
            if (protractorScopeKind2 == null) {
                ProtractorUtil.$$$reportNull$$$0(20);
            }
            return protractorScopeKind2;
        }
        if (protractorScopeKind == null) {
            ProtractorUtil.$$$reportNull$$$0(19);
        }
        return protractorScopeKind;
    }

    public static void setProtractorPackage(@NotNull Project project, @NotNull NodePackage protractorPackage) {
        if (project == null) {
            ProtractorUtil.$$$reportNull$$$0(21);
        }
        if (protractorPackage == null) {
            ProtractorUtil.$$$reportNull$$$0(22);
        }
        ProtractorUtil.setProtractorPackagePath(project, protractorPackage.getSystemIndependentPath());
    }

    @NotNull
    public static NodePackage getProtractorPackage(@NotNull Project project) {
        if (project == null) {
            ProtractorUtil.$$$reportNull$$$0(23);
        }
        String packagePath = ProtractorUtil.getProtractorPackagePath(project);
        NodePackage nodePackage = new NodePackage(StringUtil.notNullize((String)packagePath));
        if (nodePackage == null) {
            ProtractorUtil.$$$reportNull$$$0(24);
        }
        return nodePackage;
    }

    @Deprecated
    @NotNull
    public static NodePackage getProtractorPackage(@NotNull Project project, @Nullable VirtualFile requester, @Nullable NodeJsInterpreter interpreter, boolean detectIfEmpty) {
        if (project == null) {
            ProtractorUtil.$$$reportNull$$$0(25);
        }
        NodePackage nodePackage = ProtractorUtil.getProtractorPackage(project);
        if (nodePackage == null) {
            ProtractorUtil.$$$reportNull$$$0(26);
        }
        return nodePackage;
    }

    private static void setProtractorPackagePath(@NotNull Project project, @NotNull String value) {
        if (project == null) {
            ProtractorUtil.$$$reportNull$$$0(27);
        }
        if (value == null) {
            ProtractorUtil.$$$reportNull$$$0(28);
        }
        PropertiesComponent.getInstance((Project)project).setValue(KEY__PROTRACTOR_PACKAGE_DIR, value);
    }

    @Nullable
    private static String getProtractorPackagePath(@NotNull Project project) {
        if (project == null) {
            ProtractorUtil.$$$reportNull$$$0(29);
        }
        return PropertiesComponent.getInstance((Project)project).getValue(KEY__PROTRACTOR_PACKAGE_DIR);
    }

    @NotNull
    public static File getProtractorMainJsFile(@NotNull NodePackage protractorPackage) {
        if (protractorPackage == null) {
            ProtractorUtil.$$$reportNull$$$0(30);
        }
        File file2 = new File(protractorPackage.getSystemDependentPath(), "bin/protractor");
        if (file2 == null) {
            ProtractorUtil.$$$reportNull$$$0(31);
        }
        return file2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 17: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 17: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 17: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/protractor/ProtractorUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protractorPackage";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/protractor/ProtractorUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleConfigFilesInProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "listExactConfigFilesInProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readXml";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "readTestNames";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "readValueNotNull";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "readScopeKind";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtractorPackage";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtractorMainJsFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleConfigFilesInProject";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 17: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 31: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "listExactConfigFilesInProject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mightBeProtractorConfigFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findSuffixStartInd";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isProtractorConfigFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readTestNames";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeXml";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeValue";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readValueNotNull";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "readScopeKind";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setProtractorPackage";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getProtractorPackage";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setProtractorPackagePath";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getProtractorPackagePath";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getProtractorMainJsFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 17: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

