/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.objectTree.ObjectTree;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Disposer {
    private static final ObjectTree<Disposable> ourTree;
    private static final ObjectTreeAction<Disposable> ourDisposeAction;
    private static final String debugDisposer;
    private static boolean ourDebugMode;
    private static final Map<String, Disposable> ourKeyDisposables;

    public static boolean isDebugDisposerOn() {
        return "on".equals(debugDisposer);
    }

    private Disposer() {
    }

    @NotNull
    public static Disposable newDisposable() {
        Disposable disposable = Disposer.newDisposable(null);
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(0);
        }
        return disposable;
    }

    @NotNull
    public static Disposable newDisposable(final @Nullable String debugName) {
        Disposable disposable = new Disposable(){

            @Override
            public void dispose() {
            }

            public String toString() {
                return debugName == null ? super.toString() : debugName;
            }
        };
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(1);
        }
        return disposable;
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child) {
        if (parent == null) {
            Disposer.$$$reportNull$$$0(2);
        }
        if (child == null) {
            Disposer.$$$reportNull$$$0(3);
        }
        Disposer.register(parent, child, null);
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child, final @NonNls @Nullable String key) {
        if (parent == null) {
            Disposer.$$$reportNull$$$0(4);
        }
        if (child == null) {
            Disposer.$$$reportNull$$$0(5);
        }
        ourTree.register(parent, child);
        if (key != null) {
            Disposable v = Disposer.get(key);
            if (v != null) {
                throw new IllegalArgumentException("Key " + key + " already registered: " + v);
            }
            ourKeyDisposables.put(key, child);
            Disposer.register(child, new Disposable(){

                @Override
                public void dispose() {
                    ourKeyDisposables.remove(key);
                }
            });
        }
    }

    public static boolean isDisposed(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(6);
        }
        return ourTree.getDisposalInfo(disposable) != null;
    }

    public static boolean isDisposing(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(7);
        }
        return ourTree.isDisposing(disposable);
    }

    public static Disposable get(@NotNull String key) {
        if (key == null) {
            Disposer.$$$reportNull$$$0(8);
        }
        return ourKeyDisposables.get(key);
    }

    public static void dispose(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(9);
        }
        Disposer.dispose(disposable, true);
    }

    public static void dispose(@NotNull Disposable disposable, boolean processUnregistered) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(10);
        }
        ourTree.executeAll(disposable, ourDisposeAction, processUnregistered);
    }

    @NotNull
    public static ObjectTree<Disposable> getTree() {
        ObjectTree<Disposable> objectTree = ourTree;
        if (objectTree == null) {
            Disposer.$$$reportNull$$$0(11);
        }
        return objectTree;
    }

    public static void assertIsEmpty() {
        Disposer.assertIsEmpty(false);
    }

    public static void assertIsEmpty(boolean throwError) {
        if (ourDebugMode) {
            ourTree.assertIsEmpty(throwError);
        }
    }

    public static boolean isEmpty() {
        return ourDebugMode && ourTree.isEmpty();
    }

    public static boolean setDebugMode(boolean debugMode) {
        if (debugMode) {
            debugMode = !"off".equals(debugDisposer);
        }
        boolean oldValue = ourDebugMode;
        ourDebugMode = debugMode;
        return oldValue;
    }

    public static boolean isDebugMode() {
        return ourDebugMode;
    }

    public static void clearOwnFields(@Nullable Object object, @NotNull Condition<? super Field> selectCondition) {
        if (selectCondition == null) {
            Disposer.$$$reportNull$$$0(12);
        }
        if (object == null) {
            return;
        }
        for (Field each : ReflectionUtil.collectFields(object.getClass())) {
            if ((each.getModifiers() & 0x18) > 0 || !selectCondition.value(each)) continue;
            try {
                ReflectionUtil.resetField(object, each);
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    public static <T extends Disposable> T findRegisteredObject(@NotNull Disposable parentDisposable, @NotNull T object) {
        if (parentDisposable == null) {
            Disposer.$$$reportNull$$$0(13);
        }
        if (object == null) {
            Disposer.$$$reportNull$$$0(14);
        }
        return ourTree.findRegisteredObject(parentDisposable, object);
    }

    static {
        try {
            ourTree = new ObjectTree();
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("loader=" + Disposer.class.getClassLoader(), e);
        }
        ourDisposeAction = new ObjectTreeAction<Disposable>(){

            @Override
            public void execute(@NotNull Disposable each) {
                if (each == null) {
                    1.$$$reportNull$$$0(0);
                }
                each.dispose();
            }

            @Override
            public void beforeTreeExecution(@NotNull Disposable parent) {
                if (parent == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (parent instanceof Disposable.Parent) {
                    ((Disposable.Parent)parent).beforeTreeDispose();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "each";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/util/Disposer$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeTreeExecution";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        debugDisposer = System.getProperty("idea.disposer.debug");
        ourKeyDisposables = ContainerUtil.createConcurrentWeakMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/Disposer";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectCondition";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "newDisposable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/Disposer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDisposed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDisposing";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "clearOwnFields";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredObject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

