/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.codeStyle;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;

public class DrupalJSPredefinedCodeStyle
extends PredefinedCodeStyle {
    public DrupalJSPredefinedCodeStyle() {
        super("Drupal JavaScript Style", (Language)JavascriptLanguage.INSTANCE);
    }

    public void apply(CodeStyleSettings settings) {
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings(this.getLanguage());
        JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.class);
        commonSettings.RIGHT_MARGIN = 80;
        commonSettings.ELSE_ON_NEW_LINE = true;
        commonSettings.CATCH_ON_NEW_LINE = true;
        commonSettings.FINALLY_ON_NEW_LINE = true;
        commonSettings.IF_BRACE_FORCE = 3;
        commonSettings.WHILE_BRACE_FORCE = 3;
        commonSettings.DOWHILE_BRACE_FORCE = 3;
        commonSettings.FOR_BRACE_FORCE = 3;
        commonSettings.WRAP_COMMENTS = true;
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions((FileType)JavaScriptFileType.INSTANCE);
        indentOptions.INDENT_SIZE = 2;
        indentOptions.TAB_SIZE = 2;
        indentOptions.USE_TAB_CHARACTER = false;
    }
}

