/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.actions.SimpleCodeInsightAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.codeInsight.template.macro.CompleteSmartMacro;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.xml.XmlContentDFA;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateXmlTagAction
extends SimpleCodeInsightAction {
    public static final ThreadLocal<String> TEST_THREAD_LOCAL = new ThreadLocal();
    private static final Logger LOG = Logger.getInstance(GenerateXmlTagAction.class);

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(2);
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return;
        }
        try {
            XmlTag contextTag = GenerateXmlTagAction.getContextTag(editor, file2);
            if (contextTag == null) {
                throw new CommonRefactoringUtil.RefactoringErrorHintException("Caret should be positioned inside a tag");
            }
            XmlElementDescriptor currentTagDescriptor = contextTag.getDescriptor();
            assert (currentTagDescriptor != null);
            Object[] descriptors = currentTagDescriptor.getElementsDescriptors(contextTag);
            Arrays.sort(descriptors, Comparator.comparing(PsiMetaData::getName));
            Consumer consumer = selected -> {
                if (project == null) {
                    GenerateXmlTagAction.$$$reportNull$$$0(12);
                }
                if (file2 == null) {
                    GenerateXmlTagAction.$$$reportNull$$$0(13);
                }
                if (editor == null) {
                    GenerateXmlTagAction.$$$reportNull$$$0(14);
                }
                WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file2}).withName("Generate XML Tag").run(() -> {
                    if (editor == null) {
                        GenerateXmlTagAction.$$$reportNull$$$0(15);
                    }
                    if (project == null) {
                        GenerateXmlTagAction.$$$reportNull$$$0(16);
                    }
                    if (file2 == null) {
                        GenerateXmlTagAction.$$$reportNull$$$0(17);
                    }
                    if (selected == null) {
                        return;
                    }
                    XmlTag newTag = GenerateXmlTagAction.createTag(contextTag, selected);
                    XmlTag anchor2 = GenerateXmlTagAction.getAnchor(contextTag, editor, selected);
                    if (anchor2 == null) {
                        int offset = editor.getCaretModel().getOffset();
                        Document document = editor.getDocument();
                        document.insertString(offset, (CharSequence)newTag.getText());
                        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                        newTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(offset + 1), XmlTag.class, (boolean)false);
                    } else {
                        newTag = (XmlTag)contextTag.addAfter((PsiElement)newTag, (PsiElement)anchor2);
                    }
                    if (newTag != null) {
                        GenerateXmlTagAction.generateTag(newTag, editor);
                    }
                });
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                XmlElementDescriptor descriptor = (XmlElementDescriptor)ContainerUtil.find((Object[])descriptors, xmlElementDescriptor -> xmlElementDescriptor.getName().equals(TEST_THREAD_LOCAL.get()));
                consumer.consume((Object)descriptor);
            } else {
                JBPopupFactory.getInstance().createPopupChooserBuilder((List)ContainerUtil.newArrayList((Object[])descriptors)).setRenderer((ListCellRenderer)new MyListCellRenderer()).setTitle("Choose Tag Name").setItemChosenCallback(consumer).setNamerForFiltering(o -> o.getName()).createPopup().showInBestPositionFor(editor);
            }
        }
        catch (CommonRefactoringUtil.RefactoringErrorHintException e) {
            HintManager.getInstance().showErrorHint(editor, e.getMessage());
        }
    }

    @Nullable
    private static XmlTag getAnchor(@NotNull XmlTag contextTag, Editor editor, XmlElementDescriptor selected) {
        if (contextTag == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(3);
        }
        XmlContentDFA contentDFA = XmlContentDFA.getContentDFA(contextTag);
        int offset = editor.getCaretModel().getOffset();
        if (contentDFA == null) {
            return null;
        }
        XmlTag anchor2 = null;
        boolean previousPositionIsPossible = true;
        for (XmlTag subTag : contextTag.getSubTags()) {
            if (contentDFA.getPossibleElements().contains(selected)) {
                if (subTag.getTextOffset() > offset) break;
                anchor2 = subTag;
                previousPositionIsPossible = true;
            } else {
                previousPositionIsPossible = false;
            }
            contentDFA.transition(subTag);
        }
        return previousPositionIsPossible ? null : anchor2;
    }

    public static void generateTag(@NotNull XmlTag newTag, Editor editor) {
        if (newTag == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(4);
        }
        GenerateXmlTagAction.generateRaw(newTag);
        XmlTag restored = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(newTag);
        if (restored == null) {
            LOG.error("Could not restore tag: " + newTag.getText());
        }
        TemplateBuilder builder2 = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)restored);
        GenerateXmlTagAction.replaceElements(restored, builder2);
        builder2.run(editor, false);
    }

    private static void generateRaw(@NotNull XmlTag newTag) {
        XmlElementDescriptor selected;
        if (newTag == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(5);
        }
        if ((selected = newTag.getDescriptor()) == null) {
            return;
        }
        switch (selected.getContentType()) {
            case 0: {
                newTag.collapseIfEmpty();
                ASTNode node = newTag.getNode();
                assert (node != null);
                ASTNode elementEnd = node.findChildByType(XmlTokenType.XML_EMPTY_ELEMENT_END);
                if (elementEnd != null) break;
                LeafElement emptyTagEnd = Factory.createSingleLeafElement(XmlTokenType.XML_EMPTY_ELEMENT_END, "/>", 0, 2, null, newTag.getManager());
                node.addChild((ASTNode)emptyTagEnd);
                break;
            }
            case 3: {
                newTag.getValue().setText("");
            }
        }
        for (ASTNode descriptor : selected.getAttributesDescriptors(newTag)) {
            if (!descriptor.isRequired()) continue;
            newTag.setAttribute(descriptor.getName(), "");
        }
        List<XmlElementDescriptor> tags = GenerateXmlTagAction.getRequiredSubTags(selected);
        for (XmlElementDescriptor descriptor : tags) {
            if (descriptor == null) {
                XmlTag tag = XmlElementFactory.getInstance((Project)newTag.getProject()).createTagFromText((CharSequence)"<", newTag.getLanguage());
                newTag.addSubTag(tag, false);
                continue;
            }
            XmlTag subTag = newTag.addSubTag(GenerateXmlTagAction.createTag(newTag, descriptor), false);
            GenerateXmlTagAction.generateRaw(subTag);
        }
    }

    public static List<XmlElementDescriptor> getRequiredSubTags(XmlElementDescriptor selected) {
        XmlElementsGroup topGroup = selected.getTopGroup();
        if (topGroup == null) {
            return Collections.emptyList();
        }
        return GenerateXmlTagAction.computeRequiredSubTags(topGroup);
    }

    private static void replaceElements(XmlTag tag, TemplateBuilder builder2) {
        int i;
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            XmlAttributeValue value = xmlAttribute.getValueElement();
            if (value == null) continue;
            builder2.replaceElement((PsiElement)value, TextRange.from((int)1, (int)0), (Expression)new MacroCallNode(new CompleteMacro()));
        }
        if ("<".equals(tag.getText())) {
            builder2.replaceElement((PsiElement)tag, TextRange.from((int)1, (int)0), (Expression)new MacroCallNode(new CompleteSmartMacro()));
        } else if (tag.getSubTags().length == 0 && (i = tag.getText().indexOf("></")) > 0) {
            builder2.replaceElement((PsiElement)tag, TextRange.from((int)(i + 1), (int)0), (Expression)new MacroCallNode(new CompleteMacro()));
        }
        for (XmlAttribute xmlAttribute : tag.getSubTags()) {
            GenerateXmlTagAction.replaceElements((XmlTag)xmlAttribute, builder2);
        }
    }

    private static XmlTag createTag(@NotNull XmlTag contextTag, @NotNull XmlElementDescriptor descriptor) {
        if (contextTag == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(6);
        }
        if (descriptor == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(7);
        }
        String namespace = GenerateXmlTagAction.getNamespace(descriptor);
        XmlTag tag = contextTag.createChildTag(descriptor.getName(), namespace, null, false);
        PsiElement lastChild = tag.getLastChild();
        assert (lastChild != null);
        lastChild.delete();
        return tag;
    }

    private static String getNamespace(XmlElementDescriptor descriptor) {
        return descriptor instanceof XmlElementDescriptorImpl ? ((XmlElementDescriptorImpl)descriptor).getNamespace() : "";
    }

    @Nullable
    private static XmlTag getContextTag(Editor editor, PsiFile file2) {
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        XmlTag tag = null;
        if (element != null) {
            tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        }
        if (tag == null) {
            tag = ((XmlFile)file2).getRootTag();
        }
        return tag;
    }

    private static List<XmlElementDescriptor> computeRequiredSubTags(XmlElementsGroup group) {
        if (group.getMinOccurs() < 1) {
            return Collections.emptyList();
        }
        switch (group.getGroupType()) {
            case LEAF: {
                XmlElementDescriptor descriptor = group.getLeafDescriptor();
                return descriptor == null ? Collections.emptyList() : Collections.singletonList(descriptor);
            }
            case CHOICE: {
                LinkedHashSet<XmlElementDescriptor> set = null;
                for (XmlElementsGroup subGroup : group.getSubGroups()) {
                    List<XmlElementDescriptor> descriptors = GenerateXmlTagAction.computeRequiredSubTags(subGroup);
                    if (set == null) {
                        set = new LinkedHashSet<XmlElementDescriptor>(descriptors);
                        continue;
                    }
                    set.retainAll(descriptors);
                }
                if (set == null || set.isEmpty()) {
                    return Collections.singletonList(null);
                }
                return new ArrayList<XmlElementDescriptor>(set);
            }
        }
        ArrayList<XmlElementDescriptor> list2 = new ArrayList<XmlElementDescriptor>();
        for (XmlElementsGroup subGroup : group.getSubGroups()) {
            list2.addAll(GenerateXmlTagAction.computeRequiredSubTags(subGroup));
        }
        return list2;
    }

    private static boolean isInsideTagBody(XmlTag contextTag, @NotNull Editor editor) {
        if (editor == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(8);
        }
        return contextTag.getValue().getTextRange().contains(editor.getCaretModel().getOffset());
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(11);
        }
        if (!(file2 instanceof XmlFile)) {
            return false;
        }
        XmlTag contextTag = GenerateXmlTagAction.getContextTag(editor, file2);
        return contextTag != null && GenerateXmlTagAction.isInsideTagBody(contextTag, editor) && contextTag.getDescriptor() != null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 11: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextTag";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTag";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/actions/GenerateXmlTagAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnchor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "generateTag";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "generateRaw";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createTag";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideTagBody";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidForFile";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$invoke$1";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyListCellRenderer
    implements ListCellRenderer {
        private final JPanel myPanel = new JPanel(new BorderLayout());
        private final JLabel myNameLabel;
        private final JLabel myNSLabel;

        MyListCellRenderer() {
            this.myPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            this.myNameLabel = new JLabel();
            this.myPanel.add((Component)this.myNameLabel, "West");
            this.myPanel.add(new JLabel("     "));
            this.myNSLabel = new JLabel();
            this.myPanel.add((Component)this.myNSLabel, "East");
            EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
            Font font = scheme2.getFont(EditorFontType.PLAIN);
            this.myNameLabel.setFont(font);
            this.myNSLabel.setFont(font);
        }

        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            XmlElementDescriptor descriptor = (XmlElementDescriptor)value;
            Color backgroundColor = isSelected ? list2.getSelectionBackground() : list2.getBackground();
            this.myNameLabel.setText(descriptor.getName());
            this.myNameLabel.setForeground(isSelected ? list2.getSelectionForeground() : list2.getForeground());
            this.myPanel.setBackground(backgroundColor);
            this.myNSLabel.setText(GenerateXmlTagAction.getNamespace(descriptor));
            this.myNSLabel.setForeground(LookupCellRenderer.getGrayedForeground(isSelected));
            this.myNSLabel.setBackground(backgroundColor);
            return this.myPanel;
        }
    }
}

