/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.Consumer;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;

class PopupTableAdapter<T>
implements PopupChooserBuilder.PopupComponentAdapter<T> {
    private PopupChooserBuilder myBuilder;
    private final JTable myTable;

    PopupTableAdapter(PopupChooserBuilder builder2, JTable table) {
        this.myBuilder = builder2;
        this.myTable = table;
    }

    public JComponent getComponent() {
        return this.myTable;
    }

    public void setItemChosenCallback(Consumer<? super T> callback2) {
        throw new UnsupportedOperationException("setItemChosenCallback with element callback is not implemented for tables yet");
    }

    public void setItemsChosenCallback(Consumer<? super Set<T>> callback2) {
        throw new UnsupportedOperationException("setItemsChosenCallback with element callback is not implemented for tables yet");
    }

    public JScrollPane createScrollPane() {
        if (this.myTable instanceof TreeTable) {
            TreeUtil.expandAll((JTree)((TreeTable)this.myTable).getTree());
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTable);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (this.myTable.getSelectedRow() == -1) {
            this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (this.myTable.getRowCount() >= 20) {
            scrollPane.getViewport().setPreferredSize(new Dimension(this.myTable.getPreferredScrollableViewportSize().width, 300));
        } else {
            scrollPane.getViewport().setPreferredSize(this.myTable.getPreferredSize());
        }
        if (this.myBuilder.isAutoselectOnMouseMove()) {
            this.myTable.addMouseMotionListener(new MouseMotionAdapter(){
                boolean myIsEngaged = false;

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (this.myIsEngaged) {
                        int index = PopupTableAdapter.this.myTable.rowAtPoint(e.getPoint());
                        PopupTableAdapter.this.myTable.getSelectionModel().setSelectionInterval(index, index);
                    } else {
                        this.myIsEngaged = true;
                    }
                }
            });
        }
        return scrollPane;
    }
}

