/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.run.remote.PhpInvalidSdkTypeException;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomRulesSetupDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(CustomRulesSetupDialog.class);
    protected JPanel myTopPanel;
    protected final boolean myIsRemote;
    private TextFieldWithBrowseButton myPathField;
    private final String myRulesetPath;
    private final boolean myAllowChooseDirectory;

    protected CustomRulesSetupDialog(@Nullable Project project, @Nullable PhpInterpreter interpreter, @NotNull Component parent, @NotNull String rulesetPath, boolean allowChooseDirectory) {
        if (parent == null) {
            CustomRulesSetupDialog.$$$reportNull$$$0(0);
        }
        if (rulesetPath == null) {
            CustomRulesSetupDialog.$$$reportNull$$$0(1);
        }
        super(parent, false);
        this.$$$setupUI$$$();
        this.init();
        this.myAllowChooseDirectory = allowChooseDirectory;
        this.myPathField.setTextFieldPreferredWidth(60);
        this.myIsRemote = interpreter != null && interpreter.isRemote();
        try {
            this.myPathField.getButton().setEnabled(true);
            this.myPathField.addActionListener(this.createBrowserAction(project, parent, this.myPathField, interpreter));
        }
        catch (PhpInvalidSdkTypeException e) {
            this.myPathField.getButton().setVisible(false);
        }
        this.myRulesetPath = rulesetPath;
        this.myPathField.setText(this.myRulesetPath);
        this.setTitle("Custom Coding Standard");
    }

    private ActionListener createBrowserAction(@Nullable Project project, @NotNull Component parent, @NotNull TextFieldWithBrowseButton pathField, @Nullable PhpInterpreter interpreter) throws PhpInvalidSdkTypeException {
        if (parent == null) {
            CustomRulesSetupDialog.$$$reportNull$$$0(2);
        }
        if (pathField == null) {
            CustomRulesSetupDialog.$$$reportNull$$$0(3);
        }
        if (interpreter != null && interpreter.isRemote()) {
            PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
            if (manager != null) {
                return manager.createRemoteBrowserAction(project, interpreter.getPhpSdkAdditionalData(), "Set Path", pathField.getTextField(), false);
            }
            LOG.warn("Remote interpreter can't be executed. Please enable the PHP Remote Interpreter plugin.");
        }
        return e -> {
            if (parent == null) {
                CustomRulesSetupDialog.$$$reportNull$$$0(4);
            }
            this.chooseFile(parent);
        };
    }

    private void chooseFile(Component parent) {
        FileChooserDescriptor fileChooserDescriptor;
        VirtualFile file;
        File physicalFile;
        VirtualFile currFile = null;
        if (this.myRulesetPath != null && !this.myRulesetPath.isEmpty() && (physicalFile = new File(this.myRulesetPath)).exists()) {
            currFile = VfsUtil.findFileByIoFile((File)physicalFile, (boolean)true);
        }
        if ((file = FileChooser.chooseFile((FileChooserDescriptor)(fileChooserDescriptor = new FileChooserDescriptor(true, this.myAllowChooseDirectory, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                return CustomRulesSetupDialog.this.containsRulesetXml(file) && super.isFileSelectable(file);
            }

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return file.isDirectory() || CustomRulesSetupDialog.this.containsRulesetXml(file);
            }
        }), (Component)parent, null, (VirtualFile)currFile)) != null) {
            this.myPathField.setText(file.getPath());
        }
    }

    public String getCustomRulesPath() {
        return this.myPathField.getText();
    }

    protected JComponent createCenterPanel() {
        return this.myTopPanel;
    }

    protected ValidationInfo doValidate() {
        return this.validatePath(this.myPathField.getText());
    }

    @Nullable
    protected abstract ValidationInfo validatePath(String var1);

    protected abstract boolean containsRulesetXml(@Nullable VirtualFile var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rulesetPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathField";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/tools/quality/CustomRulesSetupDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createBrowserAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createBrowserAction$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myTopPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Path to ruleset:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }
}

