/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler.model.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.lang.PhpCodeGenerationUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.profiler.ProfilerUtil;
import com.jetbrains.php.profiler.model.ProfilerFileLocator;
import com.jetbrains.php.profiler.model.impl.CallableImpl;
import com.jetbrains.php.profiler.model.impl.ProfilerSourcePositionData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCallable
extends CallableImpl {
    @NotNull
    private final String myMethodName;
    @NotNull
    private final String myClassName;
    @NotNull
    private final String myNamespace;

    public MethodCallable(@NotNull String methodName, @NotNull String className, @NotNull String[] namespace, @Nullable ProfilerSourcePositionData sourcePosition) {
        if (methodName == null) {
            MethodCallable.$$$reportNull$$$0(0);
        }
        if (className == null) {
            MethodCallable.$$$reportNull$$$0(1);
        }
        if (namespace == null) {
            MethodCallable.$$$reportNull$$$0(2);
        }
        super(sourcePosition);
        this.myMethodName = methodName;
        this.myClassName = className;
        this.myNamespace = INTERNER.intern(PhpCodeGenerationUtil.generateNamespaceNamePrefix(namespace));
    }

    @Override
    public void computePresentation(@NotNull SimpleColoredComponent coloredComponent) {
        if (coloredComponent == null) {
            MethodCallable.$$$reportNull$$$0(3);
        }
        coloredComponent.append(this.myNamespace, SimpleTextAttributes.GRAY_ATTRIBUTES);
        coloredComponent.append(this.myClassName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        coloredComponent.append("->", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        coloredComponent.append(this.myMethodName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        coloredComponent.setIcon(PhpIcons.METHOD);
    }

    @Override
    @NotNull
    public String getSearchKey() {
        String string = this.myMethodName;
        if (string == null) {
            MethodCallable.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public PsiElement findElement(@NotNull Project project, @NotNull ProfilerFileLocator locator) {
        ProfilerSourcePositionData sourcePosition;
        if (project == null) {
            MethodCallable.$$$reportNull$$$0(5);
        }
        if (locator == null) {
            MethodCallable.$$$reportNull$$$0(6);
        }
        if ((sourcePosition = this.getSourcePosition()) != null) {
            return ProfilerUtil.findCallableAtSourcePosition(project, Method.class, locator, sourcePosition);
        }
        return null;
    }

    public String toString() {
        return this.myClassName + "->" + this.myMethodName;
    }

    @Override
    public String getId() {
        return this.myNamespace + "->" + this.myClassName + this.myMethodName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coloredComponent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/profiler/model/impl/MethodCallable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/profiler/model/impl/MethodCallable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

