/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpQuickFixBase
implements LocalQuickFix {
    @Nullable
    public static Collection<PhpClass> resolveClasses(@NotNull MemberReference reference, boolean classesOnly) {
        PhpExpression classReference;
        if (reference == null) {
            PhpQuickFixBase.$$$reportNull$$$0(0);
        }
        if ((classReference = reference.getClassReference()) instanceof ParenthesizedExpression) {
            classReference = (PhpExpression)((ParenthesizedExpression)classReference).getArgument();
        }
        if (classReference instanceof NewExpression) {
            classReference = ((NewExpression)classReference).getClassReference();
        }
        if (classReference instanceof PhpReference || classReference instanceof ArrayAccessExpression) {
            PhpType phpType = classReference.getType().global(reference.getProject());
            if (phpType.isEmpty()) {
                return null;
            }
            Set types = phpType.getTypes();
            if (types.size() != 1) {
                return null;
            }
            String fqn = (String)types.iterator().next();
            if ("$this".equals(fqn) || "static".equals(fqn)) {
                PhpClass clazz = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)reference, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                if (clazz != null) {
                    return ContainerUtil.newArrayList((Object[])new PhpClass[]{clazz});
                }
            } else {
                Collection classes = PhpIndex.getInstance((Project)reference.getElement().getProject()).getClassesByFQN(fqn);
                if (!classesOnly) {
                    Collection interfaces = PhpIndex.getInstance((Project)reference.getElement().getProject()).getInterfacesByFQN(fqn);
                    if (classes.isEmpty()) {
                        return interfaces;
                    }
                    if (!interfaces.isEmpty()) {
                        ArrayList<PhpClass> allClasses = new ArrayList<PhpClass>();
                        allClasses.addAll(classes);
                        allClasses.addAll(interfaces);
                        return allClasses;
                    }
                }
                return classes;
            }
        }
        return null;
    }

    @Nullable
    public static PhpClass resolveClassWithErrorReporting(@NotNull Project project, @Nullable MemberReference reference, boolean classesOnly) {
        if (project == null) {
            PhpQuickFixBase.$$$reportNull$$$0(1);
        }
        if (reference == null) {
            PhpQuickFixBase.showErrorMessage(project, PhpBundle.message("quickfix.cannot.find.class.reference", new Object[0]), null);
        } else {
            Collection<PhpClass> classes = PhpQuickFixBase.resolveClasses(reference, classesOnly);
            if (classes == null || classes.isEmpty()) {
                PhpQuickFixBase.showErrorMessage(project, PhpBundle.message("quickfix.cannot.find.target.class", reference.getText()), (PsiElement)reference);
            } else if (classes.size() > 1) {
                String fqn = PhpLangUtil.toPresentableFQN(StringUtil.notNullize((String)classes.iterator().next().getFQN()));
                PhpQuickFixBase.showErrorMessage(project, PhpBundle.message("quickfix.multiple.target.class.resolve", fqn), (PsiElement)reference);
            } else {
                return classes.iterator().next();
            }
        }
        return null;
    }

    public static PhpClass resolveClass(@Nullable MemberReference reference, boolean classesOnly) {
        if (reference == null) {
            return null;
        }
        Collection<PhpClass> classes = PhpQuickFixBase.resolveClasses(reference, classesOnly);
        return classes == null || classes.size() != 1 ? null : classes.iterator().next();
    }

    protected static void reformat(PsiElement element) {
        int pos = element.getTextOffset();
        PsiFile file = element.getContainingFile();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)element.getProject());
        PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)element.getProject());
        Document doc = docManager.getDocument(element.getContainingFile());
        assert (doc != null);
        docManager.doPostponedOperationsAndUnblockDocument(doc);
        if (file == null) {
            file = element.getContainingFile();
        }
        PsiElement elementToReformat = file.findElementAt(pos);
        assert (elementToReformat != null);
        codeStyleManager.reformatNewlyAddedElement(elementToReformat.getParent().getNode(), elementToReformat.getNode());
    }

    protected static String validateClass(@NotNull Project project, @Nullable PhpClass clazz) {
        if (project == null) {
            PhpQuickFixBase.$$$reportNull$$$0(2);
        }
        if (clazz == null) {
            return "Can not find target class for modification.";
        }
        if (!clazz.isWritable()) {
            return "The target class " + clazz.getName() + " is not writable.";
        }
        if (!ModuleUtilCore.projectContainsFile((Project)project, (VirtualFile)clazz.getContainingFile().getVirtualFile(), (boolean)false)) {
            return "The target class " + clazz.getName() + " does not belong to the project\nand can not be modified.";
        }
        return null;
    }

    protected void showIsInDumpModeMessage(@NotNull Project project, @Nullable PsiElement element) {
        if (project == null) {
            PhpQuickFixBase.$$$reportNull$$$0(3);
        }
        String message = PhpBundle.message("quickfix.is.not.available.in.dump.mode", this.getName());
        Editor editor = element == null ? null : PsiUtilBase.findEditor((PsiElement)element);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project == null) {
                PhpQuickFixBase.$$$reportNull$$$0(8);
            }
            if (editor == null || editor.getComponent().getRootPane() == null) {
                Messages.showMessageDialog((Project)project, (String)message, (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon());
            } else {
                HintManager.getInstance().showErrorHint(editor, message);
            }
        });
    }

    public static void showErrorMessage(@NotNull Project project, @NotNull String message, @Nullable PsiElement element) {
        if (project == null) {
            PhpQuickFixBase.$$$reportNull$$$0(4);
        }
        if (message == null) {
            PhpQuickFixBase.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new PhpErrorHintException(message);
        }
        Editor editor = element == null ? null : PsiUtilBase.findEditor((PsiElement)element);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project == null) {
                PhpQuickFixBase.$$$reportNull$$$0(6);
            }
            if (message == null) {
                PhpQuickFixBase.$$$reportNull$$$0(7);
            }
            if (editor == null || editor.getComponent().getRootPane() == null) {
                Messages.showMessageDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            } else {
                HintManager.getInstance().showErrorHint(editor, message);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpQuickFixBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveClasses";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveClassWithErrorReporting";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "validateClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showIsInDumpModeMessage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorMessage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$showErrorMessage$1";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$showIsInDumpModeMessage$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PhpErrorHintException
    extends RuntimeException {
        public PhpErrorHintException(String message) {
            super(message);
        }
    }
}

