/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.TreeVisitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class PhpMappingSimpleResolveDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private SimpleTree myTree;
    private JTextField myFilePathOnServerTextField;
    private final AbstractTreeBuilder myTreeBuilder;
    private boolean myStopDebugger;
    private final String myRemoteFilePath;
    private MyFileNode myLastSelectedNode;

    public PhpMappingSimpleResolveDialog(@NotNull Project project, @NotNull String remoteFilePath, @NotNull Collection<VirtualFile> candidates) {
        if (project == null) {
            PhpMappingSimpleResolveDialog.$$$reportNull$$$0(0);
        }
        if (remoteFilePath == null) {
            PhpMappingSimpleResolveDialog.$$$reportNull$$$0(1);
        }
        if (candidates == null) {
            PhpMappingSimpleResolveDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myStopDebugger = false;
        this.$$$setupUI$$$();
        this.myTreeBuilder = new SimpleTreeBuilder((JTree)this.myTree, this.myTree.getBuilderModel(), (AbstractTreeStructure)new MySimpleTreeStructure(candidates), (Comparator)new WeightBasedComparator(true)){};
        this.myRemoteFilePath = remoteFilePath;
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myTreeBuilder);
        this.init();
    }

    protected void init() {
        super.init();
        this.setTitle(PhpBundle.message("PhpMappingSimpleResolveDialog.title", new Object[0]));
        this.myFilePathOnServerTextField.setText(this.myRemoteFilePath);
        this.myTree.setMinSizeInRows(10);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTreeBuilder.initRootNode();
        final Ref nodeRef = new Ref();
        final Ref maxWeight = new Ref((Object)Integer.MIN_VALUE);
        this.myTreeBuilder.accept(MyFileNode.class, (TreeVisitor)new TreeVisitor<MyFileNode>(){

            public boolean visit(@NotNull MyFileNode node) {
                int weight;
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((weight = node.getWeight()) > (Integer)maxWeight.get()) {
                    nodeRef.set((Object)node);
                    maxWeight.set((Object)weight);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/php/debug/ui/PhpMappingSimpleResolveDialog$2", "visit"));
            }
        });
        if (!nodeRef.isNull()) {
            this.myTreeBuilder.select(nodeRef.get());
        }
        PhpUiUtil.requestFocusIfAppInactive(this);
    }

    protected String getDimensionServiceKey() {
        return "PhpMappingSimpleResolveDialog";
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @NotNull
    public VirtualFile getSelectedFile() {
        assert (this.myLastSelectedNode != null);
        VirtualFile virtualFile = this.myLastSelectedNode.getFile();
        if (virtualFile == null) {
            PhpMappingSimpleResolveDialog.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        Action[] actionArray = new Action[]{new DialogWrapper.DialogWrapperAction(PhpBundle.message("debug.mapping.resolve.dialog.stop.debugger", new Object[0])){

            protected void doAction(ActionEvent e) {
                PhpMappingSimpleResolveDialog.this.myStopDebugger = true;
                PhpMappingSimpleResolveDialog.this.doCancelAction();
            }
        }};
        if (actionArray == null) {
            PhpMappingSimpleResolveDialog.$$$reportNull$$$0(4);
        }
        return actionArray;
    }

    public boolean isStopDebugger() {
        return this.myStopDebugger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/ui/PhpMappingSimpleResolveDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/ui/PhpMappingSimpleResolveDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftSideActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        SimpleTree simpleTree;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(300, 200), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myTree = simpleTree = new SimpleTree();
        simpleTree.setRootVisible(false);
        simpleTree.setShowsRootHandles(false);
        simpleTree.putClientProperty((Object)"JTree.lineStyle", (Object)"Angled");
        jBScrollPane.setViewportView((Component)simpleTree);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("File path on server:");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFilePathOnServerTextField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    public class MyFileNode
    extends SimpleNode {
        private final VirtualFile myFile;

        private MyFileNode(MyRootNode parent, VirtualFile file) {
            super((SimpleNode)parent);
            this.myFile = file;
        }

        @NotNull
        public SimpleNode[] getChildren() {
            if (NO_CHILDREN == null) {
                MyFileNode.$$$reportNull$$$0(0);
            }
            return NO_CHILDREN;
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                MyFileNode.$$$reportNull$$$0(1);
            }
            super.update(presentation);
            presentation.setIcon(icons.PhpIcons.Php_icon);
            presentation.setPresentableText(this.myFile.getPresentableUrl());
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public int getWeight() {
            return super.getWeight() + PhpPathMapper.intersectFromEnd(PhpMappingSimpleResolveDialog.this.myRemoteFilePath, this.myFile.getPath(), false).length;
        }

        public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
            PhpMappingSimpleResolveDialog.this.doOKAction();
        }

        public void handleSelection(SimpleTree tree) {
            PhpMappingSimpleResolveDialog.this.myLastSelectedNode = this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/ui/PhpMappingSimpleResolveDialog$MyFileNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/ui/PhpMappingSimpleResolveDialog$MyFileNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class MyRootNode
    extends SimpleNode {
        private final MyFileNode[] myChildren;

        private MyRootNode(Collection<VirtualFile> candidates) {
            if (candidates == null) {
                MyRootNode.$$$reportNull$$$0(0);
            }
            ArrayList<MyFileNode> children = new ArrayList<MyFileNode>();
            for (VirtualFile candidate : candidates) {
                children.add(new MyFileNode(this, candidate));
            }
            this.myChildren = children.toArray(new MyFileNode[0]);
        }

        @NotNull
        public SimpleNode[] getChildren() {
            if (this.myChildren == null) {
                MyRootNode.$$$reportNull$$$0(1);
            }
            return this.myChildren;
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                MyRootNode.$$$reportNull$$$0(2);
            }
            super.update(presentation);
            presentation.setIcon(PhpIcons.PROJECT_ICON);
            presentation.setPresentableText("");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidates";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/ui/PhpMappingSimpleResolveDialog$MyRootNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/ui/PhpMappingSimpleResolveDialog$MyRootNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class MySimpleTreeStructure
    extends SimpleTreeStructure {
        private final MyRootNode myRootNode;

        public MySimpleTreeStructure(Collection<VirtualFile> candidates) {
            if (candidates == null) {
                MySimpleTreeStructure.$$$reportNull$$$0(0);
            }
            this.myRootNode = new MyRootNode(candidates);
        }

        @NotNull
        public Object getRootElement() {
            MyRootNode myRootNode = this.myRootNode;
            if (myRootNode == null) {
                MySimpleTreeStructure.$$$reportNull$$$0(1);
            }
            return myRootNode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidates";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/ui/PhpMappingSimpleResolveDialog$MySimpleTreeStructure";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/ui/PhpMappingSimpleResolveDialog$MySimpleTreeStructure";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

