/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.typeInference;

import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpArrayAccessTypeDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.NotNull;

public class PhpArrayAccessTypeAnalyzer
extends PhpTypeAnalyzerProcessor {
    @NotNull
    private final CharSequence myVariableName;
    @NotNull
    private final CharSequence myKey;

    public PhpArrayAccessTypeAnalyzer(@NotNull CharSequence variableName, @NotNull CharSequence key) {
        if (variableName == null) {
            PhpArrayAccessTypeAnalyzer.$$$reportNull$$$0(0);
        }
        if (key == null) {
            PhpArrayAccessTypeAnalyzer.$$$reportNull$$$0(1);
        }
        this.myVariableName = variableName;
        this.myKey = key;
    }

    public boolean processArrayAccessInstruction(PhpArrayAccessInstruction curInstruction) {
        if (PhpLangUtil.equalsVariableNames(this.myVariableName, curInstruction.getVariableName()) && PhpLangUtil.equals(this.myKey, curInstruction.getKey()) && (curInstruction.getAccess().isWrite() || curInstruction.getAccess().isWriteRef())) {
            return this.processAccessInstruction((PhpAccessInstruction)curInstruction);
        }
        return true;
    }

    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
        PhpAccessInstruction.Access access;
        if (PhpLangUtil.equalsVariableNames(this.myVariableName, instruction.getVariableName()) && (access = instruction.getAccess()).isWrite()) {
            return false;
        }
        return super.processAccessVariableInstruction(instruction);
    }

    public boolean processConditionInstruction(PhpConditionInstruction instruction) {
        PhpArrayAccessTypeDFAnalyzer analyzer = new PhpArrayAccessTypeDFAnalyzer(this.myVariableName, this.myKey);
        PhpType type = (PhpType)analyzer.performDFA(instruction.getCondition(), instruction.getResult());
        if (!type.isEmpty()) {
            this.setType(type);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "variableName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "key";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/codeInsight/typeInference/PhpArrayAccessTypeAnalyzer";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

