/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.components;

import com.intellij.ui.Graphics2DLog;
import com.intellij.ui.Gray;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;

public class DiagramWatermarkGraphics
extends Graphics2DLog {
    public DiagramWatermarkGraphics(Graphics g) {
        super(g);
        this.setBackground(UIUtil.getPanelBackground());
    }

    public void fill(Shape s) {
        if (s instanceof Rectangle2D.Float) {
            Rectangle2D.Float f = (Rectangle2D.Float)s;
            int width = (int)f.getWidth();
            int height = (int)f.getHeight();
            if (Math.abs(width - 100) < 10 && Math.abs(height - 15) < 5) {
                return;
            }
        }
        super.fill(s);
    }

    public Graphics create() {
        return new DiagramWatermarkGraphics(this.myPeer.create());
    }

    public Graphics create(int x, int y, int width, int height) {
        return new DiagramWatermarkGraphics(this.myPeer.create(x, y, width, height));
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
        Color c = this.getColor();
        if ((double)x == 10.0) {
            Rectangle2D bounds = g.getLogicalBounds();
            this.setColor((Color)Gray._85);
            this.setFont(g.getFont());
            this.drawString("Powered by yFiles", x, y);
        } else {
            super.drawGlyphVector(g, x, y);
        }
        this.setColor(c);
    }

    protected void log(String msg) {
    }
}

