/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.LinkReferenceDefinitionMarkerBlock;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001c\u0010\r\u001a\u00020\u000e2\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "Companion", "3ce148cfd89a773"})
public final class LinkReferenceDefinitionProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, stateInfo.getCurrentConstraints())) {
            return CollectionsKt.emptyList();
        }
        List<IntRange> list = Companion.matchLinkDefinition(pos.getTextFromPosition());
        if (list == null) {
            return CollectionsKt.emptyList();
        }
        List<IntRange> matchResult = list;
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)matchResult)) {
            IElementType iElementType;
            int i = indexedValue.component1();
            IntRange range = (IntRange)indexedValue.component2();
            IntRange intRange = Companion.addToRangeAndWiden(range, pos.getOffset());
            switch (i) {
                case 0: {
                    iElementType = MarkdownElementTypes.LINK_LABEL;
                    break;
                }
                case 1: {
                    iElementType = MarkdownElementTypes.LINK_DESTINATION;
                    break;
                }
                case 2: {
                    iElementType = MarkdownElementTypes.LINK_TITLE;
                    break;
                }
                default: {
                    throw (Throwable)((Object)new AssertionError((Object)"There are no more than three groups in this regex"));
                }
            }
            productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(intRange, iElementType)));
        }
        int matchLength = ((IntRange)CollectionsKt.last(matchResult)).getEndInclusive() + 1;
        LookaheadText.Position endPosition = pos.nextPosition(matchLength);
        if (endPosition != null && !Companion.isEndOfLine(endPosition)) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new LinkReferenceDefinitionMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder.mark(), pos.getOffset() + matchLength));
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        return false;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\r\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bR\u00020\fJ\u0011\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0082\bJ\u0011\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0082\bJ\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0007J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0007J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0007J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0007H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider$Companion;", "", "()V", "addToRangeAndWiden", "Lkotlin/ranges/IntRange;", "range", "t", "", "isEndOfLine", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "isSpace", "c", "", "isSpaceOrNewline", "matchLinkDefinition", "", "text", "", "matchLinkDestination", "start", "matchLinkLabel", "matchLinkTitle", "passOneNewline", "3ce148cfd89a773"})
    public static final class Companion {
        @NotNull
        public final IntRange addToRangeAndWiden(@NotNull IntRange range, int t) {
            Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
            return new IntRange(range.getStart() + t, range.getEndInclusive() + t + 1);
        }

        public final boolean isEndOfLine(@NotNull LookaheadText.Position pos) {
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            return pos.getOffsetInCurrentLine() == -1 || pos.charsToNonWhitespace() == null;
        }

        @Nullable
        public final List<IntRange> matchLinkDefinition(@NotNull CharSequence text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            int offset = MarkerBlockProvider.Companion.passSmallIndent(text);
            IntRange intRange = this.matchLinkLabel(text, offset);
            if (intRange == null) {
                return null;
            }
            IntRange linkLabel = intRange;
            offset = linkLabel.getEndInclusive() + 1;
            if (offset >= text.length() || text.charAt(offset) != ':') {
                return null;
            }
            ++offset;
            offset = this.passOneNewline(text, offset);
            IntRange intRange2 = this.matchLinkDestination(text, offset);
            if (intRange2 == null) {
                return null;
            }
            IntRange destination = intRange2;
            offset = destination.getEndInclusive() + 1;
            offset = this.passOneNewline(text, offset);
            IntRange title = this.matchLinkTitle(text, offset);
            ArrayList<IntRange> result = new ArrayList<IntRange>();
            result.add(linkLabel);
            result.add(destination);
            if (title != null) {
                for (offset = title.getEndInclusive() + 1; offset < text.length(); ++offset) {
                    Companion companion = this;
                    char c$iv = text.charAt(offset);
                    if (!(c$iv == ' ' || c$iv == '\t')) break;
                }
                if (offset >= text.length() || text.charAt(offset) == '\n') {
                    result.add(title);
                }
            }
            return result;
        }

        @Nullable
        public final IntRange matchLinkDestination(@NotNull CharSequence text, int start) {
            int offset;
            block16: {
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                if (start >= text.length()) {
                    return null;
                }
                offset = start;
                if (text.charAt(offset) != '<') break block16;
                ++offset;
                while (offset < text.length()) {
                    Companion this_$iv;
                    char c;
                    block18: {
                        block17: {
                            c = text.charAt(offset);
                            if (c == '>') {
                                return new IntRange(start, offset);
                            }
                            if (c == '<' || c == '>') break block17;
                            Companion this_$iv$iv = this_$iv = this;
                            if (!(c == ' ' || c == '\t' || c == '\n')) break block18;
                        }
                        return null;
                    }
                    if (c == '\\' && offset + 1 < text.length()) {
                        this_$iv = this;
                        char c$iv = text.charAt(offset + 1);
                        Companion this_$iv$iv = this_$iv;
                        if (!(c$iv == ' ' || c$iv == '\t' || c$iv == '\n')) {
                            ++offset;
                        }
                    }
                    ++offset;
                }
                return null;
            }
            boolean hasParens = false;
            while (offset < text.length()) {
                Companion this_$iv;
                char c = text.charAt(offset);
                Companion this_$iv$iv = this_$iv = this;
                if (c == ' ' || c == '\t' || c == '\n' || c <= '\u001b') break;
                if (c == '(') {
                    if (hasParens) break;
                    hasParens = true;
                } else if (c == ')') {
                    if (!hasParens) break;
                    hasParens = false;
                } else if (c == '\\' && offset + 1 < text.length()) {
                    this_$iv = this;
                    char c$iv = text.charAt(offset + 1);
                    Companion this_$iv$iv2 = this_$iv;
                    if (!(c$iv == ' ' || c$iv == '\t' || c$iv == '\n')) {
                        ++offset;
                    }
                }
                ++offset;
            }
            if (start == offset) {
                return null;
            }
            return new IntRange(start, offset - 1);
        }

        @Nullable
        public final IntRange matchLinkTitle(@NotNull CharSequence text, int start) {
            char c;
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            if (start >= text.length()) {
                return null;
            }
            switch (text.charAt(start)) {
                case '\'': {
                    c = '\'';
                    break;
                }
                case '\"': {
                    c = '\"';
                    break;
                }
                case '(': {
                    c = ')';
                    break;
                }
                default: {
                    return null;
                }
            }
            char endDelim = c;
            boolean isBlank = false;
            for (int offset = start + 1; offset < text.length(); ++offset) {
                Companion this_$iv;
                char c2 = text.charAt(offset);
                if (c2 == endDelim) {
                    return new IntRange(start, offset);
                }
                if (c2 == '\n') {
                    if (isBlank) {
                        return null;
                    }
                    isBlank = true;
                } else {
                    this_$iv = this;
                    if (!(c2 == ' ' || c2 == '\t')) {
                        isBlank = false;
                    }
                }
                if (c2 != '\\' || offset + 1 >= text.length()) continue;
                this_$iv = this;
                char c$iv = text.charAt(offset + 1);
                Companion this_$iv$iv = this_$iv;
                if (c$iv == ' ' || c$iv == '\t' || c$iv == '\n') continue;
                ++offset;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final IntRange matchLinkLabel(@NotNull CharSequence text, int start) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            int offset = start;
            if (offset >= text.length() || text.charAt(offset) != '[') {
                return null;
            }
            ++offset;
            boolean seenNonWhitespace = false;
            int n = 1;
            int n2 = 1000;
            while (n < n2) {
                void i;
                if (offset >= text.length()) {
                    return null;
                }
                char c = text.charAt(offset);
                if (c == '[' || c == ']') break;
                if (c == '\\') {
                    if (++offset >= text.length()) {
                        return null;
                    }
                    c = text.charAt(offset);
                }
                if (!CharsKt.isWhitespace((char)c)) {
                    seenNonWhitespace = true;
                }
                ++offset;
                ++i;
            }
            if (!seenNonWhitespace || offset >= text.length() || text.charAt(offset) != ']') {
                return null;
            }
            n = start;
            return new IntRange(n, offset);
        }

        private final int passOneNewline(CharSequence text, int start) {
            char c$iv;
            int offset;
            for (offset = start; offset < text.length(); ++offset) {
                Companion companion = this;
                c$iv = text.charAt(offset);
                if (!(c$iv == ' ' || c$iv == '\t')) break;
            }
            if (offset < text.length() && text.charAt(offset) == '\n') {
                ++offset;
                while (offset < text.length()) {
                    Companion this_$iv = this;
                    c$iv = text.charAt(offset);
                    if (!(c$iv == ' ' || c$iv == '\t')) break;
                    ++offset;
                }
            }
            return offset;
        }

        private final boolean isSpace(char c) {
            return c == ' ' || c == '\t';
        }

        private final boolean isSpaceOrNewline(char c) {
            Companion this_$iv = this;
            return c == ' ' || c == '\t' || c == '\n';
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$isSpace(Companion $this, char c) {
            return $this.isSpace(c);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

