/*
 * Decompiled with CFR 0.152.
 */
package ini4idea.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.hash.HashSet;
import ini4idea.IniBundle;
import ini4idea.lang.psi.IniFile;
import ini4idea.lang.psi.IniKey;
import ini4idea.lang.psi.IniSection;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DuplicateKeyInspection
extends LocalInspectionTool {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            DuplicateKeyInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DuplicateKeyInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof IniFile)) {
            return null;
        }
        SmartList descriptors = new SmartList();
        IniSection[] children = (IniSection[])PsiTreeUtil.getChildrenOfType((PsiElement)file, IniSection.class);
        if (children != null) {
            for (IniSection elem : children) {
                HashSet keys = new HashSet();
                Collection iniKeys = PsiTreeUtil.collectElementsOfType((PsiElement)elem, (Class[])new Class[]{IniKey.class});
                for (IniKey keyElement : iniKeys) {
                    String stringKey = keyElement.getIniKeyName().getText();
                    if (keyElement.getIniArrayIndexList() != null) {
                        keys.add(stringKey);
                        continue;
                    }
                    if (keys.contains(stringKey)) {
                        TextRange textRange = keyElement.getTextRange();
                        if (textRange == null) continue;
                        descriptors.add(manager.createProblemDescriptor((PsiElement)keyElement, IniBundle.message("ini.duplicate.key.inspection.problem.description", new Object[0]), true, new LocalQuickFix[]{RemoveDuplicateSectionFix.INSTANCE}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                        continue;
                    }
                    keys.add(stringKey);
                }
            }
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = IniBundle.message("ini.duplicate.key.inspection.display.name", new Object[0]);
        if (string == null) {
            DuplicateKeyInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("DuplicateKeyInSection" == null) {
            DuplicateKeyInspection.$$$reportNull$$$0(3);
        }
        return "DuplicateKeyInSection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ini4idea/inspections/DuplicateKeyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ini4idea/inspections/DuplicateKeyInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoveDuplicateSectionFix
    implements LocalQuickFix {
        private static final RemoveDuplicateSectionFix INSTANCE = new RemoveDuplicateSectionFix();

        private RemoveDuplicateSectionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = IniBundle.message("ini.duplicate.key.inspection.fix.name", new Object[0]);
            if (string == null) {
                RemoveDuplicateSectionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            TextRange textRange;
            if (project == null) {
                RemoveDuplicateSectionFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveDuplicateSectionFix.$$$reportNull$$$0(2);
            }
            if ((textRange = (element = descriptor.getPsiElement()).getParent().getTextRange()) != null) {
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(element.getContainingFile());
                if (document == null) {
                    return;
                }
                document.deleteString(textRange.getStartOffset(), textRange.getEndOffset());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ini4idea/inspections/DuplicateKeyInspection$RemoveDuplicateSectionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ini4idea/inspections/DuplicateKeyInspection$RemoveDuplicateSectionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

