/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.ui;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.FrameworkCommandHistoryList;
import com.jetbrains.php.framework.FrameworkCurrentInputData;
import com.jetbrains.php.framework.FrameworkRunConsoleAction;
import com.jetbrains.php.framework.data.FrameworkDataService;
import com.jetbrains.php.framework.ui.FrameworkConsoleViewImpl;
import com.jetbrains.php.framework.ui.FrameworkUiUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkToolWindowComponent
extends JPanel
implements DataProvider,
Disposable {
    private static final int MAX_TAB_TITLE_LENGTH = 30;
    private static final String[] OPTIONS = new String[]{FrameworkBundle.message("framework.tool.window.option.terminate.and.close", new Object[0]), FrameworkBundle.message("framework.tool.window.option.close.without.terminating", new Object[0]), FrameworkBundle.message("framework.tool.window.option.cancel.closing", new Object[0])};
    private final JBTabsImpl myTabbedPane;
    private final JPanel myEditorPanel;
    private final EditorTextField myEditorTextField;
    private ConsoleView myValidateConsoleView;
    private final List<FrameworkConsoleViewImpl> myConsoles;
    private final Map<FrameworkConsoleViewImpl, OSProcessHandler> myProcessHandlers;
    private int myConsolesCount;

    public FrameworkToolWindowComponent(final @NotNull Project project) {
        if (project == null) {
            FrameworkToolWindowComponent.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myConsoles = new ArrayList<FrameworkConsoleViewImpl>();
        this.myProcessHandlers = new HashMap<FrameworkConsoleViewImpl, OSProcessHandler>();
        ActionManager actionManager = ActionManager.getInstance();
        this.myTabbedPane = new JBTabsImpl(project, actionManager, IdeFocusManager.getInstance((Project)project), (Disposable)project);
        this.myTabbedPane.setTabDraggingEnabled(true);
        this.add((Component)this.myTabbedPane, "Center");
        this.myEditorTextField = FrameworkUiUtils.createEditorField(project, FrameworkCommandHistoryList.getInstance(project));
        this.myEditorPanel = new JPanel(new BorderLayout());
        this.myEditorPanel.add((Component)this.myEditorTextField, "Center");
        JPanel floatButtonPanel = new JPanel(new BorderLayout());
        InplaceButton floatButton = new InplaceButton(FrameworkBundle.message("framework.console.float.button.tip", new Object[0]), AllIcons.Actions.MoveTo2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameworkDataService.setConsoleInToolWindow(false);
                String oldText = FrameworkToolWindowComponent.this.myEditorTextField.getText();
                FrameworkRunConsoleAction.applyConsoleSettings(project, oldText, true, false);
            }
        });
        floatButtonPanel.add((Component)floatButton, "North");
        this.myEditorPanel.add((Component)floatButtonPanel, "East");
        this.myEditorPanel.setVisible(FrameworkDataService.isConsoleInToolWindow());
        this.add((Component)this.myEditorPanel, "South");
        MyDefaultFocusTraversalPolicy traversalPolicy = new MyDefaultFocusTraversalPolicy();
        this.setFocusTraversalPolicy(traversalPolicy);
        this.setFocusCycleRoot(true);
        Disposer.register((Disposable)project, (Disposable)this);
    }

    public FrameworkConsoleViewImpl createAndAddConsole(Project project, String title) {
        FrameworkConsoleViewImpl consoleView = new FrameworkConsoleViewImpl(project, false, this);
        this.addComponent(consoleView, title, true);
        consoleView.installActions();
        Disposer.register((Disposable)this, (Disposable)consoleView);
        return consoleView;
    }

    private void addComponent(FrameworkConsoleViewImpl consoleView, String title, boolean isBasicConsole) {
        JComponent component = consoleView.getComponent();
        component.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, (Color)JBColor.GRAY));
        TabInfo info = new TabInfo(component);
        info.setText(title);
        info = this.myTabbedPane.addTab(info);
        if (isBasicConsole) {
            this.myConsoles.add(consoleView);
            ++this.myConsolesCount;
            this.myTabbedPane.setNavigationActionsEnabled(true);
            consoleView.installActions();
        }
        this.addCloseTabAction(info, consoleView, !isBasicConsole);
    }

    private void addCloseTabAction(TabInfo tabInfo, FrameworkConsoleViewImpl consoleView, boolean isValidationTab) {
        DefaultActionGroup tabActions = new DefaultActionGroup();
        tabActions.add((AnAction)new CloseTab(tabInfo, consoleView, isValidationTab));
        tabInfo.setTabLabelActions((ActionGroup)tabActions, "unknown");
    }

    protected List<FrameworkConsoleViewImpl> getConsoles() {
        return Collections.unmodifiableList(this.myConsoles);
    }

    protected int getConsolesCount() {
        return this.myConsolesCount;
    }

    protected boolean hasComponentInTabs(JComponent component) {
        return this.myTabbedPane.findInfo((Component)component) != null;
    }

    public void setSelectedComponent(Component component) {
        TabInfo info = this.myTabbedPane.findInfo(component);
        if (info != null) {
            this.myTabbedPane.select(info, true);
        }
    }

    public void setTextFieldVisible(boolean visible) {
        this.myEditorPanel.setVisible(visible);
    }

    public void setText(@Nullable String text) {
        this.myEditorTextField.setText(StringUtil.notNullize((String)text));
    }

    public void requestFocusInEditor(Project project) {
        IdeFocusManager.getInstance((Project)project).requestFocus((Component)this.myEditorTextField, true);
    }

    public void cleaEditorCache() {
        Document document = this.myEditorTextField.getDocument();
        FrameworkCurrentInputData.clear(document);
    }

    public synchronized void addProcessHandler(OSProcessHandler t, FrameworkConsoleViewImpl consoleView) {
        this.myProcessHandlers.put(consoleView, t);
    }

    private synchronized boolean closeProcess(FrameworkConsoleViewImpl consoleView) {
        ProcessHandler handler = (ProcessHandler)this.myProcessHandlers.get((Object)consoleView);
        if (handler != null && !handler.isProcessTerminated()) {
            int close = Messages.showYesNoCancelDialog((Project)((Project)CommonDataKeys.PROJECT.getData((DataProvider)consoleView)), (String)FrameworkBundle.message("framework.tool.window.terminate.running.command", new Object[0]), (String)FrameworkBundle.message("framework.tool.window.message.title.command.line.tool", new Object[0]), (String)OPTIONS[0], (String)OPTIONS[1], (String)OPTIONS[2], (Icon)Messages.getQuestionIcon());
            if (close == 0) {
                handler.destroyProcess();
            }
            return close != 2;
        }
        return true;
    }

    public synchronized boolean tryToCloseProcesses() {
        Boolean close = null;
        for (Map.Entry<FrameworkConsoleViewImpl, OSProcessHandler> entry : this.myProcessHandlers.entrySet()) {
            ProcessHandler handler = (ProcessHandler)entry.getValue();
            if (handler == null || handler.isProcessTerminated()) continue;
            if (close == null) {
                int closeIndex = Messages.showYesNoCancelDialog((Project)((Project)CommonDataKeys.PROJECT.getData((DataProvider)entry.getKey())), (String)FrameworkBundle.message("framework.tool.window.terminate.all.running.commands", new Object[0]), (String)FrameworkBundle.message("framework.tool.window.message.title.command.line.tool", new Object[0]), (String)OPTIONS[0], (String)OPTIONS[1], (String)OPTIONS[2], (Icon)Messages.getQuestionIcon());
                if (closeIndex == 2) {
                    return false;
                }
                close = closeIndex == 0;
            }
            if (!close.booleanValue()) continue;
            handler.destroyProcess();
        }
        return true;
    }

    public void showValidationTab() {
        TabInfo info;
        if (this.myValidateConsoleView != null && (info = this.myTabbedPane.findInfo((Component)this.myValidateConsoleView.getComponent())) != null) {
            this.myTabbedPane.select(info, true);
        }
    }

    @Nullable
    public ConsoleView getValidateConsoleView() {
        return this.myValidateConsoleView;
    }

    public void setOutputConsoleTabTitle(FrameworkConsoleViewImpl consoleView, String commandToExecute) {
        TabInfo info = this.myTabbedPane.findInfo((Component)consoleView.getComponent());
        if (info != null) {
            String title = commandToExecute.length() > 30 ? commandToExecute.substring(0, 30 - "...".length()) + "..." : commandToExecute;
            info.setText(title);
            info.setTooltipText(commandToExecute);
        }
    }

    public static FrameworkToolWindowComponent getToolWindowComponent(ContentManager contentManager) {
        Content[] contents = contentManager.getContents();
        assert (contents.length == 1) : contents.length;
        JComponent component = contents[0].getComponent();
        assert (component instanceof FrameworkToolWindowComponent);
        return (FrameworkToolWindowComponent)component;
    }

    public ConsoleView getOrCreateValidationConsole(Project project) {
        if (this.myValidateConsoleView != null) {
            return this.myValidateConsoleView;
        }
        FrameworkConsoleViewImpl errorConsoleView = new FrameworkConsoleViewImpl(project, true, this);
        this.addComponent(errorConsoleView, FrameworkBundle.message("framework.console.tab.title.validation", new Object[0]), false);
        this.myValidateConsoleView = errorConsoleView;
        Disposer.register((Disposable)this, (Disposable)this.myValidateConsoleView);
        return errorConsoleView;
    }

    public FrameworkConsoleViewImpl getOrCreateAvailableConsole(Project project) {
        List<FrameworkConsoleViewImpl> consoleViewList = this.getConsoles();
        FrameworkConsoleViewImpl availableConsoleView = null;
        assert (consoleViewList != null);
        for (FrameworkConsoleViewImpl consoleView : consoleViewList) {
            if (Disposer.isDisposed((Disposable)consoleView) || !this.hasComponentInTabs(consoleView.getComponent()) || consoleView.isRunning()) continue;
            availableConsoleView = consoleView;
            break;
        }
        if (availableConsoleView == null) {
            availableConsoleView = this.createAndAddConsole(project, FrameworkBundle.message("framework.console.tab.title.commands.output.0", this.getConsolesCount()));
        }
        return availableConsoleView;
    }

    public void selectAllAndMoveCaret() {
        this.myEditorTextField.selectAll();
        Editor editor = this.myEditorTextField.getEditor();
        if (editor != null) {
            editor.getCaretModel().moveToOffset(StringUtil.notNullize((String)this.myEditorTextField.getText()).length());
        }
    }

    public void dispose() {
    }

    @Nullable
    protected OSProcessHandler getProcessHandler(FrameworkConsoleViewImpl consoleView) {
        return this.myProcessHandlers.get((Object)consoleView);
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            FrameworkToolWindowComponent.$$$reportNull$$$0(1);
        }
        if (PlatformDataKeys.EXPORTER_TO_TEXT_FILE.is(dataId)) {
            TabInfo info = this.myTabbedPane.getSelectedInfo();
            if (info == null) {
                return null;
            }
            JComponent component = info.getComponent();
            if (component instanceof FrameworkConsoleViewImpl) {
                return ((FrameworkConsoleViewImpl)((Object)component)).getData(dataId);
            }
            return null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/framework/ui/FrameworkToolWindowComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class CloseTab
    extends AnAction {
        private final TabInfo myTabInfo;
        private final FrameworkConsoleViewImpl myConsole;
        private final boolean isValidationTab;

        private CloseTab(TabInfo tabInfo, FrameworkConsoleViewImpl console, boolean isValidation) {
            this.myTabInfo = tabInfo;
            this.myConsole = console;
            this.isValidationTab = isValidation;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseTab.$$$reportNull$$$0(0);
            }
            e.getPresentation().setIcon(AllIcons.Actions.Close);
            e.getPresentation().setHoveredIcon(AllIcons.Actions.CloseHovered);
            e.getPresentation().setVisible(UISettings.getInstance().getShowCloseButton());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseTab.$$$reportNull$$$0(1);
            }
            if (this.isValidationTab || FrameworkToolWindowComponent.this.closeProcess(this.myConsole)) {
                FrameworkToolWindowComponent.this.myTabbedPane.removeTab(this.myTabInfo);
                FrameworkToolWindowComponent.this.myConsoles.remove((Object)this.myConsole);
                if (this.isValidationTab) {
                    FrameworkToolWindowComponent.this.myValidateConsoleView = null;
                }
                if (!FrameworkToolWindowComponent.this.myEditorPanel.isVisible() && FrameworkToolWindowComponent.this.myValidateConsoleView == null && FrameworkToolWindowComponent.this.myConsoles.isEmpty()) {
                    ToolWindowManager.getInstance((Project)FrameworkToolWindowComponent.this.myEditorTextField.getProject()).unregisterToolWindow(FrameworkUiUtils.TOOL_WINDOW_ID);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/php/framework/ui/FrameworkToolWindowComponent$CloseTab";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyDefaultFocusTraversalPolicy
    extends DefaultFocusTraversalPolicy {
        private MyDefaultFocusTraversalPolicy() {
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            if (FrameworkToolWindowComponent.this.myEditorPanel.isVisible()) {
                return FrameworkToolWindowComponent.this.myEditorTextField;
            }
            return super.getDefaultComponent(aContainer);
        }
    }
}

