/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Consumer;
import com.jetbrains.nodejs.run.profile.V8IndexCatalogManager;
import com.jetbrains.nodejs.run.profile.V8IndexManager;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapInMemoryIndexes;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8ImportantStringsHolder;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8StringIndex;
import com.jetbrains.nodejs.run.profile.heap.data.LinkedByNameId;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapHeader;
import com.jetbrains.nodejs.run.profile.heap.io.LongRawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReaderFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8HeapIndexManager
extends V8IndexManager<Category> {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapIndexManager");
    public static final String IDEA_JAVASCRIPT_PROFILING_V8_HEAP_MAX_FILE_MB = "idea.javascript.profiling.v8.heap.max.file.mb";
    public static final Integer MAX_FILE_SIZE = Integer.getInteger("idea.javascript.profiling.v8.heap.max.file.mb", 100) * 0x100000;
    private final boolean myShowHidden;

    public V8HeapIndexManager(@NotNull File snapshotFile, boolean showHidden) throws IOException {
        if (snapshotFile == null) {
            V8HeapIndexManager.$$$reportNull$$$0(0);
        }
        super(snapshotFile, (Enum[])Category.values());
        this.myShowHidden = showHidden;
    }

    @NotNull
    public static File getSystemDir() {
        File file = new File(PathManager.getSystemPath(), ApplicationManager.getApplication().isUnitTestMode() ? "v8test" : "v8");
        if (file == null) {
            V8HeapIndexManager.$$$reportNull$$$0(1);
        }
        return file;
    }

    @Override
    protected byte[] createDigest(@NotNull File snapshotFile) throws IOException {
        if (snapshotFile == null) {
            V8HeapIndexManager.$$$reportNull$$$0(2);
        }
        return V8HeapIndexManager.snapshotDigest(snapshotFile, this.myShowHidden);
    }

    @Override
    protected Category getDescriptionCategory() {
        return Category.description;
    }

    @Nullable
    public V8CachingReader initReader(@NotNull CompositeCloseable resources, @Nullable Consumer<String> errorNotificator) throws IOException, ClassNotFoundException {
        if (resources == null) {
            V8HeapIndexManager.$$$reportNull$$$0(3);
        }
        List<File> files = this.myIndexFiles.getFiles(Category.strings);
        V8StringIndex stringIndex = resources.register(new V8StringIndex(files.toArray(new File[0])));
        LinksReaderFactory<LinkedByNameId> stringsReverseIndexReaderFactory = new LinksReaderFactory<LinkedByNameId>(LinkedByNameId.Serializer.getInstance(), this.myIndexFiles.getOneFile(Category.stringsNumLinks), this.myIndexFiles.getOneFile(Category.stringsLinks));
        LinksReaderFactory<V8HeapEdge> reverseIndexReaderFactory = new LinksReaderFactory<V8HeapEdge>(V8HeapEdge.MyRawSerializer.getInstance(), this.myIndexFiles.getOneFile(Category.reverseNumLinks), this.myIndexFiles.getOneFile(Category.reverseLinks));
        V8HeapHeader header = new V8HeapHeader();
        V8ImportantStringsHolder holder = new V8ImportantStringsHolder();
        File headerFile = this.myIndexFiles.getOneFile(Category.header);
        this.readHeader(headerFile, header, holder);
        V8CachingReader reader = new V8CachingReader(this.mySnapshotFile, this.myDigest, resources, header, errorNotificator, stringIndex, this.myIndexFiles.getOneFile(Category.nodeIdx), this.myIndexFiles.getOneFile(Category.edgeIdx), stringsReverseIndexReaderFactory, reverseIndexReaderFactory, holder);
        File inMemory = this.myIndexFiles.getOneFile(Category.inMemoryIndexes);
        V8HeapInMemoryIndexes inMemoryIndexes = new V8HeapInMemoryIndexes();
        V8HeapIndexManager.readExternalizableFromFile(inMemoryIndexes, inMemory);
        LinksReaderFactory<Long> aggregatesReaderFactory = new LinksReaderFactory<Long>(new LongRawSerializer(), this.myIndexFiles.getOneFile(Category.aggregateNum), this.myIndexFiles.getOneFile(Category.aggregateLinks));
        reader.setInMemoryIndexes(inMemoryIndexes);
        reader.setAggregatesLinksReaderFactory(aggregatesReaderFactory);
        if (!this.myShowHidden) {
            reader.resetDoNotShowHidden();
        }
        return reader;
    }

    public void recordReader(@NotNull V8CachingReader reader) throws IOException {
        if (reader == null) {
            V8HeapIndexManager.$$$reportNull$$$0(4);
        }
        if (this.myDoNotSerialize) {
            return;
        }
        this.writeHeader(reader, this.myIndexFiles.generate(Category.header, ".header"));
        this.writeExternalizableToFile(reader.getInMemoryIndexes(), this.myIndexFiles.generate(Category.inMemoryIndexes, ".inMemory"));
        File description = this.categoryFile(Category.description);
        V8IndexCatalogManager.writeDigests(this.myIndexFiles.getFilesMap(), description);
    }

    private void writeExternalizableToFile(@NotNull Externalizable externalizable, @NotNull File file) throws IOException {
        if (externalizable == null) {
            V8HeapIndexManager.$$$reportNull$$$0(5);
        }
        if (file == null) {
            V8HeapIndexManager.$$$reportNull$$$0(6);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(out);
        externalizable.writeExternal(stream);
        stream.flush();
        FileUtil.writeToFile((File)file, (byte[])out.toByteArray());
    }

    private static void readExternalizableFromFile(@NotNull Externalizable externalizable, @NotNull File file) throws IOException, ClassNotFoundException {
        if (externalizable == null) {
            V8HeapIndexManager.$$$reportNull$$$0(7);
        }
        if (file == null) {
            V8HeapIndexManager.$$$reportNull$$$0(8);
        }
        V8HeapIndexManager.checkFileSize(file.length());
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        externalizable.readExternal(ois);
    }

    private static void checkFileSize(long length) throws IOException {
        if (length > (long)MAX_FILE_SIZE.intValue()) {
            throw new IOException("Can not load V8 Heap indexes file, file is too big.\nPlease specify a greater value in megabytes for property 'idea.javascript.profiling.v8.heap.max.file.mb' in idea.properties file.");
        }
    }

    private void writeHeader(@NotNull V8CachingReader reader, @NotNull File file) throws IOException {
        if (reader == null) {
            V8HeapIndexManager.$$$reportNull$$$0(9);
        }
        if (file == null) {
            V8HeapIndexManager.$$$reportNull$$$0(10);
        }
        V8HeapHeader header = reader.getHeader();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(out);
        header.writeExternal(stream);
        V8ImportantStringsHolder holder = reader.getImportantStringsHolder();
        holder.writeExternal(stream);
        stream.flush();
        FileUtil.writeToFile((File)file, (byte[])out.toByteArray());
    }

    private void readHeader(@NotNull File file, @NotNull V8HeapHeader header, @NotNull V8ImportantStringsHolder holder) throws IOException, ClassNotFoundException {
        if (file == null) {
            V8HeapIndexManager.$$$reportNull$$$0(11);
        }
        if (header == null) {
            V8HeapIndexManager.$$$reportNull$$$0(12);
        }
        if (holder == null) {
            V8HeapIndexManager.$$$reportNull$$$0(13);
        }
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        header.readExternal(ois);
        holder.readExternal(ois);
    }

    public static byte[] snapshotDigest(@NotNull File snapshotFile, boolean showHidden) throws IOException {
        if (snapshotFile == null) {
            V8HeapIndexManager.$$$reportNull$$$0(14);
        }
        return V8IndexCatalogManager.digestFile(snapshotFile, new byte[][]{(showHidden ? "hidden" : "user").getBytes(CharsetToolkit.UTF8_CHARSET)});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshotFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapIndexManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizable";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapIndexManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDigest";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initReader";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "recordReader";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeExternalizableToFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readExternalizableFromFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeHeader";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readHeader";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "snapshotDigest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Category {
        description,
        nodeIdx,
        edgeIdx,
        strings,
        stringsNumLinks,
        stringsLinks,
        reverseNumLinks,
        reverseLinks,
        aggregateNum,
        aggregateLinks,
        header,
        inMemoryIndexes;

    }
}

