/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.concurrent.ExecutorService;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class AsyncUpdateAction<T>
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.AsyncUpdateAction");
    private static final ExecutorService ourUpdaterService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"AsyncUpdateAction Pool");

    @Override
    public final void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AsyncUpdateAction.$$$reportNull$$$0(0);
        }
        T data = this.prepareDataFromContext(e);
        Presentation originalPresentation = e.getPresentation();
        if (!this.forceSyncUpdate(e) && this.isDumbAware()) {
            Presentation realPresentation = originalPresentation.clone();
            ourUpdaterService.submit(() -> {
                this.performUpdate(realPresentation, data);
                SwingUtilities.invokeLater(() -> {
                    if (originalPresentation.isVisible() != realPresentation.isVisible()) {
                        LOG.error("Async update is not supported for actions that change their visibility.Either stop extending AsyncUpdateAction or override forceSyncUpdate() to return true.Action class is: " + this.getClass().getName());
                    }
                    originalPresentation.copyFrom(realPresentation);
                });
            });
            originalPresentation.setVisible(true);
            originalPresentation.setEnabled(false);
        } else {
            this.performUpdate(originalPresentation, data);
        }
    }

    @Override
    public final void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            AsyncUpdateAction.$$$reportNull$$$0(1);
        }
        this.performUpdate(e.getPresentation(), this.prepareDataFromContext(e));
    }

    protected abstract T prepareDataFromContext(@NotNull AnActionEvent var1);

    protected abstract void performUpdate(@NotNull Presentation var1, T var2);

    protected boolean forceSyncUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            AsyncUpdateAction.$$$reportNull$$$0(2);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/actionSystem/AsyncUpdateAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeActionPerformedUpdate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "forceSyncUpdate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

