/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import a.b.lb;
import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageOptionsProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuiteListener;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.coverage.SrcFileAnnotator;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.CoverageViewSuiteListener;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageDataManagerImpl
extends CoverageDataManager {
    private static final String e = "&Replace active suites";
    private static final String k = "&Add to active suites";
    private static final String l = "Do not apply &collected coverage";
    private final List<CoverageSuiteListener> b;
    private static final Logger o;
    @NonNls
    private static final String p = "SUITE";
    private final Project d;
    private final Set<CoverageSuite> g;
    private boolean h;
    private final Object m;
    private boolean j;
    private final VirtualFileContentsChangedAdapter a;
    private Set<LocalFileSystem.WatchRequest> q;
    private List<String> i;
    private CoverageSuitesBundle c;
    private final Object f;
    private final Map<Editor, SrcFileAnnotator> n;
    private static final long r;

    @Override
    public CoverageSuitesBundle getCurrentSuitesBundle() {
        return this.c;
    }

    public CoverageDataManagerImpl(@NotNull Project project) {
        if (project == null) {
            CoverageDataManagerImpl.a(0);
        }
        this.b = ContainerUtil.createLockFreeCopyOnWriteList();
        this.g = new HashSet<CoverageSuite>();
        this.h = false;
        this.m = new Object();
        this.a = new VirtualFileContentsChangedAdapter(){
            private static final long a = lb.a(-8880992551392514112L, -1880826732561313802L, MethodHandles.lookup().lookupClass()).a(200606703403786L);

            protected void onFileChange(@NotNull VirtualFile fileOrDirectory) {
                if (fileOrDirectory == null) {
                    1.a(0);
                }
                if (CoverageDataManagerImpl.this.i != null && VfsUtilCore.isUnder((String)fileOrDirectory.getPath(), (Collection)CoverageDataManagerImpl.this.i)) {
                    CoverageDataManagerImpl.this.c.restoreCoverageData();
                    CoverageDataManagerImpl.this.a(CoverageDataManagerImpl.this.c);
                }
            }

            protected void onBeforeFileChange(@NotNull VirtualFile fileOrDirectory) {
                if (fileOrDirectory == null) {
                    1.a(1);
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l3 = a ^ 0xF1D78A19502L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "fileOrDirectory";
                objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFileChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onBeforeFileChange";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.f = new Object();
        this.n = new HashMap<Editor, SrcFileAnnotator>();
        this.d = project;
        project.getMessageBus().connect().subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                CoverageDataManagerImpl.this.chooseSuitesBundle(CoverageDataManagerImpl.this.c);
            }
        });
        CoverageViewSuiteListener coverageViewSuiteListener = this.createCoverageViewListener();
        if (coverageViewSuiteListener != null) {
            this.addSuiteListener(coverageViewSuiteListener, (Disposable)this.d);
        }
    }

    @Nullable
    protected CoverageViewSuiteListener createCoverageViewListener() {
        return new CoverageViewSuiteListener(this, this.d);
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        long l3 = r ^ 0x6AA259E45C5EL;
        if ("CoverageDataManager" == null) {
            CoverageDataManagerImpl.a(1);
        }
        return "CoverageDataManager";
    }

    public void readExternal(Element element) throws InvalidDataException {
        long l3 = r ^ 0x223722E3DFEFL;
        for (Element element2 : element.getChildren(p)) {
            Object object;
            CoverageRunner coverageRunner = BaseCoverageSuite.readRunnerAttribute(element2);
            if (coverageRunner == null) {
                object = BaseCoverageSuite.readDataFileProviderAttribute(element2);
                if (!object.isValid()) continue;
                continue;
            }
            object = null;
            for (CoverageEngine coverageEngine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
                if (!coverageRunner.acceptsCoverageEngine(coverageEngine) || (object = coverageEngine.createEmptyCoverageSuite(coverageRunner)) == null) continue;
                if (!(object instanceof BaseCoverageSuite)) break;
                ((BaseCoverageSuite)object).setProject(this.d);
                break;
            }
            if (object == null) continue;
            try {
                object.readExternal(element2);
                this.g.add((CoverageSuite)object);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        long l3 = r ^ 0x68812DDD81A3L;
        for (CoverageSuite coverageSuite : this.g) {
            Element element2 = new Element(p);
            element.addContent(element2);
            coverageSuite.writeExternal(element2);
        }
    }

    @Override
    public CoverageSuite addCoverageSuite(String name, CoverageFileProvider fileProvider, String[] filters, long lastCoverageTimeStamp, @Nullable String suiteToMergeWith, CoverageRunner coverageRunner, boolean collectLineInfo, boolean tracingEnabled) {
        CoverageSuite coverageSuite = this.a(coverageRunner, name, fileProvider, filters, lastCoverageTimeStamp, suiteToMergeWith, collectLineInfo, tracingEnabled);
        if (suiteToMergeWith == null || !name.equals(suiteToMergeWith)) {
            this.removeCoverageSuite(coverageSuite);
        }
        this.g.remove(coverageSuite);
        this.g.add(coverageSuite);
        return coverageSuite;
    }

    @Override
    public CoverageSuite addExternalCoverageSuite(String selectedFileName, long timeStamp, CoverageRunner coverageRunner, CoverageFileProvider fileProvider) {
        CoverageSuite coverageSuite = this.a(coverageRunner, selectedFileName, fileProvider, ArrayUtil.EMPTY_STRING_ARRAY, timeStamp, null, false, false);
        this.g.add(coverageSuite);
        return coverageSuite;
    }

    @Override
    public CoverageSuite addCoverageSuite(CoverageEnabledConfiguration config) {
        long l3 = r ^ 0x341EB41B1599L;
        String string = config.getName() + " Coverage Results";
        String string2 = config.getCoverageFilePath();
        assert (string2 != null);
        CoverageRunner coverageRunner = config.getCoverageRunner();
        o.assertTrue(coverageRunner != null, (Object)("Coverage runner id = " + config.getRunnerId()));
        DefaultCoverageFileProvider defaultCoverageFileProvider = new DefaultCoverageFileProvider(new File(string2));
        CoverageSuite coverageSuite = this.a(config, string, coverageRunner, defaultCoverageFileProvider);
        this.removeCoverageSuite(coverageSuite);
        this.g.add(coverageSuite);
        return coverageSuite;
    }

    @Override
    public void removeCoverageSuite(CoverageSuite suite) {
        CoverageSuite[] coverageSuiteArray;
        long l3 = r ^ 0x38B8F7735817L;
        String string = suite.getCoverageDataFileName();
        boolean bl2 = suite.isTracingEnabled();
        if (!FileUtil.isAncestor((String)PathManager.getSystemPath(), (String)string, (boolean)false)) {
            coverageSuiteArray = "Would you like to delete file '" + string + "' ";
            if (bl2) {
                coverageSuiteArray = (String)coverageSuiteArray + "and traces directory '" + FileUtil.getNameWithoutExtension((File)new File(string)) + "' ";
            }
            if (Messages.showYesNoDialog((Project)this.d, (String)(coverageSuiteArray = (String)coverageSuiteArray + "on disk?"), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon()) == 0) {
                this.a(string, bl2);
            }
        } else {
            this.a(string, bl2);
        }
        this.g.remove(suite);
        if (this.c != null && this.c.contains(suite)) {
            coverageSuiteArray = this.c.getSuites();
            this.chooseSuitesBundle((coverageSuiteArray = (CoverageSuite[])ArrayUtil.remove((Object[])coverageSuiteArray, (Object)suite)).length > 0 ? new CoverageSuitesBundle(coverageSuiteArray) : null);
        }
    }

    private void a(String string, boolean bl2) {
        FileUtil.delete((File)new File(string));
        if (bl2) {
            FileUtil.delete((File)this.a(string));
        }
    }

    @Override
    @NotNull
    public CoverageSuite[] getSuites() {
        CoverageSuite[] coverageSuiteArray = this.g.toArray(new CoverageSuite[0]);
        if (coverageSuiteArray == null) {
            CoverageDataManagerImpl.a(2);
        }
        return coverageSuiteArray;
    }

    @Override
    public void chooseSuitesBundle(CoverageSuitesBundle suite) {
        if (this.c == suite && suite == null) {
            return;
        }
        if (this.q != null) {
            LocalFileSystem.getInstance().removeWatchedRoots(this.q);
            VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.a);
            this.q = null;
            this.i = null;
        }
        this.a(suite);
    }

    private void a(CoverageSuitesBundle coverageSuitesBundle) {
        o.assertTrue(!this.d.isDefault());
        this.fireBeforeSuiteChosen();
        this.j = false;
        if (this.c != null) {
            this.c.getCoverageEngine().getCoverageAnnotator(this.d).onSuiteChosen(coverageSuitesBundle);
        }
        this.c = coverageSuitesBundle;
        this.disposeAnnotators();
        if (coverageSuitesBundle == null) {
            this.triggerPresentationUpdate();
            return;
        }
        for (CoverageSuite coverageSuite : this.c.getSuites()) {
            boolean bl2 = coverageSuite.getCoverageDataFileProvider().ensureFileExists();
            if (bl2) continue;
            this.chooseSuitesBundle(null);
            return;
        }
        this.renewCoverageData(coverageSuitesBundle);
        this.fireAfterSuiteChosen();
    }

    @Override
    public void coverageGathered(@NotNull CoverageSuite suite) {
        if (suite == null) {
            CoverageDataManagerImpl.a(3);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            long l3 = r ^ 0x7896E587F8D2L;
            if (suite == null) {
                CoverageDataManagerImpl.a(12);
            }
            if (this.d.isDisposed()) {
                return;
            }
            if (this.c != null) {
                int n2;
                String[] stringArray;
                String string = CodeInsightBundle.message((String)"display.coverage.prompt", (Object[])new Object[]{suite.getPresentableName()});
                final CoverageOptionsProvider coverageOptionsProvider = CoverageOptionsProvider.getInstance(this.d);
                DialogWrapper.DoNotAskOption doNotAskOption = new DialogWrapper.DoNotAskOption(){
                    private static final long a = lb.a(2467295939095292015L, -5910172487188525515L, MethodHandles.lookup().lookupClass()).a(95432904636531L);

                    public boolean isToBeShown() {
                        return coverageOptionsProvider.getOptionToReplace() == 3;
                    }

                    public void setToBeShown(boolean value, int exitCode) {
                        coverageOptionsProvider.setOptionsToReplace(value ? 3 : exitCode);
                    }

                    public boolean canBeHidden() {
                        return true;
                    }

                    public boolean shouldSaveOptionsOnCancel() {
                        return true;
                    }

                    @NotNull
                    public String getDoNotShowMessage() {
                        long l3 = a ^ 0x2BB29F7FCC8CL;
                        String string = CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
                        if (string == null) {
                            3.a(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l3 = a ^ 0x7D945BA77A70L;
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/CoverageDataManagerImpl$3", "getDoNotShowMessage"));
                    }
                };
                if (this.c.getCoverageEngine() == suite.getCoverageEngine()) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = e;
                    stringArray2[1] = k;
                    stringArray = stringArray2;
                    stringArray2[2] = l;
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = e;
                    stringArray = stringArray3;
                    stringArray3[1] = l;
                }
                String[] stringArray4 = stringArray;
                int n3 = n2 = doNotAskOption.isToBeShown() ? Messages.showDialog((String)string, (String)CodeInsightBundle.message((String)"code.coverage", (Object[])new Object[0]), (String[])stringArray4, (int)1, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption) : coverageOptionsProvider.getOptionToReplace();
                if (n2 == 0) {
                    this.chooseSuitesBundle(new CoverageSuitesBundle(suite));
                } else if (n2 == 1) {
                    this.chooseSuitesBundle(new CoverageSuitesBundle((CoverageSuite[])ArrayUtil.append((Object[])this.c.getSuites(), (Object)suite)));
                }
            } else {
                this.chooseSuitesBundle(new CoverageSuitesBundle(suite));
            }
        });
    }

    @Override
    public void triggerPresentationUpdate() {
        this.b();
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.d.isDisposed()) {
                return;
            }
            ProjectView.getInstance((Project)this.d).refresh();
            CoverageViewManager.getInstance(this.d).setReady(true);
        });
    }

    @Override
    public void attachToProcess(@NotNull ProcessHandler handler, final @NotNull RunConfigurationBase configuration, final RunnerSettings runnerSettings) {
        if (handler == null) {
            CoverageDataManagerImpl.a(4);
        }
        if (configuration == null) {
            CoverageDataManagerImpl.a(5);
        }
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private static final long a = lb.a(-2198810626980094450L, -5090349056420374514L, MethodHandles.lookup().lookupClass()).a(95716957737673L);

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    4.a(0);
                }
                CoverageDataManagerImpl.this.processGatheredCoverage(configuration, runnerSettings);
            }

            private static /* synthetic */ void a(int n2) {
                long l3 = a ^ 0x477A6AFCB487L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/coverage/CoverageDataManagerImpl$4", "processTerminated"));
            }
        });
    }

    @Override
    public void processGatheredCoverage(@NotNull RunConfigurationBase configuration, RunnerSettings runnerSettings) {
        if (configuration == null) {
            CoverageDataManagerImpl.a(6);
        }
        if (runnerSettings instanceof CoverageRunnerData) {
            CoverageDataManagerImpl.processGatheredCoverage(configuration);
        }
    }

    public void addRootsToWatch(List<CoverageSuite> suites) {
        this.i = suites.stream().map(coverageSuite -> coverageSuite.getCoverageDataFileName()).collect(Collectors.toList());
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        this.i.forEach(string -> localFileSystem.refreshAndFindFileByPath(string));
        this.q = localFileSystem.addRootsToWatch(this.i, true);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.a);
    }

    public static void processGatheredCoverage(RunConfigurationBase configuration) {
        Project project = configuration.getProject();
        if (project.isDisposed()) {
            return;
        }
        CoverageDataManager coverageDataManager = CoverageDataManager.getInstance(project);
        CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate(configuration);
        CoverageSuite coverageSuite = coverageEnabledConfiguration.getCurrentCoverageSuite();
        if (coverageSuite != null) {
            ((BaseCoverageSuite)coverageSuite).setConfiguration(configuration);
            coverageDataManager.coverageGathered(coverageSuite);
        }
    }

    protected void renewCoverageData(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            CoverageDataManagerImpl.a(7);
        }
        if (this.c != null) {
            this.c.getCoverageEngine().getCoverageAnnotator(this.d).renewCoverageData(suite, this);
        }
    }

    private void b() {
        VirtualFile[] virtualFileArray;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.d);
        for (VirtualFile virtualFile : virtualFileArray = fileEditorManager.getOpenFiles()) {
            FileEditor[] fileEditorArray = fileEditorManager.getAllEditors(virtualFile);
            this.a(fileEditorArray, virtualFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(FileEditor[] fileEditorArray, VirtualFile virtualFile) {
        PsiFile psiFile = (PsiFile)this.doInReadActionIfProjectOpen(() -> PsiManager.getInstance((Project)this.d).findFile(virtualFile));
        if (psiFile != null && this.c != null && psiFile.isPhysical()) {
            SrcFileAnnotator srcFileAnnotator;
            Object object;
            Editor editor;
            CoverageEngine coverageEngine = this.c.getCoverageEngine();
            if (!coverageEngine.coverageEditorHighlightingApplicableTo(psiFile)) {
                return;
            }
            for (FileEditor fileEditor : fileEditorArray) {
                if (!(fileEditor instanceof TextEditor)) continue;
                editor = ((TextEditor)fileEditor).getEditor();
                object = this.f;
                synchronized (object) {
                    srcFileAnnotator = this.n.remove(editor);
                }
                if (srcFileAnnotator == null) break;
                Disposer.dispose((Disposable)srcFileAnnotator);
                break;
            }
            for (FileEditor fileEditor : fileEditorArray) {
                if (!(fileEditor instanceof TextEditor)) continue;
                editor = ((TextEditor)fileEditor).getEditor();
                srcFileAnnotator = this.getAnnotator(editor);
                if (srcFileAnnotator == null) {
                    srcFileAnnotator = new SrcFileAnnotator(psiFile, editor);
                    object = this.f;
                    synchronized (object) {
                        this.n.put(editor, srcFileAnnotator);
                    }
                }
                if (this.c == null || !coverageEngine.acceptedByFilters(psiFile, this.c)) continue;
                srcFileAnnotator.showCoverageInformation(this.c);
            }
        }
    }

    public void projectOpened() {
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)new CoverageEditorFactoryListener(), (Disposable)this.d);
        this.d.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){
            private static final long a = lb.a(-3912229107541931976L, -3735172495786679504L, MethodHandles.lookup().lookupClass()).a(31391124906881L);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    5.a(0);
                }
                if (project != CoverageDataManagerImpl.this.d) {
                    return;
                }
                Object object = CoverageDataManagerImpl.this.m;
                synchronized (object) {
                    CoverageDataManagerImpl.this.h = true;
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l3 = a ^ 0x69D7EE45C58CL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coverage/CoverageDataManagerImpl$5", "projectClosing"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T doInReadActionIfProjectOpen(Computable<T> computation) {
        Object object = this.m;
        synchronized (object) {
            if (this.h) {
                return null;
            }
        }
        return (T)ApplicationManager.getApplication().runReadAction(computation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectSubCoverage(@NotNull CoverageSuitesBundle suite, List<String> testNames) {
        String string;
        int n2;
        Object object;
        Object object2;
        File file;
        Object object3;
        long l3 = r ^ 0x7BD0DA8F40DFL;
        if (suite == null) {
            CoverageDataManagerImpl.a(8);
        }
        suite.restoreCoverageData();
        ProjectData projectData = suite.getCoverageData();
        if (projectData == null) {
            return;
        }
        this.j = true;
        HashMap hashMap = new HashMap();
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            object3 = coverageSuite.getCoverageDataFileName();
            file = this.a((String)object3);
            for (String string2 : testNames) {
                object2 = new File(file, FileUtil.sanitizeFileName((String)string2) + ".tr");
                if (!object2.exists()) continue;
                object = null;
                try {
                    object = new DataInputStream(new FileInputStream((File)object2));
                    int n3 = ((DataInputStream)object).readInt();
                    for (n2 = 0; n2 < n3; ++n2) {
                        string = ((DataInputStream)object).readUTF();
                        int n4 = ((DataInputStream)object).readInt();
                        HashSet<Integer> hashSet = (HashSet<Integer>)hashMap.get(string);
                        if (hashSet == null) {
                            hashSet = new HashSet<Integer>();
                            hashMap.put(string, hashSet);
                        }
                        for (int i10 = 0; i10 < n4; ++i10) {
                            hashSet.add(((DataInputStream)object).readInt());
                        }
                    }
                }
                catch (Exception exception) {
                    o.error((Throwable)exception);
                }
                finally {
                    try {
                        ((FilterInputStream)object).close();
                    }
                    catch (IOException iOException) {
                        o.error((Throwable)iOException);
                    }
                }
            }
        }
        ProjectData projectData2 = new ProjectData();
        for (String string3 : hashMap.keySet()) {
            CoverageSuite coverageSuite;
            coverageSuite = projectData2.getClassData(string3);
            if (coverageSuite == null) {
                coverageSuite = projectData2.getOrCreateClassData(string3);
            }
            object3 = (Set)hashMap.get(string3);
            file = projectData.getClassData(string3);
            o.assertTrue(file != null, (Object)("missed className: \"" + string3 + "\""));
            Object[] objectArray = file.getLines();
            o.assertTrue(objectArray != null);
            int n5 = objectArray.length;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Integer)object2.next();
                if ((Integer)object < n5) continue;
                n5 = (Integer)object + 1;
            }
            object2 = new LineData[n5];
            object = object3.iterator();
            while (object.hasNext()) {
                LineData lineData;
                Integer n6 = (Integer)object.next();
                n2 = n6 - 1;
                string = null;
                if (n2 < file.getLines().length && (lineData = file.getLineData(n2)) != null) {
                    string = lineData.getMethodSignature();
                }
                lineData = new LineData(n2, string);
                if (string != null) {
                    coverageSuite.registerMethodSignature(lineData);
                }
                lineData.setStatus((byte)2);
                object2[n2] = lineData;
            }
            coverageSuite.setLines((LineData[])object2);
        }
        suite.setCoverageData(projectData2);
        this.renewCoverageData(suite);
    }

    private File a(String string) {
        return new File(new File(string).getParentFile(), FileUtil.getNameWithoutExtension((File)new File(string)));
    }

    @Override
    public void restoreMergedCoverage(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            CoverageDataManagerImpl.a(9);
        }
        this.j = false;
        suite.restoreCoverageData();
        this.renewCoverageData(suite);
    }

    @Override
    public void addSuiteListener(final CoverageSuiteListener listener, Disposable parentDisposable) {
        this.b.add(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                CoverageDataManagerImpl.this.b.remove(listener);
            }
        });
    }

    public void fireBeforeSuiteChosen() {
        for (CoverageSuiteListener coverageSuiteListener : this.b) {
            coverageSuiteListener.beforeSuiteChosen();
        }
    }

    public void fireAfterSuiteChosen() {
        for (CoverageSuiteListener coverageSuiteListener : this.b) {
            coverageSuiteListener.afterSuiteChosen();
        }
    }

    @Override
    public boolean isSubCoverageActive() {
        return this.j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SrcFileAnnotator getAnnotator(Editor editor) {
        Object object = this.f;
        synchronized (object) {
            return this.n.get(editor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAnnotators() {
        Object object = this.f;
        synchronized (object) {
            for (SrcFileAnnotator srcFileAnnotator : this.n.values()) {
                if (srcFileAnnotator == null) continue;
                Disposer.dispose((Disposable)srcFileAnnotator);
            }
            this.n.clear();
        }
    }

    @NotNull
    private CoverageSuite a(CoverageEnabledConfiguration coverageEnabledConfiguration, String string, CoverageRunner coverageRunner, DefaultCoverageFileProvider defaultCoverageFileProvider) {
        CoverageEngine coverageEngine;
        long l3 = r ^ 0xE923691E083L;
        CoverageSuite coverageSuite = null;
        CoverageEngine[] coverageEngineArray = (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions();
        int n2 = coverageEngineArray.length;
        for (int i10 = 0; !(i10 >= n2 || coverageRunner.acceptsCoverageEngine(coverageEngine = coverageEngineArray[i10]) && coverageEngine.isApplicableTo(coverageEnabledConfiguration.getConfiguration()) && (coverageSuite = coverageEngine.createCoverageSuite(coverageRunner, string, defaultCoverageFileProvider, coverageEnabledConfiguration)) != null); ++i10) {
        }
        o.assertTrue(coverageSuite != null, (Object)("Cannot create coverage suite for runner: " + coverageRunner.getPresentableName()));
        CoverageSuite coverageSuite2 = coverageSuite;
        if (coverageSuite2 == null) {
            CoverageDataManagerImpl.a(10);
        }
        return coverageSuite2;
    }

    @NotNull
    private CoverageSuite a(CoverageRunner coverageRunner, String string, CoverageFileProvider coverageFileProvider, String[] stringArray, long l3, String string2, boolean bl2, boolean bl3) {
        CoverageEngine coverageEngine;
        long l4 = r ^ 0x5C89061AE46CL;
        CoverageSuite coverageSuite = null;
        CoverageEngine[] coverageEngineArray = (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions();
        int n2 = coverageEngineArray.length;
        for (int i10 = 0; !(i10 >= n2 || coverageRunner.acceptsCoverageEngine(coverageEngine = coverageEngineArray[i10]) && (coverageSuite = coverageEngine.createCoverageSuite(coverageRunner, string, coverageFileProvider, stringArray, l3, string2, bl2, bl3, false, this.d)) != null); ++i10) {
        }
        o.assertTrue(coverageSuite != null, (Object)("Cannot create coverage suite for runner: " + coverageRunner.getPresentableName()));
        CoverageSuite coverageSuite2 = coverageSuite;
        if (coverageSuite2 == null) {
            CoverageDataManagerImpl.a(11);
        }
        return coverageSuite2;
    }

    static {
        r = lb.a(547351350863278213L, -7438929462423249227L, MethodHandles.lookup().lookupClass()).a(163414458100738L);
        o = Logger.getInstance(CoverageDataManagerImpl.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l3 = r ^ 0x2FC927C90A9AL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageDataManagerImpl";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuites";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCoverageSuite";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "coverageGathered";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processGatheredCoverage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "renewCoverageData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectSubCoverage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "restoreMergedCoverage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$coverageGathered$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CoverageEditorFactoryListener
    implements EditorFactoryListener {
        private final Alarm b;
        private final Map<Editor, Runnable> a;
        private static final long c = lb.a(-8487467265141198393L, -6738317626612002422L, MethodHandles.lookup().lookupClass()).a(88739256072628L);

        private CoverageEditorFactoryListener() {
            this.b = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)CoverageDataManagerImpl.this.d);
            this.a = new HashMap<Editor, Runnable>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editorCreated(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                CoverageEditorFactoryListener.a(0);
            }
            Object object = CoverageDataManagerImpl.this.m;
            synchronized (object) {
                if (CoverageDataManagerImpl.this.h) {
                    return;
                }
            }
            object = event.getEditor();
            if (object.getProject() != CoverageDataManagerImpl.this.d) {
                return;
            }
            PsiFile psiFile = (PsiFile)ReadAction.compute(() -> this.a((Editor)object));
            if (psiFile != null && CoverageDataManagerImpl.this.c != null && psiFile.isPhysical()) {
                CoverageEngine coverageEngine = CoverageDataManagerImpl.this.c.getCoverageEngine();
                if (!coverageEngine.coverageEditorHighlightingApplicableTo(psiFile)) {
                    return;
                }
                SrcFileAnnotator srcFileAnnotator = CoverageDataManagerImpl.this.getAnnotator((Editor)object);
                if (srcFileAnnotator == null) {
                    srcFileAnnotator = new SrcFileAnnotator(psiFile, (Editor)object);
                }
                SrcFileAnnotator srcFileAnnotator2 = srcFileAnnotator;
                Object object2 = CoverageDataManagerImpl.this.f;
                synchronized (object2) {
                    CoverageDataManagerImpl.this.n.put(object, srcFileAnnotator2);
                }
                object2 = () -> {
                    if (CoverageDataManagerImpl.this.d.isDisposed()) {
                        return;
                    }
                    if (CoverageDataManagerImpl.this.c != null && coverageEngine.acceptedByFilters(psiFile, CoverageDataManagerImpl.this.c)) {
                        srcFileAnnotator2.showCoverageInformation(CoverageDataManagerImpl.this.c);
                    }
                };
                this.a.put((Editor)object, (Runnable)object2);
                this.b.addRequest((Runnable)object2, 100);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Object object;
            Editor editor;
            if (event == null) {
                CoverageEditorFactoryListener.a(1);
            }
            if ((editor = event.getEditor()).getProject() != CoverageDataManagerImpl.this.d) {
                return;
            }
            try {
                Object object2 = CoverageDataManagerImpl.this.f;
                synchronized (object2) {
                    object = (SrcFileAnnotator)CoverageDataManagerImpl.this.n.remove(editor);
                }
                if (object != null) {
                    Disposer.dispose((Disposable)object);
                }
            }
            finally {
                object = this.a.remove(editor);
                if (object != null) {
                    this.b.cancelRequest((Runnable)object);
                }
            }
        }

        private /* synthetic */ PsiFile a(Editor editor) throws RuntimeException {
            if (CoverageDataManagerImpl.this.d.isDisposed()) {
                return null;
            }
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)CoverageDataManagerImpl.this.d);
            Document document = editor.getDocument();
            return psiDocumentManager.getPsiFile(document);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l3 = c ^ 0x19A362B70142L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl$CoverageEditorFactoryListener";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

