/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.refactoring;

import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import java.util.Objects;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.entities.Angular2Pipe;
import org.angular2.lang.Angular2LangUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2PipeRenameProcessor
extends JSDefaultRenameProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            Angular2PipeRenameProcessor.$$$reportNull$$$0(0);
        }
        return Angular2EntitiesProvider.getPipe(element) != null && Angular2LangUtil.isAngular2Context(element);
    }

    public boolean isInplaceRenameSupported() {
        return false;
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            Angular2PipeRenameProcessor.$$$reportNull$$$0(1);
        }
        return Objects.requireNonNull(Angular2EntitiesProvider.getPipe(element)).getSourceElement();
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        ES6Decorator decorator;
        JSProperty property;
        if (element == null) {
            Angular2PipeRenameProcessor.$$$reportNull$$$0(2);
        }
        if (newName == null) {
            Angular2PipeRenameProcessor.$$$reportNull$$$0(3);
        }
        if (usages == null) {
            Angular2PipeRenameProcessor.$$$reportNull$$$0(4);
        }
        if (element instanceof JSImplicitElement && element.getParent() instanceof TypeScriptClass && (property = Angular2DecoratorUtil.getProperty(decorator = Angular2DecoratorUtil.findDecorator((JSAttributeListOwner)((TypeScriptClass)element.getParent()), "Pipe"), "name")) != null && property.getValue() instanceof JSLiteralExpression) {
            PsiReference[] refs;
            for (PsiReference ref : refs = property.getValue().getReferences()) {
                if (ref.resolve() != element) continue;
                ref.handleElementRename(newName);
            }
        }
        RenameUtil.doRenameGenericNamedElement((PsiElement)element, (String)newName, (UsageInfo[])usages, (RefactoringElementListener)listener);
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        if (project == null) {
            Angular2PipeRenameProcessor.$$$reportNull$$$0(5);
        }
        if (element == null) {
            Angular2PipeRenameProcessor.$$$reportNull$$$0(6);
        }
        RenameDialog renameDialog = super.createRenameDialog(project, Objects.requireNonNull(Angular2EntitiesProvider.getPipe(element)).getSourceElement(), nameSuggestionContext, editor);
        if (renameDialog == null) {
            Angular2PipeRenameProcessor.$$$reportNull$$$0(7);
        }
        return renameDialog;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            Angular2PipeRenameProcessor.$$$reportNull$$$0(8);
        }
        if (newName == null) {
            Angular2PipeRenameProcessor.$$$reportNull$$$0(9);
        }
        if (allRenames == null) {
            Angular2PipeRenameProcessor.$$$reportNull$$$0(10);
        }
        assert (element instanceof JSImplicitElement);
        Angular2Pipe metadata = Angular2EntitiesProvider.getPipe(element);
        if (metadata != null && metadata.getTypeScriptClass() != null) {
            TypeScriptClass pipeClass = metadata.getTypeScriptClass();
            allRenames.put((PsiElement)pipeClass, Angular2PipeRenameProcessor.getDefaultPipeClassName(newName));
            if (pipeClass.getContainingFile().getName().equals(Angular2PipeRenameProcessor.getDefaultPipeFileName(((JSImplicitElement)element).getName()))) {
                PsiFile specPsiFile;
                allRenames.put((PsiElement)pipeClass.getContainingFile(), Angular2PipeRenameProcessor.getDefaultPipeFileName(newName));
                VirtualFile specFile = pipeClass.getContainingFile().getVirtualFile().getParent().findFileByRelativePath(Angular2PipeRenameProcessor.getDefaultPipeSpecFileName(((JSImplicitElement)element).getName()));
                if (specFile != null && (specPsiFile = pipeClass.getManager().findFile(specFile)) != null) {
                    allRenames.put((PsiElement)specPsiFile, Angular2PipeRenameProcessor.getDefaultPipeSpecFileName(newName));
                }
            }
        }
    }

    private static String getDefaultPipeFileName(String pipeName) {
        return pipeName + ".pipe.ts";
    }

    private static String getDefaultPipeSpecFileName(String pipeName) {
        return pipeName + ".pipe.spec.ts";
    }

    private static String getDefaultPipeClassName(String pipeName) {
        return StringUtil.capitalize((String)pipeName) + "Pipe";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/refactoring/Angular2PipeRenameProcessor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/refactoring/Angular2PipeRenameProcessor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenameDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

