/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CompactActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomePopupAction;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.mac.touchbar.ItemsContainer;
import com.intellij.ui.mac.touchbar.TBItemAnActionButton;
import com.intellij.ui.mac.touchbar.TBItemButton;
import com.intellij.ui.mac.touchbar.TBItemGroup;
import com.intellij.ui.mac.touchbar.TBItemScrubber;
import com.intellij.ui.mac.touchbar.TouchBar;
import com.intellij.ui.mac.touchbar.Utils;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuildUtils {
    private static final Logger LOG = Logger.getInstance(Utils.class);
    private static final String DIALOG_ACTIONS_CONTEXT = "DialogWrapper.touchbar.actions";
    private static final String ourSmallSeparatorText = "type.small";
    private static final String ourLargeSeparatorText = "type.large";
    private static final String ourFlexibleSeparatorText = "type.flexible";
    private static final int BUTTON_MIN_WIDTH_DLG = 107;
    private static final int BUTTON_BORDER = 16;
    private static final int BUTTON_IMAGE_MARGIN = 2;

    BuildUtils() {
    }

    static void addActionGroupButtons(@NotNull TouchBar out, @NotNull ActionGroup actionGroup, @Nullable String filterGroupPrefix, @Nullable Customizer customizer) {
        if (out == null) {
            BuildUtils.$$$reportNull$$$0(0);
        }
        if (actionGroup == null) {
            BuildUtils.$$$reportNull$$$0(1);
        }
        BuildUtils._traverse(actionGroup, new GroupVisitor(out, filterGroupPrefix, customizer));
        if (customizer != null) {
            customizer.finish();
        }
    }

    static ActionGroup getCustomizedGroup(@NotNull String barId) {
        if (barId == null) {
            BuildUtils.$$$reportNull$$$0(2);
        }
        ActionGroup actGroup = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("TouchBar");
        AnAction[] kids = actGroup.getChildren(null);
        String childGroupId = barId.startsWith("TouchBar") ? barId : "TouchBar" + barId;
        for (AnAction act : kids) {
            if (!(act instanceof ActionGroup)) continue;
            String gid = BuildUtils.getActionId(act);
            if (gid == null || gid.isEmpty()) {
                LOG.error("unregistered ActionGroup: " + act);
                continue;
            }
            if (!gid.equals(childGroupId)) continue;
            return (ActionGroup)act;
        }
        return null;
    }

    static Map<String, ActionGroup> getAltLayouts(@NotNull ActionGroup context) {
        AnAction[] kids;
        String ctxId;
        if (context == null) {
            BuildUtils.$$$reportNull$$$0(3);
        }
        if ((ctxId = BuildUtils.getActionId((AnAction)context)) == null || ctxId.isEmpty()) {
            LOG.error("can't load alt-layout for unregistered ActionGroup: " + context);
            return null;
        }
        HashMap<String, ActionGroup> result2 = new HashMap<String, ActionGroup>();
        for (AnAction act : kids = context.getChildren(null)) {
            if (!(act instanceof ActionGroup)) continue;
            String gid = BuildUtils.getActionId(act);
            if (gid == null || gid.isEmpty()) {
                LOG.info("skip loading alt-layout for unregistered ActionGroup: " + act + ", child of " + context);
                continue;
            }
            if (!gid.startsWith(ctxId + "_")) continue;
            result2.put(gid.substring(ctxId.length() + 1), (ActionGroup)act);
        }
        return result2;
    }

    static void addDialogButtons(final @NotNull TouchBar out, @Nullable Map<TouchbarDataKeys.DlgButtonDesc, JButton> unorderedButtons, @Nullable Map<Component, ActionGroup> actions) {
        if (out == null) {
            BuildUtils.$$$reportNull$$$0(4);
        }
        ModalityState ms = Utils.getCurrentModalityState();
        boolean hasSouthPanelButtons = unorderedButtons != null && !unorderedButtons.isEmpty();
        final byte[] prio = new byte[]{-1};
        if (hasSouthPanelButtons) {
            for (JButton jb : unorderedButtons.values()) {
                JBOptionButton ob;
                Action[] opts;
                TBItemButton tbb = null;
                if (jb instanceof JBOptionButton && (opts = (ob = (JBOptionButton)jb).getOptions()) != null) {
                    for (Action a : opts) {
                        AnAction anAct;
                        if (a == null || (anAct = BuildUtils._createAnAction(a, (JButton)ob, true)) == null) continue;
                        prio[0] = (byte)(prio[0] - 1);
                        tbb = out.addAnActionButton(anAct).setShowMode(1).setModality(ms).setComponent((Component)ob).setPriority(prio[0]);
                    }
                }
                if (tbb == null) continue;
                BuildUtils._setDialogLayout(tbb);
            }
        }
        if (actions != null && !actions.isEmpty()) {
            final ActionGroup ag = actions.values().iterator().next();
            TouchbarDataKeys.ActionDesc groupDesc = (TouchbarDataKeys.ActionDesc)ag.getTemplatePresentation().getClientProperty(TouchbarDataKeys.ACTIONS_DESCRIPTOR_KEY);
            if (!hasSouthPanelButtons || groupDesc != null && groupDesc.isCombineWithDlgButtons()) {
                final Customizer customizer = new Customizer(groupDesc, ms){

                    @Override
                    public void process(@NotNull INodeInfo ni, @NotNull TBItemAnActionButton butt) {
                        if (ni == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (butt == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        super.process(ni, butt);
                        prio[0] = (byte)(prio[0] - 1);
                        butt.setPriority(prio[0]);
                        butt.myOptionalContextName = BuildUtils.DIALOG_ACTIONS_CONTEXT;
                        if (ni.getParentDesc() != null && !ni.getParentDesc().isShowImage()) {
                            butt.setShowMode(1);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "ni";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "butt";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/ui/mac/touchbar/BuildUtils$1";
                        objectArray[2] = "process";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                TouchBar.addActionGroup(out, ag, customizer);
                ag.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (!"DefaultActionGroup.children".equals(evt.getPropertyName())) {
                            return;
                        }
                        AnAction[] prevArr = (AnAction[])evt.getOldValue();
                        AnAction[] currArr = (AnAction[])evt.getNewValue();
                        ArrayList prev2 = new ArrayList();
                        for (AnAction act : prevArr) {
                            BuildUtils._collectActions(act, prev2);
                        }
                        ArrayList curr = new ArrayList();
                        for (AnAction act : currArr) {
                            BuildUtils._collectActions(act, curr);
                        }
                        if (prev2 != null && !prev2.isEmpty()) {
                            if (curr != null && !curr.isEmpty()) {
                                if (curr.size() != prev2.size()) {
                                    out.getItemsContainer().remove(tbi -> BuildUtils.DIALOG_ACTIONS_CONTEXT.equals(tbi.myOptionalContextName));
                                    TouchBar.addActionGroup(out, ag, customizer);
                                } else {
                                    out.getItemsContainer().forEachDeep(tbi -> {
                                        if (!(tbi instanceof TBItemAnActionButton)) {
                                            return;
                                        }
                                        TBItemAnActionButton butt = (TBItemAnActionButton)tbi;
                                        int prevIndex = prev2.indexOf(butt.getAnAction());
                                        if (prevIndex == -1) {
                                            return;
                                        }
                                        AnAction newAct = (AnAction)curr.get(prevIndex);
                                        butt.setAnAction(newAct);
                                    });
                                }
                            } else {
                                out.getItemsContainer().remove(tbi -> tbi instanceof TBItemAnActionButton && prev2.indexOf(((TBItemAnActionButton)tbi).getAnAction()) != -1);
                            }
                        } else {
                            if (curr == null || curr.isEmpty()) {
                                return;
                            }
                            TouchBar.addActionGroup(out, ag, customizer);
                        }
                        out.updateActionItems();
                    }
                });
            }
        }
        if (hasSouthPanelButtons) {
            TBItemGroup gr = out.addGroup();
            ItemsContainer group = gr.getContainer();
            List<TouchbarDataKeys.DlgButtonDesc> ordered = BuildUtils._extractOrderedButtons(unorderedButtons);
            for (TouchbarDataKeys.DlgButtonDesc desc : ordered) {
                TBItemButton tBItemButton;
                JButton jb = unorderedButtons.get(desc);
                AnAction anAct = BuildUtils._createAnAction(jb.getAction(), jb, false);
                if (anAct == null) continue;
                if (desc.isMainGroup()) {
                    tBItemButton = group.addAnActionButton(anAct).setShowMode(1).setModality(ms).setComponent(jb);
                } else {
                    prio[0] = (byte)(prio[0] - 1);
                    tBItemButton = out.addAnActionButton(anAct, gr).setShowMode(1).setModality(ms).setComponent(jb).setPriority(prio[0]);
                }
                TBItemAnActionButton tbb = tBItemButton;
                boolean isDefault = desc.isDefault();
                if (!isDefault) {
                    boolean bl = jb.getAction() != null ? jb.getAction().getValue("DefaultAction") != null : (isDefault = jb.isDefaultButton());
                }
                if (isDefault) {
                    tbb.setColored(true);
                }
                BuildUtils._setDialogLayout(tbb);
            }
            out.selectVisibleItemsToShow();
            out.setPrincipal(gr);
        }
    }

    static TouchBar createScrubberBarFromPopup(@NotNull ListPopupImpl listPopup) {
        if (listPopup == null) {
            BuildUtils.$$$reportNull$$$0(5);
        }
        TouchBar result2 = new TouchBar("popup_scrubber_bar" + listPopup, true, false, true);
        Application app = ApplicationManager.getApplication();
        ModalityStateEx ms = app != null ? LaterInvocator.getCurrentModalityState() : null;
        TBItemScrubber scrub = result2.addScrubber();
        ListPopupStep<Object> listPopupStep = listPopup.getListStep();
        List stepValues = listPopupStep.getValues();
        for (Object obj : stepValues) {
            Icon ic = listPopupStep.getIconFor(obj);
            String txt = listPopupStep.getTextFor(obj);
            if (listPopupStep.isMnemonicsNavigationEnabled()) {
                int pos;
                MnemonicNavigationFilter filter = listPopupStep.getMnemonicNavigationFilter();
                int n = pos = filter == null ? -1 : filter.getMnemonicPos(obj);
                if (pos != -1) {
                    txt = txt.substring(0, pos) + txt.substring(pos + 1);
                }
            }
            Runnable edtAction = () -> {
                if (listPopup == null) {
                    BuildUtils.$$$reportNull$$$0(12);
                }
                if (stepValues == null) {
                    BuildUtils.$$$reportNull$$$0(13);
                }
                if (obj != null) {
                    listPopup.getList().setSelectedValue(obj, false);
                } else {
                    listPopup.getList().setSelectedIndex(stepValues.indexOf(obj));
                }
                listPopup.handleSelect(true);
            };
            Runnable action = () -> {
                if (app == null) {
                    SwingUtilities.invokeLater(edtAction);
                } else {
                    app.invokeLater(edtAction, ms);
                }
            };
            scrub.addItem(ic, txt, action);
        }
        result2.selectVisibleItemsToShow();
        return result2;
    }

    static TouchBar createStopRunningBar(List<? extends Pair<RunContentDescriptor, Runnable>> stoppableDescriptors) {
        TouchBar tb = new TouchBar("select_running_configuration_to_stop", true, true, true);
        tb.addButton().setText("Stop All").setActionOnEDT(() -> stoppableDescriptors.forEach(pair -> ((Runnable)pair.second).run()));
        TBItemScrubber stopScrubber = tb.addScrubber();
        for (Pair<RunContentDescriptor, Runnable> pair : stoppableDescriptors) {
            stopScrubber.addItem(((RunContentDescriptor)pair.first).getIcon(), ((RunContentDescriptor)pair.first).getDisplayName(), (Runnable)pair.second);
        }
        tb.selectVisibleItemsToShow();
        return tb;
    }

    @Nullable
    static String getActionId(AnAction act) {
        if (ApplicationManager.getApplication() == null) {
            return null;
        }
        return ActionManager.getInstance().getId((AnAction)(act instanceof CustomisedActionGroup ? ((CustomisedActionGroup)act).getOrigin() : act));
    }

    private static void _setDialogLayout(TBItemButton button) {
        if (button == null) {
            return;
        }
        button.setLayout(107, 32768, 2, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _traverse(@NotNull ActionGroup group, @NotNull GroupVisitor visitor) {
        String groupId;
        if (group == null) {
            BuildUtils.$$$reportNull$$$0(6);
        }
        if (visitor == null) {
            BuildUtils.$$$reportNull$$$0(7);
        }
        if ((groupId = BuildUtils.getActionId((AnAction)group)) == null) {
            groupId = "unregistered";
        }
        AnAction[] children2 = group.getChildren(null);
        for (int i = 0; i < children2.length; ++i) {
            AnAction child2 = children2[i];
            if (child2 == null) {
                LOG.error(String.format("action is null: i=%d, group='%s', group id='%s'", i, group.toString(), groupId));
                continue;
            }
            if (child2 instanceof ActionGroup) {
                ActionGroup childGroup = (ActionGroup)child2;
                boolean visitNode = visitor.enterNode(childGroup);
                if (!visitNode) continue;
                try {
                    if (childGroup.isPopup()) {
                        visitor.visitLeaf(child2);
                        continue;
                    }
                    BuildUtils._traverse((ActionGroup)child2, visitor);
                    continue;
                }
                finally {
                    visitor.leaveNode(childGroup);
                }
            }
            visitor.visitLeaf(child2);
        }
    }

    private static AnAction _createAnAction(final @Nullable Action action, final @NotNull JButton fromButton, final boolean useTextFromAction) {
        Object anAct;
        if (fromButton == null) {
            BuildUtils.$$$reportNull$$$0(8);
        }
        Object object = anAct = action == null ? null : action.getValue("AnAction");
        if (anAct == null) {
            return new DumbAwareAction(){
                {
                    this.setEnabledInModalContext(true);
                    if (useTextFromAction) {
                        Object name = action == null ? fromButton.getText() : action.getValue("Name");
                        this.getTemplatePresentation().setText(name instanceof String ? (String)name : "");
                    }
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (action == null) {
                        fromButton.doClick();
                        return;
                    }
                    action.actionPerformed(new ActionEvent(fromButton, 1001, null));
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    e.getPresentation().setEnabled(action == null ? fromButton.isEnabled() : action.isEnabled());
                    if (!useTextFromAction) {
                        e.getPresentation().setText((String)DialogWrapper.extractMnemonic((String)fromButton.getText()).second);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/ui/mac/touchbar/BuildUtils$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "update";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        if (!(anAct instanceof AnAction)) {
            return null;
        }
        return (AnAction)anAct;
    }

    @Nullable
    private static List<TouchbarDataKeys.DlgButtonDesc> _extractOrderedButtons(@NotNull Map<TouchbarDataKeys.DlgButtonDesc, JButton> unorderedButtons) {
        if (unorderedButtons == null) {
            BuildUtils.$$$reportNull$$$0(9);
        }
        if (unorderedButtons.isEmpty()) {
            return null;
        }
        ArrayList<TouchbarDataKeys.DlgButtonDesc> main = new ArrayList<TouchbarDataKeys.DlgButtonDesc>();
        ArrayList<TouchbarDataKeys.DlgButtonDesc> secondary = new ArrayList<TouchbarDataKeys.DlgButtonDesc>();
        for (Map.Entry<TouchbarDataKeys.DlgButtonDesc, JButton> entry : unorderedButtons.entrySet()) {
            TouchbarDataKeys.DlgButtonDesc jbdesc = entry.getKey();
            if (jbdesc == null) continue;
            if (jbdesc.isMainGroup()) {
                main.add(jbdesc);
                continue;
            }
            secondary.add(jbdesc);
        }
        Comparator<TouchbarDataKeys.DlgButtonDesc> cmp = Comparator.comparingInt(TouchbarDataKeys.DlgButtonDesc::getOrder);
        main.sort(cmp);
        secondary.sort(cmp);
        return ContainerUtil.concat(secondary, main);
    }

    private static void _collectActions(@NotNull AnAction act, @NotNull List<? super AnAction> out) {
        if (act == null) {
            BuildUtils.$$$reportNull$$$0(10);
        }
        if (out == null) {
            BuildUtils.$$$reportNull$$$0(11);
        }
        if (act instanceof ActionGroup) {
            AnAction[] children2;
            ActionGroup group = (ActionGroup)act;
            for (AnAction child2 : children2 = group.getChildren(null)) {
                if (child2 == null) continue;
                if (child2 instanceof ActionGroup) {
                    ActionGroup childGroup = (ActionGroup)child2;
                    BuildUtils._collectActions((AnAction)childGroup, out);
                    continue;
                }
                out.add((AnAction)child2);
            }
        } else {
            out.add((AnAction)act);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "barId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listPopup";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromButton";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unorderedButtons";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "act";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepValues";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/mac/touchbar/BuildUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addActionGroupButtons";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomizedGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAltLayouts";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addDialogButtons";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createScrubberBarFromPopup";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "_traverse";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "_createAnAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "_extractOrderedButtons";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "_collectActions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createScrubberBarFromPopup$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class Customizer {
        private final int myShowMode;
        @Nullable
        private final ModalityState myModality;
        private TBItemAnActionButton myRunConfigurationButton;
        private List<TBItemAnActionButton> myRunnerButtons;

        Customizer(int showMode, @Nullable ModalityState modality) {
            this.myShowMode = showMode;
            this.myModality = modality;
        }

        Customizer(@Nullable TouchbarDataKeys.ActionDesc groupDesc, @Nullable ModalityState modality) {
            this.myShowMode = groupDesc == null || !groupDesc.isShowText() ? 3 : 2;
            this.myModality = modality;
        }

        Customizer() {
            this.myShowMode = 3;
            this.myModality = null;
        }

        void process(@NotNull INodeInfo ni, @NotNull TBItemAnActionButton butt) {
            if (ni == null) {
                Customizer.$$$reportNull$$$0(0);
            }
            if (butt == null) {
                Customizer.$$$reportNull$$$0(1);
            }
            String actId = BuildUtils.getActionId(butt.getAnAction());
            boolean isRunConfigPopover = "RunConfiguration".equals(actId);
            boolean isOpenInTerminalAction = "Terminal.OpenInTerminal".equals(actId);
            TouchbarDataKeys.ActionDesc pd = ni.getParentDesc();
            int nodeMode = pd != null && pd.isShowText() ? 2 : this.myShowMode;
            int mode = isRunConfigPopover || isOpenInTerminalAction ? 2 : nodeMode;
            butt.setShowMode(mode).setModality(this.myModality);
            if (ni.isParentCompact()) {
                butt.setHiddenWhenDisabled(true);
            }
            if (isRunConfigPopover) {
                this.myRunConfigurationButton = butt;
            } else if (butt.getAnAction() instanceof WelcomePopupAction) {
                butt.setHasArrowIcon(true);
            } else if ("RunnerActionsTouchbar".equals(ni.getParentGroupID()) || "Stop".equals(actId)) {
                if (this.myRunnerButtons == null) {
                    this.myRunnerButtons = new ArrayList<TBItemAnActionButton>();
                }
                this.myRunnerButtons.add(butt);
            }
            TouchbarDataKeys.ActionDesc actionDesc = (TouchbarDataKeys.ActionDesc)butt.getAnAction().getTemplatePresentation().getClientProperty(TouchbarDataKeys.ACTIONS_DESCRIPTOR_KEY);
            if (actionDesc != null && actionDesc.getContextComponent() != null) {
                butt.setComponent(actionDesc.getContextComponent());
            }
        }

        void finish() {
            if (this.myRunConfigurationButton != null && this.myRunnerButtons != null && !this.myRunnerButtons.isEmpty()) {
                this.myRunConfigurationButton.setLinkedButtons(this.myRunnerButtons);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ni";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "butt";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/mac/touchbar/BuildUtils$Customizer";
            objectArray[2] = "process";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface INodeInfo {
        public boolean isParentCompact();

        public String getParentGroupID();

        public TouchbarDataKeys.ActionDesc getParentDesc();
    }

    static class GroupVisitor
    implements INodeInfo {
        @NotNull
        private final TouchBar myOut;
        @Nullable
        private final String myFilterByPrefix;
        @Nullable
        private final Customizer myCustomizer;
        private int mySeparatorCounter;
        private final LinkedList<InternalNode> myNodePath;

        GroupVisitor(@NotNull TouchBar out, @Nullable String filterByPrefix, @Nullable Customizer customizer) {
            if (out == null) {
                GroupVisitor.$$$reportNull$$$0(0);
            }
            this.mySeparatorCounter = 0;
            this.myNodePath = new LinkedList();
            this.myOut = out;
            this.myFilterByPrefix = filterByPrefix;
            this.myCustomizer = customizer;
        }

        boolean enterNode(@NotNull ActionGroup groupNode) {
            if (groupNode == null) {
                GroupVisitor.$$$reportNull$$$0(1);
            }
            String groupName = BuildUtils.getActionId((AnAction)groupNode);
            if (this.myFilterByPrefix != null && groupName != null && groupName.startsWith(this.myFilterByPrefix)) {
                return false;
            }
            TouchbarDataKeys.ActionDesc groupDesc = (TouchbarDataKeys.ActionDesc)groupNode.getTemplatePresentation().getClientProperty(TouchbarDataKeys.ACTIONS_DESCRIPTOR_KEY);
            InternalNode node = new InternalNode(groupNode, groupName, groupDesc);
            if (groupDesc != null && groupDesc.isMainGroup()) {
                TBItemGroup group = this.myOut.addGroup();
                node.groupContainer = group.getContainer();
                this.myOut.setPrincipal(group);
            }
            this.myNodePath.add(node);
            return true;
        }

        void visitLeaf(AnAction act) {
            ItemsContainer out = this._getParentContainer();
            if (out == null) {
                out = this.myOut.getItemsContainer();
            }
            if (act instanceof Separator) {
                Separator sep = (Separator)act;
                int increment = 1;
                if (sep.getText() != null) {
                    if (sep.getText().equals(BuildUtils.ourSmallSeparatorText)) {
                        out.addSpacing(false);
                    } else if (sep.getText().equals(BuildUtils.ourLargeSeparatorText)) {
                        out.addSpacing(true);
                    } else if (sep.getText().equals(BuildUtils.ourFlexibleSeparatorText)) {
                        out.addFlexibleSpacing();
                    }
                } else {
                    this.mySeparatorCounter += increment;
                }
                return;
            }
            if (this.mySeparatorCounter > 0) {
                if (this.mySeparatorCounter == 1) {
                    out.addSpacing(false);
                } else if (this.mySeparatorCounter == 2) {
                    out.addSpacing(true);
                } else {
                    out.addFlexibleSpacing();
                }
                this.mySeparatorCounter = 0;
            }
            TBItemAnActionButton butt = out.addAnActionButton(act);
            if (this.myCustomizer != null) {
                this.myCustomizer.process(this, butt);
            }
        }

        void leaveNode(ActionGroup groupNode) {
            this.myNodePath.removeLast();
        }

        @Nullable
        private ItemsContainer _getParentContainer() {
            return this.myNodePath.isEmpty() ? null : this.myNodePath.getLast().groupContainer;
        }

        @Override
        public boolean isParentCompact() {
            return !this.myNodePath.isEmpty() && this.myNodePath.getLast().group instanceof CompactActionGroup;
        }

        @Override
        public String getParentGroupID() {
            if (this.myNodePath.isEmpty()) {
                return null;
            }
            return this.myNodePath.getLast().groupID;
        }

        @Override
        public TouchbarDataKeys.ActionDesc getParentDesc() {
            if (this.myNodePath.isEmpty()) {
                return null;
            }
            return this.myNodePath.getLast().groupDesc;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupNode";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/mac/touchbar/BuildUtils$GroupVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "enterNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class InternalNode {
            @NotNull
            final ActionGroup group;
            @Nullable
            final String groupID;
            final TouchbarDataKeys.ActionDesc groupDesc;
            ItemsContainer groupContainer;

            InternalNode(@NotNull ActionGroup group, @Nullable String groupID, TouchbarDataKeys.ActionDesc groupDesc) {
                if (group == null) {
                    InternalNode.$$$reportNull$$$0(0);
                }
                this.group = group;
                this.groupID = groupID;
                this.groupDesc = groupDesc;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/ui/mac/touchbar/BuildUtils$GroupVisitor$InternalNode", "<init>"));
            }
        }
    }
}

