/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticPathReferenceProvider
extends PathReferenceProviderBase {
    private boolean myEndingSlashNotAllowed;
    private boolean myRelativePathsAllowed;
    private final FileType[] mySuitableFileTypes;

    public StaticPathReferenceProvider(@Nullable FileType[] suitableFileTypes) {
        this.mySuitableFileTypes = suitableFileTypes;
    }

    @Override
    public boolean createReferences(@NotNull PsiElement psiElement, int offset, String text, @NotNull List<PsiReference> references, final boolean soft) {
        if (psiElement == null) {
            StaticPathReferenceProvider.$$$reportNull$$$0(0);
        }
        if (references == null) {
            StaticPathReferenceProvider.$$$reportNull$$$0(1);
        }
        FileReferenceSet set = new FileReferenceSet(text, psiElement, offset, null, true, this.myEndingSlashNotAllowed, this.mySuitableFileTypes){

            @Override
            protected boolean isUrlEncoded() {
                return true;
            }

            @Override
            protected boolean isSoft() {
                return soft;
            }
        };
        if (!this.myRelativePathsAllowed) {
            set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, FileReferenceSet.ABSOLUTE_TOP_LEVEL);
        }
        Collections.addAll(references, set.getAllReferences());
        return true;
    }

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
        if (path == null) {
            StaticPathReferenceProvider.$$$reportNull$$$0(2);
        }
        if (element == null) {
            StaticPathReferenceProvider.$$$reportNull$$$0(3);
        }
        SmartList list2 = new SmartList();
        this.createReferences(element, (List<PsiReference>)list2, true);
        if (list2.isEmpty()) {
            return null;
        }
        final PsiElement target2 = ((PsiReference)list2.get(list2.size() - 1)).resolve();
        if (target2 == null) {
            return null;
        }
        return new PathReference(path, (Function)PathReference.ResolveFunction.NULL_RESOLVE_FUNCTION){

            public PsiElement resolve() {
                return target2;
            }
        };
    }

    public void setEndingSlashNotAllowed(boolean endingSlashNotAllowed) {
        this.myEndingSlashNotAllowed = endingSlashNotAllowed;
    }

    public void setRelativePathsAllowed(boolean relativePathsAllowed) {
        this.myRelativePathsAllowed = relativePathsAllowed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/paths/StaticPathReferenceProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferences";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPathReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

