/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextComponentCaret
extends UserDataHolderBase
implements Caret {
    private final Editor myEditor;

    public TextComponentCaret(Editor editor) {
        this.myEditor = editor;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            TextComponentCaret.$$$reportNull$$$0(0);
        }
        return editor;
    }

    @NotNull
    public CaretModel getCaretModel() {
        CaretModel caretModel = this.myEditor.getCaretModel();
        if (caretModel == null) {
            TextComponentCaret.$$$reportNull$$$0(1);
        }
        return caretModel;
    }

    public boolean isValid() {
        return true;
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean scrollToCaret) {
        this.getCaretModel().moveCaretRelatively(columnShift, lineShift, withSelection, false, scrollToCaret);
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            TextComponentCaret.$$$reportNull$$$0(2);
        }
        this.getCaretModel().moveToLogicalPosition(pos);
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            TextComponentCaret.$$$reportNull$$$0(3);
        }
        this.getCaretModel().moveToVisualPosition(pos);
    }

    public void moveToOffset(int offset) {
        this.getCaretModel().moveToOffset(offset);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        this.getCaretModel().moveToOffset(offset, locateBeforeSoftWrap);
    }

    public boolean isUpToDate() {
        return this.getCaretModel().isUpToDate();
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        LogicalPosition logicalPosition = this.getCaretModel().getLogicalPosition();
        if (logicalPosition == null) {
            TextComponentCaret.$$$reportNull$$$0(4);
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        VisualPosition visualPosition = this.getCaretModel().getVisualPosition();
        if (visualPosition == null) {
            TextComponentCaret.$$$reportNull$$$0(5);
        }
        return visualPosition;
    }

    public int getOffset() {
        return this.getCaretModel().getOffset();
    }

    public int getVisualLineStart() {
        return this.getCaretModel().getVisualLineStart();
    }

    public int getVisualLineEnd() {
        return this.getCaretModel().getVisualLineEnd();
    }

    public int getSelectionStart() {
        return this.getSelectionModel().getSelectionStart();
    }

    @NotNull
    public VisualPosition getSelectionStartPosition() {
        VisualPosition visualPosition = this.myEditor.offsetToVisualPosition(this.getSelectionModel().getSelectionStart());
        if (visualPosition == null) {
            TextComponentCaret.$$$reportNull$$$0(6);
        }
        return visualPosition;
    }

    public int getSelectionEnd() {
        return this.getSelectionModel().getSelectionEnd();
    }

    @NotNull
    public VisualPosition getSelectionEndPosition() {
        VisualPosition visualPosition = this.myEditor.offsetToVisualPosition(this.getSelectionModel().getSelectionEnd());
        if (visualPosition == null) {
            TextComponentCaret.$$$reportNull$$$0(7);
        }
        return visualPosition;
    }

    @Nullable
    public String getSelectedText() {
        return this.getSelectionModel().getSelectedText();
    }

    public int getLeadSelectionOffset() {
        return this.getSelectionModel().getLeadSelectionOffset();
    }

    @NotNull
    public VisualPosition getLeadSelectionPosition() {
        VisualPosition visualPosition = this.myEditor.offsetToVisualPosition(this.getSelectionModel().getLeadSelectionOffset());
        if (visualPosition == null) {
            TextComponentCaret.$$$reportNull$$$0(8);
        }
        return visualPosition;
    }

    public boolean hasSelection() {
        return this.getSelectionModel().hasSelection();
    }

    public void setSelection(int startOffset, int endOffset) {
        this.getSelectionModel().setSelection(startOffset, endOffset);
    }

    public void setSelection(int startOffset, int endOffset, boolean updateSystemSelection) {
        this.setSelection(startOffset, endOffset);
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.getSelectionModel().setSelection(startOffset, endPosition, endOffset);
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.getSelectionModel().setSelection(startPosition, startOffset, endPosition, endOffset);
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset, boolean updateSystemSelection) {
        this.setSelection(startPosition, startOffset, endPosition, endOffset);
    }

    public void removeSelection() {
        this.getSelectionModel().removeSelection();
    }

    public void selectLineAtCaret() {
        this.getSelectionModel().selectLineAtCaret();
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        this.getSelectionModel().selectWordAtCaret(honorCamelWordsSettings);
    }

    @Nullable
    public Caret clone(boolean above) {
        return null;
    }

    public void dispose() {
    }

    public boolean isAtRtlLocation() {
        return false;
    }

    public boolean isAtBidiRunBoundary() {
        return false;
    }

    @NotNull
    public CaretVisualAttributes getVisualAttributes() {
        CaretVisualAttributes caretVisualAttributes = CaretVisualAttributes.DEFAULT;
        if (caretVisualAttributes == null) {
            TextComponentCaret.$$$reportNull$$$0(9);
        }
        return caretVisualAttributes;
    }

    public void setVisualAttributes(@NotNull CaretVisualAttributes attributes) {
        if (attributes == null) {
            TextComponentCaret.$$$reportNull$$$0(10);
        }
    }

    private SelectionModel getSelectionModel() {
        return this.myEditor.getSelectionModel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/textarea/TextComponentCaret";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretModel";
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/textarea/TextComponentCaret";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicalPosition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualPosition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionStartPosition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionEndPosition";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadSelectionPosition";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "moveToLogicalPosition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "moveToVisualPosition";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setVisualAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

