/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.GotoFileAction;
import com.intellij.ide.actions.searcheverywhere.AbstractGotoSEContributor;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereDataKeys;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoFileConfiguration;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.ui.IdeUICustomization;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSearchEverywhereContributor
extends AbstractGotoSEContributor<FileType> {
    private final GotoFileModel myModelForRenderer;

    public FileSearchEverywhereContributor(@Nullable Project project, @Nullable PsiElement context) {
        super(project, context);
        this.myModelForRenderer = project == null ? null : new GotoFileModel(project);
    }

    @NotNull
    public String getGroupName() {
        if ("Files" == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(0);
        }
        return "Files";
    }

    public String includeNonProjectItemsText() {
        return IdeBundle.message((String)"checkbox.include.non.project.files", (Object[])new Object[]{IdeUICustomization.getInstance().getProjectConceptName()});
    }

    public int getSortWeight() {
        return 200;
    }

    @Override
    @NotNull
    protected FilteringGotoByModel<FileType> createModel(@NotNull Project project) {
        if (project == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(1);
        }
        GotoFileModel gotoFileModel = new GotoFileModel(project);
        if (gotoFileModel == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(2);
        }
        return gotoFileModel;
    }

    @Override
    @NotNull
    public ListCellRenderer getElementsRenderer(@NotNull JList<?> list2) {
        if (list2 == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(3);
        }
        AbstractGotoSEContributor.SERenderer sERenderer = new AbstractGotoSEContributor.SERenderer(list2){

            @Override
            @NotNull
            protected PsiElementListCellRenderer.ItemMatchers getItemMatchers(@NotNull JList list2, @NotNull Object value) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiElementListCellRenderer.ItemMatchers defaultMatchers = super.getItemMatchers(list2, value);
                if (!(value instanceof PsiFileSystemItem) || FileSearchEverywhereContributor.this.myModelForRenderer == null) {
                    PsiElementListCellRenderer.ItemMatchers itemMatchers = defaultMatchers;
                    if (itemMatchers == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return itemMatchers;
                }
                PsiElementListCellRenderer.ItemMatchers itemMatchers = GotoFileModel.convertToFileItemMatchers(defaultMatchers, (PsiFileSystemItem)value, FileSearchEverywhereContributor.this.myModelForRenderer);
                if (itemMatchers == null) {
                    1.$$$reportNull$$$0(3);
                }
                return itemMatchers;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "list";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/FileSearchEverywhereContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/FileSearchEverywhereContributor$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getItemMatchers";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getItemMatchers";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (sERenderer == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(4);
        }
        return sERenderer;
    }

    @Override
    public boolean processSelectedItem(@NotNull Object selected, int modifiers, @NotNull String searchText) {
        VirtualFile file2;
        if (selected == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(5);
        }
        if (searchText == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(6);
        }
        if (selected instanceof PsiFile && (file2 = ((PsiFile)selected).getVirtualFile()) != null && this.myProject != null) {
            Pair<Integer, Integer> pos = FileSearchEverywhereContributor.getLineAndColumn(searchText);
            OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, file2, ((Integer)pos.first).intValue(), ((Integer)pos.second).intValue());
            descriptor.setUseCurrentWindow(FileSearchEverywhereContributor.openInCurrentWindow(modifiers));
            if (descriptor.canNavigate()) {
                descriptor.navigate(true);
                return true;
            }
        }
        return super.processSelectedItem(selected, modifiers, searchText);
    }

    @Override
    public Object getDataForItem(@NotNull Object element, @NotNull String dataId) {
        if (element == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(7);
        }
        if (dataId == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(8);
        }
        if (CommonDataKeys.PSI_FILE.is(dataId) && element instanceof PsiFile) {
            return element;
        }
        if (SearchEverywhereDataKeys.ITEM_STRING_DESCRIPTION.is(dataId) && element instanceof PsiFile) {
            String basePath;
            String path = ((PsiFile)element).getVirtualFile().getPath();
            path = FileUtil.toSystemIndependentName((String)path);
            if (this.myProject != null && (basePath = this.myProject.getBasePath()) != null) {
                path = FileUtil.getRelativePath((String)basePath, (String)path, (char)'/');
            }
            return path;
        }
        return super.getDataForItem(element, dataId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/FileSearchEverywhereContributor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/FileSearchEverywhereContributor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementsRenderer";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processSelectedItem";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDataForItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<FileType> {
        @NotNull
        public SearchEverywhereContributor<FileType> createContributor(AnActionEvent initEvent) {
            FileSearchEverywhereContributor fileSearchEverywhereContributor = new FileSearchEverywhereContributor(initEvent.getProject(), GotoActionBase.getPsiContext(initEvent));
            if (fileSearchEverywhereContributor == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return fileSearchEverywhereContributor;
        }

        @Nullable
        public SearchEverywhereContributorFilter<FileType> createFilter(AnActionEvent initEvent) {
            Project project = initEvent.getProject();
            if (project == null) {
                return null;
            }
            List items = Stream.of(FileTypeManager.getInstance().getRegisteredFileTypes()).sorted(GotoFileAction.FileTypeComparator.INSTANCE).collect(Collectors.toList());
            return new PersistentSearchEverywhereContributorFilter<FileType>(items, GotoFileConfiguration.getInstance(project), FileType::getName, FileType::getIcon);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/searcheverywhere/FileSearchEverywhereContributor$Factory", "createContributor"));
        }
    }
}

