/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.StdJobDescriptors;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.lang.GlobalInspectionContextExtension;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalInspectionContextBase
extends UserDataHolderBase
implements GlobalInspectionContext {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.GlobalInspectionContextImpl");
    private static final TObjectHashingStrategy<Tools> TOOLS_HASHING_STRATEGY = new TObjectHashingStrategy<Tools>(){

        public int computeHashCode(Tools object) {
            return object.getShortName().hashCode();
        }

        public boolean equals(Tools o1, Tools o2) {
            return o1.getShortName().equals(o2.getShortName());
        }
    };
    private RefManager myRefManager;
    private AnalysisScope myCurrentScope;
    @NotNull
    private final Project myProject;
    private final List<JobDescriptor> myJobDescriptors;
    private final StdJobDescriptors myStdJobDescriptors;
    protected ProgressIndicator myProgressIndicator;
    private InspectionProfileImpl myExternalProfile;
    protected final Map<Key, GlobalInspectionContextExtension> myExtensions;
    final Map<String, Tools> myTools;
    @NonNls
    public static final String PROBLEMS_TAG_NAME = "problems";
    @NonNls
    public static final String LOCAL_TOOL_ATTRIBUTE = "is_local_tool";

    public GlobalInspectionContextBase(@NotNull Project project) {
        if (project == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(0);
        }
        this.myJobDescriptors = new ArrayList<JobDescriptor>();
        this.myStdJobDescriptors = new StdJobDescriptors();
        this.myProgressIndicator = new EmptyProgressIndicator();
        this.myExtensions = new HashMap<Key, GlobalInspectionContextExtension>();
        this.myTools = new THashMap();
        this.myProject = project;
        for (InspectionExtensionsFactory factory : InspectionExtensionsFactory.EP_NAME.getExtensionList()) {
            GlobalInspectionContextExtension extension = factory.createGlobalInspectionContextExtension();
            this.myExtensions.put(extension.getID(), extension);
        }
    }

    public AnalysisScope getCurrentScope() {
        return this.myCurrentScope;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(1);
        }
        return project;
    }

    public <T> T getExtension(@NotNull Key<T> key) {
        if (key == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(2);
        }
        return (T)this.myExtensions.get(key);
    }

    public InspectionProfileImpl getCurrentProfile() {
        if (this.myExternalProfile != null) {
            return this.myExternalProfile;
        }
        String currentProfile = ((InspectionManagerBase)InspectionManager.getInstance((Project)this.myProject)).getCurrentProfile();
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance(this.myProject);
        InspectionProfileImpl profile2 = profileManager.getProfile(currentProfile, false);
        if (profile2 == null) {
            profile2 = InspectionProfileManager.getInstance().getProfile(currentProfile);
            if (profile2 != null) {
                return profile2;
            }
            String[] availableProfileNames = profileManager.getAvailableProfileNames();
            if (availableProfileNames.length == 0) {
                throw new IllegalStateException("There should be at least one inspection profile");
            }
            profile2 = profileManager.getProfile(availableProfileNames[0], true);
        }
        return profile2;
    }

    public boolean shouldCheck(@NotNull RefEntity entity, @NotNull GlobalInspectionTool tool) {
        if (entity == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(3);
        }
        if (tool == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(4);
        }
        return !(entity instanceof RefElementImpl) || this.isToCheckMember((RefElementImpl)entity, (InspectionProfileEntry)tool);
    }

    public boolean isSuppressed(@NotNull PsiElement element, @NotNull String id) {
        RefManagerImpl refManager;
        if (element == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(5);
        }
        if (id == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(6);
        }
        if ((refManager = (RefManagerImpl)this.getRefManager()).isDeclarationsFound()) {
            RefElement refElement = refManager.getReference(element);
            return refElement instanceof RefElementImpl && ((RefElementImpl)refElement).isSuppressed(id);
        }
        return SuppressionUtil.isSuppressed(element, id);
    }

    void cleanupTools() {
        this.myProgressIndicator.cancel();
        for (GlobalInspectionContextExtension extension : this.myExtensions.values()) {
            extension.cleanup();
        }
        for (Tools tools : this.myTools.values()) {
            for (ScopeToolState state : tools.getTools()) {
                InspectionToolWrapper toolWrapper = state.getTool();
                toolWrapper.cleanup(this.myProject);
            }
        }
        this.myTools.clear();
        EntryPointsManager entryPointsManager = EntryPointsManager.getInstance((Project)this.getProject());
        if (entryPointsManager != null) {
            entryPointsManager.cleanup();
        }
        if (this.myRefManager != null) {
            ((RefManagerImpl)this.myRefManager).cleanup();
            this.myRefManager = null;
            if (this.myCurrentScope != null) {
                this.myCurrentScope.invalidate();
                this.myCurrentScope = null;
            }
        }
        this.myJobDescriptors.clear();
    }

    public void setCurrentScope(@NotNull AnalysisScope currentScope) {
        if (currentScope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(7);
        }
        this.myCurrentScope = currentScope;
    }

    public void doInspections(@NotNull AnalysisScope scope) {
        if (scope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(8);
        }
        if (!GlobalInspectionContextUtil.canRunInspections(this.myProject, true)) {
            return;
        }
        this.cleanup();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (scope == null) {
                GlobalInspectionContextBase.$$$reportNull$$$0(47);
            }
            this.myCurrentScope = scope;
            this.launchInspections(scope);
        }, this.myProject.getDisposed());
    }

    @NotNull
    public RefManager getRefManager() {
        if (this.myRefManager == null) {
            this.myRefManager = (RefManager)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> new RefManagerImpl(this.myProject, this.myCurrentScope, this));
        }
        RefManager refManager = this.myRefManager;
        if (refManager == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(9);
        }
        return refManager;
    }

    public boolean isToCheckMember(@NotNull RefElement owner, @NotNull InspectionProfileEntry tool) {
        if (owner == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(10);
        }
        if (tool == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(11);
        }
        return this.isToCheckFile(((RefElementImpl)owner).getContainingFile(), tool) && !((RefElementImpl)owner).isSuppressed(tool.getShortName(), tool.getAlternativeID());
    }

    public boolean isToCheckFile(PsiFile file2, @NotNull InspectionProfileEntry tool) {
        Tools tools;
        if (tool == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(12);
        }
        if ((tools = this.myTools.get(tool.getShortName())) != null && file2 != null) {
            for (ScopeToolState state : tools.getTools()) {
                NamedScope namedScope = state.getScope(file2.getProject());
                if (namedScope != null && !namedScope.getValue().contains(file2, this.getCurrentProfile().getProfileManager().getScopesManager())) continue;
                return state.isEnabled() && state.getTool().getTool() == tool;
            }
        }
        return false;
    }

    protected void launchInspections(final @NotNull AnalysisScope scope) {
        if (scope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        LOG.info("Code inspection started");
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.getProject(), InspectionsBundle.message((String)"inspection.progress.title", (Object[])new Object[0]), true, this.createOption()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                GlobalInspectionContextBase.this.performInspectionsWithProgress(scope, false, false);
            }

            public void onSuccess() {
                GlobalInspectionContextBase.this.notifyInspectionsFinished(scope);
            }

            public void onCancel() {
                GlobalInspectionContextBase.this.cleanup();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/ex/GlobalInspectionContextBase$2", "run"));
            }
        });
    }

    @NotNull
    protected PerformInBackgroundOption createOption() {
        PerformInBackgroundOption performInBackgroundOption = new PerformInBackgroundOption(){

            public boolean shouldStartInBackground() {
                return true;
            }
        };
        if (performInBackgroundOption == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(14);
        }
        return performInBackgroundOption;
    }

    protected void notifyInspectionsFinished(@NotNull AnalysisScope scope) {
        if (scope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(15);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performInspectionsWithProgress(@NotNull AnalysisScope scope, boolean runGlobalToolsOnly, boolean isOfflineInspections) {
        if (scope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(16);
        }
        this.myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (this.myProgressIndicator == null) {
            throw new IllegalStateException("Inspections must be run under progress");
        }
        this.myProgressIndicator.setIndeterminate(false);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        RefManagerImpl refManager = (RefManagerImpl)this.getRefManager();
        try {
            psiManager.startBatchFilesProcessingMode();
            refManager.inspectionReadActionStarted();
            this.getStdJobDescriptors().BUILD_GRAPH.setTotalAmount(scope.getFileCount());
            this.getStdJobDescriptors().LOCAL_ANALYSIS.setTotalAmount(scope.getFileCount());
            this.getStdJobDescriptors().FIND_EXTERNAL_USAGES.setTotalAmount(0);
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                if (scope == null) {
                    GlobalInspectionContextBase.$$$reportNull$$$0(46);
                }
                this.runTools(scope, runGlobalToolsOnly, isOfflineInspections);
            }, (ProgressIndicator)ProgressWrapper.wrap(this.myProgressIndicator));
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        finally {
            refManager.inspectionReadActionFinished();
            psiManager.finishBatchFilesProcessingMode();
        }
    }

    protected void runTools(@NotNull AnalysisScope scope, boolean runGlobalToolsOnly, boolean isOfflineInspections) {
        if (scope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(17);
        }
    }

    public void initializeTools(@NotNull List<? super Tools> outGlobalTools, @NotNull List<? super Tools> outLocalTools, @NotNull List<? super Tools> outGlobalSimpleTools) {
        if (outGlobalTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(18);
        }
        if (outLocalTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(19);
        }
        if (outGlobalSimpleTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(20);
        }
        List<Tools> usedTools = this.getUsedTools();
        for (Tools currentTools : usedTools) {
            JobDescriptor[] jobDescriptors;
            String shortName = currentTools.getShortName();
            this.myTools.put(shortName, currentTools);
            InspectionToolWrapper toolWrapper = currentTools.getTool();
            GlobalInspectionContextBase.classifyTool(outGlobalTools, outLocalTools, outGlobalSimpleTools, currentTools, toolWrapper);
            for (ScopeToolState state : currentTools.getTools()) {
                state.getTool().initialize((GlobalInspectionContext)this);
            }
            for (JobDescriptor jobDescriptor : jobDescriptors = toolWrapper.getJobDescriptors((GlobalInspectionContext)this)) {
                this.appendJobDescriptor(jobDescriptor);
            }
        }
        for (GlobalInspectionContextExtension extension : this.myExtensions.values()) {
            extension.performPreRunActivities(outGlobalTools, outLocalTools, (GlobalInspectionContext)this);
        }
    }

    @NotNull
    protected List<Tools> getUsedTools() {
        InspectionProfileImpl profile2 = this.getCurrentProfile();
        List<Tools> tools = profile2.getAllEnabledInspectionTools(this.myProject);
        LinkedHashSet dependentTools = new LinkedHashSet();
        for (Tools tool : tools) {
            profile2.collectDependentInspections(tool.getTool(), dependentTools, this.getProject());
        }
        if (dependentTools.isEmpty()) {
            List<Tools> list2 = tools;
            if (list2 == null) {
                GlobalInspectionContextBase.$$$reportNull$$$0(21);
            }
            return list2;
        }
        THashSet set = new THashSet(tools, TOOLS_HASHING_STRATEGY);
        set.addAll(ContainerUtil.map(dependentTools, toolWrapper -> new ToolsImpl((InspectionToolWrapper)toolWrapper, toolWrapper.getDefaultLevel(), true, true)));
        ArrayList<Tools> arrayList = new ArrayList<Tools>((Collection<Tools>)set);
        if (arrayList == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void classifyTool(@NotNull List<? super Tools> outGlobalTools, @NotNull List<? super Tools> outLocalTools, @NotNull List<? super Tools> outGlobalSimpleTools, @NotNull Tools currentTools, @NotNull InspectionToolWrapper toolWrapper) {
        if (outGlobalTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(23);
        }
        if (outLocalTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(24);
        }
        if (outGlobalSimpleTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(25);
        }
        if (currentTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(26);
        }
        if (toolWrapper == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(27);
        }
        if (toolWrapper instanceof LocalInspectionToolWrapper) {
            outLocalTools.add((Tools)currentTools);
            return;
        } else {
            if (!(toolWrapper instanceof GlobalInspectionToolWrapper)) throw new RuntimeException("unknown tool " + toolWrapper);
            if (toolWrapper.getTool() instanceof GlobalSimpleInspectionTool) {
                outGlobalSimpleTools.add((Tools)currentTools);
                return;
            } else {
                if (!(toolWrapper.getTool() instanceof GlobalInspectionTool)) throw new RuntimeException("unknown global tool " + toolWrapper);
                outGlobalTools.add((Tools)currentTools);
            }
        }
    }

    @NotNull
    public Map<String, Tools> getTools() {
        Map<String, Tools> map = this.myTools;
        if (map == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(28);
        }
        return map;
    }

    private void appendJobDescriptor(@NotNull JobDescriptor job) {
        if (job == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(29);
        }
        if (!this.myJobDescriptors.contains(job)) {
            this.myJobDescriptors.add(job);
            job.setDoneAmount(0);
        }
    }

    public void codeCleanup(@NotNull AnalysisScope scope, @NotNull InspectionProfile profile2, @Nullable String commandName, @Nullable Runnable postRunnable, boolean modal, Predicate<ProblemDescriptor> shouldApplyFix) {
        if (scope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(30);
        }
        if (profile2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(31);
        }
    }

    public void codeCleanup(@NotNull AnalysisScope scope, @NotNull InspectionProfile profile2, @Nullable String commandName, @Nullable Runnable postRunnable, boolean modal) {
        if (scope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(32);
        }
        if (profile2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(33);
        }
        this.codeCleanup(scope, profile2, commandName, postRunnable, modal, d -> true);
    }

    public static void modalCodeCleanup(@NotNull Project project, @NotNull AnalysisScope scope, @Nullable Runnable runnable2) {
        if (project == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(34);
        }
        if (scope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(35);
        }
        GlobalInspectionContextBase globalContext = (GlobalInspectionContextBase)InspectionManager.getInstance((Project)project).createNewGlobalContext(false);
        InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(project).getCurrentProfile();
        globalContext.codeCleanup(scope, profile2, null, runnable2, true, descriptor -> true);
    }

    public static void cleanupElements(@NotNull Project project, @Nullable Runnable runnable2, PsiElement ... scope) {
        if (project == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(36);
        }
        if (scope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(37);
        }
        GlobalInspectionContextBase.cleanupElements(project, runnable2, (ProblemDescriptor descriptor) -> true, scope);
    }

    public static void cleanupElements(@NotNull Project project, @Nullable Runnable runnable2, Predicate<ProblemDescriptor> shouldApplyFix, PsiElement ... scope) {
        if (project == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(38);
        }
        if (scope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(39);
        }
        ArrayList<SmartPsiElementPointer> elements = new ArrayList<SmartPsiElementPointer>();
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)project);
        for (PsiElement element : scope) {
            elements.add(manager.createSmartPsiElementPointer(element));
        }
        GlobalInspectionContextBase.cleanupElements(project, runnable2, elements, shouldApplyFix);
    }

    public static void cleanupElements(@NotNull Project project, @Nullable Runnable runnable2, List<? extends SmartPsiElementPointer<PsiElement>> elements) {
        if (project == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(40);
        }
        GlobalInspectionContextBase.cleanupElements(project, runnable2, elements, (ProblemDescriptor descriptor) -> true);
    }

    public static void cleanupElements(@NotNull Project project, @Nullable Runnable runnable2, List<? extends SmartPsiElementPointer<PsiElement>> elements, Predicate<ProblemDescriptor> shouldApplyFix) {
        if (project == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(41);
        }
        Runnable cleanupRunnable = () -> {
            if (project == null) {
                GlobalInspectionContextBase.$$$reportNull$$$0(45);
            }
            ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>();
            for (SmartPsiElementPointer element : elements) {
                PsiElement psiElement = element.getElement();
                if (psiElement == null || !psiElement.isPhysical()) continue;
                psiElements.add(psiElement);
            }
            if (psiElements.isEmpty()) {
                return;
            }
            GlobalInspectionContextBase globalContext = (GlobalInspectionContextBase)InspectionManager.getInstance((Project)project).createNewGlobalContext(false);
            InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(project).getCurrentProfile();
            AnalysisScope analysisScope = new AnalysisScope((SearchScope)new LocalSearchScope(psiElements.toArray(PsiElement.EMPTY_ARRAY)), project);
            globalContext.codeCleanup(analysisScope, profile2, null, runnable2, true, shouldApplyFix);
        };
        Application application = ApplicationManager.getApplication();
        if (application.isWriteAccessAllowed() && !application.isUnitTestMode()) {
            application.invokeLater(cleanupRunnable);
        } else {
            cleanupRunnable.run();
        }
    }

    public void close(boolean noSuspiciousCodeFound) {
        this.cleanup();
    }

    public void cleanup() {
        this.cleanupTools();
    }

    public void incrementJobDoneAmount(@NotNull JobDescriptor job, @NotNull String message) {
        if (job == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(42);
        }
        if (message == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(43);
        }
        if (this.myProgressIndicator == null) {
            return;
        }
        ProgressManager.checkCanceled();
        int old = job.getDoneAmount();
        job.setDoneAmount(old + 1);
        float totalProgress = this.getTotalProgress();
        this.myProgressIndicator.setFraction((double)totalProgress);
        this.myProgressIndicator.setText(job.getDisplayName() + " " + message);
    }

    private float getTotalProgress() {
        int totalDone = 0;
        int totalTotal = 0;
        for (JobDescriptor jobDescriptor : this.myJobDescriptors) {
            totalDone += jobDescriptor.getDoneAmount();
            totalTotal += jobDescriptor.getTotalAmount();
        }
        return totalTotal == 0 ? 1.0f : 1.0f * (float)totalDone / (float)totalTotal;
    }

    public void setExternalProfile(InspectionProfileImpl profile2) {
        this.myExternalProfile = profile2;
    }

    @NotNull
    public StdJobDescriptors getStdJobDescriptors() {
        StdJobDescriptors stdJobDescriptors = this.myStdJobDescriptors;
        if (stdJobDescriptors == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(44);
        }
        return stdJobDescriptors;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 21: 
            case 22: 
            case 28: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 21: 
            case 22: 
            case 28: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 21: 
            case 22: 
            case 28: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/GlobalInspectionContextBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 4: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentScope";
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 30: 
            case 32: 
            case 35: 
            case 37: 
            case 39: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outGlobalTools";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outLocalTools";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outGlobalSimpleTools";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTools";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 29: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/GlobalInspectionContextBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefManager";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createOption";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedTools";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTools";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdJobDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 21: 
            case 22: 
            case 28: 
            case 44: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldCheck";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentScope";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doInspections";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isToCheckMember";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isToCheckFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "launchInspections";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "notifyInspectionsFinished";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "performInspectionsWithProgress";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runTools";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "initializeTools";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "classifyTool";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "appendJobDescriptor";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "codeCleanup";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "modalCodeCleanup";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "cleanupElements";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "incrementJobDoneAmount";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$cleanupElements$8";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$performInspectionsWithProgress$2";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doInspections$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 21: 
            case 22: 
            case 28: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

